#include "analysis.h"
#include <malloc.h>
#include <stdio.h>
#include "utilities.h"

int ana_n_free = 0;
int ana_n_malloc = 0;

void* ana_malloc(int n){
  ana_n_malloc++;
  return (void *)malloc(n);
}

void ana_pfree(void *ptr){
  if(ptr == NULL) return;
  ana_n_free++;
  free(ptr);
  ptr = NULL;
}

int ana_print_n_malloc(){
  printf("ana_malloc=%d\n",ana_n_malloc);
  return ana_n_malloc;
}

int ana_print_n_free(){
  printf("ana_free=%d\n",ana_n_free);
  return ana_n_free;
}

Analyses ana_init_output(int n){
  int i;
  Analyses out;

  if(n <= 0) return NULL;
  out = (Analyses)ana_malloc(sizeof(struct analyses));
  if(out == NULL) util_error("ana_init_output","cannot initialize structure analyses");
  out->length = n;
  out->tab = (Ana_analysis *)ana_malloc(n*sizeof(Ana_analysis));
  if(out->tab == NULL) util_error("ana_init_output","cannot initialize array of analyses");
  for(i = 0 ; i < n ; i++){
    out->tab[i] =(Ana_analysis)ana_malloc(sizeof(struct analysis)); 
    if(out->tab[i] == NULL) util_error("ana_init_output","cannot initialize analysis");
    out->tab[i]->output = -1;
    out->tab[i]->analysis = NULL;
  }

  return out;
}



void ana_free_output(Analyses *out){
  int i,n;
  if(*out == NULL) return;
  n = (*out)->length;
  for(i = 0 ; i < n ; i++){
    ll_free(&((*out)->tab[i]->analysis)); 
    ana_pfree((*out)->tab[i]);
  }
  ana_pfree((*out)->tab);
  ana_pfree(*out);
}



void ana_insert_analysis(Analyses *out,int index,int key,int value){
  if(*out == NULL) util_error("ana_insert_analysis","*out should not be NULL");
  if((index < 0) || (index >= (*out)->length))util_error("ana_insert_analysis","index range");
  if((*out)->tab == NULL) util_error("ana_insert_analysis","tab should not be NULL");
  if((*out)->tab[index] == NULL) util_error("ana_insert_analysis","tab[index] should not be NULL");
  ll_insert_sorted(&((*out)->tab[index]->analysis),key,value,0);  
}


void ana_set_output(Analyses *out,int index,int key){
  if(*out == NULL) util_error("ana_set_output","*out should not be NULL");
  if((index < 0) || (index >= (*out)->length))util_error("ana_set_output","index range");
  if((*out)->tab == NULL) util_error("ana_set_output","tab should not be NULL");
  if((*out)->tab[index] == NULL) util_error("ana_set_output","tab[index] should not be NULL");
  (*out)->tab[index]->output = key;
}


Analyses ana_get_grammar_outputs(Tab_u outputs, Tokens *tok){
  int i,l,j,nk,nv;
  Analyses out;
  int n = tab_u_get_n_elements(outputs);
  Ustring temp,temp2,temp1,key,value;
  Tab_u split1,split2;
  Uchar c;

  out = ana_init_output(n);
  for(i = 0 ; i < n ; i++){
    temp = tab_u_get_value(outputs,i);
    c = ustring_get_uchar(temp,0);
    if(c == '['){
      temp1 = ustring_get_substr(temp,1,ustring_length(temp) - 1);
      split1 = ustring_split(';',temp1);
      l = tab_u_get_n_elements(split1);
      for(j = 0 ; j < l ; j++){
	temp2 = tab_u_get_value(split1,j);
	split2 = ustring_split('=',temp2);
	key = tab_u_get_value(split2,0);
	value = tab_u_get_value(split2,1);
	tok_add_element(tok,key,0,&nk);
	tok_add_element(tok,value,0,&nv);
	ana_insert_analysis(&out,i,nk,nv);
	tab_u_free(&split2);
      }
      tab_u_free(&split1);
      ustring_free(temp1);
    }
    else{
      tok_add_element(tok,temp,0,&nk); 
      ana_set_output(&out,i,nk);
    }    
  }
  //    ana_print(out);
  return out;
}


void ana_print(Analyses a){
  int i,n;
  if(a == NULL) return;
  //  n = a->length;  
  n = 3;
  for(i = 0 ; i < n ; i++){
    printf("%d OUTPUT\n%d\nANALYSES\n",i,a->tab[i]->output);
    ll_println(a->tab[i]->analysis);
  }

}

Ustring ana_to_ustring(Analyses ana,int index,Tokens tok){
  Ustring u = NULL;
  struct ll_cell *ptr;
  Llist l =  ana_get_analysis_list(ana,index);
  if(l == NULL) return NULL;
  ptr = l->head;
  while(ptr != NULL){
    ustring_append(&u,';');
    ustring_strcat(&u,tok_get_element(tok,ptr->key));
    ustring_append(&u,'=');
    ustring_strcat(&u,tok_get_element(tok,ptr->value));
    ptr = ptr->next;
  }
  return u;
}


Llist ana_get_analysis_list(Analyses a,int index){
  if(a == NULL) return NULL;
  if(a->tab == NULL) return NULL;
  if(a->tab[index] == NULL) return NULL;
  return a->tab[index]->analysis;
}
