#ifndef _h_alph
#define _h_alph

#include "tab_u.h"
#include "hashtable.h"
#include "tokens.h"
#include "llist.h"
#include "text.h"

struct alphabet{
  Tab_u equivalences;
  Hashtable uchar_hash;
};

typedef struct alphabet * Alphabet;


//FUNCTIONS


Alphabet alph_load(char *filename,int has_ascii_format);
void alph_free(Alphabet *alph);

int alph_ustring_insensitive_cmp(Ustring u,Ustring v,Alphabet alph);
Llist alph_get_indexes_insensitive_from_lexicon(Text t,int pos,Lexicon lex,Alphabet alph,Tab_u tokens);

void alph_print(Alphabet alph);
void alph_println(Alphabet alph);

int alph_print_n_malloc();
int alph_print_n_free();

#endif
