#ifndef _UNITEX_GRF_H_
#define _UNITEX_GRF_H_

#include <iostream>
#include <vector>
#include <string>

#include <boost/filesystem/path.hpp>
#include <outilex/xml.h>


class generic_fst;

struct grf_box {

  grf_box() : x(0), y(0), input(), output(), trans() {}
  grf_box(const std::string & line) : x(0), y(0), input(), output(), trans() { read_line(line); }

  void read_line(const std::string & line);
  void read_xml(xmlNode * node);
  void write_xml(xmlwriter & writer, int id) const;

  int x, y;
  std::vector<std::string> input; // do not tokenize input
  //std::vector<std::vector<std::string> > input; // tokenized input
  std::string output;
  std::vector<int> trans;
};


struct unitex_grf {

public:

  unitex_grf() : boxes() {}
  unitex_grf(const boost::filesystem::path & path) : boxes() { load(path); }

  inline int size() const { return boxes.size(); }

  inline grf_box & operator[](int idx) { return boxes[idx]; }
  inline const grf_box & operator[](int idx) const { return boxes[idx]; }


  // determine file type by extension (.xgrf or .grf8)
  void load(const boost::filesystem::path & path);

  // load from grf8
  void read_grf8(std::istream & is);
  void write_grf8(const boost::filesystem::path & path) const;

  //load from xml description
  void read_xml(const boost::filesystem::path & path);
  void write_xml(const boost::filesystem::path & path) const;
  void write_xml(xmlwriter & writer) const;

public:
  std::vector<grf_box> boxes;

private:
  void read_xgrf_boxes(xmlNodePtr node);
};

void grf_to_generic_fst(const unitex_grf & grf, generic_fst & fst);

#endif
