#ifndef _TRANSITIVE_CLOSURE_H_
#define _TRANSITIVE_CLOSURE_H_

#include <vector>

template <typename FSA, typename Predicate>
void transitive_closure(const FSA & fsa, int q, int * tab, Predicate pred) {

  std::vector<int> s;
  s.push_back(q);

  while (! s.empty()) {

    q = s.back(); s.pop_back();  

    if (tab[q]) { continue; }
    tab[q] = 1;

    for (typename FSA::const_trans_iterator tr = fsa.trans_begin(q);
         tr != fsa.trans_end(q); ++tr) {
      if (pred(*tr)) {
        s.push_back(tr->to());
      }
    }
  }
}


#if 0
template<typename FSA, typename Predicate>
void transitive_closure(const FSA & fsa, int q, int * tab, Predicate pred) {
  
  if (tab[q]) { return; }
  tab[q] = 1;
  
  for (typename FSA::const_trans_iterator tr = fsa.trans_begin(q); tr != fsa.trans_end(q); ++tr) {
    if (pred(*tr)) {
      transitive_closure(fsa, tr->to(), tab, pred); 
    }
  }
}
#endif

#endif
