#ifndef _SHORTEST_PATH_H_
#define _SHORTEST_PATH_H_

#include <outilex/wgb_color.h>

namespace detail {

/*
 * compute the shortest path, from a given source to any destination
 * FSA is the graph, q is the current state, curr is the score of the
 * current path wich lead from the source to the current state,
 * score is the function which gives a score to a given transition,
 * res is the tab used to store the results, color is used to avoid infinite reccursion
 * in cyclic graphs
 */


template<typename FSA, typename score_type, typename ScoreFunc>
void shortest_acyclic_path_compute(FSA & A, int q, ScoreFunc & score, const score_type & curr,
                           score_type * res, wgb_color * color) {
  
  typedef FSA fsa_type;

  if (color[q] == gray) {
    //std::cerr << "warning: found a cycle while computing shortest_path\n";
    return;
  }

  color[q] = gray;

  res[q] = score_type::plus(res[q], curr); 

  for (typename fsa_type::const_trans_iterator tr = A.trans_begin(q); tr != A.trans_end(q); ++tr) {
    shortest_acyclic_path_compute(A, tr->to(), score, score_type::mult(curr, score(*tr)), res, color);
  }

  color[q] = white;
}

} // namespace details


template<typename FSA, typename score_type, typename ScoreFunc>
void shortest_acyclic_path(FSA & A, int src, score_type * res, ScoreFunc & score) {

  int size = A.size();
  wgb_color color[size];

  for (int i = 0; i < size; ++i) {
    res[i] = score_type::zero();
    color[i] = white;
  }

  detail::shortest_acyclic_path_compute(A, src, score, score_type::one(), res, color);
}


#endif

