#ifndef _GENERIC_FST_H_
#define _GENERIC_FST_H_

#include <string>
#include <boost/filesystem/path.hpp>

#include <outilex/basic_fst.h>


class generic_fst : public basic_fst<std::string, std::string> {
public:
  typedef basic_fst<std::string, std::string> fst_type;

  std::string name;

  generic_fst(const std::string n = std::string()) : fst_type(), name(n) {}
  generic_fst(const boost::filesystem::path & path);

  void read(const boost::filesystem::path & path);
  void write(const boost::filesystem::path & path) const;

  void swap(generic_fst & fst) {
    fst_type::swap(fst);
    name.swap(fst.name);
  }
};


inline std::ostream & operator<<(std::ostream & os, const generic_fst::label_type & label) {
  os << label.in << '/' << label.out;
  return os;
}


#if 0
inline bool operator<(const generic_fst::label_type & a, const generic_fst::label_type & b) {
  if (a.in != b.in) { return a.in < b.in; }
  return a.out < b.out;
}
#endif

#endif

#if 0
class generic_fst {

public:

  typedef std::string input_type;
  typedef std::string output_type;

  struct label_type {
    input_type in;
    output_type out;
    label_type() : in(), out() {}
    label_type(const input_type & in_, const output_type & out_)
      : in(in_), out(out_) {}
  };

  typedef std::set<output_type> outputs_type;
  typedef outputs_type data_type;

  struct transition {

    int to_;
    label_type label_;

    transition() {}
    transition(const label_type & label, int to)
      : to_(to), label_(label) {}
    transition(const input_type & in, const output_type & out, int to)
      : to_(to), label_(in, out) {}

    int & to() { return to_; }
    int to() const { return to_; }

    label_type & label() { return label_; }
    const label_type & label() const { return label_; }

    input_type & in() { return label_.in; }
    const input_type & in() const { return label_.in; }

    output_type & out() { return label_.out; }
    const output_type & out() const { return label_.out; }


    void write_XML(xmlwriter & writer) const;
    void read_XML(xmlNode * node);
  };

  typedef std::vector<transition> transitions;

  typedef transitions::iterator trans_iterator;
  typedef transitions::const_iterator const_trans_iterator;


  struct state {

    bool final;
    outputs_type final_outputs;
    transitions trans;

    state() : final(false), final_outputs(), trans() {}

    void clear() { final = false; final_outputs.clear(); trans.clear(); }

    void write_final_outputs(xmlwriter & writer) const;
    void read_final_outputs(xmlNode * node);
    void write_XML(xmlwriter & writer, int no) const;
    void read_XML(xmlNode * node);
  };


  generic_fst() : name(), states() {}
  generic_fst(const boost::filesystem::path & path) : name(), states() { read(path); }

  void init(const generic_fst & fst) { name = fst.name; states.clear(); }


  bool empty() const { return states.empty(); }
  int size() const { return states.size(); }
  const std::string & get_name() const { return name; }

  int start() const { return 0; }

  void clear() { states.clear(); }

  void reserve(int size) { states.reserve(size); }
  void resize(int size) { states.resize(size); }

  void set_final(int q, bool final = true) { states[q].final = final; }
  bool final(int q) const { return states[q].final; }

  //outputs_type & final_outputs(int q) { return states[q].final_outputs; }
  const outputs_type & final_outputs(int q) const { return states[q].final_outputs; }

  const data_type & data(int q) const { return states[q].final_outputs; }
  void set_data(int q, const data_type & data) { states[q].final_outputs = data; }

  void merge_data(int q, const data_type & data) { states[q].final_outputs.insert(data.begin(), data.end()); }


  trans_iterator trans_begin(int q) { return states[q].trans.begin(); }
  const_trans_iterator trans_begin(int q) const { return states[q].trans.begin(); }

  trans_iterator trans_end(int q) { return states[q].trans.end(); }
  const_trans_iterator trans_end(int q) const { return states[q].trans.end(); }

  int trans_size(int q) const { return states[q].trans.size(); }
  void trans_reserve(int q, int size) { return states[q].trans.reserve(size); }

  transition & get_trans(int q, int trno) { return states[q].trans[trno]; }
  const transition & get_trans(int q, int trno) const { return states[q].trans[trno]; }

  int add_state(bool final = false) {
    int size = states.size();
    states.resize(size + 1);
    states[size].final = final;
    return size;
  }

  void add_trans(int from, const label_type & label, int to) {
    states[from].trans.push_back(transition(label, to));
  }

  void add_trans(int from, const std::string & in, const std::string & out, int to) {
    states[from].trans.push_back(transition(in, out, to));
  }

  void swap(generic_fst & fst) {
    name.swap(fst.name);
    states.swap(fst.states);
  }
  

  /* XML serialisation */

  void read(const boost::filesystem::path & path);
  void write(const boost::filesystem::path & path) const;

  void read_XML(xmlNode * node);
  void write_XML(xmlwriter & writer) const;

public:
  std::string name;
  std::vector<state> states;
};
#endif
