#ifndef _FSA_UNION_H_
#define _FSA_UNION_H_


template<typename Fsa1, typename Fsa2>
void fsa_union(Fsa1 & fsa1, const Fsa2 & fsa2) {

  if (fsa2.empty()) { return; }

  int size1 = fsa1.size(), size2 = fsa2.size();

  fsa1.reserve(size1 + size2);

  int q0 = size1;

  for (int q = 0; q < size2; ++q) {

    int nq = fsa1.add_state();
    //assert(nq == q0 + q); <-- invariant condition

    fsa1.set_data(nq, fsa2.data(q));
    fsa1.set_final(nq, fsa2.final(q));

    fsa1.trans_reserve(nq, fsa2.trans_size(q));
    for (typename Fsa2::const_trans_iterator tr = fsa2.trans_begin(q);
         tr != fsa2.trans_end(q); ++tr) {
      //std::cerr << "tr in : " << tr->in() << std::endl;
      fsa1.add_trans(nq, tr->label(), q0 + tr->to());
    }
  }

  if (q0 != 0) {
    if (fsa2.final(0)) { fsa1.set_final(0); }
    fsa1.merge_data(0, fsa2.data(0));
    fsa1.trans_reserve(0, fsa1.trans_size(0) + fsa2.trans_size(0));
    for (typename Fsa2::const_trans_iterator tr = fsa2.trans_begin(0);
         tr != fsa2.trans_end(0); ++tr) {
      fsa1.add_trans(0, tr->label(), q0 + tr->to());
    }
  }
}

#endif
