#include <boost/filesystem/path.hpp>
#include <boost/filesystem/fstream.hpp>
#include <boost/filesystem/convenience.hpp>
#include <outilex/generic_fst.h>
#include <outilex/fsa-dump_dot.h>


using namespace std;
namespace fs = boost::filesystem;


char * progname;
void usage() {
  cout << "usage: " << progname << " <gfst>\n";
  exit(1);
}


int main(int argc, char **argv) try {

  fs::path fstpath, opath;

  progname = *argv;
  argv++, argc--;

  if (! argc) { usage(); }

  while (argc) {
  
    string arg = *argv;
    
    if (arg == "-h") {
    
    usage();
    
    } else if (arg == "-o") {
    
      argv++, argc--;
      if (! argc) { cerr << "bad args\n"; exit(1); }
    
      opath = fs::path(*argv, fs::native);
    
    } else {
      fstpath = fs::path(arg, fs::native);
    }

    argv++, argc--;
  }
  
  if (fstpath.empty()) { cerr << "argument missing\n"; exit(1); }

  if (opath.empty()) {
    opath = fs::change_extension(fstpath, ".dot");
  }

  generic_fst fst(fstpath);

  fs::ofstream os(opath);

  fsa_dump_dot(fst, os);

} catch (exception & e) {
  cerr << "fatal error: " << e.what() << endl;
  exit(1);
}

