#include <boost/filesystem/path.hpp>

#include <outilex/xml.h>
#include <outilex/xml-names.h>
#include <outilex/xml_format_fst.h>
#include <outilex/generic_fst.h>

using namespace std;
using namespace boost;
namespace fs = boost::filesystem;

generic_fst::generic_fst(const fs::path & path) : fst_type(), name() {
  read(path);
}


namespace {
struct gfst_xml_formater {


  const char * fst_name() { return xmlnames::GENERIC_FST_ELEM; }

  void write_fst_data(xmlwriter & writer, const generic_fst & T) {
    writer.write_string(T.name);
  }

  void read_fst_data(xmlNode * node, generic_fst & T) {
    char * text = (char *) xmlNodeGetContent(node);
    T.name = text;
    xmlFree(text);
  }

  void write_fst_state_data(xmlwriter & w, const generic_fst & T, int q) {}
  void read_fst_state_data(xmlNode * n, generic_fst & T, int q) {}

  void write_in(xmlwriter & writer, const std::string & in) { writer.write_string(in); }
  void read_in(xmlNode * node, std::string & in) {
    char * text = (char *) xmlNodeGetContent(node);
    in = text;
    xmlFree(text);
  }

  void write_out(xmlwriter & writer, const std::string & out) { writer.write_string(out); }
  void read_out(xmlNode * node, std::string & out) {
    char * text = (char *) xmlNodeGetContent(node);
    out = text;
    xmlFree(text);
  }
};

} // namespace ""


void generic_fst::read(const boost::filesystem::path & path) {
  xml_read_fst(path, *this, gfst_xml_formater());
}

void generic_fst::write(const boost::filesystem::path& path) const {
  xml_write_fst(path, *this, gfst_xml_formater());
}




#if 0
void generic_fst::read(const fs::path & path) {

  string fname = path.native_file_string();

  xmlDocPtr doc = xmlParseFile(fname.c_str());

  if (doc == NULL) {
    throw xml_parse_error("genfst::read_XML: " + fname + " not successfully parsed");
  }

  xmlNodePtr node = xmlDocGetRootElement(doc);

  try {
    read_XML(node);
  } catch (exception & e) {
    cerr << "genfst::read: error while parsing fst " << fname << ": " << e.what() << endl;
    xmlFreeDoc(doc);
    throw;
  }
  xmlFreeDoc(doc);
}


void generic_fst::transition::write_XML(xmlwriter & writer) const {
  writer.start_element("transition");
  writer.write_attribute("to", lexical_cast<string>(to_));
  writer.write_element("in", label_.in);
  writer.write_element("out", label_.out);
  writer.end_element();
}


void generic_fst::transition::read_XML(xmlNodePtr node) {
  char * text = xmlGetProp(node, "to");
  to_ = lexical_cast<int>(text);
  xmlFree(text);
  node = node->xmlChildrenNode;
  while (node) {
    if (xmlStrcmp(node->name, "in") == 0) {
      text = (char *) xmlNodeGetContent(node);
      label_.in = text;
      xmlFree(text);
    } else if (xmlStrcmp(node->name, "out") == 0) {
      text = (char *) xmlNodeGetContent(node);
      label_.out = text;
      xmlFree(text);
    }
    node = node->next;
  }
}



void generic_fst::state::write_final_outputs(xmlwriter & writer) const {
  writer.start_element("final_outputs");
  for (outputs_type::const_iterator it = final_outputs.begin(); it != final_outputs.end(); ++it) {
    writer.write_element("out", *it);
  }
  writer.end_element();
}


void generic_fst::state::read_final_outputs(xmlNodePtr node) {
  node = node->xmlChildrenNode;
  while (node) {
    if (xmlStrcmp(node->name, "out") == 0) {
      char * text = (char *) xmlNodeGetContent(node);
      final_outputs.insert(text);
      xmlFree(text);
    }
    node = node->next;
  }
}

void generic_fst::state::write_XML(xmlwriter & writer, int no) const {

  writer.start_element("state");
  writer.write_attribute("id", lexical_cast<string>(no));
  if (final) {
    writer.write_attribute("final", "1");
  }
  writer.write_attribute("size", lexical_cast<string>(trans.size()));

  if (! final_outputs.empty()) { write_final_outputs(writer); }

  for_each(trans.begin(), trans.end(), XML_Writer(writer));

  writer.end_element();
}


void generic_fst::state::read_XML(xmlNodePtr node) {

  clear();

  char * text = xmlGetProp(node, "final");
 
  if (text && text[0] && '1') {
    final = true;
  } else { final = false; }

  if (text) { xmlFree(text); }


  node = node->xmlChildrenNode;

  while (node) {

    if (xmlStrcmp(node->name, "transition") == 0) {

      int size = trans.size();
      trans.resize(size + 1);
      trans[size].read_XML(node);

    } else if ((xmlStrcmp(node->name, "final_outputs") == 0) && final) {
      read_final_outputs(node);
    }
    node = node->next;
  }
}


void generic_fst::write(const fs::path & path) const {

  xmlwriter writer(path);
  writer.set_indent(true);

  writer.start_document();
  write_XML(writer);
  writer.end_document();
}


void generic_fst::write_XML(xmlwriter & writer) const {

  writer.start_element("generic-fst");
  writer.write_attribute("name", name);
  writer.write_attribute("size", lexical_cast<string>(size()));

  for (int q = 0; q < size(); ++q) {
    states[q].write_XML(writer, q);
  }
  writer.end_element();
}


void generic_fst::read_XML(xmlNodePtr node) {

  states.clear();
  name.clear();
  
  if (node == NULL) { throw xml_parse_error("genfst::read_XML: empty document"); }

  if (xmlStrcmp(node->name, "generic-fst")) {
    throw xml_parse_error("genfst::read_XML: wrong doc type");
  }

  char * text = xmlGetProp(node, "name");
  if (text) {
    name = text;
    xmlFree(text);
  }

  text = xmlGetProp(node, "size");
  if (text) {
    states.reserve(lexical_cast<int>(text));
    xmlFree(text);
  }

  node = node->xmlChildrenNode;
  int qno = 0;
  while (node) {
    if (xmlStrcmp(node->name, "state") == 0) {
      states.resize(qno + 1);
      states[qno].read_XML(node);
      qno++;
    }
    node = node->next;
  }
}
#endif
