/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.unitex.undo;

import fr.umlv.unitex.GenericGraphBox;
import fr.umlv.unitex.GenericGraphicalZone;
import java.util.ArrayList;
import javax.swing.undo.AbstractUndoableEdit;

public class TransitionGroupEdit
extends AbstractUndoableEdit {
    private ArrayList selectedBoxes;
    private ArrayList oldSelectedBoxes;
    private GenericGraphBox dst;
    private GenericGraphicalZone zone;

    public TransitionGroupEdit(ArrayList arrayList, GenericGraphBox genericGraphBox, GenericGraphicalZone genericGraphicalZone) {
        this.selectedBoxes = arrayList;
        this.oldSelectedBoxes = (ArrayList)arrayList.clone();
        this.dst = genericGraphBox;
        this.zone = genericGraphicalZone;
    }

    public void undo() {
        super.undo();
        for (GenericGraphBox genericGraphBox : this.oldSelectedBoxes) {
            genericGraphBox.addTransitionTo(this.dst);
            genericGraphBox.setSelected(true);
            this.selectedBoxes.add(genericGraphBox);
            this.zone.initText(genericGraphBox.getContent(), genericGraphBox.getTransduction());
        }
    }

    public void redo() {
        super.redo();
        for (GenericGraphBox genericGraphBox : this.oldSelectedBoxes) {
            genericGraphBox.addTransitionTo(this.dst);
            genericGraphBox.setSelected(false);
            this.selectedBoxes.remove(genericGraphBox);
        }
    }
}

