/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.unitex.undo;

import fr.umlv.unitex.GenericGraphBox;
import fr.umlv.unitex.GenericGraphicalZone;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.swing.undo.AbstractUndoableEdit;

public class BoxeGroupTextEdit
extends AbstractUndoableEdit {
    private ArrayList selectedBoxes;
    private ArrayList oldSelectedBoxes;
    private HashMap selectedBoxesAndOldString;
    private HashMap transductions;
    private String remplacementString;
    private String remplacementTrans;
    private GenericGraphicalZone zone;

    public BoxeGroupTextEdit(ArrayList arrayList, String string, String string2, GenericGraphicalZone genericGraphicalZone) {
        this.selectedBoxes = arrayList;
        this.oldSelectedBoxes = (ArrayList)arrayList.clone();
        this.selectedBoxesAndOldString = new HashMap();
        this.remplacementString = string;
        this.remplacementTrans = string2;
        this.zone = genericGraphicalZone;
        for (GenericGraphBox genericGraphBox : arrayList) {
            String string3 = genericGraphBox.getTransduction();
            if (string3 == null) {
                string3 = "";
            }
            this.selectedBoxesAndOldString.put(genericGraphBox, genericGraphBox.getContent());
            this.transductions.put(genericGraphBox, string3);
        }
    }

    public void undo() {
        super.undo();
        Set set = this.selectedBoxesAndOldString.keySet();
        for (GenericGraphBox genericGraphBox : set) {
            String string = (String)this.selectedBoxesAndOldString.get(genericGraphBox);
            String string2 = (String)this.transductions.get(genericGraphBox);
            genericGraphBox.setContent(string, string2);
            genericGraphBox.setSelected(true);
            this.selectedBoxes.add(genericGraphBox);
            this.zone.initText(genericGraphBox.getContent(), genericGraphBox.getTransduction());
        }
    }

    public void redo() {
        super.redo();
        for (GenericGraphBox genericGraphBox : this.oldSelectedBoxes) {
            genericGraphBox.setContent(this.remplacementString, this.remplacementTrans);
            genericGraphBox.setSelected(true);
            this.selectedBoxes.add(genericGraphBox);
            this.zone.initText(genericGraphBox.getContent(), genericGraphBox.getTransduction());
        }
    }
}

