/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.unitex;

import fr.outilex.OutilexEnvironment;
import fr.umlv.unitex.GraphFrame;
import fr.umlv.unitex.Preferences;
import fr.umlv.unitex.io.GraphIO;
import fr.umlv.unitex.io.UnicodeIO;
import java.awt.Dimension;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.JOptionPane;

public class UnitexAction {
    public static GraphFrame loadXGrf(File file, OutilexEnvironment outilexEnvironment) {
        GraphIO graphIO = GraphIO.loadGraph(file);
        if (graphIO == null) {
            return null;
        }
        GraphFrame graphFrame = new GraphFrame(true, outilexEnvironment);
        graphFrame.graphicalZone.pref = graphIO.pref;
        graphFrame.graphicalZone.pref.antialiasing = Preferences.pref.antialiasing;
        graphFrame.texte.setFont(graphFrame.graphicalZone.pref.input);
        graphFrame.graphicalZone.Width = graphIO.width;
        graphFrame.graphicalZone.Height = graphIO.height;
        graphFrame.graphicalZone.graphBoxes = graphIO.boxes;
        graphFrame.scroll.setPreferredSize(new Dimension(graphIO.width, graphIO.height));
        graphFrame.graphicalZone.setPreferredSize(new Dimension(graphIO.width, graphIO.height));
        graphFrame.setGraph(file);
        return graphFrame;
    }

    public static GraphFrame loadGraph(File file, OutilexEnvironment outilexEnvironment) {
        String string = file.getAbsolutePath();
        if (string.endsWith(".xgrf")) {
            return UnitexAction.loadXGrf(file, outilexEnvironment);
        }
        if (string.endsWith(".grf")) {
            return UnitexAction.loadGrf(file, outilexEnvironment);
        }
        return null;
    }

    public static GraphFrame loadGrf(File file, OutilexEnvironment outilexEnvironment) {
        try {
            if (!UnicodeIO.isAUnicodeLittleEndianFile(file)) {
                JOptionPane.showMessageDialog(null, file.getAbsolutePath() + " is not a unicode file", "Error", 0);
                return null;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(null, "Cannot open " + file.getAbsolutePath(), "Error", 0);
            return null;
        }
        GraphIO graphIO = GraphIO.loadGraph(file);
        if (graphIO == null) {
            return null;
        }
        GraphFrame graphFrame = new GraphFrame(true, outilexEnvironment);
        graphFrame.graphicalZone.pref = graphIO.pref;
        graphFrame.graphicalZone.pref.antialiasing = Preferences.pref.antialiasing;
        graphFrame.texte.setFont(graphFrame.graphicalZone.pref.input);
        graphFrame.graphicalZone.Width = graphIO.width;
        graphFrame.graphicalZone.Height = graphIO.height;
        graphFrame.graphicalZone.graphBoxes = graphIO.boxes;
        graphFrame.scroll.setPreferredSize(new Dimension(graphIO.width, graphIO.height));
        graphFrame.graphicalZone.setPreferredSize(new Dimension(graphIO.width, graphIO.height));
        graphFrame.setGraph(file);
        return graphFrame;
    }

    public static boolean saveAsGrf(GraphFrame graphFrame, File file) {
        GraphIO graphIO = new GraphIO();
        graphIO.boxes = graphFrame.graphicalZone.graphBoxes;
        graphIO.pref = graphFrame.graphicalZone.pref;
        graphIO.width = graphFrame.graphicalZone.Width;
        graphIO.height = graphFrame.graphicalZone.Height;
        String string = file.getAbsolutePath();
        if (!string.endsWith(".grf")) {
            file = new File(string + ".grf");
        }
        graphFrame.modified = false;
        graphIO.saveGraph(file);
        graphFrame.setGraph(file);
        graphFrame.setTitle(file.getName());
        return true;
    }

    public static boolean saveAsXGrf(GraphFrame graphFrame, File file) {
        GraphIO graphIO = new GraphIO();
        graphIO.boxes = graphFrame.graphicalZone.graphBoxes;
        graphIO.pref = graphFrame.graphicalZone.pref;
        graphIO.width = graphFrame.graphicalZone.Width;
        graphIO.height = graphFrame.graphicalZone.Height;
        graphFrame.modified = false;
        graphIO.saveGraph(file);
        graphFrame.setGraph(file);
        graphFrame.setTitle(file.getName());
        return true;
    }

    public static boolean saveAsGraph(GraphFrame graphFrame, File file) {
        String string = file.getAbsolutePath();
        if (!string.endsWith(".xgrf") && !string.endsWith(".grf")) {
            file = new File(string + ".xgrf");
            string = string + ".xgrf";
        }
        if (string.endsWith(".xgrf")) {
            return UnitexAction.saveAsXGrf(graphFrame, file);
        }
        if (string.endsWith(".grf")) {
            return UnitexAction.saveAsGrf(graphFrame, file);
        }
        return false;
    }

    public static boolean saveGraph(GraphFrame graphFrame) {
        File file = graphFrame.getGraph();
        GraphIO graphIO = new GraphIO();
        graphIO.boxes = graphFrame.graphicalZone.graphBoxes;
        graphIO.pref = graphFrame.graphicalZone.pref;
        graphIO.width = graphFrame.graphicalZone.Width;
        graphIO.height = graphFrame.graphicalZone.Height;
        graphFrame.modified = false;
        String string = file.getAbsolutePath();
        if (string.endsWith(".grf")) {
            string = string.substring(0, string.lastIndexOf(46)) + ".xgrf";
        }
        file = new File(string);
        graphIO.saveGraph(file);
        graphFrame.setGraph(file);
        graphFrame.setTitle(file.getName());
        return true;
    }

    public static void exportDot(GraphFrame graphFrame, File file) {
        GraphIO graphIO = new GraphIO();
        graphIO.boxes = graphFrame.graphicalZone.graphBoxes;
        graphIO.exportDot(file);
    }
}

