/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.unitex;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class NumericTextField
extends JTextField {
    public NumericTextField(String string) {
        this.setEditable(true);
        this.setText(string);
        this.setHorizontalAlignment(4);
    }

    public NumericTextField(int n, String string) {
        super(n);
        this.setEditable(true);
        this.setText(string);
        this.setHorizontalAlignment(4);
    }

    public Document createDefaultModel() {
        return new NumericTextDocument();
    }

    public void setText(int n) {
        this.setText("" + n);
    }

    private class NumericTextDocument
    extends PlainDocument {
        private NumericTextDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null) {
                return;
            }
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == '\n' || cArray[i] >= '0' && cArray[i] <= '9') continue;
                return;
            }
            super.insertString(n, string, attributeSet);
        }
    }
}

