/*
 * Decompiled with CFR 0.152.
 */
package fr.outilex.texts;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPInputStream;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.html.HTMLEditorKit;

public class TextPanel
extends JPanel {
    JTabbedPane parent;
    JEditorPane textArea;
    File textName;
    JComponent upperBar;
    boolean savable;

    public TextPanel() {
        this.init(null, true, "", null);
    }

    public TextPanel(JTabbedPane jTabbedPane) {
        this.init(jTabbedPane, true, "", null);
    }

    public TextPanel(JTabbedPane jTabbedPane, boolean bl) {
        this.init(jTabbedPane, bl, "", null);
    }

    public TextPanel(JTabbedPane jTabbedPane, boolean bl, JComponent jComponent) {
        this.init(jTabbedPane, bl, "", jComponent);
    }

    private void init(JTabbedPane jTabbedPane, boolean bl, String string, JComponent jComponent) {
        this.textArea = new JEditorPane();
        this.parent = jTabbedPane;
        this.setEditable(bl);
        this.textArea.setEnabled(true);
        this.upperBar = jComponent;
        this.savable = true;
        this.setLayout(new BorderLayout());
        this.textArea.setBorder(BorderFactory.createLoweredBevelBorder());
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        if (this.upperBar == null) {
            this.add((Component)jScrollPane, "Center");
        } else {
            this.add((Component)this.upperBar, "North");
            this.add((Component)jScrollPane, "South");
        }
    }

    public void setSavable(boolean bl) {
        this.savable = bl;
    }

    public String getText() {
        return this.textArea.getText();
    }

    public String getTitle() {
        if (this.textName == null) {
            return null;
        }
        return this.textName.getName();
    }

    public String getAbsolutePath() {
        if (this.textName == null) {
            return null;
        }
        return this.textName.getAbsolutePath();
    }

    public void setFile(String string) {
        this.textName = string == null ? null : new File(string);
    }

    public void load(String string, boolean bl) {
        try {
            this.setEditable(bl);
            if (string.endsWith(".gz")) {
                this.textArea.read((InputStream)new GZIPInputStream(new FileInputStream(string)), (Object)null);
            } else {
                this.textArea.setPage("file://" + string);
            }
            System.out.println(this.textArea.getContentType());
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.textArea.setText("This file is too large to be displayed...");
            this.setSavable(false);
            System.out.println("WHAT");
        }
        catch (IOException iOException) {
            this.setTitle("");
            System.out.println("Cannot open file " + string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isEditable() {
        return this.textArea.isEditable();
    }

    public void setEditable(boolean bl) {
        this.textArea.setEditable(bl);
    }

    public void setTitle(String string) {
        if (string != null) {
            this.textName = new File(string);
        }
        if (string == null || string.equals("")) {
            string = "new text";
        }
        int n = this.parent.getSelectedIndex();
        this.parent.setTitleAt(n, string);
    }

    public void setHtml() {
        this.textArea.setEditorKit(new HTMLEditorKit());
    }

    public void setPlain() {
        this.textArea.setEditorKit(new DefaultEditorKit());
    }

    public void save(String string) {
        if (!this.savable) {
            return;
        }
        if (string.endsWith(".gz")) {
            System.out.println("Cannot save a GZIP file: to be implemented");
            return;
        }
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8");
            outputStreamWriter.write(this.getText());
            outputStreamWriter.close();
            if (this.textName == null || this.textName.getAbsolutePath().equals("")) {
                this.setTitle(string);
            }
        }
        catch (IOException iOException) {
            System.out.println("Cannot save file " + string);
            return;
        }
    }
}

