/*
 * Decompiled with CFR 0.152.
 */
package fr.outilex.texts;

import fr.outilex.OutilexEnvironment;
import fr.outilex.process.ProcessActionListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class TextFsa
extends JPanel {
    private JTabbedPane parent;
    private String filename;
    private JTextField sentence;
    private OutilexEnvironment env;
    private JLabel automaton;
    private JScrollPane scp;

    public TextFsa(String string, OutilexEnvironment outilexEnvironment) {
        this.env = outilexEnvironment;
        this.parent = this.env.contentPane;
        this.filename = string;
        this.build();
    }

    public void build() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel("Sentence #");
        jPanel.add(jLabel);
        this.sentence = new JTextField("1");
        this.sentence.setPreferredSize(new Dimension(30, 20));
        jPanel.add(this.sentence);
        JButton jButton = new JButton("View");
        jButton.addActionListener(new ProcessActionListener("tfsaview", this.env, null));
        jPanel.add(jButton);
        this.add((Component)jPanel, "North");
        this.automaton = new JLabel();
        this.scp = new JScrollPane(this.automaton);
        this.add((Component)this.scp, "Center");
        this.validate();
        this.repaint();
    }

    public int getSentence() {
        String string = this.sentence.getText();
        return Integer.parseInt(string);
    }

    public String getPath() {
        return this.filename;
    }

    public String getShortname() {
        return new File(this.filename).getName();
    }

    public void setSentenceImage() {
        try {
            File file = new File(this.filename);
            String string = file.getParent() + "/sentence.png";
            BufferedImage bufferedImage = ImageIO.read(new File(string));
            try {
                int n = bufferedImage.getHeight(this.automaton);
                int n2 = bufferedImage.getWidth(this.automaton);
                BufferedImage bufferedImage2 = new BufferedImage(n, n2, 1);
                Graphics2D graphics2D = bufferedImage2.createGraphics();
                graphics2D.translate(n, 0);
                graphics2D.rotate(1.5707963267948966);
                graphics2D.drawImage(bufferedImage, 0, 0, n2, n, this.automaton);
                this.automaton.setIcon(new ImageIcon(bufferedImage2));
                this.scp.getViewport().setView(this.automaton);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                JOptionPane.showMessageDialog(this, "Out of memory error: too long sentence\nWe're dealing with this problem!", "Error", 0);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

