/*
 * Decompiled with CFR 0.152.
 */
package fr.outilex.projects;

import fr.outilex.OutilexContentPane;
import fr.outilex.OutilexEnvironment;
import fr.outilex.config.OutilexParameters;
import fr.outilex.dictionaries.Dico;
import fr.outilex.dictionaries.DicoActionListener;
import fr.outilex.dictionaries.DicoPanel;
import fr.outilex.grammars.Grammar;
import fr.outilex.grammars.GraphActionListener;
import fr.outilex.io.OutilexFileChoosers;
import fr.outilex.projects.DicoListModel;
import fr.outilex.projects.GrammarListModel;
import fr.outilex.projects.InsertResourceDialog;
import fr.outilex.projects.OutilexProject;
import fr.outilex.projects.TextListModel;
import fr.outilex.texts.Text;
import fr.outilex.texts.TextActionListener;
import fr.outilex.texts.TextPanel;
import fr.umlv.unitex.GraphFrame;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListModel;

public class ProjectActionListener
implements ActionListener {
    private String action;
    private Component source;
    private OutilexEnvironment env;
    private JPanel mainPanel;
    private TextListModel textsModel;
    private DicoListModel dicosModel;
    private GrammarListModel grfsModel;
    private OutilexProject project;
    public OutilexContentPane contentPane;

    public ProjectActionListener(String string, OutilexEnvironment outilexEnvironment, Component component) {
        this.action = string;
        this.env = outilexEnvironment;
        this.source = component;
        this.init(outilexEnvironment);
    }

    public ProjectActionListener(String string, OutilexEnvironment outilexEnvironment) {
        this.action = string;
        this.env = outilexEnvironment;
        this.source = null;
        this.init(outilexEnvironment);
    }

    void init(OutilexEnvironment outilexEnvironment) {
        this.contentPane = outilexEnvironment.contentPane;
        this.mainPanel = outilexEnvironment.mainPanel;
        this.project = outilexEnvironment.project;
        this.textsModel = (TextListModel)outilexEnvironment.texts.getModel();
        this.dicosModel = (DicoListModel)outilexEnvironment.dicos.getModel();
        this.grfsModel = (GrammarListModel)outilexEnvironment.grfs.getModel();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.action.equals("new")) {
            this.newProject();
            return;
        }
        if (this.action.equals("save")) {
            this.saveProject();
            return;
        }
        if (this.action.equals("saveas")) {
            this.saveAsProject();
            return;
        }
        if (this.action.equals("open")) {
            this.openProject();
            return;
        }
        if (this.action.equals("close")) {
            this.closeProject();
            return;
        }
        if (this.action.equals("exit")) {
            System.exit(0);
            return;
        }
        if (this.action.equals("closetab")) {
            this.closeSelectedTab();
            return;
        }
        if (this.action.equals("newtab")) {
            this.newTab();
            return;
        }
        if (this.action.equals("insert")) {
            ProjectActionListener.insertResource(false, this.env, this.source);
            return;
        }
        if (this.action.equals("insertSelected")) {
            ProjectActionListener.insertResource(true, this.env, this.source);
            return;
        }
        if (this.action.equals("openresource")) {
            ProjectActionListener.openResource(this.env, this.source);
            return;
        }
        if (this.action.equals("opentext")) {
            return;
        }
        if (this.action.equals("remove")) {
            ProjectActionListener.removeSelectedResource(this.env, this.source);
            return;
        }
        if (this.action.equals("setpriority")) {
            this.setDicoPriority();
            return;
        }
    }

    public static String getOpenableDictionary(String string) {
        String string2 = string.substring(0, string.length() - 4);
        String string3 = string2 + ".dic";
        if (new File(string3).exists()) {
            return string3;
        }
        string3 = string2 + ".dic.xml.gz";
        if (new File(string3).exists()) {
            return string3;
        }
        return null;
    }

    public static void openText(OutilexEnvironment outilexEnvironment) {
        String string = ((Text)outilexEnvironment.texts.getSelectedValue()).getPath();
        if (string == null) {
            return;
        }
        TextActionListener.openText(string, outilexEnvironment, true);
    }

    public static void openResource(OutilexEnvironment outilexEnvironment, Component component) {
        Object e;
        Object object;
        if (component instanceof JList) {
            object = (JList)component;
            e = ((JList)object).getSelectedValue();
            if (e == null) {
                return;
            }
        } else {
            return;
        }
        object = ProjectActionListener.getDefaultType(component);
        if (object == null) {
            return;
        }
        if (((String)object).equals("Graph")) {
            GraphActionListener.openGraph(((Grammar)e).getPath(), outilexEnvironment);
        }
        if (((String)object).equals("Dictionary")) {
            String string = ((Dico)e).getPath();
            String string2 = ProjectActionListener.getOpenableDictionary(string);
            if (string2 == null) {
                JOptionPane.showMessageDialog(null, "There exist no viewable dictionary for index " + string, "Warning", 0);
                return;
            }
            DicoActionListener.openDico(string2, outilexEnvironment, true);
            return;
        }
        if (((String)object).equals("Text")) {
            TextActionListener.openText(((Text)e).getPath(), outilexEnvironment, true);
            return;
        }
    }

    public static void removeSelectedResource(OutilexEnvironment outilexEnvironment, Component component) {
        Object e;
        ListModel listModel;
        if (component instanceof JList) {
            JList jList = (JList)component;
            listModel = jList.getModel();
            e = jList.getSelectedValue();
            if (e == null) {
                return;
            }
        } else {
            return;
        }
        if (listModel instanceof TextListModel) {
            ((TextListModel)listModel).removeText((Text)e);
        }
        if (listModel instanceof GrammarListModel) {
            ((GrammarListModel)listModel).removeGrammar((Grammar)e);
        }
        if (listModel instanceof DicoListModel) {
            ((DicoListModel)listModel).removeDico((Dico)e);
        }
    }

    public static void removeSelectedText(OutilexEnvironment outilexEnvironment) {
        Text text = (Text)outilexEnvironment.texts.getSelectedValue();
        if (text == null) {
            return;
        }
        TextListModel textListModel = (TextListModel)outilexEnvironment.texts.getModel();
        textListModel.removeText(text);
    }

    public void newTab() {
    }

    public static String selectResourceType(String[] stringArray, String string, OutilexEnvironment outilexEnvironment) {
        JFrame jFrame = outilexEnvironment.mainFrame;
        return (String)JOptionPane.showInputDialog(jFrame, "", "Choose a resource type", -1, null, stringArray, string);
    }

    public static String getResourceType(Component component) {
        if (component instanceof GraphFrame) {
            return "Graph";
        }
        if (component instanceof DicoPanel) {
            return "Dico";
        }
        if (component instanceof TextPanel) {
            return "Text";
        }
        return null;
    }

    public static String getFilename(Component component) {
        if (component instanceof GraphFrame) {
            GraphFrame graphFrame = (GraphFrame)component;
            return graphFrame.getGraph().getAbsolutePath();
        }
        if (component instanceof DicoPanel) {
            DicoPanel dicoPanel = (DicoPanel)component;
            return dicoPanel.getAbsolutePath();
        }
        if (component instanceof TextPanel) {
            TextPanel textPanel = (TextPanel)component;
            return textPanel.getAbsolutePath();
        }
        return null;
    }

    public static String getDefaultType(Component component) {
        String string = null;
        if (component == null) {
            return null;
        }
        if (component instanceof JList) {
            ListModel listModel = ((JList)component).getModel();
            if (listModel instanceof TextListModel) {
                string = "Text";
            }
            if (listModel instanceof GrammarListModel) {
                string = "Graph";
            }
            if (listModel instanceof DicoListModel) {
                string = "Dictionary";
            }
        }
        return string;
    }

    public static void insertResource(boolean bl, OutilexEnvironment outilexEnvironment, Component component) {
        String string;
        String string2;
        JFrame jFrame = outilexEnvironment.mainFrame;
        InsertResourceDialog insertResourceDialog = new InsertResourceDialog(jFrame, outilexEnvironment, ProjectActionListener.getDefaultType(component));
        if (!bl) {
            insertResourceDialog.setVisible(true);
        }
        if (bl || insertResourceDialog.isSelectedResource()) {
            Component component2 = outilexEnvironment.contentPane.getSelectedComponent();
            string2 = ProjectActionListener.getResourceType(component2);
            string = ProjectActionListener.getFilename(component2);
        } else {
            string2 = insertResourceDialog.getResourceType();
            string = insertResourceDialog.getFilename();
        }
        ProjectActionListener.insertResource(string, string2, outilexEnvironment, component);
    }

    public static void insertResource(String string, String string2, OutilexEnvironment outilexEnvironment, Component component) {
        if (string2 == null) {
            return;
        }
        if (string == null) {
            return;
        }
        if (string2.equals("Graph")) {
            GrammarListModel grammarListModel = (GrammarListModel)outilexEnvironment.grfs.getModel();
            grammarListModel.addGrammar(new Grammar(string));
            return;
        }
        if (string2.equals("Dico")) {
            DicoListModel dicoListModel = (DicoListModel)outilexEnvironment.dicos.getModel();
            String string3 = string;
            if (!string.endsWith(".idx")) {
                if (string.endsWith(".dic")) {
                    if (!new File(string = string.substring(0, string.length() - 3) + "idx").exists()) {
                        JOptionPane.showMessageDialog(null, "The dictionary index " + string + " does not exist.\n You should index " + string3 + " first\n", "Warning", 0);
                        return;
                    }
                } else if (string.endsWith(".dic.xml.gz")) {
                    if (!new File(string = string.substring(0, string.length() - 10) + "idx").exists()) {
                        JOptionPane.showMessageDialog(null, "The dictionary index " + string + " does not exist.\n You should index " + string3 + " first\n", "Warning", 0);
                        return;
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Your dictionary does have the good extension (.idx or .dic or .dic.xml.gz)", "Warning", 0);
                    return;
                }
            }
            dicoListModel.addDico(new Dico(string));
            return;
        }
        if (string2.equals("Text")) {
            TextListModel textListModel = (TextListModel)outilexEnvironment.texts.getModel();
            textListModel.addText(new Text(string));
            return;
        }
    }

    public void clearProject() {
        this.project.setProjectPath(null);
        this.dicosModel.clearDicos();
        this.textsModel.clearTexts();
        this.grfsModel.clearGrammars();
        this.contentPane.removeAll();
        this.contentPane.addPanel("Welcome", this.contentPane.createWelcomePanel());
        this.mainPanel.revalidate();
        this.env.mainFrame.setTitle("Outilex");
        this.env.mainPanel.locatePane.setGraphPath("");
    }

    public void closeProject() {
        this.clearProject();
    }

    public void newProject() {
        this.clearProject();
    }

    public void saveAsProject() {
        JFileChooser jFileChooser = OutilexFileChoosers.getSaveAsProjectFileChooser();
        int n = jFileChooser.showSaveDialog(this.env.mainFrame);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            String string = file.getAbsolutePath();
            if (!string.endsWith(".xop")) {
                string = string + ".xop";
            }
            if (this.project.save(string)) {
                this.env.mainFrame.setTitle("Outilex - " + string);
            }
        }
    }

    public void saveProject() {
        String string = this.project.getProjectPath();
        if (string == null) {
            this.saveAsProject();
            return;
        }
        this.project.save(string);
        this.env.mainFrame.setTitle("Outilex - " + string);
    }

    public void openProject() {
        File file;
        String string;
        JFileChooser jFileChooser = OutilexFileChoosers.getOpenProjectFileChooser();
        int n = jFileChooser.showOpenDialog(this.env.mainFrame);
        if (n == 0 && this.project.open(string = (file = jFileChooser.getSelectedFile()).getAbsolutePath())) {
            this.env.mainFrame.setTitle("Outilex - " + string);
            OutilexParameters.LANGUAGE = this.project.getLanguage();
            this.textsModel.update();
            this.dicosModel.update();
            this.grfsModel.update();
            this.env.mainPanel.locatePane.setGraphPath(this.project.getLocateGraph());
        }
    }

    public void setDicoPriority() {
        Dico dico = (Dico)this.env.dicos.getSelectedValue();
        if (dico == null) {
            return;
        }
        String string = JOptionPane.showInputDialog("Please input a priority (default: 10)");
        if (string != null) {
            dico.setPriority(string);
        }
    }

    public void closeSelectedTab() {
        this.contentPane.removeSelected();
    }
}

