/*
 * Decompiled with CFR 0.152.
 */
package fr.outilex.projects;

import fr.outilex.OutilexEnvironment;
import fr.outilex.dictionaries.DicoActionListener;
import fr.outilex.grammars.GraphActionListener;
import fr.outilex.texts.TextActionListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class InsertResourceDialog
extends JDialog {
    private String[] possibilities = new String[]{"Dictionary", "Graph", "Text"};
    private boolean selected;
    private String defaultType;
    private String resourceName;
    private String resourceType;
    private OutilexEnvironment env;

    public InsertResourceDialog(JFrame jFrame, OutilexEnvironment outilexEnvironment, String string) {
        super(jFrame, "Insert Resource In Project", true);
        this.env = outilexEnvironment;
        this.defaultType = string;
        this.createPanel();
    }

    private void createPanel() {
        JPanel jPanel = new JPanel();
        Dimension dimension = new Dimension(200, 20);
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createLineBorder(Color.gray));
        ButtonGroup buttonGroup = new ButtonGroup();
        final JRadioButton jRadioButton = new JRadioButton("already selected resource");
        JRadioButton jRadioButton2 = new JRadioButton("browse");
        final JLabel jLabel = new JLabel("Resource type");
        final JComboBox<String> jComboBox = new JComboBox<String>(this.possibilities);
        if (this.defaultType != null) {
            System.out.println(this.defaultType);
            jComboBox.setSelectedItem(this.defaultType);
        }
        final JLabel jLabel2 = new JLabel("File");
        final JTextField jTextField = new JTextField("");
        final JButton jButton = new JButton("...");
        JPanel jPanel4 = new JPanel();
        JButton jButton2 = new JButton("Insert");
        JButton jButton3 = new JButton("Cancel");
        final InsertResourceDialog insertResourceDialog = this;
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jRadioButton.isSelected()) {
                    insertResourceDialog.setVisible(false);
                    InsertResourceDialog.this.selected = true;
                    InsertResourceDialog.this.resourceName = "";
                    InsertResourceDialog.this.resourceType = "";
                    return;
                }
                if (!jTextField.getText().equals("")) {
                    insertResourceDialog.setVisible(false);
                    InsertResourceDialog.this.selected = false;
                    InsertResourceDialog.this.resourceName = jTextField.getText();
                    InsertResourceDialog.this.resourceType = InsertResourceDialog.this.getType((String)jComboBox.getSelectedItem());
                    return;
                }
            }
        });
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                insertResourceDialog.setVisible(false);
                InsertResourceDialog.this.selected = false;
                InsertResourceDialog.this.resourceName = "";
                InsertResourceDialog.this.resourceType = "";
            }
        });
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jLabel.setEnabled(false);
                jLabel2.setEnabled(false);
                jComboBox.setEnabled(false);
                jTextField.setEnabled(false);
                jButton.setEnabled(false);
            }
        });
        jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jLabel.setEnabled(true);
                jLabel2.setEnabled(true);
                jComboBox.setEnabled(true);
                jTextField.setEnabled(true);
                jButton.setEnabled(true);
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                String string2 = (String)jComboBox.getSelectedItem();
                if ((string2 = InsertResourceDialog.this.getType(string2)).equals("Graph")) {
                    string = GraphActionListener.selectGraph(InsertResourceDialog.this.env);
                    if (string == null) {
                        return;
                    }
                    jTextField.setText(string);
                }
                if (string2.equals("Dico")) {
                    string = DicoActionListener.selectIdxDico(InsertResourceDialog.this.env);
                    if (string == null) {
                        return;
                    }
                    jTextField.setText(string);
                }
                if (string2.equals("Text")) {
                    string = TextActionListener.selectText(InsertResourceDialog.this.env);
                    if (string == null) {
                        return;
                    }
                    jTextField.setText(string);
                }
            }
        });
        jRadioButton2.setSelected(true);
        jRadioButton.setSelected(false);
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        jPanel2.add(jRadioButton);
        jPanel2.add(jRadioButton2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        jComboBox.setPreferredSize(dimension);
        jPanel3.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel3.add(jComboBox, gridBagConstraints);
        jTextField.setPreferredSize(dimension);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        jPanel3.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel3.add((Component)jTextField, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jButton.setPreferredSize(new Dimension(20, 20));
        jPanel3.add((Component)jButton, gridBagConstraints);
        jPanel4.add(jButton2);
        jPanel4.add(jButton3);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        this.setContentPane(jPanel);
        this.setSize(400, 200);
    }

    public String getType(String string) {
        if (string.equals("Dictionary")) {
            return "Dico";
        }
        return string;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getFilename() {
        return this.resourceName;
    }

    public boolean isSelectedResource() {
        return this.selected;
    }
}

