/*
 * Decompiled with CFR 0.152.
 */
package fr.outilex.process;

import fr.outilex.OutilexContentPane;
import fr.outilex.OutilexEnvironment;
import fr.outilex.OutilexException;
import fr.outilex.OutilexMainPanel;
import fr.outilex.config.OutilexParameters;
import fr.outilex.dictionaries.Dico;
import fr.outilex.grammars.Grammar;
import fr.outilex.process.Command;
import fr.outilex.process.ProcessInfo;
import fr.outilex.texts.Text;
import fr.outilex.texts.TextFsa;
import fr.outilex.utils.OutilexUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class ProcessActionListener
implements ActionListener {
    private String action;
    private OutilexEnvironment env;
    private OutilexMainPanel mainPanel;

    public ProcessActionListener(String string, OutilexEnvironment outilexEnvironment, OutilexMainPanel outilexMainPanel) {
        this.action = string;
        this.env = outilexEnvironment;
        this.mainPanel = outilexMainPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.action.equals("clean")) {
            return;
        }
        if (this.action.equals("clear")) {
            this.clearCheckBoxes();
            return;
        }
        if (this.action.equals("default")) {
            ProcessActionListener.init(this.mainPanel);
            return;
        }
        if (this.action.equals("tfsaview")) {
            this.viewTextFsa();
        }
        if (this.action.equals("go")) {
            ProcessActionListener.go(this.env, this.mainPanel);
            return;
        }
    }

    public ArrayList buildPSViewCommand(int n, String string) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        Command command = new Command();
        command.setProg("tfsa2dot");
        command.addArgument("tfsa2dot");
        String string2 = OutilexParameters.LINGDIR + "/" + OutilexParameters.LANGUAGE + "/lingdef.xml";
        command.addArgument("-l");
        command.addArgument(string2);
        command.addArgument("-o");
        String string3 = new File(string).getParent() + "/sentence";
        String string4 = string3 + ".dot";
        command.addArgument(string4);
        command.addArgument(string);
        command.addArgument("-n");
        command.addArgument("" + n);
        arrayList.add(command);
        command = new Command();
        command.setProg("dot");
        command.addArgument("dot");
        command.addArgument("-Tpng");
        command.addArgument(string4);
        command.addArgument("-o");
        String string5 = string3 + ".png";
        command.addArgument(string5);
        arrayList.add(command);
        command = new Command();
        command.setType(Command.OUTILEX);
        command.setProg("tfsaview");
        command.addArgument("tfsaview");
        arrayList.add(command);
        return arrayList;
    }

    void viewTextFsa() {
        OutilexContentPane outilexContentPane = this.env.contentPane;
        Component component = outilexContentPane.getSelectedComponent();
        if (component instanceof TextFsa) {
            TextFsa textFsa = (TextFsa)component;
            new ProcessInfo(this.buildPSViewCommand(textFsa.getSentence(), textFsa.getPath()), this.env).start();
        }
    }

    void clearCheckBoxes() {
        this.mainPanel.clean.setSelected(false);
        this.mainPanel.normalize.setSelected(false);
        this.mainPanel.segment.setSelected(false);
        this.mainPanel.applyDico.setSelected(false);
        this.mainPanel.applyGrf.setSelected(false);
        this.mainPanel.elagFSA.setSelected(false);
        this.mainPanel.viewFSA.setSelected(false);
        this.mainPanel.locatePattern.setSelected(false);
        this.mainPanel.buildConcordance.setSelected(false);
    }

    public static void init(OutilexMainPanel outilexMainPanel) {
        outilexMainPanel.clean.setEnabled(true);
        outilexMainPanel.normalize.setEnabled(true);
        outilexMainPanel.segment.setEnabled(true);
        outilexMainPanel.applyDico.setEnabled(true);
        outilexMainPanel.applyGrf.setEnabled(true);
        outilexMainPanel.elagFSA.setEnabled(false);
        outilexMainPanel.viewFSA.setEnabled(false);
        outilexMainPanel.locatePattern.setEnabled(true);
        outilexMainPanel.buildConcordance.setEnabled(true);
    }

    public static void disableAll(OutilexMainPanel outilexMainPanel) {
        outilexMainPanel.clean.setEnabled(false);
        outilexMainPanel.normalize.setEnabled(false);
        outilexMainPanel.segment.setEnabled(false);
        outilexMainPanel.applyDico.setEnabled(false);
        outilexMainPanel.applyGrf.setEnabled(false);
        outilexMainPanel.elagFSA.setEnabled(false);
        outilexMainPanel.viewFSA.setEnabled(false);
        outilexMainPanel.locatePattern.setEnabled(false);
        outilexMainPanel.buildConcordance.setEnabled(false);
    }

    public static String check(OutilexMainPanel outilexMainPanel) {
        return "";
    }

    public static void go(OutilexEnvironment outilexEnvironment, OutilexMainPanel outilexMainPanel) {
        try {
            new ProcessInfo(ProcessActionListener.buildProcessCommands(outilexMainPanel), outilexEnvironment).start();
        }
        catch (OutilexException outilexException) {
            JOptionPane.showMessageDialog(outilexMainPanel, outilexException.what(), "Error", 0);
        }
    }

    public static ArrayList buildProcessCommands(OutilexMainPanel outilexMainPanel) throws OutilexException {
        ArrayList arrayList = new ArrayList();
        try {
            if (outilexMainPanel.clean.isSelected()) {
                arrayList.addAll(ProcessActionListener.buildCleanCommands(outilexMainPanel));
            }
            if (outilexMainPanel.segment.isSelected()) {
                arrayList.addAll(ProcessActionListener.buildSegmentationCommands(outilexMainPanel));
            }
            if (outilexMainPanel.applyDico.isSelected()) {
                arrayList.addAll(ProcessActionListener.buildApplyDicoCommands(outilexMainPanel));
            }
            if (outilexMainPanel.normalize.isSelected()) {
                arrayList.addAll(ProcessActionListener.buildNormalizeCommands(outilexMainPanel));
            }
            if (outilexMainPanel.applyGrf.isSelected()) {
                arrayList.addAll(ProcessActionListener.buildApplyGrfCommands(outilexMainPanel));
            }
            if (outilexMainPanel.locatePattern.isSelected()) {
                arrayList.addAll(ProcessActionListener.buildLocatePatternCommands(outilexMainPanel));
            }
            if (outilexMainPanel.buildConcordance.isSelected()) {
                arrayList.addAll(ProcessActionListener.buildConcordanceCommands(outilexMainPanel));
            }
            return arrayList;
        }
        catch (OutilexException outilexException) {
            throw new OutilexException(outilexException.what());
        }
    }

    public static void checkClean(String string) throws OutilexException {
        if (string == null) {
            throw new OutilexException("You should select a text!");
        }
    }

    public static ArrayList buildCleanCommands(OutilexMainPanel outilexMainPanel) throws OutilexException {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        try {
            String string = ProcessActionListener.getSelectedText(outilexMainPanel);
            ProcessActionListener.checkClean(string);
            File file = new File(string + ".dir");
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return arrayList;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                arrayList.add(Command.deleteFileCommand(fileArray[i].getAbsolutePath()));
            }
            return arrayList;
        }
        catch (OutilexException outilexException) {
            throw new OutilexException(outilexException.what());
        }
    }

    public static void checkSegmentation(String string) throws OutilexException {
        if (string == null) {
            throw new OutilexException("You should select a text!");
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new OutilexException("File " + string + " does not exist!");
        }
    }

    public static ArrayList buildSegmentationCommands(OutilexMainPanel outilexMainPanel) throws OutilexException {
        try {
            ArrayList<Command> arrayList = new ArrayList<Command>();
            String string = ProcessActionListener.getSelectedText(outilexMainPanel);
            ProcessActionListener.checkSegmentation(string);
            Command command = new Command();
            command.setProg("tokenization");
            command.addArgument(OutilexParameters.BINDIR + "/tokenization");
            command.addArgument(string);
            arrayList.add(command);
            arrayList.add(Command.createDirCommand(string + ".dir"));
            String string2 = new File(string).getName();
            arrayList.add(Command.moveFileCommand(string + ".postfilter", string + ".dir/" + string2 + ".postfilter"));
            arrayList.add(Command.moveFileCommand(string + ".segmentation", string + ".dir/" + string2 + ".segmentation"));
            arrayList.add(Command.moveFileCommand(string + ".tokenization", string + ".dir/" + string2 + ".tokenization"));
            return arrayList;
        }
        catch (OutilexException outilexException) {
            throw new OutilexException(outilexException.what());
        }
    }

    public static String getSelectedText(OutilexMainPanel outilexMainPanel) throws OutilexException {
        Text text = (Text)outilexMainPanel.texts.getSelectedValue();
        if (text == null) {
            throw new OutilexException("You should select a text !");
        }
        return text.getPath();
    }

    public static String getSegmentedText(String string) throws OutilexException {
        if (string == null) {
            throw new OutilexException("You should select a text !");
        }
        String string2 = new File(string).getName();
        String string3 = string + ".dir/" + string2 + ".segmentation";
        return string3;
    }

    public static String getTextFsa(String string) throws OutilexException {
        if (string == null) {
            throw new OutilexException("You should select a text!");
        }
        String string2 = new File(string).getName();
        String string3 = string + ".dir/" + string2;
        return string3;
    }

    public static ArrayList buildApplyDicoCommands(OutilexMainPanel outilexMainPanel) throws OutilexException {
        String string;
        String string2;
        ArrayList<Command> arrayList = new ArrayList<Command>();
        Object[] objectArray = outilexMainPanel.dicos.getSelectedValues();
        if (objectArray == null) {
            throw new OutilexException("You need to select the different dictionaries you want to apply on text!");
        }
        int n = objectArray.length;
        if (n <= 0) {
            throw new OutilexException("You need to select the different dictionaries you want to apply on text!");
        }
        String[] stringArray = new String[n];
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            Dico dico = (Dico)objectArray[i];
            string2 = dico.getPath();
            int n2 = dico.getPriority();
            string = string2;
            if (!string2.endsWith(".idx")) {
                throw new OutilexException("The selected dictionary (" + string2 + ") should end with the extension .idx");
            }
            if (!new File(string).exists()) {
                throw new OutilexException(string + " does not exist");
            }
            stringArray[i] = string;
            nArray[i] = n2;
        }
        Command command = new Command();
        command.setProg("apply-dic");
        command.addArgument(OutilexParameters.BINDIR + "/apply-dic");
        for (int i = 0; i < n; ++i) {
            command.addArgument("-dic");
            command.addArgument(stringArray[i]);
            command.addArgument("" + nArray[i]);
        }
        command.addArgument("-imaj");
        command.addArgument("-icase");
        command.addArgument("-imark");
        String string3 = OutilexParameters.LINGDIR + "/" + OutilexParameters.LANGUAGE + "/lingdef.xml";
        command.addArgument("-l");
        command.addArgument(string3);
        string2 = ProcessActionListener.getSelectedText(outilexMainPanel);
        String string4 = ProcessActionListener.getSegmentedText(string2);
        command.addArgument(string4);
        arrayList.add(command);
        string = ProcessActionListener.getTextFsa(string2);
        arrayList.add(Command.copyFileCommand(string + ".fsa", string + "-0.fsa"));
        if (outilexMainPanel.dicoRPane.textFsaView()) {
            command = new Command();
            command.setType(Command.OUTILEX);
            command.setProg("opentextfsa");
            command.addArgument("opentextfsa");
            command.addArgument(string + "-0.fsa");
            arrayList.add(command);
        }
        return arrayList;
    }

    public static Command buildCompileGrfCommand(String string) throws OutilexException {
        if (!string.endsWith(".xgrf")) {
            throw new OutilexException("Graph should be an xgrf graph");
        }
        File file = new File(string);
        Command command = new Command();
        command.setProg("make-wrtn");
        command.addArgument(OutilexParameters.BINDIR + "/make-wrtn");
        command.addArgument("-l");
        command.addArgument(OutilexParameters.LINGDIR + "/" + OutilexParameters.LANGUAGE + "/lingdef.xml");
        command.addArgument(file.getAbsolutePath());
        return command;
    }

    public static ArrayList buildNormalizeCommands(OutilexMainPanel outilexMainPanel) throws OutilexException {
        try {
            ArrayList<Command> arrayList = new ArrayList<Command>();
            String string = ProcessActionListener.getSelectedText(outilexMainPanel);
            String string2 = ProcessActionListener.getTextFsa(string);
            String string3 = OutilexParameters.LINGDIR + "/" + OutilexParameters.LANGUAGE + "/Norm.xgrf";
            arrayList.add(ProcessActionListener.buildCompileGrfCommand(string3));
            Command command = new Command();
            command.setProg("transduct-fsa");
            command.addArgument(OutilexParameters.BINDIR + "/transduct-fsa");
            command.addArgument("-l");
            command.addArgument(OutilexParameters.LINGDIR + "/" + OutilexParameters.LANGUAGE + "/lingdef.xml");
            command.addArgument("-gram");
            String string4 = OutilexUtils.getPathWithoutExtension(new File(string3).getAbsolutePath());
            command.addArgument(string4 + ".wrtn");
            command.addArgument("-o");
            command.addArgument(string2 + "-norm.fsa");
            command.addArgument(string2 + ".fsa");
            arrayList.add(command);
            arrayList.add(Command.copyFileCommand(string2 + "-norm.fsa", string2 + ".fsa"));
            return arrayList;
        }
        catch (OutilexException outilexException) {
            throw new OutilexException(outilexException.what());
        }
    }

    public static ArrayList buildApplyGrfCommands(OutilexMainPanel outilexMainPanel) throws OutilexException {
        try {
            Command command;
            ArrayList<Command> arrayList = new ArrayList<Command>();
            String string = ProcessActionListener.getSelectedText(outilexMainPanel);
            String string2 = ProcessActionListener.getTextFsa(string);
            Object[] objectArray = outilexMainPanel.grfs.getSelectedValues();
            if (objectArray == null) {
                throw new OutilexException("You should select the different graphs you want to apply on text-fsa!");
            }
            int n = objectArray.length;
            if (n <= 0) {
                throw new OutilexException("You should select the different graphs you want to apply on text-fsa!");
            }
            for (int i = 0; i < n; ++i) {
                String string3 = ((Grammar)objectArray[i]).getPath();
                arrayList.add(ProcessActionListener.buildCompileGrfCommand(string3));
                command = new Command();
                command.setProg("decore-fsa");
                command.addArgument(OutilexParameters.BINDIR + "/decore-fsa");
                command.addArgument("-l");
                command.addArgument(OutilexParameters.LINGDIR + "/" + OutilexParameters.LANGUAGE + "/lingdef.xml");
                command.addArgument("-rtn");
                String string4 = OutilexUtils.getPathWithoutExtension(new File(string3).getAbsolutePath());
                command.addArgument(string4 + ".wrtn");
                String string5 = "";
                String string6 = "-final";
                if (i > 0) {
                    string5 = "-" + new Integer(i);
                }
                if (i < n - 1) {
                    string6 = "-" + new Integer(i + 1);
                }
                command.addArgument("-o");
                command.addArgument(string2 + string6 + ".fsa");
                command.addArgument(string2 + string5 + ".fsa");
                arrayList.add(command);
            }
            arrayList.add(Command.copyFileCommand(string2 + "-final.fsa", string2 + ".fsa"));
            if (outilexMainPanel.grfRPane.textFsaView()) {
                command = new Command();
                command.setType(Command.OUTILEX);
                command.setProg("opentextfsa");
                command.addArgument("opentextfsa");
                command.addArgument(string2 + "-final.fsa");
                arrayList.add(command);
            }
            return arrayList;
        }
        catch (OutilexException outilexException) {
            throw new OutilexException(outilexException.what());
        }
    }

    public static Command buildConcordancerCommand(OutilexMainPanel outilexMainPanel, String string, String string2) {
        Command command = new Command();
        command.setProg("concordancer");
        command.addArgument(OutilexParameters.BINDIR + "/concordancer");
        command.addArgument("-l");
        command.addArgument(OutilexParameters.LINGDIR + "/" + OutilexParameters.LANGUAGE + "/lingdef.xml");
        command.addArgument("-gram");
        String string3 = OutilexUtils.getPathWithoutExtension(new File(string).getAbsolutePath());
        command.addArgument(string3 + ".wrtn");
        if (outilexMainPanel.locatePane.isLongestMatch()) {
            command.addArgument("-longest-match");
        }
        if (outilexMainPanel.locatePane.isMerge()) {
            command.addArgument("-m");
        }
        command.addArgument("-o");
        String string4 = new File(string2).getName();
        String string5 = string2 + ".dir/concord.index";
        command.addArgument(string5);
        String string6 = string2 + ".dir/" + string4 + ".fsa";
        command.addArgument(string6);
        return command;
    }

    public static Command buildDisplayResultCommand(String string) {
        Command command = new Command();
        command.setType(Command.OUTILEX);
        command.setProg("openreadtext");
        command.addArgument("openreadtext");
        command.addArgument(string);
        return command;
    }

    public static String getTransductOutput(OutilexMainPanel outilexMainPanel, String string) {
        return string + ".dir/" + outilexMainPanel.locatePane.getResultName();
    }

    public static Command buildTransductionCommand(OutilexMainPanel outilexMainPanel, String string, String string2) {
        Command command = new Command();
        command.setProg("wrtn-txt-transduct");
        command.addArgument(OutilexParameters.BINDIR + "/wrtn-txt-transduct");
        command.addArgument("-l");
        command.addArgument(OutilexParameters.LINGDIR + "/" + OutilexParameters.LANGUAGE + "/lingdef.xml");
        command.addArgument("-gram");
        String string3 = OutilexUtils.getPathWithoutExtension(new File(string).getAbsolutePath());
        command.addArgument(string3 + ".wrtn");
        command.addArgument(outilexMainPanel.locatePane.getFormatOption());
        command.addArgument(outilexMainPanel.locatePane.getOutputOption());
        command.addArgument("-o");
        String string4 = new File(string2).getName();
        String string5 = string2 + ".dir/" + outilexMainPanel.locatePane.getResultName();
        command.addArgument(string5);
        String string6 = string2 + ".dir/" + string4 + ".fsa";
        command.addArgument(string6);
        return command;
    }

    public static ArrayList buildLocatePatternCommands(OutilexMainPanel outilexMainPanel) throws OutilexException {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        String string = ProcessActionListener.getSelectedText(outilexMainPanel);
        String string2 = outilexMainPanel.locatePane.getGraphPath();
        if (string2 == null || string2.equals("")) {
            throw new OutilexException("You should select a graph!");
        }
        if (!string2.endsWith(".xgrf")) {
            throw new OutilexException("The selected graph should be a xgrf graph");
        }
        arrayList.add(ProcessActionListener.buildCompileGrfCommand(string2));
        if (outilexMainPanel.locatePane.isConcordancer()) {
            arrayList.add(ProcessActionListener.buildConcordancerCommand(outilexMainPanel, string2, string));
        } else {
            arrayList.add(ProcessActionListener.buildTransductionCommand(outilexMainPanel, string2, string));
            arrayList.add(ProcessActionListener.buildDisplayResultCommand(ProcessActionListener.getTransductOutput(outilexMainPanel, string)));
        }
        return arrayList;
    }

    public static ArrayList buildConcordanceCommands(OutilexMainPanel outilexMainPanel) throws OutilexException {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        String string = ProcessActionListener.getSelectedText(outilexMainPanel);
        Command command = new Command();
        command.setProg("make-concord-html");
        command.addArgument(OutilexParameters.BINDIR + "/make-concord-html");
        String string2 = string + ".dir/concord.index";
        command.addArgument(string2);
        command.addArgument("-left");
        command.addArgument("" + outilexMainPanel.concordPane.getLeftSize());
        command.addArgument("-right");
        command.addArgument("" + outilexMainPanel.concordPane.getRightSize());
        command.addArgument("-o");
        String string3 = string + ".dir/concord.html";
        command.addArgument(string3);
        if (outilexMainPanel.concordPane.isInTextOrder()) {
            command.addArgument("-dontsort");
        }
        arrayList.add(command);
        command = new Command();
        command.setType(Command.OUTILEX);
        command.setProg("openreadtext");
        command.addArgument("openreadtext");
        command.addArgument(string3);
        arrayList.add(command);
        return arrayList;
    }
}

