/*
 * Decompiled with CFR 0.152.
 */
package fr.outilex.grammars;

import fr.outilex.OutilexContentPane;
import fr.outilex.OutilexEnvironment;
import fr.outilex.io.OutilexFileChoosers;
import fr.outilex.utils.OutilexUtils;
import fr.umlv.unitex.GraphAlignmentMenu;
import fr.umlv.unitex.GraphFrame;
import fr.umlv.unitex.GraphPresentationMenu;
import fr.umlv.unitex.GraphSizeMenu;
import fr.umlv.unitex.UnitexAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;

public class GraphActionListener
implements ActionListener {
    String action = "";
    OutilexEnvironment env;

    public GraphActionListener(String string, OutilexEnvironment outilexEnvironment) {
        this.action = string;
        this.env = outilexEnvironment;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.action.equals("new")) {
            GraphActionListener.newGraph(this.env);
            return;
        }
        if (this.action.equals("open")) {
            GraphActionListener.openGraph(this.env);
            return;
        }
        if (this.action.equals("saveas")) {
            this.saveAsGraph();
            return;
        }
        if (this.action.equals("save")) {
            this.saveGraph();
            return;
        }
        if (this.action.equals("addtoproject")) {
            GraphActionListener.addToProject(this.env);
            return;
        }
        if (this.action.equals("export")) {
            GraphActionListener.export(this.env);
            return;
        }
        if (this.action.equals("alignment")) {
            this.align();
            return;
        }
        if (this.action.equals("antialiasing")) {
            this.antialiasing();
            return;
        }
        if (this.action.equals("presentation")) {
            this.presentation();
            return;
        }
        if (this.action.equals("graphsize")) {
            this.graphSize();
            return;
        }
        if (this.action.equals("fitintab")) {
            this.fitInTab();
            return;
        }
        if (this.action.equals("fit60")) {
            this.fit(60);
            return;
        }
        if (this.action.equals("fit80")) {
            this.fit(80);
            return;
        }
        if (this.action.equals("fit100")) {
            this.fit(100);
            return;
        }
        if (this.action.equals("fit120")) {
            this.fit(120);
            return;
        }
        if (this.action.equals("fit140")) {
            this.fit(140);
            return;
        }
    }

    public static void newGraph(OutilexEnvironment outilexEnvironment) {
        OutilexContentPane outilexContentPane = outilexEnvironment.contentPane;
        GraphFrame graphFrame = new GraphFrame(false, outilexEnvironment);
        outilexContentPane.addPanel("New graph", graphFrame);
        outilexContentPane.setSelectedIndex(outilexContentPane.getTabCount() - 1);
    }

    public static void openGraph(String string, OutilexEnvironment outilexEnvironment) {
        GraphFrame graphFrame = UnitexAction.loadGraph(new File(string), outilexEnvironment);
        if (graphFrame == null) {
            return;
        }
        OutilexContentPane outilexContentPane = outilexEnvironment.contentPane;
        outilexContentPane.addPanel(OutilexUtils.getFileName(string), graphFrame);
        outilexContentPane.setSelectedIndex(outilexContentPane.getTabCount() - 1);
    }

    public static String selectGraph(Component component) {
        JFileChooser jFileChooser = OutilexFileChoosers.getOpenGraphFileChooser();
        int n = jFileChooser.showOpenDialog(component);
        if (n == 0) {
            return jFileChooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    public static String selectGraph(OutilexEnvironment outilexEnvironment) {
        return GraphActionListener.selectGraph(outilexEnvironment.mainFrame);
    }

    public static void openGraph(OutilexEnvironment outilexEnvironment) {
        String string = GraphActionListener.selectGraph(outilexEnvironment);
        if (string != null) {
            GraphActionListener.openGraph(string, outilexEnvironment);
        }
    }

    private void saveGraph() {
        GraphActionListener.saveGraph(this.env);
    }

    public static void saveGraph(OutilexEnvironment outilexEnvironment) {
        OutilexContentPane outilexContentPane = outilexEnvironment.contentPane;
        Component component = outilexContentPane.getSelectedComponent();
        if (component instanceof GraphFrame) {
            GraphFrame graphFrame = (GraphFrame)component;
            if (graphFrame == null) {
                return;
            }
            if (graphFrame.getGraph() == null) {
                GraphActionListener.saveAsGraph(outilexEnvironment);
            } else {
                UnitexAction.saveGraph(graphFrame);
            }
        }
    }

    private void saveAsGraph() {
        GraphActionListener.saveAsGraph(this.env);
    }

    public static void saveAsGraph(OutilexEnvironment outilexEnvironment) {
        OutilexContentPane outilexContentPane = outilexEnvironment.contentPane;
        Component component = outilexContentPane.getSelectedComponent();
        if (component instanceof GraphFrame) {
            GraphFrame graphFrame = (GraphFrame)component;
            if (graphFrame == null) {
                return;
            }
            JFileChooser jFileChooser = OutilexFileChoosers.getSaveAsGraphFileChooser();
            int n = jFileChooser.showSaveDialog(outilexEnvironment.mainFrame);
            if (n != 0) {
                return;
            }
            UnitexAction.saveAsGraph(graphFrame, jFileChooser.getSelectedFile());
            outilexContentPane.setTitleAt(outilexContentPane.getSelectedIndex(), graphFrame.getGraph().getName());
        }
    }

    public static void addToProject(OutilexEnvironment outilexEnvironment) {
    }

    public static void export(OutilexEnvironment outilexEnvironment) {
        OutilexContentPane outilexContentPane = outilexEnvironment.contentPane;
        Component component = outilexContentPane.getSelectedComponent();
        if (component instanceof GraphFrame) {
            GraphFrame graphFrame = (GraphFrame)component;
            if (graphFrame == null) {
                return;
            }
            JFileChooser jFileChooser = OutilexFileChoosers.getExportGraphFileChooser();
            int n = jFileChooser.showOpenDialog(outilexEnvironment.mainFrame);
            if (n != 0) {
                return;
            }
            String string = jFileChooser.getSelectedFile().getAbsolutePath();
            if (string.endsWith(".dot")) {
                UnitexAction.exportDot(graphFrame, jFileChooser.getSelectedFile());
            }
        }
    }

    public void align() {
        Component component = this.env.contentPane.getSelectedComponent();
        if (component == null) {
            return;
        }
        if (component instanceof GraphFrame) {
            GraphFrame graphFrame = (GraphFrame)component;
            new GraphAlignmentMenu(graphFrame.graphicalZone.isGrid, graphFrame.graphicalZone.nPixels, this.env);
        }
    }

    public void antialiasing() {
        Component component = this.env.contentPane.getSelectedComponent();
        if (component == null) {
            return;
        }
        if (component instanceof GraphFrame) {
            GraphFrame graphFrame = (GraphFrame)component;
            graphFrame.changeAntialiasingValue();
        }
    }

    public void presentation() {
        Component component = this.env.contentPane.getSelectedComponent();
        if (component == null) {
            return;
        }
        if (component instanceof GraphFrame) {
            new GraphPresentationMenu(this.env);
        }
    }

    public void graphSize() {
        Component component = this.env.contentPane.getSelectedComponent();
        if (component == null) {
            return;
        }
        if (component instanceof GraphFrame) {
            new GraphSizeMenu(this.env);
        }
    }

    public void fitInTab() {
        Component component = this.env.contentPane.getSelectedComponent();
        if (component == null) {
            return;
        }
        if (component instanceof GraphFrame) {
            GraphFrame graphFrame = (GraphFrame)component;
            Dimension dimension = graphFrame.scroll.getSize();
            double d = (double)(dimension.width - 3) / (double)graphFrame.graphicalZone.Width;
            double d2 = (double)(dimension.height - 3) / (double)graphFrame.graphicalZone.Height;
            if (d < d2) {
                graphFrame.setScaleFactor(d);
            } else {
                graphFrame.setScaleFactor(d2);
            }
        }
    }

    public void fit(int n) {
        Component component = this.env.contentPane.getSelectedComponent();
        if (component == null) {
            return;
        }
        if (component instanceof GraphFrame) {
            GraphFrame graphFrame = (GraphFrame)component;
            graphFrame.removeComponentListener(graphFrame.compListener);
            graphFrame.setScaleFactor((double)n / 100.0);
        }
    }
}

