#ifndef _REALTIME_THREAD
#define _REALTIME_THREAD

#include "classes.h"
#include "threads.h"

#define GC_MEM									0
#define IMMORTAL_MEM							1

#define rt_get_thread(thread) ((Thread*)&(thread->_super))

FOURBYTES thread_start_time;

#if SlackStealer == 1
extern JINT laxity_level[MAX_PRIORITY];
extern JINT laxity;
extern JINT date_last_activity;
extern JBYTE last_thread;
extern JINT instant_time;
#endif

#if SlackStealer == 2
extern JINT laxity_bylevel[MAX_PRIORITY];
extern JINT ci[MAX_PRIORITY];
extern JINT wi[MAX_PRIORITY];
extern JINT laxity;
extern JINT date_last_activity;
extern JINT date_first_activity;
extern JINT date_last_begin;
extern JINT date_last_end;
extern JBYTE last_thread;
extern JINT instant_time;
#endif

void init_rt_threads(void);
void init_rt_thread(RealtimeThread *rtThread, byte memoryType);

void dequeue_rt_thread(RealtimeThread *rtthread);
RealtimeThread* current_is_rt();

void prepare_2_wait(RealtimeThread *rtThread);
inline void schedule_periodic(RealtimeThread *rtthread);

void check_deadline();

inline void rt_set_start(RealtimeThread *rtThread, JINT);
inline void rt_set_period(RealtimeThread *rtThread, JINT);
inline void rt_set_cost(RealtimeThread *rtThread, int);
inline void rt_set_deadline(RealtimeThread *rtThread, int);

extern RealtimeThread* findRealtimeThread(Thread * t);

#if SlackStealer == 1
extern void init_laxity_bylevel();
extern void first_start_laxity(RealtimeThread *rtthread);
extern void search_global_laxity();
extern void evaluate_laxity(RealtimeThread *prio);
extern JINT interference(RealtimeThread *rtt, RealtimeThread *prio);
extern JINT number_request(JINT a, JINT b, JINT periode);
extern JINT minimal(JINT a, JINT b);
extern void laxity_rtthread_begin();
extern void laxity_rtthread_end();
extern JINT instant_laxity();
#endif

#if SlackStealer == 2
extern void init_laxity_bylevel();
extern void first_start_laxity(RealtimeThread *rtthread);
extern void search_global_laxity();
extern void evaluate_laxity_first(RealtimeThread *prio);
extern JINT interference_init(RealtimeThread *rtt, RealtimeThread *prio);
extern void laxity_rtthread_end();
extern JINT interference(RealtimeThread *rtt);
extern void laxity_rtthread_begin();
extern JINT instant_laxity();
#endif

#endif
