#include "stdlib.h"
#include "realtime_threads.h"
#include "async_event_handler.h"
#include "monitor_control.h"
#include "exceptions.h"
#include "interpreter.h"
#include "specialsignatures.h"
#include "stack.h"
#include "configure.h"




/**
 * List of waitting start time Thread
 * 
 */
static RealtimeThread *rtThreadQ;

#if SlackStealer == 1
/**
*
* Slack stealer DASS
*/
JINT laxity_bylevel[MAX_PRIORITY];
JINT laxity;
JINT date_last_activity;
JBYTE last_thread;
JINT instant_time;
#endif

#if SlackStealer == 2
/**
*
* Slack Stealer MASS
*/
JINT laxity_bylevel[MAX_PRIORITY];
JINT ci[MAX_PRIORITY];
JINT wi[MAX_PRIORITY];
JINT laxity;
JINT date_last_activity;
JINT date_first_activity;
JINT date_last_begin;
JINT date_last_end;
JBYTE last_thread;
JINT instant_time;
#endif



void init_rt_threads(void){
	rtThreadQ = NULL;
}

void init_rt_thread(RealtimeThread *rtThread, byte memoryType){


#if IMMORTAL_MEM_ACTIVED == 0
	if(memoryType == IMMORTAL_MEM) {
		throw_exception(illegalStateException);
		return;
	}
#endif


	//protect_obj(rtThread);
	int now = (int)get_sys_time();

	rtThread->memoryType = memoryType;

	init_thread(rt_get_thread(rtThread));
	
	if(rtThread->start > 0){
		rtThread->startPeriod = now + rtThread->start; 
		// we can't use sleep_thread because our thread
		// is not the currentThread.
		rt_get_thread(rtThread)->sleepUntil = rtThread->start + get_sys_time();
		rt_get_thread(rtThread)->state = START_DELAYED;
	} else {
		rtThread->startPeriod = now; 
	}
	rtThread->endDeadline = rtThread->startPeriod + rtThread->deadline; 
	
	//add realtime thread into realtime thread queue
	rtThread->nextRealtimeThread = ptr2ref(rtThreadQ);
	rtThreadQ = rtThread;
	//unprotect_obj(rtThread);

	#if SlackStealer == 1
	//DASS ajout du rtthread
	first_start_laxity(rtThread);
	#endif
	
	#if SlackStealer == 2
	//MASS ajout du rtthread
	first_start_laxity(rtThread);
	#endif
	
	rtThread->remainingCost = rtThread->cost; 

}

void prepare_2_wait(RealtimeThread *rtThread){
	FOURBYTES time = (rtThread->startPeriod + rtThread->period);
	//set up the time of the next start
	if(time > get_sys_time()){
		// we need to use get_sys_time() and not 
		// a variable sets earlier to be more precise.
		sleep_thread(time - get_sys_time());
	} else  {
		//rt_get_thread(rtThread)->sleepUntil = 0;
	}
	
	//update the absolute time of the realtime thread
	rtThread->startPeriod += rtThread->period;
	rtThread->endDeadline += rtThread->period;
	
	#if SlackStealer == 1
	//DASS fin d'activite avant la remise à cost de remainingCost
	rtThread->remainingCost = 0;
	laxity_rtthread_end();
	#endif
	#if SlackStealer == 2
	//MASS fin d'activite 
	laxity_rtthread_end();
	#endif
	
	rtThread->remainingCost = rtThread->cost; 

	schedule_request(REQUEST_SWITCH_THREAD);
}

inline void rt_set_start(RealtimeThread *rtThread, JINT start) {
	rtThread->start = start;
}

inline void rt_set_period(RealtimeThread *rtThread, JINT period) {
	rtThread->period = period;
}

inline void rt_set_cost(RealtimeThread *rtThread, int cost) {
	rtThread->cost = cost;
}

inline void rt_set_deadline(RealtimeThread *rtThread, int deadline) {
	rtThread->deadline = deadline;
	
}

void check_deadline() {
	RealtimeThread *rtthread = rtThreadQ;
	int now = (int)get_sys_time();
//	protect_obj(rtThreadQ);
	while(rtthread){
		//check deadline
		//deadline == 0  infinite time
		if(rtthread->deadline != 0 && rtthread->endDeadline < now){

			if(rtthread->deadlineMissHandler){
				getAndIncrementPendingFireCount(ref2ptr(rtthread->deadlineMissHandler));
			}
			dequeue_rt_thread(rtthread);	
			dequeue_thread(rt_get_thread(rtthread));
			schedule_request(REQUEST_SWITCH_THREAD);

			//lancement du handler 
/*			set_top_ref_cur (ptr2ref ());
			dispatch_virtual ((Object *) candidate, run_4_5V, null);
*/		}
		

		//check cost overrun on the current thread
		// cost ==0 infinite time
		if(currentThread->threadId == rt_get_thread(rtthread)->threadId && rtthread->cost != 0){
			//rtthread->remainingCost -= (now - thread_start_time);
			rtthread->remainingCost -= (get_sys_time() - thread_start_time);
			if(rtthread->remainingCost < 0){
				if(rtthread->costOverrunHandler){
					getAndIncrementPendingFireCount(ref2ptr(rtthread->costOverrunHandler));
				}
				dequeue_rt_thread(rtthread);	
				dequeue_thread(rt_get_thread(rtthread));
				schedule_request(REQUEST_SWITCH_THREAD);
			}
		}

		rtthread = rtthread->nextRealtimeThread;
	}
//unprotect_obj(rtThreadQ);
}

void dequeue_rt_thread(RealtimeThread *rtthread){
	RealtimeThread *rtt = rtThreadQ;
	RealtimeThread *previous=NULL;
	
	if(rtthread == NULL) {
		return;
	}
	if(rtt == rtthread){
		rtThreadQ = ref2ptr(rtThreadQ->nextRealtimeThread);
	} else {
	  do{
	    previous=rtt;
	    rtt=ref2ptr(rtt->nextRealtimeThread);
	  }while(rtt!=rtthread);
	  previous->nextRealtimeThread=rtthread->nextRealtimeThread;
	}
	rtthread->nextRealtimeThread = NULL;
}


RealtimeThread* current_is_rt(){
	 RealtimeThread *rtt = rtThreadQ;
    while(rtt){
			if(rt_get_thread(rtt)->threadId == currentThread->threadId){
				return rtt;
			}
			rtt = rtt->nextRealtimeThread;
	  }
	  return NULL;
}

inline void schedule_periodic(RealtimeThread *rtthread){		
	//on calcul la prochaine activation
	// et les autres temps
	rtthread->startPeriod += rtthread->period;
	rtthread->endDeadline += rtthread->period;

//	printf("time: %d, next start: %d, next dl: %d\n", now, rtthread->startPeriod, rtthread->endDeadline);

	//on le rajoute dans la liste de rt Thread
	rtthread->nextRealtimeThread = rtThreadQ;
	rtThreadQ = rtthread;
	//on rajoute dans le scheduleur
	enqueue_thread(rt_get_thread(rtthread));	
}

RealtimeThread* findRealtimeThread(Thread * t){
  RealtimeThread* anchorRtThread = rtThreadQ;
  if (anchorRtThread == null){
    return null;
  }

  RealtimeThread* currentRtThread = anchorRtThread;
  do{
    if (rt_get_thread(currentRtThread) == t){
      return currentRtThread;
    }
    currentRtThread = currentRtThread->nextRealtimeThread;

  }while (currentRtThread != null && currentRtThread != anchorRtThread);

  return null;
}

#if SlackStealer == 1
/**
*
* Implantation DASS
*/
/*Initialisation */
void init_laxity_bylevel(){
  int i;
  laxity=-1; 
  last_thread=-1; // aucun rtthread ne s'est execute auparavant
  date_last_activity = get_sys_time(); 
  for(i=0;i<MAX_PRIORITY;i++)
    laxity_bylevel[i]=-1;
}

/* Fonction appelee a chaque depart de RTthread : calcule laxite en verifiant si le thread n'est pas arrive tardivement */
void first_start_laxity(RealtimeThread *rtthread){
  RealtimeThread *rtthread2 = rtThreadQ;
  int i;
  instant_time=get_sys_time();
  if(instant_time-date_last_activity>=1){
    //mise à jour des autres Si pour avoir une laxite correcte si la rtthread est arrive loin d'un changement de contexte
    if(last_thread == -1){
      for(i=0;i<MAX_PRIORITY;i++){
	if(laxity_bylevel[i]!=-1){
	  laxity_bylevel[i]-= (instant_time - date_last_activity);
	}
      }
    }
    else{
      for(i=0;i<MAX_PRIORITY;i++){
	if(laxity_bylevel[i]!=-1 && i+1>last_thread ){
	  laxity_bylevel[i]-= (instant_time - date_last_activity);
	}
      }
    } 
  }
  /* si les rtthreads ne sont pas declares dans l'ordre de priorite, on recalcule les Si des rtthreads moins prioritaires */
  while(rtthread2){
    if(rt_get_thread(rtthread2)->priority < rt_get_thread(rtthread)->priority){
     evaluate_laxity(rtthread2);
    }
    rtthread2 = (RealtimeThread *)rtthread2->nextRealtimeThread;
  }
  
  evaluate_laxity(rtthread);
  search_global_laxity();
  date_last_activity = get_sys_time();
}

/* laxite globale avec parcours de tous les Si */
void search_global_laxity(){
  int i;
  laxity=-1; //à chaque recherche, remise de laxity à -1 pour prendre en compte les nouveaux calculs.
  for(i=0;i<MAX_PRIORITY;i++){
   if(laxity==-1 && laxity_bylevel[i]!=-1 ){
     laxity = laxity_bylevel[i];
   }
   else if(laxity_bylevel[i]!=-1 && laxity_bylevel[i]<laxity  ){
     laxity = laxity_bylevel[i];
    }
  }
}

/* laxite au niveau i correspondant au thread prio*/
void evaluate_laxity(RealtimeThread *prio){
  JINT interfer = 0;
  
  JINT tmp;
  
  RealtimeThread *rtthread2 = rtThreadQ;
  while(rtthread2){
    if(rt_get_thread(rtthread2)->priority >= rt_get_thread(prio)->priority){
     interfer+=interference(rtthread2,prio);
    }
    rtthread2 = (RealtimeThread *)rtthread2->nextRealtimeThread;
  }
  
  tmp = prio->endDeadline - instant_time - interfer;
  if (tmp<0) tmp = 0;
    laxity_bylevel[(rt_get_thread(prio)->priority) -1]= tmp;
}

/* Interference causee par le RT rtt subie par le RT prio */
JINT interference(RealtimeThread *rtt,RealtimeThread *prio){
  
  JINT result;
  result = /*rtt-> remainingCost +*/ (rtt->cost) * number_request(rtt->startPeriod,prio->endDeadline,rtt->period)+ minimal(rtt->cost,(prio->endDeadline-rtt->startPeriod - number_request(rtt->startPeriod,prio->endDeadline,rtt->period)*rtt->period ));
  
  return result;
}


JINT number_request(JINT a, JINT b, JINT periode){
  JINT res;
  res= (b-a)/periode;
  if(res<0)
    return 0;
  else
    return res;
}

JINT minimal(JINT a, JINT b){
  JINT c;
  c=b;
  if(b<0)
    c=0;
  
  if(a<c)
    return a;
  else
    return c;
}

/* Calcul en debut d'activite du rtthread */
void laxity_rtthread_begin(){
  int i;
  instant_time = get_sys_time();
  /*on ignore les delais de calcul de l'ordonnanceur pour eviter des mises à jours trop repetees*/
  if(instant_time-date_last_activity>=3){
    if(last_thread == -1){
      for(i=0;i<MAX_PRIORITY;i++){
	if(laxity_bylevel[i]!=-1){
	  laxity_bylevel[i]-= (instant_time - date_last_activity);
	}
      }
    }
    else{
      for(i=0;i<MAX_PRIORITY;i++){
	if(laxity_bylevel[i]!=-1 && i+1>last_thread ){
	  laxity_bylevel[i]-= (instant_time - date_last_activity);
	}
      }
    }
    date_last_activity=instant_time;
    search_global_laxity();
  }
  last_thread=currentThread->priority;
}

/*Calcul en fin d'activite du rtthread */
void laxity_rtthread_end(){
  int i;
  instant_time = get_sys_time();
//  last_thread=currentThread->priority;
  for(i=0;i<MAX_PRIORITY;i++){
    if(laxity_bylevel[i]!=-1 && i+1>last_thread ){
      laxity_bylevel[i]-= (instant_time - date_last_activity);
    }
  }
  evaluate_laxity(current_is_rt());
  date_last_activity=instant_time;
  current_is_rt()->started=0;
  last_thread=-1; // aucun rtthread ne s'execute
  search_global_laxity();
}

JINT instant_laxity(){
  instant_time = get_sys_time();
  JINT tmp;
  tmp=laxity-(instant_time-date_last_activity);
  if(last_thread!=-1)
    return laxity;
  else{
    if(tmp<0)
      return 0;
    else
      return tmp; 
  }
  
}
#endif





#if SlackStealer == 2
/**
*
* Implantation MASS
*/
/*Initialisation */
void init_laxity_bylevel(){
  int i;
  laxity=-1; 
  last_thread=-1; // aucun rtthread ne s'est execute auparavant
  date_last_activity = get_sys_time(); 
  date_first_activity=-1;
  date_last_begin=-1;
  date_last_end=-1;
  for(i=0;i<MAX_PRIORITY;i++){
    ci[i]=-1;
    wi[i]=-1;
    laxity_bylevel[i]=-1;
  }
}

/* Fonction appelee a chaque depart de RTthread : calcule laxite en verifiant si le thread n'est pas arrive tardivement */
void first_start_laxity(RealtimeThread *rtthread){
  RealtimeThread *rtthread2 = rtThreadQ;
  int i;
  instant_time=get_sys_time();
  /* si les rtthreads ne sont pas declares dans l'ordre de priorite, on recalcule les Si des rtthreads moins prioritaires */
  while(rtthread2){
    if(rt_get_thread(rtthread2)->priority < rt_get_thread(rtthread)->priority){
     evaluate_laxity_first(rtthread2);
    }
    rtthread2 = (RealtimeThread *)rtthread2->nextRealtimeThread;
  }
  
  evaluate_laxity_first(rtthread);
  search_global_laxity();
  date_last_activity = instant_time;
}


/* laxite globale avec calcul et parcours de tous les Si */
void search_global_laxity(){
  int i;
  laxity=-1; //à chaque recherche, remise de laxity à -1 pour prendre en compte les nouveaux calculs.
  for(i=0;i<MAX_PRIORITY;i++){
    if(ci[i]!=-1){
     laxity_bylevel[i]=wi[i]-ci[i];
    }
  }
  for(i=0;i<MAX_PRIORITY;i++){
   if(laxity==-1 && laxity_bylevel[i]!=-1 ){
     laxity = laxity_bylevel[i];
   }
   else if(laxity_bylevel[i]!=-1 && laxity_bylevel[i]<laxity  ){
     laxity = laxity_bylevel[i];
    }
  }
}


/* laxite au niveau i correspondant au thread prio*/
void evaluate_laxity_first(RealtimeThread *prio){
  JINT interfer = 0;
    
  RealtimeThread *rtthread2 = rtThreadQ;
  while(rtthread2){
    if(rt_get_thread(rtthread2)->priority > rt_get_thread(prio)->priority){
     interfer+=interference_init(rtthread2,prio);
    }
    rtthread2 = (RealtimeThread *)rtthread2->nextRealtimeThread;
  }
  wi[(rt_get_thread(prio)->priority) -1]=prio->deadline-interfer;
  ci[(rt_get_thread(prio)->priority) -1]=prio->cost;
}

/* Interference causee par le RT rtt subie par le RT prio lors du calcul initial */
JINT interference_init(RealtimeThread *rtt,RealtimeThread *prio){
  
  JINT result;
  JINT tmp;
  tmp=prio->deadline%rtt->period;
  if(tmp==0)
    result=rtt->cost * (prio->deadline/rtt->period);
  else
    result=rtt->cost * ((prio->deadline/rtt->period)+1);
  
  return result;
}

/*Calcul en fin d'activite du rtthread */
void laxity_rtthread_end(){
  int i;
  JINT dtf;
  RealtimeThread *currentRt = current_is_rt();
  instant_time = get_sys_time();
  last_thread=currentThread->priority;//pour les cas de premption, risque de voir last_thread=-1
  dtf=instant_time-date_last_end;
  laxity=-1;
  for(i=0;i<MAX_PRIORITY;i++){
    if(laxity_bylevel[i]!=-1){
      if(i+1>last_thread ){
	wi[i]-=dtf;
      }
      else if(i+1<last_thread){
	wi[i]=wi[i]-dtf+currentRt->cost; 
      }
      else{
	ci[i]=currentRt->cost;
	wi[i]=wi[i]-dtf+currentRt->period-interference(currentRt);
      }
      laxity_bylevel[i]=wi[i]-ci[i];
      if(laxity==-1 && laxity_bylevel[i]!=-1)
	laxity=laxity_bylevel[i];
      else if(laxity_bylevel[i]!=-1 && laxity_bylevel[i]<laxity)
	laxity=laxity_bylevel[i];
    } 
  }
  date_last_activity=instant_time;
  date_last_end=instant_time;
  current_is_rt()->started=0;
  last_thread=-1; // aucun rtthread ne s'execute
}

JINT interference(RealtimeThread *rtt){
  JINT interfer=0;
  int k,r,u;
  RealtimeThread *rtthread2 = rtThreadQ;
  while(rtthread2){
    if(rt_get_thread(rtthread2)->priority > rt_get_thread(rtt)->priority){
      r=rtt->period%rtthread2->period;
      k=rtt->period/rtthread2->period;
      if(rtt->startPeriod%rtthread2->period==0)
	u=(((rtt->startPeriod/rtthread2->period))*rtthread2->period)-rtt->startPeriod;
      else
	u=(((rtt->startPeriod/rtthread2->period)+1)*rtthread2->period)-rtt->startPeriod;
      if(u<=r)
	interfer+=(k+1)*rtthread2->cost;
      else
	interfer+=k*rtthread2->cost;
    }
    rtthread2 = (RealtimeThread *)rtthread2->nextRealtimeThread;
  }
  return interfer;
}



/* Calcul en debut d'activite du rtthread */
void laxity_rtthread_begin(){
  instant_time = get_sys_time();

  if(last_thread!=-1){
    if(instant_time-date_last_end<=instant_time-date_last_begin)
      ci[last_thread-1]-= instant_time-date_last_end;
    else
      ci[last_thread-1]-= instant_time-date_last_begin;
  }
  else{
    if(date_first_activity==0){
	tmp=laxity-(instant_time-date_last_activity);
	if(tmp<0)
	  laxity= 0;
	else
	  laxity= tmp; 
      }
  }
  if(date_first_activity==-1){
    date_first_activity=0;
    date_last_activity=instant_time;
    date_last_end=instant_time;
  }
  date_last_begin=instant_time;
  last_thread=currentThread->priority;
}


JINT instant_laxity(){
  instant_time = get_sys_time();
  JINT tmp;
  tmp=laxity-(instant_time-date_last_activity);
  if(last_thread!=-1)
    return laxity;
  else{
    if(tmp<0)
      return 0;
    else
      return tmp; 
  }
}

#endif
































