/* 
 * File:   monitor_control.h
 * Author: amahendran
 *
 * Created on 27 fvrier 2010, 15:51
 */

#ifndef _MONITOR_CONTROL_H
#define	_MONITOR_CONTROL_H

#include "classes.h"
#include "threads.h"
#include "constants.h"
#include "memory.h"
#include "rconsole.h"

#define NB_MONITOR_CONTROLS MAX_PRIORITY+2 //0 for PIP - 100 for EDF

extern REFERENCE monitorControls;
extern MonitorControl **monitorControlsQ;
extern MonitorControl *defaultMC;

extern void init_monitor_controls();
extern void init_monitor_control(MonitorControl *pMc, JINT syncType, JINT prioCeil);
extern void enqueue_mc(MonitorControl *pMc);
extern void dequeue_mc(MonitorControl *pMc);

extern void set_all_mc(MonitorControl *pMC);
extern MonitorControl* find_monitor_in_queue(objSync *pSync);
extern void set_one_mc(Object *mon, MonitorControl *pMC);
extern MonitorControl* get_mc(Object *mon);
extern MonitorControl* getInitialThreadPriority(Thread* pThread);
extern JINT getCurrentSync();
extern JINT getCurrentDefaultCeilingPriority();

#endif	/* _MONITOR_CONTROL_H */

