#include "monitor_control.h"

REFERENCE monitorControls;
MonitorControl **monitorControlsQ = null;

//
MonitorControl *defaultMC = null;

void init_monitor_controls(){
    int i;

    monitorControls = ptr2ref(new_primitive_array(T_REFERENCE, NB_MONITOR_CONTROLS));
    monitorControlsQ = (MonitorControl **)ref_array(monitorControls);
    //gMCCounter = 0;
    for (i = 0; i<NB_MONITOR_CONTROLS; i++)
    {
        monitorControlsQ[i] = null;
    }
    //if (defaultMC==null){
        defaultMC = (MonitorControl*) new_object_for_class(LEJOS_REALTIME_MONITORCONTROL);
        defaultMC->ceilingPriority=0;
        defaultMC->synchronizationType=PIP;
        defaultMC->threadPriority=0;
        defaultMC->sync=null;
        defaultMC->immortal=0;
        defaultMC->threadID = 0;
    //}
}

void init_monitor_control(MonitorControl *pMC, JINT syncType, JINT prioCeil){
    if (defaultMC==null){
        defaultMC = (MonitorControl*) new_object_for_class(LEJOS_REALTIME_MONITORCONTROL);
        defaultMC->ceilingPriority=0;
        defaultMC->synchronizationType=PIP;
        defaultMC->threadPriority=0;
        defaultMC->sync=null;
        defaultMC->immortal=0;
        defaultMC->threadID=0;
    }

    pMC->ceilingPriority=prioCeil;
    pMC->synchronizationType=syncType;
    pMC->threadPriority=0;
    pMC->sync=null;
    pMC->immortal=0;
    pMC->threadID=0;
}

void enqueue_mc(MonitorControl *pMc){
    JINT cIndex = pMc->ceilingPriority;
    MonitorControl *previous = monitorControlsQ[cIndex];
    monitorControlsQ[cIndex] = pMc;
    if (previous == null){
        pMc->nextMonitorControl = ptr2ref(pMc);
    }
    else {
        MonitorControl *pNext = word2ptr(previous->nextMonitorControl);
        pMc->nextMonitorControl = ptr2ref(pNext);
        previous->nextMonitorControl = ptr2ref(pMc);
    }
}

void dequeue_mc(MonitorControl *pMc){
    // First take it out of its current queue
    JINT cIndex = pMc->ceilingPriority;
    MonitorControl **pMCQ = &monitorControlsQ[cIndex];

    if (*pMCQ == null){
        return;
    }

    // Find the previous mc at the old priority
    MonitorControl *previous = *pMCQ;
    while (word2ptr(previous->nextMonitorControl) != pMc){
        previous = word2ptr(previous->nextMonitorControl);
    }
    if (previous == pMc)
    {
        *pMCQ = null;
    }
    else
    {
        previous->nextMonitorControl = pMc->nextMonitorControl;
        *pMCQ = previous;
    }
}

//Native function which sets all the monitor with the given synchronization type
void set_all_mc(MonitorControl *pMC){ //This is a parameter, not the variable used to call this
    defaultMC->ceilingPriority = pMC->ceilingPriority;

    defaultMC->synchronizationType = pMC->synchronizationType;
    MonitorControl **pQ = monitorControlsQ;
    int i =0;
    for (i = 0; i<NB_MONITOR_CONTROLS; i++)
    {
        
        
        if (pQ[i] == null || pQ[i]->ceilingPriority == pMC->ceilingPriority){
            continue;
        }

        MonitorControl *anchor = pQ[i];
        MonitorControl *current = anchor;
        do{

            if (pMC->synchronizationType == PIP){
                current->immortal = 0;
            }
            else if (pMC->synchronizationType == PCE && current->immortal == 1){
                current = word2ptr(current->nextMonitorControl);
                continue;
            }

            MonitorControl *next = word2ptr(current->nextMonitorControl);
            dequeue_mc(current);
            current->ceilingPriority=pMC->ceilingPriority;
            current->synchronizationType=pMC->synchronizationType;
            enqueue_mc(current);
            current = next;
        }while(current!=anchor);
    }

}

MonitorControl* find_monitor_in_queue(objSync *pSync){
    MonitorControl **pQ = monitorControlsQ;
    int i =0;
    for (i = 0; i<NB_MONITOR_CONTROLS; i++)
    {
        if (pQ[i] == null){
            continue;
        }
        MonitorControl *anchor = pQ[i];
        MonitorControl *current = anchor;
        do{
            if (current->sync == pSync){
                return current;
            }
            current = word2ptr(current->nextMonitorControl);
        }while(current!=anchor);
    }
    return null;
}

void set_one_mc(Object *mon, MonitorControl *pMC){
    if (defaultMC->synchronizationType != pMC->synchronizationType){
        set_all_mc(pMC);
    }
    MonitorControl *mc = find_monitor_in_queue(&(mon->sync));
    if (mc!=null){
        dequeue_mc(mc);
    }
    else{
        mc = (MonitorControl*) new_object_for_class(LEJOS_REALTIME_MONITORCONTROL);

    }
    mc->ceilingPriority = pMC->ceilingPriority;
    mc->synchronizationType = pMC->synchronizationType;
    mc->sync = &(mon->sync);
    //Remove this condition if you want to use both PIP and PCE (keep the instruction mc->immortal = 1;). Other modifications have to be done
    if (pMC->synchronizationType==PCE){
        mc->immortal = 1;
    }
    enqueue_mc(mc);
}

MonitorControl* get_mc(Object *mon){
    MonitorControl *mc = (MonitorControl*) new_object_for_class(LEJOS_REALTIME_MONITORCONTROL);
    MonitorControl *tmp = find_monitor_in_queue(&(mon->sync));
    mc->ceilingPriority = tmp->ceilingPriority;
    mc->immortal = tmp->immortal;
    mc->nextMonitorControl = JNULL;
    mc->sync = null;
    mc->synchronizationType = tmp->synchronizationType;
    mc->threadID = 0;
    mc->threadPriority = 0;
    return mc;
    //return find_monitor_in_queue(&(mon->sync));
}

MonitorControl* getInitialThreadPriority(Thread* pThread){
    MonitorControl *current = monitorControlsQ[pThread->priority];
    MonitorControl *anchor = current;
    MonitorControl *final = null;
    byte newLoop = 0;
    do{
        if (newLoop ==1){
            anchor = current;
            newLoop=0;
        }
        if (current == null){
            return final;
        }
        if (current->threadID == pThread->threadId && current->ceilingPriority != current->threadPriority){
            final = current;
            current = monitorControlsQ[current->threadPriority];
            newLoop=1;
            continue;
        }
        current = word2ptr(current->nextMonitorControl);
    }while (anchor != current);
    return final;
}

JINT getCurrentSync(){
    return defaultMC->synchronizationType;
}

JINT getCurrentDefaultCeilingPriority(){
    return defaultMC->ceilingPriority;
}