#include "stdlib.h"
#include "async_event_handler.h"
#include "stack.h"
#include "realtime_threads.h"
#include "threads.h"

#undef push_word()
#undef push_ref()
#define push_word( a) push_word_cur( a)
#define push_ref( a)  push_ref_cur( a)


static AsyncEventHandler *asyncHandlerQ;

void enqueue_async_handler(AsyncEventHandler *async) {
	async->nextAsyncHandler = asyncHandlerQ;
	asyncHandlerQ = async;
}

void dequeue_async_handler(AsyncEventHandler *async) {
	AsyncEventHandler *aeh = asyncHandlerQ;

	if(aeh == async) {
		asyncHandlerQ = asyncHandlerQ->nextAsyncHandler;
	} else {
		while((aeh != NULL) && ((aeh = aeh->nextAsyncHandler) != async));
		if(aeh != NULL) {
			aeh->nextAsyncHandler = async->nextAsyncHandler;
		}
		async->nextAsyncHandler = NULL;
	}
}

void check_fire() {
	AsyncEventHandler *aeh = asyncHandlerQ;
	while(aeh) {
		if(aeh->fireCount > 0){ 
			if(aeh->absoluteMinInterarrival < get_sys_time()){
				aeh->absoluteMinInterarrival = get_sys_time()+aeh->minInterarrival;
				
				RealtimeThread * rt = (RealtimeThread *) aeh->rtthread;
				enqueue_thread(rt_get_thread(rt));
				--(aeh->fireCount);
			}
		} else {
			dequeue_async_handler(aeh);
		}
		aeh = aeh->nextAsyncHandler;
	}
}

void getAndIncrementPendingFireCount(AsyncEventHandler * aeh) {
	byte tmp = aeh->fireCount;
	++(aeh->fireCount);
	push_word(tmp);
	if(tmp == 0) {
		enqueue_async_handler(aeh);
	}
}

void getAndDecrementPendingFireCount(AsyncEventHandler * aeh) {
	byte tmp = aeh->fireCount;
	--aeh->fireCount;
	push_word(tmp);
	if(aeh->fireCount == 0) {
		dequeue_async_handler(aeh);
	}
}

void getAndClearPendingFireCount(AsyncEventHandler * aeh) {
	byte tmp = aeh->fireCount;
	aeh->fireCount = 0;
	push_word(tmp);
}
