package lejos.pc.tools;

import lejos.pc.comm.*;
import java.io.*;
import javax.swing.*;

import java.awt.*;

/***
 *GUI application to write the leJOS Virtual Machine and Menu system to the NXT
 * Flash. Created on August 15, 2008, 9:36 AM revised Nov 10, 2008 to run with
 * Java 5 Author Roger Glassey based on Andy Shaw original command line code
 */
public class NXJFlashG extends javax.swing.JFrame {
	private static final long serialVersionUID = 177459839585979953L;

	// GUI generated by NetBeans
	/** Creates new form NXJFlashG */
	public NXJFlashG() {
		initComponents();
		setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);
		flasher = new Flasher();
		setVisible(true);
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.0
	 */
	// <editor-fold defaultstate="collapsed"
	// desc="Generated Code">//GEN-BEGIN:initComponents
	private void initComponents() {
		setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
		setTitle("Install  NXJ  Firmware in  NXT");
		setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);
		JPanel p1 = new JPanel();
		goB = new javax.swing.JButton();
		goB.setText(" Start Program ");
		p1.add(goB);
		add(p1, BorderLayout.NORTH);
		msgPanel = new javax.swing.JPanel();
		msgPanel.setPreferredSize(new Dimension(400, 160));
		add(msgPanel, BorderLayout.SOUTH);

		progressTxt = new javax.swing.JTextArea();
		progressLabel = new javax.swing.JLabel("Progress Log", SwingConstants.CENTER);
		progressTxt.setColumns(30);
		progressTxt.setRows(70);

		JPanel progress = new JPanel(new BorderLayout());
		progress.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
		progress.setMinimumSize(new Dimension(350, 550));
		progress.add(progressLabel, BorderLayout.NORTH);
		progress.add(progressTxt, BorderLayout.CENTER);

		JPanel progBarPanel = new JPanel(new BorderLayout());
		progBarPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
		progBarPanel.setMinimumSize(new Dimension(300, 50));
		progBarLabel = new javax.swing.JLabel(" ", SwingConstants.CENTER);
		progBar = new javax.swing.JProgressBar(0, 100);
		progBar.setStringPainted(true);
		progBarPanel.add(progBar, BorderLayout.NORTH);
		progBarPanel.add(progBarLabel, BorderLayout.SOUTH);
		progress.add(progBarPanel, BorderLayout.SOUTH);
		add(progress, BorderLayout.CENTER);

		goB.setText("Start program");
		goB.addActionListener(new java.awt.event.ActionListener() {

			public void actionPerformed(java.awt.event.ActionEvent evt) {
				goBActionPerformed();
			}
		});

	}

	private void goBActionPerformed() {
		flasher.start();
	}

	/**
	 * @param args
	 *            the command line arguments
	 */
	public static void main(String args[]) {
		new NXJFlashG().setVisible(true);

	}

	/**
	 * Inner class to to the real work
	 */
	private class Flasher extends Thread implements NXJFlashUI {
		NXJFlashUpdate updater = new NXJFlashUpdate(this);

		public void message(String str) {
			progressTxt.append(str + "\n");
		}

		public void progress(String str, int percent) {
			if (str.length() <= 0)
				progBarLabel.setText(" ");
			else
				progBarLabel.setText(str);
			progBar.setValue(percent);
		}

		@Override
		public void run() {
			boolean more = true;
			while (more) {
				JOptionPane.showMessageDialog(msgPanel,
						"Click OK when your NXT is turned on and connected ");
				try {
					String home = System.getProperty("nxj.home");
					if (home == null)
						home = System.getenv("NXJ_HOME");
					byte[] memoryImage = updater.createFirmwareImage(null,
							null, home);
					boolean format = 0 == JOptionPane.showConfirmDialog(
							msgPanel,
							"Do you want to erase all NXT files now?",
							"Clear memory first", JOptionPane.YES_NO_OPTION);
					byte[] fs = null;
					if (format)
						fs = updater.createFilesystemImage();
					NXTSamba nxt = openDevice();
					if (nxt != null)
						updater.updateDevice(nxt, memoryImage, fs, true, true, true);
				} catch (Exception e) {
					JOptionPane.showMessageDialog(msgPanel,
							"Bad news: An error has occurred " + e,
							"Fatal error ", JOptionPane.ERROR_MESSAGE);
					System.exit(1);

				}
				more = 0 == JOptionPane.showConfirmDialog(msgPanel,
						"Do you want to flash firmware again?", "Question",
						JOptionPane.YES_NO_OPTION);
			}
			System.exit(1);
		}

		/**
		 * Locate and open an NXT device ready for the firmware to be updated.
		 * First we look for devices that are already in SAM-BA mode. If we do
		 * not find any we look for devices in normal mode and attempt to
		 * re-boot them into SAM-BA mode.
		 * 
		 * @return
		 */
		NXTSamba openDevice() throws NXTCommException, IOException {
			// First look to see if there are any devices already in SAM-BA mode
			NXTSamba samba = updater.openSambaDevice(0);
			if (samba == null) {
				NXTInfo[] nxts;
				progressTxt
						.append("\nNo devices in firmware update mode were found.\nSearching for other NXT devices.\n");
				NXTConnector conn = new NXTConnector();
				nxts = conn.search(null, null, NXTCommFactory.USB);
				if (nxts.length <= 0) {
					JOptionPane
							.showMessageDialog(
									msgPanel,
									"No NXT found. \nPlease check that it's turned on and connected.",
									"Warning", JOptionPane.WARNING_MESSAGE);
					return null;
				}
				progressTxt.append("Found " + nxts[0].name
						+ " Bluetooth address  " + nxts[0].deviceAddress
						+ "\n\n");
				// Force into firmware update mode.
				updater.resetDevice(nxts[0]);
				samba = updater.openSambaDevice(30000);
			}
			if (samba == null) {
				System.err
						.println("Unable to locate the device in firmware update mode.\nPlease place the device in reset mode and try again.");
			}
			return samba;
		}

	}

	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JButton goB;
	private javax.swing.JPanel msgPanel;
	private javax.swing.JLabel progressLabel;
	private javax.swing.JTextArea progressTxt;
	// End of variables declaration//GEN-END:variables
	private javax.swing.JLabel progBarLabel;
	private javax.swing.JProgressBar progBar;
	private Flasher flasher;
	public static final int DEFAULT_WIDTH = 400;
	public static final int DEFAULT_HEIGHT = 700;
}
