/**
 * GUI application for remote control of a NXT running RCNavigator<br>
 * Distance in meters <br>
 * uses  RCNavComms  class for bluetooth communications
 * used   Command enum in this project
 * @author  Roger Glassey
 */
public class RCNavigationControl extends javax.swing.JFrame
{
	private static final long serialVersionUID = 1L;

/** Creates new form RCNavigationControl */
   public RCNavigationControl()
    {
      initComponents();
    }
   /**
    * calls constructor for this class
    */
    public static void main(String args[])
    {
                new RCNavigationControl().setVisible(true);
      
    }
   /** This method is called from within the constructor to
    * initialize the form.
    * WARNING: Do NOT modify this code. The content of this method is
    * always regenerated by the Form Editor.
    */
   @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    connectButton = new javax.swing.JButton();
    nameText = new javax.swing.JTextField();
    jLabel1 = new javax.swing.JLabel();
    jLabel6 = new javax.swing.JLabel();
    robotPanel = new javax.swing.JPanel();
    jLabel7 = new javax.swing.JLabel();
    robotX = new javax.swing.JTextField();
    jLabel8 = new javax.swing.JLabel();
    robotY = new javax.swing.JTextField();
    jLabel9 = new javax.swing.JLabel();
    robotHeading = new javax.swing.JTextField();
    commandPanel = new javax.swing.JPanel();
    rotateButton = new javax.swing.JButton();
    jLabel5 = new javax.swing.JLabel();
    angleField = new javax.swing.JTextField();
    travelButton = new javax.swing.JButton();
    jLabel4 = new javax.swing.JLabel();
    distanceField = new javax.swing.JTextField();
    goButton = new javax.swing.JButton();
    jLabel2 = new javax.swing.JLabel();
    XField = new javax.swing.JTextField();
    YField = new javax.swing.JTextField();
    jLabel3 = new javax.swing.JLabel();
    addressText = new javax.swing.JTextField();
    jLabel10 = new javax.swing.JLabel();
    jLabel11 = new javax.swing.JLabel();
    statusField = new javax.swing.JTextField();

    setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
    setTitle("RC Navigator Control");

    connectButton.setText("Connect");
    connectButton.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mouseClicked(java.awt.event.MouseEvent evt) {
        connectButtonMouseClicked(evt);
      }
    });

    jLabel1.setText("Name");

    robotPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Robot Position and Heading"));

    jLabel7.setText("X ");

    robotX.setText(" ");

    jLabel8.setText("Y");

    jLabel9.setText("Heading");

    javax.swing.GroupLayout robotPanelLayout = new javax.swing.GroupLayout(robotPanel);
    robotPanel.setLayout(robotPanelLayout);
    robotPanelLayout.setHorizontalGroup(
      robotPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(robotPanelLayout.createSequentialGroup()
        .addGap(20, 20, 20)
        .addComponent(jLabel7, javax.swing.GroupLayout.PREFERRED_SIZE, 17, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(robotX, javax.swing.GroupLayout.PREFERRED_SIZE, 86, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addGap(18, 18, 18)
        .addComponent(jLabel8, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(robotY, javax.swing.GroupLayout.PREFERRED_SIZE, 82, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(jLabel9)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(robotHeading, javax.swing.GroupLayout.PREFERRED_SIZE, 81, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addGap(109, 109, 109))
    );
    robotPanelLayout.setVerticalGroup(
      robotPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(robotPanelLayout.createSequentialGroup()
        .addGroup(robotPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addGroup(robotPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
            .addComponent(robotX, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
            .addComponent(jLabel7))
          .addGroup(robotPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
            .addComponent(jLabel8)
            .addComponent(robotY, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
            .addComponent(jLabel9)
            .addComponent(robotHeading, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
        .addContainerGap(20, Short.MAX_VALUE))
    );

    commandPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Commands"));

    rotateButton.setText("Rotate");
    rotateButton.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mouseClicked(java.awt.event.MouseEvent evt) {
        rotateButtonMouseClicked(evt);
      }
    });

    jLabel5.setText("Angle");

    travelButton.setText("Travel");
    travelButton.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mouseClicked(java.awt.event.MouseEvent evt) {
        travelButtonMouseClicked(evt);
      }
    });

    jLabel4.setText("Distance ");

    goButton.setText("GoTo XY");
    goButton.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mouseClicked(java.awt.event.MouseEvent evt) {
        goButtonMouseClicked(evt);
      }
    });

    jLabel2.setText("X");

    jLabel3.setText("Y");

    javax.swing.GroupLayout commandPanelLayout = new javax.swing.GroupLayout(commandPanel);
    commandPanel.setLayout(commandPanelLayout);
    commandPanelLayout.setHorizontalGroup(
      commandPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(commandPanelLayout.createSequentialGroup()
        .addContainerGap()
        .addGroup(commandPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(travelButton, javax.swing.GroupLayout.DEFAULT_SIZE, 75, Short.MAX_VALUE)
          .addComponent(goButton)
          .addComponent(rotateButton, javax.swing.GroupLayout.DEFAULT_SIZE, 75, Short.MAX_VALUE))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(commandPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
          .addComponent(jLabel2)
          .addComponent(jLabel4)
          .addComponent(jLabel5))
        .addGroup(commandPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addGroup(commandPanelLayout.createSequentialGroup()
            .addGap(9, 9, 9)
            .addGroup(commandPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
              .addComponent(XField, javax.swing.GroupLayout.DEFAULT_SIZE, 79, Short.MAX_VALUE)
              .addComponent(distanceField, javax.swing.GroupLayout.DEFAULT_SIZE, 79, Short.MAX_VALUE)))
          .addGroup(commandPanelLayout.createSequentialGroup()
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
            .addComponent(angleField, javax.swing.GroupLayout.DEFAULT_SIZE, 78, Short.MAX_VALUE)))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
        .addComponent(jLabel3, javax.swing.GroupLayout.PREFERRED_SIZE, 14, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addGap(12, 12, 12)
        .addComponent(YField, javax.swing.GroupLayout.PREFERRED_SIZE, 77, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addGap(140, 140, 140))
    );
    commandPanelLayout.setVerticalGroup(
      commandPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, commandPanelLayout.createSequentialGroup()
        .addContainerGap()
        .addGroup(commandPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(goButton)
          .addGroup(commandPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
            .addComponent(jLabel2)
            .addComponent(XField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
            .addComponent(jLabel3)
            .addComponent(YField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 8, Short.MAX_VALUE)
        .addGroup(commandPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(travelButton)
          .addComponent(jLabel4)
          .addComponent(distanceField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addGap(7, 7, 7)
        .addGroup(commandPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addGroup(commandPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
            .addComponent(rotateButton)
            .addComponent(jLabel5))
          .addComponent(angleField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addContainerGap())
    );

    jLabel10.setText("Address");

    jLabel11.setText("Status:");

    statusField.setText("waiting to connect");

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addGroup(layout.createSequentialGroup()
            .addContainerGap()
            .addComponent(jLabel6)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(commandPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
          .addGroup(layout.createSequentialGroup()
            .addGap(40, 40, 40)
            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
              .addGroup(layout.createSequentialGroup()
                .addComponent(jLabel11)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(statusField))
              .addGroup(layout.createSequentialGroup()
                .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 37, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(nameText, javax.swing.GroupLayout.PREFERRED_SIZE, 92, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jLabel10)
                .addGap(27, 27, 27)
                .addComponent(addressText, javax.swing.GroupLayout.PREFERRED_SIZE, 92, javax.swing.GroupLayout.PREFERRED_SIZE)))
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(connectButton, javax.swing.GroupLayout.DEFAULT_SIZE, 128, Short.MAX_VALUE)
            .addGap(23, 23, 23)))
        .addContainerGap())
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addComponent(robotPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        .addGap(14, 14, 14))
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(jLabel1)
          .addComponent(connectButton)
          .addComponent(nameText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(addressText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(jLabel10))
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
          .addGroup(layout.createSequentialGroup()
            .addGap(83, 83, 83)
            .addComponent(jLabel6)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 129, Short.MAX_VALUE))
          .addGroup(layout.createSequentialGroup()
            .addGap(6, 6, 6)
            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
              .addComponent(jLabel11)
              .addComponent(statusField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
            .addGap(32, 32, 32)
            .addComponent(commandPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
            .addGap(18, 18, 18)))
        .addComponent(robotPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addContainerGap())
    );

    pack();
  }// </editor-fold>//GEN-END:initComponents

private void connectButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_connectButtonMouseClicked
   String name = nameText.getText();
   String address = addressText.getText();
   statusField.setText("Connecting to "+ name);
   if (!communicator.connect(name,address))
   {
     statusField.setText("Connection Failed");
     connected = false;
   }
   else {
	   statusField.setText("Connected to " + name );
	   connected = true;
   }
}//GEN-LAST:event_connectButtonMouseClicked

private void goButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_goButtonMouseClicked
   if (!connected) return;
   statusField.setText("GoTo " +XField.getText()+" "+YField.getText());
   float x; 
   float y;
   try {
	   x = Float.parseFloat(XField.getText());
	   y = Float.parseFloat(YField.getText());
	   System.out.println("Sent "+Command.GOTO+" x "+x+" y "+y);
	   communicator.send(Command.GOTO,x,y);
	   statusField.setText("waiting for data");
   } catch (NumberFormatException e) {
	   statusField.setText("Invalid x, y values");
   }
}//GEN-LAST:event_goButtonMouseClicked

private void travelButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_travelButtonMouseClicked
  if (!connected) return;
  statusField.setText("Travel "+distanceField.getText());
  float distance;
  try {
	  distance = Float.parseFloat(distanceField.getText());
	  System.out.println("Sent "+Command.TRAVEL+" "+distance);
	  communicator.send(Command.TRAVEL,distance);
	  statusField.setText("waiting for data");
  } catch (NumberFormatException e) {
	   statusField.setText("Invalid distance value");
  }
}//GEN-LAST:event_travelButtonMouseClicked

private void rotateButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_rotateButtonMouseClicked
  if (!connected) return;
  statusField.setText("Rotate "+angleField.getText());
  float angle;
  try {
	  angle = Float.parseFloat(angleField.getText());
	  System.out.println("Sent "+Command.ROTATE+" "+angle);
	  communicator.send(Command.ROTATE,angle);
	  statusField.setText("waiting for data");
  } catch (NumberFormatException e) {
	   statusField.setText("Invalid angle value");	  
  }
}//GEN-LAST:event_rotateButtonMouseClicked

public void showtRobotPosition(float x, float y, float heading)
{
    robotX.setText(""+x);
    robotY.setText(""+y);
    robotHeading.setText(""+heading);
    statusField.setText("waiting for command");
}

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JTextField XField;
  private javax.swing.JTextField YField;
  private javax.swing.JTextField addressText;
  private javax.swing.JTextField angleField;
  private javax.swing.JPanel commandPanel;
  private javax.swing.JButton connectButton;
  private javax.swing.JTextField distanceField;
  private javax.swing.JButton goButton;
  private javax.swing.JLabel jLabel1;
  private javax.swing.JLabel jLabel10;
  private javax.swing.JLabel jLabel11;
  private javax.swing.JLabel jLabel2;
  private javax.swing.JLabel jLabel3;
  private javax.swing.JLabel jLabel4;
  private javax.swing.JLabel jLabel5;
  private javax.swing.JLabel jLabel6;
  private javax.swing.JLabel jLabel7;
  private javax.swing.JLabel jLabel8;
  private javax.swing.JLabel jLabel9;
  private javax.swing.JTextField nameText;
  private javax.swing.JTextField robotHeading;
  private javax.swing.JPanel robotPanel;
  private javax.swing.JTextField robotX;
  private javax.swing.JTextField robotY;
  private javax.swing.JButton rotateButton;
  private javax.swing.JTextField statusField;
  private javax.swing.JButton travelButton;
  // End of variables declaration//GEN-END:variables
  private boolean connected = false;

   private RCNavComms communicator = new RCNavComms(this);
}




