package lejos.realtime;

/**
 *
 * @author Team iRboT
 */
public class SporadicParameters extends AperiodicParameters {

    public static final java.lang.String mitViolationExceptnew = "EXCEPT";
    public static final java.lang.String mitViolationIgnore = "IGNORE";
    public static final java.lang.String mitViolationSave = "SAVE";
    public static final java.lang.String mitViolationReplace = "REPLACE";
    private String mitViolationBehavior = mitViolationSave;
    private RelativeTime mit;

    /**
     * Create a SporadicParameters object.
     *
     * This constructor is equivalent to:
     * SporadicParameters(minInterarrival, null, null, null, null)
     * 
     * @param  mit
     * 		The release times of the schedulable object will occur no 
     * 		closer than this interval. This time object is treated as if 
     * 		it were copied. Changes to mit will not effect
     * 		the SporadicParameters object. There is no default value. 
     * 		If minInterarrival is null an illegal argument exception is 
     * 		thrown.
     *
     * @throws java.lang.IllegalArgumentException 
     * 		Thrown if minInterarrival is null or its time value 
     * 		is not greater than zero.
     *
     * @throws IllegalAssignmentError 
     * 		Thrown if minInterarrival cannot be stored in this.
     *
     * Since: 1.0.1
     */
    public SporadicParameters(RelativeTime minInterarrival) {

        this(minInterarrival, null, null, null, null);

    }

    /**
     * Create a SporadicParameters object.
     *
     * @param  minInterarrival 
     * 		The release times of the schedulable object will occur no 
     * 		closer than this interval. This time object is treated as if 
     * 		it were copied. Changes to minInterarrival will not effect the 
     * 		SporadicParameters object. There is no default value. 
     * 		If minInterarrival is null an illegal argument exception is 
     * 		thrown.
     *
     * @param cost 
     * 		Processing time per release. On implementations which can 
     * 		measure the amount of time a schedulable object is executed, 
     * 		this value is the maximum amount of time a schedulable object 
     * 		receives per release. On implementations which cannot measure 
     * 		execution time, this value is used as a hint to the feasibility
     * 	 	algorithm. On such systems it is not possible to determine 
     * 	 	when any particular object exceeds cost. If null, the default 
     * 	 	value is a new instance of RelativeTime(0,0).
     *
     * @param deadline 
     * 		The latest permissible completion time measured from the 
     * 		release time of the associated invocation of the schedulable 
     * 		object. For a minimum implementation for purposes of 
     * 		feasibility analysis, the deadline is equal to the minimum 
     * 		interarrival interval. Other implementations may use this 
     * 		parameter to compute execution eligibility. If null, the 
     * 		default value is a new instance of RelativeTime(mit).
     *
     * @param overrunHandler 
     * 		This handler is invoked if an invocation of the schedulable 
     * 		object exceeds cost. Not required for minimum implementation. 
     * 		If null no overrun handler will be used.
     *
     * @param missHandler 
     *		This handler is invoked if the run() method of the schedulable 
     *		object is still executing after the deadline has passed. 
     *		Although minimum implementations do not consider deadlines in 
     *		feasibility calculations, they must recognize variable 
     *		deadlines and invoke the miss handler as appropriate. 
     *		If null, no deadline miss handler will be used.
     *
     * @throws java.lang.IllegalArgumentException 
     * 		Thrown if minInterarrival is null or its time value is not 
     * 		greater than zero, or the time value of cost is less than 
     * 		zero, or the time value of deadline is not greater than zero.
     *
     * @throws IllegalAssignmentError 
     * 		Thrown if minInterarrival, cost, deadline, overrunHandler or 
     * 		missHandler cannot be stored in this.
     *
     */
    public SporadicParameters(RelativeTime minInterarrival, RelativeTime cost, RelativeTime deadline, AsyncEventHandler overrunHandler, AsyncEventHandler missHandler) {
        super(cost, deadline, overrunHandler, missHandler);
        if (deadline == null) {
            super.setDeadline(minInterarrival);
        }
        setMinimumInterarrival(minInterarrival);


    }

    /**
     * Sets the behavior of the arrival time queue in the case where the new 
     * arrival time is closer to the previous arrival time than the minimum 
     * interarrival time given in this.
     *
     * Values of behavior are compared using reference equality (==) not value
     * equality (equals()).
     *
     * @param  behavior 
     * 		A string representing the behavior.
     *
     * @throws java.lang.IllegalArgumentException 
     * 		Thrown if behavior is not one of the final MIT violation 
     * 		behavior values defined in this class.
     */
    public void setMitViolationBehavior(java.lang.String behavior) {
        mitViolationBehavior = behavior;
    }

    /** 
     * Gets the arrival time queue behavior in the event of a minimum 
     * interarrival time violation.
     *
     * @return 
     * 		The minimum interarrival time violation behavior as a string.
     */
    public java.lang.String getMitViolationBehavior() {
        return mitViolationBehavior;
    }

    /**
     * This method first performs a feasibility analysis using the new cost, 
     * and deadline as replacements for the matching attributes of this. 
     *
     * If the resulting system is feasible, the method replaces the current 
     * scheduling characteristics, of this with the new scheduling 
     * characteristics.
     * 
     * @Overrides: setIfFeasible in class AperiodicParameters
     *
     * @param cost 
     * 		The proposed cost. to determine when any particular object 
     * 		exceeds cost. If null, the default value is a new instance of 
     * 		RelativeTime(0,0).
     * 	
     * 	@param deadline 
     * 		The proposed deadline. If null, the default value is a new 
     * 		instance of RelativeTime(mit).
     *
     * 	@return 
     * 	        True, if the resulting system is feasible and the changes are 
     * 	        made. False, if the resulting system is not feasible and no 
     * 	        changes are made.
     *
     * 	@throws java.lang.IllegalArgumentException 
     * 		Thrown if the time value of cost is less than zero, or the 
     * 		time value of deadline is less than or equal to zero, or the 
     * 		values are incompatible with the scheduler for any of the 
     * 		schedulable objects which are presently using this parameter 
     * 		object.
     *
     * 	@throws IllegalAssignmentError 
     * 		Thrown if cost or deadline cannot be stored in this.
     *
     */
    public boolean setIfFeasible(RelativeTime cost, RelativeTime deadline) {
        throw new UnsupportedOperationException("Not overrided yet.");
    }

    /**
     * This method first performs a feasibility analysis using the new 
     * interarrival, cost and deadline attributes as replacements for the 
     * matching attributes of this. 
     *
     * If the resulting system is feasible the method replaces the current 
     * attributes with the new ones.
     *
     * Changes to a SporadicParameters instance effect subsequent arrivals.
     *
     * @param interarrival 
     * 		The proposed interarrival time. There is no default value. If 
     * 		minInterarrival is null an illegal argument exception is 
     * 		thrown.
     *
     * @param cost 
     * 		The proposed cost. If null, the default value is a new 
     * 		instance of RelativeTime(0,0).
     *
     * @param deadline 
     * 		The proposed deadline. If null, the default value is a new 
     * 		instance of RelativeTime(mit).
     *
     * 	@return
     * 		True, if the resulting system is feasible and the changes are 
     * 		made. False, if the resulting system is not feasible and no 
     * 		changes are made.
     *
     * 	@throws java.lang.IllegalArgumentException 
     * 		Thrown if minInterarrival is null or its time value is not 
     * 		greater than zero, or the time value of cost is less than 
     * 		zero, or the time value of deadline is not greater than zero.
     *
     * 	@throws IllegalAssignmentError 
     * 		Thrown if interarrival, cost or deadline cannot be stored in 
     * 		this.
     */
    public boolean setIfFeasible(RelativeTime interarrival, RelativeTime cost, RelativeTime deadline) {
        throw new UnsupportedOperationException("Not overrided yet.");
    }

    /**
     * Gets the minimum interarrival time.
     *
     * @return
     *       	The minimum interarrival time.
     */
    public RelativeTime getMinimumInterarrival() {
        return mit;
    }

    /**
     * Set the minimum interarrival time.
     *
     * @param minimum 
     * 		The release times of the schedulable object will occur no 
     * 		closer than this interval.
     *
     * @throws java.lang.IllegalArgumentException
     * 		Thrown if minimum is null or its time value is not greater 
     * 		than zero.
     *
     * @throws IllegalAssignmentError 
     * 		Thrown if minimum cannot be stored in this.
     */
    public void setMinimumInterarrival(RelativeTime minimum) {
        if (minimum == null) {
            throw new IllegalArgumentException("minInterarrival must not be null");
        }
        mit = minimum;
    }
}
