package lejos.realtime;

/**
 * Subclasses of SchedulingParameters ({@link PriorityParameters},
 * {@link ImportanceParameters}, and any others defined for particular
 * schedulers) provide the parameters to be used by the Scheduler.
 *
 * Changes to the values in a parameters object affects the scheduling behavior
 * of all the {@link Schedulable} objects to which it is bound.
 * 
 * Caution: Subclasses of this class are explicitly unsafe in multithreaded
 * situations when they are being changed. No synchronization is done. It is
 * assumed that users of this class who are mutating instances will be doing
 * their own synchronization at a higher level.


 * @author Benoit Bousquet
 */
public class SchedulingParameters implements Cloneable {

    
}
