package lejos.realtime;

/**
 *
 * @author Team iRboT
 */

public class RelativeTime extends HighResolutionTime implements Cloneable, Comparable<RelativeTime> {

    
        /**
         * Equivalent to new RelativeTime(0,0).
         *
         * The clock association is implicitly made with the real-time clock.
         */

    public RelativeTime(){
        this(0,0);
    }

    /**
     * Equivalent to new RelativeTime(0,0,clock).
     *
     * The clock association is made with the clock parameter.
     * If clock is null the association is made with the real-time clock.
     *
     * @param clock
     *          The clock providing the association for the newly constructed
     * object.
     * 
     */
    public RelativeTime(Clock clock){
        this(0, 0, clock);
    }

    /**
     * Construct a RelativeTime object representing an interval based on the
     * parameter millis plus the parameter nanos.
     * 
     * The construction is subject to millis and nanos parameters normalization.
     * If there is an overflow in the millisecond component when normalizing
     * then an IllegalArgumentException will be thrown.
     *
     * The clock association is implicitly made with the real-time clock.
     * 
     * @param millis
     *          The desired value for the millisecond component of this.
     * The actual value is the result of parameter normalization.
     *
     * @param nanos
     *          The desired value for the nanosecond component of this. The
     * actual value is the result of parameter normalization.
     * 
     * @throws java.lang.IllegalArgumentException
     *          Thrown if there is an overflow in the millisecond component
     * when normalizing.
     *
     *
     */
    public RelativeTime(long millis, int nanos) {
        super();
        super.set(millis, nanos);
    }

    
    

    /**
     * Construct a RelativeTime object representing an interval based on the
     * parameter millis plus the parameter nanos.
     *
     * The construction is subject to millis and nanos parameters
     * normalization. If there is an overflow in the millisecond component when
     * normalizing then an IllegalArgumentException will be thrown.
     *
     * The clock association is made with the clock parameter. If clock is null
     * the association is made with the real-time clock.
     *
     * @param millis
     *          The desired value for the millisecond component of this.
     * The actual value is the result of parameter normalization.
     *
     * @param nanos
     *          The desired value for the nanosecond component of this. The
     * actual value is the result of parameter normalization.
     *
     * @param clock
     *          The clock providing the association for the newly constructed
     * object.
     *
     * @throws java.lang.IllegalArgumentException
     *          Thrown if there is an overflow in the millisecond component
     * when normalizing.
     *
     * Since:
     *          1.0.1
     */
public RelativeTime(long millis, int nanos, Clock clock){
    throw new UnsupportedOperationException("Not supported yet.");
    
}


    public RelativeTime(RelativeTime time){
        this(time.getMilliseconds(),time.getNanoseconds(),time.getClock());
    }


    /**
     * Make a new RelativeTime object from the given RelativeTime object.
     *
     * The clock association is made with the clock parameter. If clock is null
     * the association is made with the real-time clock.
     *
     * @param time
     *          The RelativeTime object which is the source for the copy.
     *
     * @param clock
     *          The clock providing the association for the newly constructed
     * object.
     *
     * @throws java.lang.IllegalArgumentException
     *          Thrown if the time parameter is null.
     *
     * Since:
     *        1.0.1
     *
     */
    public RelativeTime(RelativeTime time, Clock clock){
        
    }

    
    
    @Override
    public int compareTo(RelativeTime o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    
    public AbsoluteTime absolute(Clock clock){
        /*
         Convert the time of this to an absolute time, using the given instance of Clock to determine the current time. The calculation is the current time indicated by the given instance of Clock plus the interval given by this. If clock is null the real-time clock is assumed. A destination object is allocated to return the result. The clock association of the result is with the clock passed as a parameter.
        Specified by:
        absolute in class HighResolutionTime
        Parameters:
        clock - The instance of Clock used to convert the time of this into absolute time, and the new clock association for the result.
        Returns:
        The AbsoluteTime conversion in a newly allocated object, associated with the clock parameter.
        Throws:
        java.lang.ArithmeticException - Thrown if the result does not fit in the normalized format.
        */
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public AbsoluteTime absolute(Clock clock, AbsoluteTime dest){
        /*
         Convert the time of this to an absolute time, using the given instance of Clock to determine the current time. The calculation is the current time indicated by the given instance of Clock plus the interval given by this. If clock is null the real-time clock is assumed. If dest is not null, the result is placed there and returned. Otherwise, a new object is allocated for the result. The clock association of the result is with the clock passed as a parameter.
        Specified by:
        absolute in class HighResolutionTime
        Parameters:
        clock - The instance of Clock used to convert the time of this into absolute time, and the new clock association for the result.
        dest - If dest is not null, the result is placed there and returned. Otherwise, a new object is allocated for the result.
        Returns:
        The AbsoluteTime conversion in dest if dest is not null, otherwise the result is returned in a newly allocated object. It is associated with the clock parameter.
        Throws:
        java.lang.ArithmeticException - Thrown if the result does not fit in the normalized format.
        */
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public RelativeTime add(long millis, int nanos){
        /*
         Create a new object representing the result of adding millis and nanos to the values from this and normalizing the result. The result will have the same clock association as this. An ArithmeticException is thrown if the result does not fit in the normalized format.
        Parameters:
        millis - The number of milliseconds to be added to this.
        nanos - The number of nanoseconds to be added to this.
        Returns:
        A new RelativeTime object whose time is the normalization of this plus millis and nanos.
        Throws:
        java.lang.ArithmeticException - Thrown if the result does not fit in the normalized format.
        */
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public RelativeTime add(long millis, int nanos, RelativeTime dest){
        /*
         Return an object containing the value resulting from adding millis and nanos to the values from this and normalizing the result. If dest is not null, the result is placed there and returned. Otherwise, a new object is allocated for the result. The result will have the same clock association as this, and the clock association with dest is ignored. An ArithmeticException is thrown if the result does not fit in the normalized format.
        Parameters:
        millis - The number of milliseconds to be added to this.
        nanos - The number of nanoseconds to be added to this.
        dest - If dest is not null, the result is placed there and returned. Otherwise, a new object is allocated for the result.
        Returns:
        the result of the normalization of this plus millis and nanos in dest if dest is not null, otherwise the result is returned in a newly allocated object.
        Throws:
        java.lang.ArithmeticException - Thrown if the result does not fit in the normalized format.
        */
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public RelativeTime add(RelativeTime time){
        /*
         Create a new instance of RelativeTime representing the result of adding time to the value of this and normalizing the result. The clock associated with this and the clock associated with the time parameter are expected to be the same, and such association is used for the result. An IllegalArgumentException is thrown if the clock associated with this and the clock associated with the time parameter are different. An IllegalArgumentException is thrown if the time parameter is null. An ArithmeticException is thrown if the result does not fit in the normalized format.
        Parameters:
        time - The time to add to this.
        Returns:
        A new RelativeTime object whose time is the normalization of this plus the parameter time.
        Throws:
        java.lang.IllegalArgumentException - Thrown if the clock associated with this and the clock associated with the time parameter are different, or when the time parameter is null.
        java.lang.ArithmeticException - Thrown if the result does not fit in the normalized format.
        */
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public RelativeTime add(RelativeTime time, RelativeTime dest){
        /*
         Return an object containing the value resulting from adding time to the value of this and normalizing the result. If dest is not null, the result is placed there and returned. Otherwise, a new object is allocated for the result. The clock associated with this and the clock associated with the time parameter are expected to be the same, and such association is used for the result. The clock associated with the dest parameter is ignored. An IllegalArgumentException is thrown if the clock associated with this and the clock associated with the time parameter are different. An IllegalArgumentException is thrown if the time parameter is null. An ArithmeticException is thrown if the result does not fit in the normalized format.
        Parameters:
        time - The time to add to this.
        dest - If dest is not null, the result is placed there and returned. Otherwise, a new object is allocated for the result.
        Returns:
        the result of the normalization of this plus the RelativeTime parameter time in dest if dest is not null, otherwise the result is returned in a newly allocated object.
        Throws:
        java.lang.IllegalArgumentException - Thrown if the clock associated with this and the clock associated with the time parameter are different, or when the time parameter is null.
        java.lang.ArithmeticException - Thrown if the result does not fit in the normalized format.
        */
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addInterarrivalTo(AbsoluteTime timeAndDestination){
        /*
         Deprecated. As of RTSJ 1.0.1
        Add the interval of this to the given instance of AbsoluteTime.
        Parameters:
        timeAndDestination - A reference to the given instance of AbsoluteTime and the result.
        */
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public RelativeTime getInterarrivalTime(){
        /*
         Deprecated. As of RTSJ 1.0.1
        Gets the interval defined by this. For an instance of RationalTime it is the interval divided by the frequency.
        Returns:
        A reference to a new instance of RelativeTime with the same interval as this.
        */
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public RelativeTime getInterarrivalTime(RelativeTime destination){
        /*
         Deprecated. As of RTSJ 1.0.1
        Gets the interval defined by this. For an instance of RationalTime it is the interval divided by the frequency.
        Parameters:
        destination - A reference to the new object holding the result.
        Returns:
        A reference to an object holding the result.
        */
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public RelativeTime relative(Clock clock){
        /*
         Return a copy of this. A new object is allocated for the result. This method is the implementation of the abstract method of the HighResolutionTime base class. No conversion into RelativeTime is needed in this case. The clock association of the result is with the clock passed as a parameter. If clock is null the association is made with the real-time clock.
        Specified by:
        relative in class HighResolutionTime
        Parameters:
        clock - The clock parameter is used only as the new clock association with the result, since no conversion is needed.
        Returns:
        The copy of this in a newly allocated RelativeTime object, associated with the clock parameter.
        */
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public RelativeTime relative(Clock clock, RelativeTime dest){
        /*
         Return a copy of this. If dest is not null, the result is placed there and returned. Otherwise, a new object is allocated for the result. This method is the implementation of the abstract method of the HighResolutionTime base class. No conversion into RelativeTime is needed in this case. The clock association of the result is with the clock passed as a parameter. If clock is null the association is made with the real-time clock.
        Specified by:
        relative in class HighResolutionTime
        Parameters:
        clock - The clock parameter is used only as the new clock association with the result, since no conversion is needed.
        dest - If dest is not null, the result is placed there and returned. Otherwise, a new object is allocated for the result.
        Returns:
        The copy of this in dest if dest is not null, otherwise the result is returned in a newly allocated object. It is associated with the clock parameter.
        */
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public RelativeTime subtract(RelativeTime time){
        /*
         Create a new instance of RelativeTime representing the result of subtracting time from the value of this and normalizing the result. The clock associated with this and the clock associated with the time parameter are expected to be the same, and such association is used for the result. An IllegalArgumentException is thrown if the clock associated with this and the clock associated with the time parameter are different. An IllegalArgumentException is thrown if the time parameter is null. An ArithmeticException is thrown if the result does not fit in the normalized format.
        Parameters:
        time - The time to subtract from this.
        Returns:
        A new RelativeTime object whose time is the normalization of this minus the parameter time parameter time.
        Throws:
        java.lang.IllegalArgumentException - Thrown if the clock associated with this and the clock associated with the time parameter are different, or when the time parameter is null.
        java.lang.ArithmeticException - Thrown if the result does not fit in the normalized format.
        */
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public RelativeTime subtract(RelativeTime time, RelativeTime dest){
        /*
         Return an object containing the value resulting from subtracting the value of time from the value of this and normalizing the result. If dest is not null, the result is placed there and returned. Otherwise, a new object is allocated for the result. The clock associated with this and the clock associated with the time parameter are expected to be the same, and such association is used for the result. The clock associated with the dest parameter is ignored. An IllegalArgumentException is thrown if the clock associated with this and the clock associated with the time parameter are different. An IllegalArgumentException is thrown if the time parameter is null. An ArithmeticException is thrown if the result does not fit in the normalized format.
        Parameters:
        time - The time to subtract from this.
        dest - If dest is not null, the result is placed there and returned. Otherwise, a new object is allocated for the result.
        Returns:
        the result of the normalization of this minus the RelativeTime parameter time in dest if dest is not null, otherwise the result is returned in a newly allocated object.
        Throws:
        java.lang.IllegalArgumentException - Thrown if the if the clock associated with this and the clock associated with the time parameter are different, or when the time parameter is null.
        java.lang.ArithmeticException - Thrown if the result does not fit in the normalized format.
        */
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public java.lang.String toString(){
        /*
         Create a printable string of the time given by this.
        The string shall be a decimal representation of the milliseconds and nanosecond values; formatted as follows "(2251 ms, 750000 ns)"

        Overrides:
        toString in class java.lang.Object
        Returns:
        String object converted from the time given by this.
         */
        throw new UnsupportedOperationException("Not supported yet.");
    }

}
