package lejos.realtime;

/**
 * Class used to create a Realtime thread.
 * 
 * @author Team iRboT
 */
public class RealtimeThread extends Thread implements Schedulable {

    //this field must match MAX_PRIORITY in thread.h
    public final static int MIN_PRIORITY = 10;
    public final static int NORM_PRIORITY = 25;
    public final static int MAX_PRIORITY = 99;

	 public final static int GC_MEM = 0;
	 public final static int IMMORTAL_MEM = 1;

    /* The following fields are used by the VM.
     * Their sizes and location can only be changed
     * if classes.h is changed accordingly. Needless
     * to say, they are read-only.
     */

    private RealtimeThread _TVM_nextRealtimeThread;
    private int _TVM_start;
    private int _TVM_period;
    private int _TVM_cost;
    private int _TVM_deadline;
    private int _TVM_startPeriod;
    private int _TVM_remainingCost;
    private int _TVM_endDeadline;
    private AsyncEventHandler _TVM_costOverrunHandler;
    private AsyncEventHandler _TVM_deadlineMissHandler;
    private byte _TVM_memoryType;
    private byte _TVM_started;

    private ReleaseParameters release;
    private SchedulingParameters scheduling;

	 private MemoryParameters memoryParameters;

    /**
     * Create a real-time thread with default values for all parameters.
     * This constructor is equivalent to {@code RealtimeThread(null, null, null, null, null, null)}.
     */
    public RealtimeThread() {
        this(null,null,null,null,null,null);
    }

    /**
     * Create a real-time thread with the given SchedulingParameters and
     * default values for all other parameters. This constructor is equivalent
     * to {@link RealtimeThread(scheduling, null, null, null, null, null)}.
     *
     *
     * @throws java.lang.IllegalArgumentException
     *          Thrown if the scheduling parameters are not compatible with 
     * the associated scheduler.
     *
     * @throws IllegalAssignmentError
     *          Thrown if the new RealtimeThread instance cannot hold a
     * reference to scheduling, or if scheduling cannot hold a reference to
     * the new RealtimeThread.
     */
    public RealtimeThread(SchedulingParameters scheduling) {
        this(scheduling,null,null,null,null,null);
    }


    /**
     * Create a real-time thread with the given SchedulingParameters and
     * ReleaseParameters  and default values for all other parameters.
     *
     * This constructor is equivalent to
     * {@ling RealtimeThread(scheduling, release, null, null, null, null)}.
     * 
     * @throws java.lang.IllegalArgumentException
     *          Thrown if the scheduling parameters or release parameters
     * are not compatible with the associated scheduler.
     *
     * @throws IllegalAssignmentError
     *          Thrown if the new RealtimeThread instance cannot hold a
     * reference to scheduling or release, or if either parameter cannot
     * hold a reference to the new RealtimeThread.
     *
     */
    public RealtimeThread(SchedulingParameters scheduling, ReleaseParameters release) {
        this(scheduling,release,null,null,null,null);
    }

	 public RealtimeThread(SchedulingParameters prio, 
	 			ReleaseParameters release, 
				MemoryParameters memoryParam, 
				MemoryArea memoryArea) {

		this(prio, release);
		if(memoryParam != null || memoryArea != null)
			throw new UnsupportedOperationException("Not supported yet.");
	 }

    public RealtimeThread(SchedulingParameters scheduling,
                      ReleaseParameters release,
                      MemoryParameters memory,
                      MemoryArea area,
                      ProcessingGroupParameters group,
                      java.lang.Runnable logic){
        
        super();
        
         
        if(memory!= null || area != null|| group != null || logic != null){
                throw new UnsupportedOperationException("Not supported yet.");
                /*setMemoryParameters(memory);
                setProcessingGroupParameters(group);*/
        }


        setSchedulingParameters(scheduling);

        setReleaseParameters(release);
        
    }

    @Override
    public void run() {
        throw new UnsupportedOperationException("Not overrided yet.");
    }

    @Override
    public void setReleaseParameters(ReleaseParameters release) throws IllegalArgumentException, IllegalStateException {
        if(release == null){
            

            release = new AperiodicParameters();
            //throw new IllegalArgumentException("ReleaseParameters must not be null.");
        }
        
        if (release instanceof PeriodicParameters) {

            PeriodicParameters pp = (PeriodicParameters) release;
            rt_set_start((int) pp.getStart().getMilliseconds());
        
            rt_set_period((int) pp.getPeriod().getMilliseconds());
        }
        
        rt_set_cost((int) release.getCost().getMilliseconds());
        
        rt_set_deadline((int) release.getDeadline().getMilliseconds());
        
        rt_set_deadlineMissHandler(release.getDeadlineMissHandler());
        
        rt_set_costOverrunHandler(release.getCostOverrunHandler());
        
        this.release = release;
    }

    @Override
    public void setSchedulingParameters(SchedulingParameters scheduling) throws IllegalArgumentException, IllegalAssignmentError {
        if(scheduling == null){
         scheduling = new PriorityParameters(RealtimeThread.NORM_PRIORITY);
        }
        if (scheduling instanceof PriorityParameters) {
            int prio = ((PriorityParameters) scheduling).getPriority();
            if (MIN_PRIORITY > prio || MAX_PRIORITY < prio) {
                throw new IllegalArgumentException("priority must be between " + MIN_PRIORITY + " and " + MAX_PRIORITY);
            }
            super.set_priority(prio);

        }
        this.scheduling=scheduling;
        
    }

    @Override
    public void start() {
		 init_rt_thread(GC_MEM);
	 }

    @Override
    public boolean addIfFeasible() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean addToFeasibility() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public MemoryParameters getMemoryParameters() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ProcessingGroupParameters getProcessingGroupParameters() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ReleaseParameters getReleaseParameters() {
        return release;
    }

    @Override
    public Scheduler getScheduler() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SchedulingParameters getSchedulingParameters() {
        return scheduling;
    }

    public final void schedulePeriodic() {
        schedule_periodic();
    }

    @Override
    public boolean removeFromFeasibility() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private final native void init_rt_thread(int memoryType);

    private final native void prepare_2_wait();

    private final native void schedule_periodic();

    public final native void rt_set_start(int start);

    public final native void rt_set_period(int period);

    public final native void rt_set_cost(int cost);

    public final native void rt_set_deadline(int deadline);

    public final native void rt_set_costOverrunHandler(AsyncEventHandler costOverrunHandler);

    public final native void rt_set_deadlineMissHandler(AsyncEventHandler deadlineMissHandler);

    @Override
    public boolean setIfFeasible(ReleaseParameters release, MemoryParameters memory) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean setIfFeasible(ReleaseParameters release, MemoryParameters memory, ProcessingGroupParameters group) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean setIfFeasible(ReleaseParameters release, ProcessingGroupParameters group) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean setIfFeasible(SchedulingParameters scheduling, ReleaseParameters release, MemoryParameters memory) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean setIfFeasible(SchedulingParameters scheduling, ReleaseParameters release, MemoryParameters memory, ProcessingGroupParameters group) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setMemoryParameters(MemoryParameters memory) {
        memoryParameters = memory;
   }

    @Override
    public boolean setMemoryParametersIfFeasible(MemoryParameters memory) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setProcessingGroupParameters(ProcessingGroupParameters group) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean setProcessingGroupParametersIfFeasible(ProcessingGroupParameters group) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean setReleaseParametersIfFeasible(ReleaseParameters release) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setScheduler(Scheduler scheduler) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setScheduler(Scheduler scheduler, SchedulingParameters scheduling, ReleaseParameters release, MemoryParameters memoryParameters, ProcessingGroupParameters group) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean setSchedulingParametersIfFeasible(SchedulingParameters scheduling) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean waitForNextPeriod() {
        prepare_2_wait();
        return true;
    }
}
