package lejos.realtime;

import java.util.ArrayList;

/**
 *
 * @author Team iRboT
 */
public class RMScheduler extends PriorityScheduler{

    protected RMScheduler(){
       super("RMScheduler");
    }

    /**
     * Return a reference to the distinguished instance of PriorityScheduler
     * which is the system's base scheduler.
     *
     * @return A reference to the distinguished instance PriorityScheduler.
     */
    //@Override
    public static PriorityScheduler instance(){
        if(current == null){
            current = new RMScheduler();
        }
        if(current.policy!="RMScheduler"){
            current = new RMScheduler();
        }
        return current;
    }

    @Override
    public boolean isFeasible(){
        ArrayList[] allThreads = new ArrayList[getMaxPriority()+1];
        for(int i =0;i<allThreads.length;i++){
            allThreads[i]= new ArrayList<RealtimeThread>();
        }
        float u = (float) 0;
        int n = feasabilityList.size();
        if(n==0){
            return true;
        }
        int wt = 0;
        int t = 1;

        for(Schedulable schedulable : feasabilityList){
            if(schedulable instanceof RealtimeThread){
                RealtimeThread rtThread = (RealtimeThread) schedulable;
                int priority = getThreadPriority(rtThread);
                allThreads[priority].add(rtThread);

                /*
                 * default DM
                 */

                float utmp = (float) getThreadCost(rtThread)/getThreadPeriod(rtThread);
                u = u + utmp;
            }
        }
        if(u>1){
            return false;
        }
        else{
            if(u<n*(Math.pow(2, (double)1/n)-1)){
                return true;
            }
            else{
                for(Schedulable s : feasabilityList){
                    int priority = 0;
                    if(s instanceof RealtimeThread){
                        /*Busy Period*/
                        RealtimeThread rtThread = (RealtimeThread) s;
                        priority = getThreadPriority(rtThread);
                        while(wt != t){
                            t = wt;
                            wt = getWorkTime(allThreads, priority, t);
                        }
                         /*end Busy Period*/

                        /*instances to study*/
                        int q = (int) Math.ceil(wt/getThreadPeriod(rtThread));

                        /*response time analysis*/
                        t=1;
                        wt=0;
                        int[] ct = new int[q];
                        for(int m=1;m<=q;m++){
                            while(wt != t){
                                t = wt;
                                wt = getWorkTimeForResponseTime(allThreads, priority, t, rtThread, m);
                            }
                            ct[m-1] = wt - m * (int) (getThreadPeriod(rtThread));
                        }
                        int r = ct[0];
                        for(int i = 1;i<q;i++){
                            if(ct[i]>r){
                                r = ct[i];
                            }
                        }
                        if(r>getThreadDeadline(rtThread)){
                            return false;
                        }
                    }
                }
            }
        }
        return false;
    }

}
