package lejos.realtime;

/**
 * Instances of this class should be assigned to schedulable objects that are
 * by schedulers which use a single integer to determine execution order.
 *
 * The base scheduler required by this specification and represented by the
 * class PriorityScheduler is such a scheduler.
 * 
 * @author Benoit Bousquet
 */
public class PriorityParameters extends SchedulingParameters {
    
    private int priority;

    public PriorityParameters() {
    }

    public PriorityParameters(int priority) {
        this.priority = priority;
    }

    /**
     * Gets the priority value.
     *
     * @return
     *      The priority value.
     */
    public int getPriority() {
        return priority;
    }

    /**
     * Sets the priority value.
     *
     * @param priority
     *      The value to which priority is set.
     *
     * @throws IllegalArgumentException
     *      Thrown if the given priority value is incompatible with the
     * scheduler for any of the schedulable objects which are presently using
     * this parameter object.
     */
    public void setPriority(int priority) throws IllegalArgumentException {
        if(priority < 0) {
            throw new IllegalArgumentException("Invalid priority.");
        }
        this.priority = priority;
    }

    /**
     * Converts the priority value to a string.
     * 
     * @return
     *      A string representing the value of priority.
     */
    @Override
    public String toString() {
        return Integer.toString(priority);
    }
}
