/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package lejos.realtime;

/**
 *
 * @author amahendran
 */
public class PriorityCeilingEmulation extends MonitorControl {
    private int ceilingPriority;

    private PriorityCeilingEmulation(int ceilingPriority){
        if (ceilingPriority>RealtimeThread.MAX_PRIORITY || ceilingPriority<RealtimeThread.MIN_PRIORITY){
            throw new IllegalArgumentException("Ceiling priority must be between "+RealtimeThread.MIN_PRIORITY+" and "+RealtimeThread.MAX_PRIORITY);
        }
        init_monitor_control(PCE, ceilingPriority);
        this.ceilingPriority = ceilingPriority;
    }

    public static PriorityCeilingEmulation instance(int ceiling){
        return new PriorityCeilingEmulation(ceiling);
    }

    public int getCeiling(){
        return ceilingPriority;
    }

    public static PriorityCeilingEmulation getMaxCeiling(){
        throw new UnsupportedOperationException("Not yet implemented");
    }
}
