/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package lejos.realtime;

/**
 *
 * @author team iRboT
 */
public abstract class MonitorControl {

    private MonitorControl _TVM_nextMonitorControl;
    private int _TVM_sync;
    private int _TVM_synchronizationType;
    private int _TVM_ceilingPriority;
    private int _TVM_threadPriority;
    private int _TVM_immortal;
    private int _TVM_threadID;

    private static MonitorControl currentMonitorControl =null;
    protected final static int PIP = 1;
    protected final static int PCE = 2;

    //private static MonitorControl mc = new MonitorControl() {};

    protected MonitorControl(){
        //super();
    }

    public static MonitorControl getMonitorControl(){
        //mc.init_monitor_control();
        if (currentMonitorControl == null){
            currentMonitorControl = PriorityInheritance.instance();
        }
        return currentMonitorControl;
    }

    public static MonitorControl getMonitorControl(Object monitor){
        return get_mc(monitor);
    }

    public final static native void set_all_mc(MonitorControl mc);
    protected final native void init_monitor_control(int syncType, int prioCeil);
    public final static native void set_one_mc(Object monitor, MonitorControl mc);
    public final static native MonitorControl get_mc(Object monitor);


    public static MonitorControl setMonitorControl(MonitorControl policy){
        if (currentMonitorControl == null){
            currentMonitorControl = PriorityInheritance.instance();
        }
        set_all_mc(policy);
        currentMonitorControl=policy;
        return currentMonitorControl;
    }

    public static MonitorControl setMonitorControl(Object monitor, MonitorControl policy){
        if (currentMonitorControl == null){
            currentMonitorControl = PriorityInheritance.instance();
        }
        set_one_mc(monitor, policy);
        currentMonitorControl=policy;
        return currentMonitorControl;
    }

}
