package lejos.realtime;

/**
 *
 * @author Team iRboT
 */
public abstract class HighResolutionTime {

    private long millis;
    private int nanos;
    private Clock clock;

    


    /**
     * Behaves exactly like target.wait() but with the enhancement that it waits
     * with a precision of HighResolutionTime.
     *
     * As for target.wait(), there is the possibility of spurious wakeup
     * behavior. The wait time may be relative or absolute, and it is
     * controlled by the clock associated with it. If the wait time is
     * relative, then the calling thread is blocked waiting on target for the
     * amount of time given by time, and measured by the associated clock.
     * If the wait time is absolute, then the calling thread is blocked
     * waiting on target until the indicated time value is reached by the
     * associated clock.
     *
     * @param target
     *          The object on which to wait. The current thread must have a
     * lock on the object.
     *
     * @param time
     *          The time for which to wait. If it is RelativeTime(0,0) then
     * wait indefinitely. If it is null then wait indefinitely.
     *
     * @throws java.lang.InterruptedException
     *          Thrown if this schedulable object is interrupted by
     * RealtimeThread.interrupt() or AsynchronouslyInterruptedException.fire()
     * while it is waiting.
     *
     * @throws java.lang.IllegalArgumentException
     *          Thrown if time represents a relative time less than zero.
     *
     * @throws java.lang.IllegalMonitorStateException
     *          Thrown if target is not locked by the caller.
     *
     * @throws java.lang.UnsupportedOperationException
     *          Thrown if the wait operation is not supported using the clock
     * associated with time.
     *
     *  See Also:
     *         Object.wait(), Object.wait(long), Object.wait(long,int)
     */
    public static void waitForObject(java.lang.Object target, HighResolutionTime time) throws java.lang.InterruptedException{
        
        throw new UnsupportedOperationException("Not overrided yet.");
    }


       /**
        * Convert the time of this to an absolute time, using the given
        * instance of Clock to determine the current time when necessary.
        *
        * If clock is null the real-time clock is assumed. A destination object
        * is allocated to return the result. The clock association of the
        * result is with the clock passed as a parameter. See the derived
        * class comments for more specific information.
        *
        * @param clock
        *        The instance of Clock used to convert the time of this into
        * absolute time, and the new clock association for the result.
        *
        * @return
        *        The AbsoluteTime conversion in a newly allocated object,
        * associated with the clock parameter.
        */
    public abstract AbsoluteTime absolute(Clock clock);



    /**
     * Convert the time of this to an absolute time, using the given instance
     * of Clock to determine the current time when necessary.
     *
     * If clock is null the real-time clock is assumed. If dest is not null,
     * the result is placed there and returned. Otherwise, a new object is
     * allocated for the result. The clock association of the result is with
     * the clock passed as a parameter. See the derived class comments for
     * more specific information.
     *
     * @param clock
     *           The instance of Clock used to convert the time of this into
     * absolute time, and the new clock association for the result.
     *
     * @param dest
     *          If dest is not null, the result is placed there and returned.
     * Otherwise, a new object is allocated for the result.
     *
     * @return
     *          The AbsoluteTime conversion in dest if dest is not null,
     * otherwise the result is returned in a newly allocated object. It is
     * associated with the clock parameter.
     *
     */
    public abstract AbsoluteTime absolute(Clock clock, AbsoluteTime dest);
        

    /**
     * Return a clone of this.
     *
     * This method should behave effectively as if it constructed a new object
     * with the visible values of this. The new object is created in the
     * current allocation context.
     *
     * Overrides:
     *      clone in class java.lang.Object
     *
     * Since:  1.0.1
     *
     */
    public java.lang.Object clone(){
        
        throw new UnsupportedOperationException("Not overrided yet.");
    }


       /**
        * Compares this HighResolutionTime with the specified
        * HighResolutionTime time.
        *
        * @param time
        *           Compares with the time of this.
        *
        * @throws java.lang.ClassCastException
        *           Thrown if the time parameter is not of the same class as
        * this.
        *
        * @throws java.lang.IllegalArgumentException
        *           Thrown if the time parameter is not associated with the
        * same clock as this, or when the time parameter is null.
        */
    public int compareTo(HighResolutionTime time){
     
        throw new UnsupportedOperationException("Not overrided yet.");
    }


    /**
     * For the Comparable interface.
     *
     * Specified by:
     *          compareTo in interface java.lang.Comparable
     *
     * @throws java.lang.IllegalArgumentException
     *          Thrown if the object parameter is not associated with the same
     * clock as this, or when the object parameter is null.
     *
     * @throws java.lang.ClassCastException
     *          Thrown if the specified object's type prevents it from being
     * compared to this Object.
     */
/*    public int compareTo(java.lang.Object object){
        
        throw new
                UnsupportedOperationException("Not overrided yet.");
    }
*/

    /**
     * Returns true if the argument time has the same type and values as this.
     *
     * Equality includes clock association.
     *
     * @param time
     *          Value compared to this.
     *
     * @return
     *          true if the parameter time is of the same type and has the same values as this.
     */
    public boolean equals(HighResolutionTime time){
        
        throw new UnsupportedOperationException("Not overrided yet.");
    }


       /**
        * Returns true if the argument object has the same type and values
        * as this.
        *
        * Equality includes clock association.
        *
        * Overrides:
        *         equals in class java.lang.Object
        *
        * @param object
        *           Value compared to this.
        *
        * @return
        *           true if the parameter object is of the same type and has the same values as this.
        */
    public boolean equals(java.lang.Object object){
        throw new UnsupportedOperationException("Not overrided yet.");
    }


    /**
     * Returns a reference to the clock associated with this.
     *
     * @return
     *            A reference to the clock associated with this.
     *
     * Since: 1.0.1
     *
     */
    public Clock getClock(){
        
        return clock;
    }

    /**
     *  Returns the milliseconds component of this.
     * @return
     *      The milliseconds component of this.
     */
    public final long getMilliseconds(){
        return millis;
    }

    /**
     *  Returns the nanoseconds component of this.
     * @return
     *      The nanoseconds component of this.
     */
    public final int getNanoseconds(){
        return nanos;
    }

    /**
     * Returns a hash code for this object in accordance with the general
     * contract of Object.hashCode().
     *
     * Time objects that are equal have the same hash code.
     *
     * Overrides:
     *          hashCode in class java.lang.Object
     *
     * @return
     *          The hashcode value for this instance.
     *
     */
    public int hashCode(){
        
        throw new UnsupportedOperationException("Not overrided yet.");
    }


       /**
        * Convert the time of this to a relative time, using the given instance
        * of Clock to determine the current time when necessary.
        *
        * If clock is null the real-time clock is assumed. A destination object
        * is allocated to return the result. The clock association of the
        * result is with the clock passed as a parameter. See the derived class
        * comments for more specific information.
        *
        * @param clock
        *           The instance of Clock used to convert the time of this
        * into relative time, and the new clock association for the result.
        *
        * @return
        *           The RelativeTime conversion in a newly allocated object,
        * associated with the clock parameter.
        *
        */
    public abstract RelativeTime relative(Clock clock);
     


    /**
     * Convert the time of this to a relative time, using the given instance of
     * Clock to determine the current time when necessary.
     *
     * If clock is null the real-time clock is assumed. If dest is not null,
     * the result is placed there and returned. Otherwise, a new object is
     * allocated for the result. The clock association of the result is with
     * the clock passed as a parameter. See the derived class comments for
     * more specific information.
     *
     * @param clock
     *          The instance of Clock used to convert the time of this into
     * relative time, and the new clock association for the result.
     *
     * @param dest
     *          If dest is not null, the result is placed there and returned.
     * Otherwise, a new object is allocated for the result.
     *
     * @return
     *          The RelativeTime conversion in dest if dest is not null,
     * otherwise the result is returned in a newly allocated object. It is
     * associated with the clock parameter.
     */

    public abstract RelativeTime relative(Clock clock, RelativeTime dest);
        

       /**
        * Change the value represented by this to that of the given time.
        *
        * If the time parameter is null this method will throw
        * IllegalArgumentException. If the type of this and the type of the
        * given time are not the same this method will throw
        * ClassCastException. The clock associated with this is set to be the
        * clock associated with the time parameter.
        *
        * @param time
        *           The new value for this.
        *
        * @throws java.lang.IllegalArgumentException
        *           Thrown if the parameter time is null.
        *
        * @throws java.lang.ClassCastException
        *           Thrown if the type of this and the type of the parameter
        * time are not the same.
        *
        * Since:
        *       1.0.1 The description of the method in 1.0 was erroneous.
        */

    public void set(HighResolutionTime time){
        if(time == null){
            throw new IllegalArgumentException("HighResolution time must not be null.");
        }
        set(time.getMilliseconds(),time.getNanoseconds());
    }


      /**
       * Sets the millisecond component of this to the given argument, and the
       * nanosecond component of this to 0. This method is equivalent to
       * set(millis, 0).
       *
       * @param millis
       *            This value shall be the value of the millisecond component
       * of this at the completion of the call.
       *
       */
    public void set(long millis){
      
        set(millis,0);
    }

    /**
     * Sets the millisecond and nanosecond components of this.
     *
     * The setting is subject to parameter normalization. If there is an
     * overflow in the millisecond component while normalizing then an
     * IllegalArgumentException will be thrown. If after normalization the
     * time is negative then the time represented by this is set to a negative
     * value, but note that negative times are not supported everywhere.
     * For instance, a negative relative time is an invalid value for a periodic
     * thread's period.
     * 
     * @param millis 
     *          The desired value for the millisecond component of this at the
     * completion of the call. The actual value is the result of parameter
     * normalization.
     *
     * @param nanos
     *          The desired value for the nanosecond component of this at the
     * completion of the call. The actual value is the result of parameter
     * normalization.
     *
     * @throws java.lang.IllegalArgumentException
     *          Thrown if there is an overflow in the millisecond component
     * while normalizing.
     */
    public void set(long millis, int nanos) throws IllegalArgumentException {
        this.millis = millis;
        this.nanos = nanos;
    }
}
