
package lejos.realtime;

/**
 *
 * @author amahendran
 */
public class EnergyRealtimeThread extends RealtimeThread {

    /* The following fields are used by the VM.
     * Their sizes and location can only be changed
     * if classes.h is changed accordingly. Needless
     * to say, they are read-only.
     */
    private int _TVM_energyCost;

    //Extra fields
    private EnergyParameters energyParameters;

    public EnergyRealtimeThread(){
        super();
        setEnergyParameters(null);
    }

    public EnergyRealtimeThread(EnergyParameters energyParameters){
        super();
        setEnergyParameters(energyParameters);
    }

    public EnergyRealtimeThread(SchedulingParameters scheduling, EnergyParameters energyParameters){
        super(scheduling,null,null,null,null,null);
        setEnergyParameters(energyParameters);
    }

    public EnergyRealtimeThread(SchedulingParameters scheduling, ReleaseParameters release, EnergyParameters energyParameters) {
        super(scheduling,release,null,null,null,null);
        setEnergyParameters(energyParameters);
    }

    public EnergyRealtimeThread(SchedulingParameters scheduling,
	 			ReleaseParameters release,
				MemoryParameters memoryParam,
				MemoryArea memoryArea,
                                EnergyParameters energyParameters) {
        super(scheduling,release,memoryParam,memoryArea,null,null);
        setEnergyParameters(energyParameters);
    }

    public EnergyRealtimeThread(SchedulingParameters scheduling,
	 			ReleaseParameters release,
				MemoryParameters memoryParam,
				MemoryArea memoryArea,
                                ProcessingGroupParameters group,
                                java.lang.Runnable logic,
                                EnergyParameters energyParameters) {
        super(scheduling,release,memoryParam,memoryArea,group,logic);
        setEnergyParameters(energyParameters);
    }

    public void setEnergyParameters(EnergyParameters energyParameters){
        this.energyParameters = energyParameters;
        if (energyParameters == null){
            set_energy_cost(0);
        }
        else {
            set_energy_cost(energyParameters.getEnergy());
        }
    }

    //Using defensive copy
    public EnergyParameters getEnergyParameters(){
        return energyParameters==null?null:new EnergyParameters(energyParameters.getEnergy());
    }

    private final native void set_energy_cost(int energy);
}
