/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package lejos.realtime;

/**
 *
 * @author team iRbot
 */
public class EDFScheduler extends Scheduler{
    
    private static EDFScheduler singleton = new EDFScheduler();

    private EDFScheduler(){
    }

    /**
     * Inform this scheduler and cooperating facilities that the resource demands of the given instance of Schedulable  will be considered in the feasibility analysis of the associated Scheduler until further notice. Whether the resulting system is feasible or not, the addition is completed.
     * If the object is already included in the feasibility set, do nothing.
     * @param schedulable - A reference to the given instance of Schedulable
     * @return True, if the system is feasible after the addition. False, if not.
     * @throws java.lang.IllegalArgumentException - Thrown if schedulable is null, or if schedulable is not associated with this; that is schedulable.getScheduler() != this.
     */
    protected boolean addToFeasibility(Schedulable schedulable) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    /**
     * Trigger the execution of a schedulable object (like an AsyncEventHandler).
     * @param schedulable - The schedulable object to make active. If null, nothing happens.
     * @throws java.lang.UnsupportedOperationException - Thrown if the scheduler cannot release schedulable for execution.
     */
    public void fireSchedulable(Schedulable schedulable){
        throw new UnsupportedOperationException("Not yet implemented");
    }

    /**
     * Gets a string representing the policy of this.
     * The string value need not be interned, but it must be created in a memory area that does not cause an illegal assignment error if stored in the current allocation context and does not cause a MemoryAccessError when accessed.
     * @return The policy name (EDF) as a string
     */
    public java.lang.String getPolicyName(){
        return "EDF";
    }

    /**
     * Queries the system about the feasibility of the system currently being considered.
     * @return True, if the system is feasible. False, if not.
     */
    public boolean isFeasible(){
        throw new UnsupportedOperationException("Not yet implemented");
    }

    /**
     * Inform this scheduler and cooperating facilities that the resource demands of the given instance of Schedulable should no longer be considered in the feasibility analysis of the associated Scheduler.
     * Whether the resulting system is feasible or not, the removal is completed.
     * @param  schedulable - A reference to the given instance of Schedulable
     * @return True, if the removal was successful. False, if the schedulable object cannot be removed from the scheduler's feasibility set; e.g., the schedulable object is not part of the scheduler's feasibility set.
     * @throws java.lang.IllegalArgumentException - Thrown if schedulable  is null.
     */
    protected boolean removeFromFeasibility(Schedulable schedulable){
        throw new UnsupportedOperationException("Not yet implemented");
    }

    /**
     * This method first performs a feasibility analysis using the proposed parameter objects as replacements for the current parameters of schedulable. If the resulting system is feasible, this method replaces the current parameters of schedulable with the proposed ones.
     * This method does not require that the schedulable object be in the feasibility set before it is called. If it is not initially a member of the feasibility set it will be added if the resulting system is feasible.
     * @param schedulable - The schedulable object for which the changes are proposed.
     * @param release - The proposed release parameters. If null, the default value of this scheduler is used (a new object is created if the default value is not null).
     * @param memory - The proposed memory parameters. If null, the default value of this scheduler is used (a new object is created if the default value is not null).
     * @return True, if the resulting system is feasible and the changes are made. False, if the resulting system is not feasible and no changes are made.
     * @throws java.lang.IllegalArgumentException - Thrown if schedulable is null, or schedulable is not associated with this scheduler, or the proposed parameters are not compatible with this scheduler.
     * @throws IllegalAssignmentError - Thrown if schedulable cannot hold references to the proposed parameter objects, or the parameter objects cannot hold a reference to schedulable.
     * @throws java.lang.IllegalThreadStateException - Thrown if the new release parameters change schedulable from periodic scheduling to some other protocol and schedulable is currently waiting for the next release in RealtimeThread.waitForNextPeriod() or RealtimeThread.waitForNextPeriodInterruptible().
     */
    public boolean setIfFeasible(Schedulable schedulable, ReleaseParameters release, MemoryParameters memory){
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public boolean setIfFeasible(Schedulable schedulable, ReleaseParameters release, MemoryParameters memory, ProcessingGroupParameters group){
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public boolean setIfFeasible(Schedulable schedulable, SchedulingParameters scheduling, ReleaseParameters release, MemoryParameters memory, ProcessingGroupParameters group){
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public static EDFScheduler instance(){
        return singleton;
    }
}
