package lejos.realtime;

/**
 *
 * @author Team iRboT
 */
public class AsyncEventHandler implements Schedulable {

    private RealtimeThread _TVM_rtthread;
    private AsyncEventHandler _TVM_nextAsyncHandler;
    private byte _TVM_fireCount;
    private int _TVM_minInterarrival;
    private int _TVM_absoluteMinInterarrival;
    
    private final RealtimeThread rt;


    /**
     * Create an instance of AsyncEventHandler with default values for all
     * parameters.
     *
     * This constructor is equivalent to
     * AsyncEventHandler(null, null, null, null, null, false, null).
     */
    public AsyncEventHandler() {
        

        this(null,null,null,null,null,false,null);
        
    }

    public AsyncEventHandler(SchedulingParameters scheduling,
                         ReleaseParameters release,
                         MemoryParameters memory,
                         MemoryArea area,
                         ProcessingGroupParameters group,
                         boolean nonheap,
                         java.lang.Runnable logic){


         if(memory!= null || area != null|| group != null || logic != null){
                throw new UnsupportedOperationException("Not supported yet.");
                /*setMemoryParameters(memory);
                setProcessingGroupParameters(group);*/
        }
         
        rt = new RealtimeThread(new PriorityParameters(RealtimeThread.NORM_PRIORITY),new AperiodicParameters()) {

            @Override
            public void run() {
                while (waitForNextFire()) {
                    handleAsyncEvent();
                }
            }
        };
        setSchedulingParameters(scheduling);
        
        setReleaseParameters(release);
       
        //rt.setSchedulingParameters(new PriorityParameters(23));
        //rt.setReleaseParameters(new ReleaseParameters(new RelativeTime(10000, 0), new RelativeTime(60000, 0), null, null));
        init_async_thread(rt);
        rt.start();
    }

    @Override
    public void setReleaseParameters(ReleaseParameters release) throws IllegalArgumentException, IllegalStateException {
        rt.setReleaseParameters(release);
        if(release instanceof SporadicParameters ){
            SporadicParameters sp = (SporadicParameters) release;
            
            async_set_minInterarrival((int)sp.getMinimumInterarrival().getMilliseconds());
            


        }
    }

    @Override
    public void setSchedulingParameters(SchedulingParameters scheduling) throws IllegalArgumentException {
        rt.setSchedulingParameters(scheduling);
    }

    @Override
    public final void run() {
    }

    @Override
    public boolean addIfFeasible() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean addToFeasibility() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public MemoryParameters getMemoryParameters() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ProcessingGroupParameters getProcessingGroupParameters() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ReleaseParameters getReleaseParameters() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Scheduler getScheduler() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void handleAsyncEvent() {
        throw new UnsupportedOperationException("Not overrided yet.");
    }

    @Override
    public SchedulingParameters getSchedulingParameters() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean removeFromFeasibility() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean setIfFeasible(ReleaseParameters release, MemoryParameters memory) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean setIfFeasible(ReleaseParameters release, MemoryParameters memory, ProcessingGroupParameters group) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean setIfFeasible(ReleaseParameters release, ProcessingGroupParameters group) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean setIfFeasible(SchedulingParameters scheduling, ReleaseParameters release, MemoryParameters memory) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean setIfFeasible(SchedulingParameters scheduling, ReleaseParameters release, MemoryParameters memory, ProcessingGroupParameters group) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setMemoryParameters(MemoryParameters memory) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean setMemoryParametersIfFeasible(MemoryParameters memory) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setProcessingGroupParameters(ProcessingGroupParameters group) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean setProcessingGroupParametersIfFeasible(ProcessingGroupParameters group) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean setReleaseParametersIfFeasible(ReleaseParameters release) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setScheduler(Scheduler scheduler) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setScheduler(Scheduler scheduler, SchedulingParameters scheduling, ReleaseParameters release, MemoryParameters memoryParameters, ProcessingGroupParameters group) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean setSchedulingParametersIfFeasible(SchedulingParameters scheduling) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private native void init_async_thread(RealtimeThread rt);
    private native void async_set_minInterarrival(int minInterarrival);


    /**
     * Returns fireCount and clear it.
     * @return
     *      fireCount;
     */
    native int getAndClearPendingFireCount();

    /**
     * Returns fireCount and decrement it.
     * @return
     *      fireCount;
     */
    native int getAndDecrementPendingFireCount();

    /**
     * Returns fireCount and increment it.
     * @return
     *      fireCount;
     */
    native int getAndIncrementPendingFireCount();

    protected final native void prepare_2_wait_fire();

    boolean waitForNextFire() {
        prepare_2_wait_fire();
        return true;
    }
}
