package lejos.realtime;

import lejos.nxt.comm.RConsole;

/**
 *
 * @author Team iRboT
 */
public class AperiodicParameters extends ReleaseParameters {

    public static final java.lang.String arrivalTimeQueueOverflowExcept = "EXCEPT";
    public static final java.lang.String arrivalTimeQueueOverflowIgnore = "IGNORE";
    public static final java.lang.String arrivalTimeQueueOverflowReplace = "REPLACE";
    public static final java.lang.String arrivalTimeQueueOverflowSave = "SAVE";
    private String ArrivalTimeQueueOverflowBehavior = arrivalTimeQueueOverflowSave;

    /**
     * Create an AperiodicParameters object.
     *
     * This constructor is equivalent to:
     * AperiodicParameters(null, null, null, null)
     *
     * Since: 1.0.1
     */
    public AperiodicParameters() {
        this(null, null, null, null);
    }

    /**
     * Create an AperiodicParameters object.
     *
     * @param cost
     *          Processing time per invocation. On implementations which can
     *          measure the amount of time a schedulable object is executed,
     *          this value is the maximum amount of time a schedulable object
     *          receives. On implementations which cannot measure execution
     *          time, this value is used as a hint to the feasibility
     *          algorithm. On such systems it is not possible to determine when
     *          any particular object exceeds cost. If null, the default value
     *          is a new instance of RelativeTime(0,0).
     *
     * @param deadline
     *          The latest permissible completion time measured from the
     *          release time of the associated invocation of the schedulable
     *          object. If null, the default value is a new instance of
     *          RelativeTime(Long.MAX_VALUE, 999999).
     *
     * @param overrunHandler
     *          This handler is invoked if an invocation of the schedulable
     *          object exceeds cost. Not required for minimum implementation.
     *          If null, the default value is no overrun handler.
     *
     * @param missHandler
     *          This handler is invoked if the run() method of the schedulable
     *          object is still executing after the deadline has passed.
     *          Although minimum implementations do not consider deadlines in
     *          feasibility calculations, they must recognize variable
     *          deadlines and invoke the miss handler as appropriate. If null,
     *          the default value is no miss handler.
     *
     * @throws java.lang.IllegalArgumentException
     *          Thrown if the time value of cost is less than zero, or the
     *          time value of deadline is less than or equal to zero.
     *
     * @throws IllegalAssignmentError
     *          Thrown if cost, deadline, overrunHandler or missHandler cannot
     *          be stored in this.
     *
     */
    public AperiodicParameters(RelativeTime cost, RelativeTime deadline, AsyncEventHandler overrunHandler, AsyncEventHandler missHandler) {
        super(cost, deadline, overrunHandler, missHandler);
        setDeadline(deadline);

    }

    /**
     * Gets the behavior of the arrival time queue in the event of an overflow.
     *
     * @returns
     *          The behavior of the arrival time queue as a string.
     *
     * Since: 1.0.1 Moved from SporadicParameters
     *
     */
    public java.lang.String getArrivalTimeQueueOverflowBehavior() {

        return ArrivalTimeQueueOverflowBehavior;
    }

    /**
     * Gets the initial number of elements the arrival time queue can hold.
     *
     * This returns the initial queue length currently associated with this
     * parameter object. If the overflow policy is SAVE the initial queue
     * length may not be related to the current queue lengths of schedulable
     * objects associated with this parameter object.
     *
     * @returns
     *          The initial length of the queue.
     *
     * Since: 1.0.1 Moved here from SporadicParameters.
     *
     */
    public int getInitialArrivalTimeQueueLength() {

        throw new UnsupportedOperationException("Not overrided yet.");
    }

    /**
     * Sets the deadline value.
     *
     * If this parameter object is associated with any schedulable object
     * (by being passed through the schedulable object's constructor or set
     * with a method such as
     * RealtimeThread.setReleaseParameters(ReleaseParameters)) the deadline
     * of those schedulable objects is altered as specified by each
     * schedulable object's respective scheduler.
     *
     * Overrides:
     *         setDeadline in class ReleaseParameters
     *
     * @param deadline
     *         The latest permissible completion time measured from the
     *         release time of the associated invocation of the schedulable
     *         object. If deadline is null, the deadline is set to a new
     *         instance of RelativeTime(Long.MAX_VALUE, 999999).
     *
     * @throws java.lang.IllegalArgumentException
     *         Thrown if the time value of deadline is less than or equal to
     *         zero, or if the new value of this deadline is incompatible with
     *         the scheduler for any associated schedulable object.
     *
     * @throws IllegalAssignmentError
     *         Thrown if deadline cannot be stored in this.
     */
    public void setDeadline(RelativeTime deadline) {
        if (deadline == null) {
            //new RelativeTime(0,0) matching with infinite time for deadline or cost
            deadline = new RelativeTime(0, 0);
        }
        super.setDeadline(deadline);
    }

    /**
     * Sets the behavior of the arrival time queue in the case where the
     * insertion of a new element would make the queue size greater than the
     * initial size given in this.
     *
     * Values of behavior are compared using reference equality (==) not value
     * equality (equals()).
     *
     * @param behavior
     *          A string representing the behavior.
     *
     * @throws java.lang.IllegalArgumentException
     *          Thrown if behavior is not one of the final queue overflow
     *          behavior values defined in this class.
     *
     * Since: 1.0.1 Moved here from SporadicParameters.
     */
    public void setArrivalTimeQueueOverflowBehavior(java.lang.String behavior) {

        ArrivalTimeQueueOverflowBehavior = behavior;
    }

    /**
     * This method first performs a feasibility analysis using the new cost,
     * and deadline as replacements for the matching attributes of this. If the
     * resulting system is feasible, the method replaces the current scheduling
     * characteristics, of this with the new scheduling characteristics.
     *
     * Overrides:
     *          setIfFeasible in class ReleaseParameters
     *
     * @param cost
     *          The proposed cost. to determine when any particular object
     *          exceeds cost. If null, the default value is a new instance of
     *          RelativeTime(0,0).
     *
     * @param deadline
     *          The proposed deadline. If null, the default value is a new
     *          instance of RelativeTime(Long.MAX_VALUE, 999999).
     *
     * @returns
     *          false. Aperiodic parameters never yield a feasible system.
     *          (Subclasses of AperiodicParameters, such as SporadicParameters,
     *          need not return false.)
     *
     * @throws java.lang.IllegalArgumentException
     *          Thrown if the time value of cost is less than zero, or the time
     *          value of deadline is less than or equal to zero, or the values
     *          are incompatible with the scheduler for any of the schedulable
     *          objects which are presently using this parameter object.
     *
     * @throws IllegalAssignmentError
     *          Thrown if cost or deadline cannot be stored in this.
     */
    public boolean setIfFeasible(RelativeTime cost, RelativeTime deadline) {
        throw new UnsupportedOperationException("Not overrided yet.");
    }

    /**
     * Sets the initial number of elements the arrival time queue can hold
     * without lengthening the queue.
     *
     * The initial length of an arrival queue is set when the SO using the
     * queue is constructed, after that time changes in the initial queue
     * length are ignored.
     *
     * @param initial
     *         The initial length of the queue.
     *
     * @throws java.lang.IllegalArgumentException
     *         Thrown if initial is less than zero.
     *
     * Since: 1.0.1 Moved here from SporadicParameters.
     *
     */
    public void setInitialArrivalTimeQueueLength(int initial) {
        throw new UnsupportedOperationException("Not overrided yet.");
    }
}
