package lejos.realtime;

/**
 *
 * @author Team iRboT
 */
public class AbsoluteTime extends HighResolutionTime {

    /**
     * Equivalent to new AbsoluteTime(0,0).
     *
     * The clock association is implicitly made with the real-time clock.
     */
    public AbsoluteTime(){
        this(0,0);
    }

    /**
     * Make a new AbsoluteTime object from the given AbsoluteTime object.
     *
     * The new object will have the same clock association as the time
     * parameter.
     *
     * @param time
     *          The AbsoluteTime object which is the source for the copy.
     *
     * @throws IllegalArgumentException
     *          Thrown if the time parameter is null.
         */
    public AbsoluteTime(AbsoluteTime time) {
        if(time == null) {
            throw new IllegalArgumentException("Time cannot be null.");
        }

        
        
    }

    /**
     * Make a new AbsoluteTime object from the given AbsoluteTime object.
     *
     * The clock association is made with the clock parameter.
     * If clock is null the association is made with the real-time clock.
     *
     * @param time
     *          The AbsoluteTime object which is the source for the copy.
     * @param clock
     *          The clock providing the association for the newly constructed
     * object.
     * 
     * @throws IllegalArgumentException
     *          Thrown if the time parameter is null.
     */
    public AbsoluteTime(AbsoluteTime time, Clock clock) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /**
     * Equivalent to new AbsoluteTime(0,0,clock).
     *
     * The clock association is made with the clock parameter. If clock is null
     * the association is made with the real-time clock.
     *
     * @param clock
     *          The clock providing the association for the newly constructed
     * object.
     */
    public AbsoluteTime(Clock clock){
        this(0,0, clock);
    }

    /**
     * Equivalent to new AbsoluteTime (date.getTime(),0).
     *
     * The clock association is implicitly made with the real-time clock.
     *
     * @param date
     *          The java.util.Date representation of the time past the Epoch.
     *
     * @throws IllegalArgumentException
     *          Thrown if the date parameter is null.
     */
    public AbsoluteTime(java.util.Date date){
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /**
     * Equivalent to new AbsoluteTime (date.getTime(),0,clock).
     *
     * Warning: While the date is used to set the milliseconds component of the
     * new AbsoluteTime object (with nanoseconds component set to 0), the new
     * object represents the date only if the clock parameter has an epoch
     * equal to Epoch.
     * The clock association is made with the clock parameter. If clock is null
     * the association is made with the real-time clock.
     *
     * @param date
     *          The java.util.Date representation of the time past the Epoch.
     * @param clock
     *          The clock providing the association for the newly constructed
     * object.
     *
     * @throws IllegalArgumentException
     *          Thrown if the date parameter is null.
     */
    public AbsoluteTime(java.util.Date date, Clock clock){

        throw new UnsupportedOperationException("Not supported yet.");
    }

    public AbsoluteTime(long millis, int nanos){
        /*
         The clock association is implicitly made with the real-time clock.
        Parameters:
        millis - The desired value for the millisecond component of this. The actual value is the result of parameter normalization.
        nanos - The desired value for the nanosecond component of this. The actual value is the result of parameter normalization.
        Throws:
        java.lang.IllegalArgumentException - Thrown if there is an overflow in the millisecond component when normalizing.
        Construct an AbsoluteTime object with time millisecond and nanosecond components past the real-time clock's Epoch (00:00:00 GMT on January 1, 1970) based on the parameter millis plus the parameter nanos. The construction is subject to millis and nanos parameters normalization. If there is an overflow in the millisecond component when normalizing then an IllegalArgumentException will be thrown. If after normalization the time object is negative then the time represented by this is time before the Epoch.
        */
    }

    public AbsoluteTime(long millis, int nanos, Clock clock){
        /*
         Construct an AbsoluteTime object with time millisecond and nanosecond components past the epoch for clock.
        The value of the AbsoluteTime instance is based on the parameter millis plus the parameter nanos. The construction is subject to millis and nanos parameters normalization. If there is an overflow in the millisecond component when normalizing then an IllegalArgumentException will be thrown. If after normalization the time object is negative then the time represented by this is time before the epoch.
        The clock association is made with the clock parameter. If clock is null the association is made with the real-time clock.

        Note: The start of a clock's epoch is an attribute of the clock. It is defined as the Epoch (00:00:00 GMT on Jan 1, 1970) for the default real-time clock, but other classes of clock may define other epochs.

        Parameters:
        millis - The desired value for the millisecond component of this. The actual value is the result of parameter normalization.
        nanos - The desired value for the nanosecond component of this. The actual value is the result of parameter normalization.
        clock - The clock providing the association for the newly constructed object.
        Throws:
        java.lang.IllegalArgumentException - Thrown if there is an overflow in the millisecond component when normalizing.
        Since:
        1.0.1
         */
    }

    
    public AbsoluteTime absolute(Clock clock){
        /*
         Return a copy of this modified if necessary to have the specified clock association. A new object is allocated for the result. This method is the implementation of the abstract method of the HighResolutionTime base class. No conversion into AbsoluteTime is needed in this case. The clock association of the result is with the clock passed as a parameter. If clock is null the association is made with the real-time clock.
        Specified by:
        absolute in class HighResolutionTime
        Parameters:
        clock - The clock parameter is used only as the new clock association with the result, since no conversion is needed.
        Returns:
        The copy of this in a newly allocated AbsoluteTime object, associated with the clock parameter.
        absolute
         */
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public AbsoluteTime absolute(Clock clock, AbsoluteTime dest){
        /*
         Return a copy of this modified if necessary to have the specified clock association. If dest is not null, the result is placed in dest and returned. Otherwise, a new object is allocated for the result. This method is the implementation of the abstract method of the HighResolutionTime base class. No conversion into AbsoluteTime is needed in this case. The clock association of the result is with the clock passed as a parameter. If clock is null the association is made with the real-time clock.
        Specified by:
        absolute in class HighResolutionTime
        Parameters:
        clock - The clock parameter is used only as the new clock association with the result, since no conversion is needed.
        dest - If dest is not null, the result is placed there and returned. Otherwise, a new object is allocated for the result.
        Returns:
        The copy of this in dest if dest is not null, otherwise the result is returned in a newly allocated object. It is associated with the clock parameter.
        */
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public AbsoluteTime add(long millis, int nanos){
        /*Create a new object representing the result of adding millis and nanos to the values from this and normalizing the result. The result will have the same clock association as this. An ArithmeticException is thrown if the result does not fit in the normalized format.
        Parameters:
        millis - The number of milliseconds to be added to this.
        nanos - The number of nanoseconds to be added to this.
        Returns:
        A new AbsoluteTime object whose time is the normalization of this plus millis and nanos.
        Throws:
        java.lang.ArithmeticException - Thrown if the result does not fit in the normalized format.
         */
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public AbsoluteTime add(long millis, int nanos, AbsoluteTime dest){
        /*Return an object containing the value resulting from adding millis and nanos to the values from this and normalizing the result. If dest is not null, the result is placed there and returned. Otherwise, a new object is allocated for the result. The result will have the same clock association as this, and the clock association with dest is ignored. An ArithmeticException is thrown if the result does not fit in the normalized format.
        Parameters:
        millis - The number of milliseconds to be added to this.
        nanos - The number of nanoseconds to be added to this.
        dest - If dest is not null, the result is placed there and returned. Otherwise, a new object is allocated for the result.
        Returns:
        the result of the normalization of this plus millis and nanos in dest if dest is not null, otherwise the result is returned in a newly allocated object.
        Throws:
        java.lang.ArithmeticException - Thrown if the result does not fit in the normalized format.
         */
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public AbsoluteTime add(RelativeTime time){
        /*Create a new instance of AbsoluteTime representing the result of adding time to the value of this and normalizing the result. The clock associated with this and the clock associated with the time parameter must be the same, and such association is used for the result. An IllegalArgumentException is thrown if the clock associated with this and the clock associated with the time parameter are different. An IllegalArgumentException is thrown if the time parameter is null. An ArithmeticException is thrown if the result does not fit in the normalized format.
        Parameters:
        time - The time to add to this.
        Returns:
        A new AbsoluteTime object whose time is the normalization of this plus the parameter time.
        Throws:
        java.lang.IllegalArgumentException - Thrown if the clock associated with this and the clock associated with the time parameter are different, or when the time parameter is null.
        java.lang.ArithmeticException - Thrown if the result does not fit in the normalized format.
         */
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public AbsoluteTime add(RelativeTime time, AbsoluteTime dest){
        /*
         Return an object containing the value resulting from adding time to the value of this and normalizing the result. If dest is not null, the result is placed there and returned. Otherwise, a new object is allocated for the result. The clock associated with this and the clock associated with the time parameter must be the same, and such association is used for the result. The clock associated with the dest parameter is ignored. An IllegalArgumentException is thrown if the clock associated with this and the clock associated with the time parameter are different. An IllegalArgumentException is thrown if the time parameter is null. An ArithmeticException is thrown if the result does not fit in the normalized format.
        Parameters:
        time - The time to add to this.
        dest - If dest is not null, the result is placed there and returned. Otherwise, a new object is allocated for the result.
        Returns:
        the result of the normalization of this plus the RelativeTime parameter time in dest if dest is not null, otherwise the result is returned in a newly allocated object.
        Throws:
        java.lang.IllegalArgumentException - Thrown if the clock associated with this and the clock associated with the time parameter are different, or when the time parameter is null.
        java.lang.ArithmeticException - Thrown if the result does not fit in the normalized format.
         */
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public java.util.Date getDate(){
        /*
         Convert the time given by this to a Date format. Note that Date represents time as milliseconds so the nanoseconds of this will be lost. An UnsupportedOperationException is thrown if the clock associated with this does not have the concept of date.
        Returns:
        A newly allocated Date object with a value of the time past the Epoch represented by this.
        Throws:
        java.lang.UnsupportedOperationException - Thrown if the clock associated with this does not have the concept of date.
        */
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public RelativeTime relative(Clock clock){
        /*Convert the time of this to a relative time, using the given instance of Clock to determine the current time. The calculation is the current time indicated by the given instance of Clock subtracted from the time given by this. If clock is null the real-time clock is assumed. A destination object is allocated to return the result. The clock association of the result is with the clock passed as a parameter.
        Specified by:
        relative in class HighResolutionTime
        Parameters:
        clock - The instance of Clock used to convert the time of this into relative time, and the new clock association for the result.
        Returns:
        The RelativeTime conversion in a newly allocated object, associated with the clock parameter.
        Throws:
        java.lang.ArithmeticException - Thrown if the result does not fit in the normalized format.
        */
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public RelativeTime relative(Clock clock, RelativeTime dest){
        /*Convert the time of this to a relative time, using the given instance of Clock to determine the current time. The calculation is the current time indicated by the given instance of Clock subtracted from the time given by this. If clock is null the real-time clock is assumed. If dest is not null, the result is placed there and returned. Otherwise, a new object is allocated for the result. The clock association of the result is with the clock passed as a parameter.
        Specified by:
        relative in class HighResolutionTime
        Parameters:
        clock - The instance of Clock used to convert the time of this into relative time, and the new clock association for the result.
        dest - If dest is not null, the result is placed there and returned. Otherwise, a new object is allocated for the result.
        Returns:
        The RelativeTime conversion in dest if dest is not null, otherwise the result is returned in a newly allocated object. It is associated with the clock parameter.
        Throws:
        java.lang.ArithmeticException - Thrown if the result does not fit in the normalized format.
        */
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void set(java.util.Date date){
        /*
         Change the time represented by this to that given by the parameter. Note that Date represents time as milliseconds so the nanoseconds of this will be set to 0. An IllegalArgumentException is thrown if the parameter date is null. The clock association is implicitly made with the real-time clock.
        Parameters:
        date - A reference to a Date which will become the time represented by this after the completion of this method.
        Throws:
        java.lang.IllegalArgumentException - Thrown if the parameter date is null.
        */
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public RelativeTime subtract(AbsoluteTime time){
        /*Create a new instance of RelativeTime representing the result of subtracting time from the value of this and normalizing the result. The clock associated with this and the clock associated with the time parameter must be the same, and such association is used for the result. An IllegalArgumentException is thrown if the clock associated with this and the clock associated with the time parameter are different. An IllegalArgumentException is thrown if the time parameter is null. An ArithmeticException is thrown if the result does not fit in the normalized format.
        Parameters:
        time - The time to subtract from this.
        Returns:
        A new RelativeTime object whose time is the normalization of this minus the AbsoluteTime parameter time.
        Throws:
        java.lang.IllegalArgumentException - if the clock associated with this and the clock associated with the time parameter are different, or when the time parameter is null.
        java.lang.ArithmeticException - Thrown if the result does not fit in the normalized format.
        */
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public RelativeTime subtract(AbsoluteTime time, RelativeTime dest){
        /*Return an object containing the value resulting from subtracting time from the value of this and normalizing the result. If dest is not null, the result is placed there and returned. Otherwise, a new object is allocated for the result. The clock associated with this and the clock associated with the time parameter must be the same, and such association is used for the result. The clock associated with the dest parameter is ignored. An IllegalArgumentException is thrown if the clock associated with this and the clock associated with the time parameter are different. An IllegalArgumentException is thrown if the time parameter is null. An ArithmeticException is thrown if the result does not fit in the normalized format.
        Parameters:
        time - The time to subtract from this.
        dest - If dest is not null, the result is placed there and returned. Otherwise, a new object is allocated for the result.
        Returns:
        the result of the normalization of this minus the AbsoluteTime parameter time in dest if dest is not null, otherwise the result is returned in a newly allocated object.
        Throws:
        java.lang.IllegalArgumentException - if the clock associated with this and the clock associated with the time parameter are different, or when the time parameter is null.
        java.lang.ArithmeticException - Thrown if the result does not fit in the normalized format.
        */
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public AbsoluteTime subtract(RelativeTime time){
        /*Create a new instance of AbsoluteTime representing the result of subtracting time from the value of this and normalizing the result. The clock associated with this and the clock associated with the time parameter must be the same, and such association is used for the result. An IllegalArgumentException is thrown if the clock associated with this and the clock associated with the time parameter are different. An IllegalArgumentException is thrown if the time parameter is null. An ArithmeticException is thrown if the result does not fit in the normalized format.
        Parameters:
        time - The time to subtract from this.
        Returns:
        A new AbsoluteTime object whose time is the normalization of this minus the parameter time.
        Throws:
        java.lang.IllegalArgumentException - Thrown if the clock associated with this and the clock associated with the time parameter are different, or when the time parameter is null.
        java.lang.ArithmeticException - Thrown if the result does not fit in the normalized format.
        */
        throw new UnsupportedOperationException("Not supported yet.");
    }
    
    public AbsoluteTime subtract(RelativeTime time, AbsoluteTime dest){
        /*Return an object containing the value resulting from subtracting time from the value of this and normalizing the result. If dest is not null, the result is placed there and returned. Otherwise, a new object is allocated for the result. The clock associated with this and the clock associated with the time parameter must be the same, and such association is used for the result. The clock associated with the dest parameter is ignored. An IllegalArgumentException is thrown if the clock associated with this and the clock associated with the time parameter are different. An IllegalArgumentException is thrown if the time parameter is null. An ArithmeticException is thrown if the result does not fit in the normalized format.
        Parameters:
        time - The time to subtract from this.
        dest - If dest is not null, the result is placed there and returned. Otherwise, a new object is allocated for the result.
        Returns:
        the result of the normalization of this minus the RelativeTime parameter time in dest if dest is not null, otherwise the result is returned in a newly allocated object.
        Throws:
        java.lang.IllegalArgumentException - Thrown if the clock associated with this and the clock associated with the time parameter are different, or when the time parameter is null.
        java.lang.ArithmeticException - Thrown if the result does not fit in the normalized format.
        */
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public java.lang.String toString(){
        /*
         Create a printable string of the time given by this.
        The string shall be a decimal representation of the milliseconds and nanosecond values; formatted as follows "(2251 ms, 750000 ns)"
        Overrides:
        toString in class java.lang.Object
        Returns:
        String object converted from the time given by this.
         */
        throw new UnsupportedOperationException("Not supported yet.");
    }

}
