/* This file is auto-generated by optc-gen.awk.  */

#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "tm.h"
#include "opts.h"
#include "intl.h"

#ifdef GCC_DRIVER
int target_flags;
#else
#include "flags.h"
#include "target.h"
#endif /* GCC_DRIVER */

/* Set by -Wabi.
   Warn about things that will change when compiling with an ABI-compliant compiler  */
int warn_abi;

/* Set by -Waddress.
   Warn about suspicious uses of memory addresses  */
int warn_address;

/* Set by -Waggregate-return.
   Warn about returning structures, unions or arrays  */
int warn_aggregate_return;

/* Set by -Warray-bounds.
   Warn if an array is accessed out of bounds  */
int warn_array_bounds;

/* Set by -Wassign-intercept.
   Warn whenever an Objective-C assignment is being intercepted by the garbage collector  */
int warn_assign_intercept;

/* Set by -Wattributes.
   Warn about inappropriate attribute usage  */
int warn_attributes = 1;

/* Set by -Wbad-function-cast.
   Warn about casting functions to incompatible types  */
int warn_bad_function_cast;

/* Set by -Wc++-compat.
   Warn about C constructs that are not in the common subset of C and C++  */
int warn_cxx_compat;

/* Set by -Wc++0x-compat.
   Warn about C++ constructs whose meaning differs between ISO C++ 1998 and ISO C++ 200x  */
int warn_cxx0x_compat;

/* Set by -Wcast-align.
   Warn about pointer casts which increase alignment  */
int warn_cast_align;

/* Set by -Wcast-qual.
   Warn about casts which discard qualifiers  */
int warn_cast_qual;

/* Set by -Wchar-subscripts.
   Warn about subscripts whose type is \"char\"  */
int warn_char_subscripts;

/* Set by -Wclobbered.
   Warn about variables that might be changed by \"longjmp\" or \"vfork\"  */
int warn_clobbered = -1;

/* Set by -Wconversion.
   Warn for implicit type conversions that may change a value  */
int warn_conversion;

/* Set by -Wcoverage-mismatch.
   Warn instead of error in case profiles in -fprofile-use do not match  */
int warn_coverage_mismatch;

/* Set by -Wctor-dtor-privacy.
   Warn when all constructors and destructors are private  */
int warn_ctor_dtor_privacy;

/* Set by -Wdeclaration-after-statement.
   Warn when a declaration is found after a statement  */
int warn_declaration_after_statement;

/* Set by -Wdeprecated.
   Warn if a deprecated compiler feature, class, method, or field is used  */
int warn_deprecated = 1;

/* Set by -Wdeprecated-declarations.
   Warn about uses of __attribute__((deprecated)) declarations  */
int warn_deprecated_decl = 1;

/* Set by -Wdisabled-optimization.
   Warn when an optimization pass is disabled  */
int warn_disabled_optimization;

/* Set by -Wdiv-by-zero.
   Warn about compile-time integer division by zero  */
int warn_div_by_zero = 1;

/* Set by -Weffc++.
   Warn about violations of Effective C++ style rules  */
int warn_ecpp;

/* Set by -Wempty-body.
   Warn about an empty body in an if or else statement  */
int warn_empty_body = -1;

/* Set by -Wenum-compare.
   Warn about comparison of different enum types  */
int warn_enum_compare = 1;

/* Set by -Werror.
   Treat all warnings as errors  */
int warnings_are_errors;

/* Set by -Wfatal-errors.
   Exit on the first error occurred  */
int flag_fatal_errors;

/* Set by -Wfloat-equal.
   Warn if testing floating point numbers for equality  */
int warn_float_equal;

/* Set by -Wformat-contains-nul.
   Warn about format strings that contain NUL bytes  */
int warn_format_contains_nul;

/* Set by -Wformat-extra-args.
   Warn if passing too many arguments to a function for its format string  */
int warn_format_extra_args;

/* Set by -Wformat-nonliteral.
   Warn about format strings that are not literals  */
int warn_format_nonliteral;

/* Set by -Wformat-security.
   Warn about possible security problems with format functions  */
int warn_format_security;

/* Set by -Wformat-y2k.
   Warn about strftime formats yielding 2-digit years  */
int warn_format_y2k;

/* Set by -Wformat-zero-length.
   Warn about zero-length formats  */
int warn_format_zero_length;

/* Set by -Wignored-qualifiers.
   Warn whenever type qualifiers are ignored.  */
int warn_ignored_qualifiers = -1;

/* Set by -Wimplicit-function-declaration.
   Warn about implicit function declarations  */
int warn_implicit_function_declaration = -1;

/* Set by -Wimplicit-int.
   Warn when a declaration does not specify a type  */
int warn_implicit_int;

/* Set by -Winit-self.
   Warn about variables which are initialized to themselves  */
int warn_init_self;

/* Set by -Winline.
   Warn when an inlined function cannot be inlined  */
int warn_inline;

/* Set by -Wint-to-pointer-cast.
   Warn when there is a cast to a pointer from an integer of a different size  */
int warn_int_to_pointer_cast = 1;

/* Set by -Winvalid-offsetof.
   Warn about invalid uses of the \"offsetof\" macro  */
int warn_invalid_offsetof = 1;

/* Set by -Wlogical-op.
   Warn when a logical operator is suspicously always evaluating to true or false  */
int warn_logical_op;

/* Set by -Wlong-long.
   Do not warn about using \"long long\" when -pedantic  */
int warn_long_long = 1;

/* Set by -Wmain.
   Warn about suspicious declarations of \"main\"  */
int warn_main = -1;

/* Set by -Wmissing-braces.
   Warn about possibly missing braces around initializers  */
int warn_missing_braces;

/* Set by -Wmissing-declarations.
   Warn about global functions without previous declarations  */
int warn_missing_declarations;

/* Set by -Wmissing-field-initializers.
   Warn about missing fields in struct initializers  */
int warn_missing_field_initializers = -1;

/* Set by -Wmissing-format-attribute.
   Warn about functions which might be candidates for format attributes  */
int warn_missing_format_attribute;

/* Set by -Wmissing-noreturn.
   Warn about functions which might be candidates for __attribute__((noreturn))  */
int warn_missing_noreturn;

/* Set by -Wmissing-parameter-type.
   Warn about function parameters declared without a type specifier in K&R-style functions  */
int warn_missing_parameter_type = -1;

/* Set by -Wmissing-prototypes.
   Warn about global functions without prototypes  */
int warn_missing_prototypes;

/* Set by -Wmudflap.
   Warn about constructs not instrumented by -fmudflap  */
int warn_mudflap = 1;

/* Set by -Wnested-externs.
   Warn about \"extern\" declarations not at file scope  */
int warn_nested_externs;

/* Set by -Wnon-template-friend.
   Warn when non-templatized friend functions are declared within a template  */
int warn_nontemplate_friend = 1;

/* Set by -Wnon-virtual-dtor.
   Warn about non-virtual destructors  */
int warn_nonvdtor;

/* Set by -Wnonnull.
   Warn about NULL being passed to argument slots marked as requiring non-NULL  */
int warn_nonnull;

/* Set by -Wold-style-cast.
   Warn if a C-style cast is used in a program  */
int warn_old_style_cast;

/* Set by -Wold-style-declaration.
   Warn for obsolescent usage in a declaration  */
int warn_old_style_declaration = -1;

/* Set by -Wold-style-definition.
   Warn if an old-style parameter definition is used  */
int warn_old_style_definition;

/* Set by -Woverflow.
   Warn about overflow in arithmetic expressions  */
int warn_overflow = 1;

/* Set by -Woverlength-strings.
   Warn if a string is longer than the maximum portable length specified by the standard  */
int warn_overlength_strings = -1;

/* Set by -Woverloaded-virtual.
   Warn about overloaded virtual function names  */
int warn_overloaded_virtual;

/* Set by -Woverride-init.
   Warn about overriding initializers without side effects  */
int warn_override_init = -1;

/* Set by -Wpacked.
   Warn when the packed attribute has no effect on struct layout  */
int warn_packed;

/* Set by -Wpacked-bitfield-compat.
   Warn about packed bit-fields whose offset changed in GCC 4.4  */
int warn_packed_bitfield_compat = -1;

/* Set by -Wpadded.
   Warn when padding is required to align structure members  */
int warn_padded;

/* Set by -Wparentheses.
   Warn about possibly missing parentheses  */
int warn_parentheses;

/* Set by -Wpmf-conversions.
   Warn when converting the type of pointers to member functions  */
int warn_pmf2ptr = 1;

/* Set by -Wpointer-arith.
   Warn about function pointer arithmetic  */
int warn_pointer_arith;

/* Set by -Wpointer-sign.
   Warn when a pointer differs in signedness in an assignment  */
int warn_pointer_sign = -1;

/* Set by -Wpointer-to-int-cast.
   Warn when a pointer is cast to an integer of a different size  */
int warn_pointer_to_int_cast = 1;

/* Set by -Wpragmas.
   Warn about misuses of pragmas  */
int warn_pragmas = 1;

/* Set by -Wprotocol.
   Warn if inherited methods are unimplemented  */
int warn_protocol = 1;

/* Set by -Wpsabi.
     */
int warn_psabi = 1;

/* Set by -Wredundant-decls.
   Warn about multiple declarations of the same object  */
int warn_redundant_decls;

/* Set by -Wreorder.
   Warn when the compiler reorders code  */
int warn_reorder;

/* Set by -Wreturn-type.
   Warn whenever a function's return type defaults to \"int\" (C), or about inconsistent return types (C++)  */
int warn_return_type;

/* Set by -Wselector.
   Warn if a selector has multiple methods  */
int warn_selector;

/* Set by -Wsequence-point.
   Warn about possible violations of sequence point rules  */
int warn_sequence_point;

/* Set by -Wshadow.
   Warn when one local variable shadows another  */
int warn_shadow;

/* Set by -Wsign-compare.
   Warn about signed-unsigned comparisons  */
int warn_sign_compare = -1;

/* Set by -Wsign-conversion.
   Warn for implicit type conversions between signed and unsigned integers  */
int warn_sign_conversion = -1;

/* Set by -Wsign-promo.
   Warn when overload promotes from unsigned to signed  */
int warn_sign_promo;

/* Set by -Wstack-protector.
   Warn when not issuing stack smashing protection for some reason  */
int warn_stack_protect;

/* Set by -Wstrict-aliasing=.
   Warn about code which might break strict aliasing rules  */
int warn_strict_aliasing = -1;

/* Set by -Wstrict-overflow=.
   Warn about optimizations that assume that signed overflow is undefined  */
int warn_strict_overflow = -1;

/* Set by -Wstrict-prototypes.
   Warn about unprototyped function declarations  */
int warn_strict_prototypes;

/* Set by -Wstrict-selector-match.
   Warn if type signatures of candidate methods do not match exactly  */
int warn_strict_selector_match;

/* Set by -Wswitch.
   Warn about enumerated switches, with no default, missing a case  */
int warn_switch;

/* Set by -Wswitch-default.
   Warn about enumerated switches missing a \"default:\" statement  */
int warn_switch_default;

/* Set by -Wswitch-enum.
   Warn about all enumerated switches missing a specific case  */
int warn_switch_enum;

/* Set by -Wsync-nand.
   Warn when __sync_fetch_and_nand and __sync_nand_and_fetch built-in functions are used  */
int warn_sync_nand = 1;

/* Set by -Wsynth.
   Deprecated.  This switch has no effect  */
int warn_synth;

/* Set by -Wsystem-headers.
   Do not suppress warnings from system headers  */
int warn_system_headers;

/* Set by -Wtraditional.
   Warn about features not present in traditional C  */
int warn_traditional;

/* Set by -Wtraditional-conversion.
   Warn of prototypes causing type conversions different from what would happen in the absence of prototype  */
int warn_traditional_conversion;

/* Set by -Wtype-limits.
   Warn if a comparison is always true or always false due to the limited range of the data type  */
int warn_type_limits = -1;

/* Set by -Wundeclared-selector.
   Warn about @selector()s without previously declared methods  */
int warn_undeclared_selector;

/* Set by -Wuninitialized.
   Warn about uninitialized automatic variables  */
int warn_uninitialized;

/* Set by -Wunreachable-code.
   Warn about code that will never be executed  */
int warn_notreached;

/* Set by -Wunsafe-loop-optimizations.
   Warn if the loop cannot be optimized due to nontrivial assumptions.  */
int warn_unsafe_loop_optimizations;

/* Set by -Wunused.
   Enable all -Wunused- warnings  */
int warn_unused = 0;

/* Set by -Wunused-function.
   Warn when a function is unused  */
int warn_unused_function = -1;

/* Set by -Wunused-label.
   Warn when a label is unused  */
int warn_unused_label = -1;

/* Set by -Wunused-parameter.
   Warn when a function parameter is unused  */
int warn_unused_parameter = -1;

/* Set by -Wunused-value.
   Warn when an expression value is unused  */
int warn_unused_value = -1;

/* Set by -Wunused-variable.
   Warn when a variable is unused  */
int warn_unused_variable = -1;

/* Set by -Wvla.
   Warn if a variable length array is used  */
int warn_vla = -1;

/* Set by -Wvolatile-register-var.
   Warn when a register variable is declared volatile  */
int warn_volatile_register_var;

/* Set by -Wwrite-strings.
   In C++, nonzero means warn about deprecated conversion from string literals to `char *'.  In C, similar warning, except that the conversion is of course not deprecated by the ISO C standard.  */
int warn_write_strings;

/* Set by -fPIC.
   Generate position-independent code if possible (large mode)  */
int flag_pic;

/* Set by -fPIE.
   Generate position-independent code for executables if possible (large mode)  */
int flag_pie;

/* Set by -fabi-version=.
     */
int flag_abi_version = 2;

/* Set by -falign-functions.
   Align the start of functions  */
int align_functions;

/* Set by -falign-jumps.
   Align labels which are only reached by jumping  */
int align_jumps;

/* Set by -falign-labels.
   Align all labels  */
int align_labels;

/* Set by -falign-loops.
   Align the start of loops  */
int align_loops;

/* Set by -fargument-alias.
   Specify that arguments may alias each other and globals  */
int flag_argument_noalias;

/* Set by -fassociative-math.
   Allow optimization for floating-point arithmetic which may change the result of the operation due to rounding.  */
int flag_associative_math;

/* Set by -fasynchronous-unwind-tables.
   Generate unwind tables that are exact at each instruction boundary  */
int flag_asynchronous_unwind_tables;

/* Set by -fauto-inc-dec.
   Generate auto-inc/dec instructions  */
int flag_auto_inc_dec = 1;

/* Set by -fbounds-check.
   Generate code to check bounds before indexing arrays  */
int flag_bounds_check;

/* Set by -fbranch-count-reg.
   Replace add, compare, branch with branch on count register  */
int flag_branch_on_count_reg = 1;

/* Set by -fbranch-probabilities.
   Use profiling information for branch probabilities  */
int flag_branch_probabilities;

/* Set by -fbranch-target-load-optimize.
   Perform branch target load optimization before prologue / epilogue threading  */
int flag_branch_target_load_optimize;

/* Set by -fbranch-target-load-optimize2.
   Perform branch target load optimization after prologue / epilogue threading  */
int flag_branch_target_load_optimize2;

/* Set by -fbtr-bb-exclusive.
   Restrict target load migration not to re-use registers in any basic block  */
int flag_btr_bb_exclusive;

/* Set by -fcaller-saves.
   Save registers around function calls  */
int flag_caller_saves;

/* Set by -fcheck-data-deps.
   Compare the results of several data dependence analyzers.  */
int flag_check_data_deps;

/* Set by -fcommon.
   Do not put uninitialized globals in the common section  */
int flag_no_common;

/* Set by -fconserve-stack.
   Do not perform optimizations increasing noticeably stack usage  */
int flag_conserve_stack;

/* Set by -fcprop-registers.
   Perform a register copy-propagation optimization pass  */
int flag_cprop_registers;

/* Set by -fcrossjumping.
   Perform cross-jumping optimization  */
int flag_crossjumping;

/* Set by -fcse-follow-jumps.
   When running CSE, follow jumps to their targets  */
int flag_cse_follow_jumps;

/* Set by -fcse-skip-blocks.
   When running CSE, follow conditional jumps  */
int flag_cse_skip_blocks;

/* Set by -fcx-fortran-rules.
   Complex multiplication and division follow Fortran rules  */
int flag_cx_fortran_rules;

/* Set by -fcx-limited-range.
   Omit range reduction step when performing complex division  */
int flag_cx_limited_range;

/* Set by -fdata-sections.
   Place data items into their own section  */
int flag_data_sections;

/* Set by -fdce.
   Use the RTL dead code elimination pass  */
int flag_dce = 1;

/* Set by -fdefer-pop.
   Defer popping functions args from stack until later  */
int flag_defer_pop;

/* Set by -fdelayed-branch.
   Attempt to fill delay slots of branch instructions  */
int flag_delayed_branch;

/* Set by -fdelete-null-pointer-checks.
   Delete useless null pointer checks  */
int flag_delete_null_pointer_checks;

/* Set by -fdse.
   Use the RTL dead store elimination pass  */
int flag_dse = 1;

/* Set by -fdump-noaddr.
   Suppress output of addresses in debugging dumps  */
int flag_dump_noaddr;

#ifdef GCC_DRIVER
/* Set by -fdump-unnumbered.
   Suppress output of instruction numbers, line number notes and addresses in debugging dumps  */
int flag_dump_unnumbered;
#endif /* GCC_DRIVER */

/* Set by -fdwarf2-cfi-asm.
   Enable CFI tables via GAS assembler directives.  */
int flag_dwarf2_cfi_asm = HAVE_GAS_CFI_DIRECTIVE;

/* Set by -fearly-inlining.
   Perform early inlining  */
int flag_early_inlining = 1;

/* Set by -feliminate-dwarf2-dups.
   Perform DWARF2 duplicate elimination  */
int flag_eliminate_dwarf2_dups;

/* Set by -feliminate-unused-debug-symbols.
   Perform unused type elimination in debug info  */
int flag_debug_only_used_symbols;

/* Set by -feliminate-unused-debug-types.
   Perform unused type elimination in debug info  */
int flag_eliminate_unused_debug_types = 1;

/* Set by -femit-class-debug-always.
   Do not suppress C++ class debug information.  */
int flag_emit_class_debug_always = 0;

/* Set by -fexceptions.
   Enable exception handling  */
int flag_exceptions;

/* Set by -fexpensive-optimizations.
   Perform a number of minor, expensive optimizations  */
int flag_expensive_optimizations;

/* Set by -ffinite-math-only.
   Assume no NaNs or infinities are generated  */
int flag_finite_math_only;

/* Set by -ffloat-store.
   Don't allocate floats and doubles in extended-precision registers  */
int flag_float_store;

/* Set by -fforward-propagate.
   Perform a forward propagation pass on RTL  */
int flag_forward_propagate;

/* Set by -ffriend-injection.
   Inject friend functions into enclosing namespace  */
int flag_friend_injection;

/* Set by -ffunction-cse.
   Allow function addresses to be held in registers  */
int flag_no_function_cse;

/* Set by -ffunction-sections.
   Place each function into its own section  */
int flag_function_sections;

/* Set by -fgcse.
   Perform global common subexpression elimination  */
int flag_gcse;

/* Set by -fgcse-after-reload.
   Perform global common subexpression elimination after register allocation has finished  */
int flag_gcse_after_reload;

/* Set by -fgcse-las.
   Perform redundant load after store elimination in global common subexpression elimination  */
int flag_gcse_las = 0;

/* Set by -fgcse-lm.
   Perform enhanced load motion during global common subexpression elimination  */
int flag_gcse_lm = 1;

/* Set by -fgcse-sm.
   Perform store motion after global common subexpression elimination  */
int flag_gcse_sm = 0;

/* Set by -fgnu89-inline.
   Use traditional GNU semantics for inline functions  */
int flag_gnu89_inline = -1;

/* Set by -fgraphite.
   Enable in and out of Graphite representation  */
int flag_graphite;

/* Set by -fgraphite-identity.
   Enable Graphite Identity transformation  */
int flag_graphite_identity;

/* Set by -fguess-branch-probability.
   Enable guessing of branch probabilities  */
int flag_guess_branch_prob;

/* Set by -fident.
   Process #ident directives  */
int flag_no_ident;

/* Set by -fif-conversion.
   Perform conversion of conditional jumps to branchless equivalents  */
int flag_if_conversion;

/* Set by -fif-conversion2.
   Perform conversion of conditional jumps to conditional execution  */
int flag_if_conversion2;

/* Set by -findirect-inlining.
   Perform indirect inlining  */
int flag_indirect_inlining;

/* Set by -finhibit-size-directive.
   Do not generate .size directives  */
int flag_inhibit_size_directive;

/* Set by -finline.
   Pay attention to the \"inline\" keyword  */
int flag_no_inline = 0;

/* Set by -finline-functions.
   Integrate simple functions into their callers  */
int flag_inline_functions;

/* Set by -finline-functions-called-once.
   Integrate functions called once into their callers  */
int flag_inline_functions_called_once = 1;

/* Set by -finline-small-functions.
   Integrate simple functions into their callers when code size is known to not growth  */
int flag_inline_small_functions;

/* Set by -finstrument-functions.
   Instrument function entry and exit with profiling calls  */
int flag_instrument_function_entry_exit;

/* Set by -fipa-cp.
   Perform Interprocedural constant propagation  */
int flag_ipa_cp;

/* Set by -fipa-cp-clone.
   Perform cloning to make Interprocedural constant propagation stronger  */
int flag_ipa_cp_clone;

/* Set by -fipa-matrix-reorg.
   Perform matrix layout flattening and transposing based on profiling information.  */
int flag_ipa_matrix_reorg;

/* Set by -fipa-pta.
   Perform interprocedural points-to analysis  */
int flag_ipa_pta = 0;

/* Set by -fipa-pure-const.
   Discover pure and const functions  */
int flag_ipa_pure_const = 0;

/* Set by -fipa-reference.
   Discover readonly and non addressable static variables  */
int flag_ipa_reference = 0;

/* Set by -fipa-struct-reorg.
   Perform structure layout optimizations based on profiling information.  */
int flag_ipa_struct_reorg;

/* Set by -fipa-type-escape.
   Type based escape and alias analysis  */
int flag_ipa_type_escape = 0;

/* Set by -fira-coalesce.
   Do optimistic coalescing.  */
int flag_ira_coalesce = 0;

/* Set by -fira-share-save-slots.
   Share slots for saving different hard registers.  */
int flag_ira_share_save_slots = 1;

/* Set by -fira-share-spill-slots.
   Share stack slots for spilled pseudo-registers.  */
int flag_ira_share_spill_slots = 1;

/* Set by -fivopts.
   Optimize induction variables on trees  */
int flag_ivopts = 1;

/* Set by -fjump-tables.
   Use jump tables for sufficiently large switch statements  */
int flag_jump_tables = 1;

/* Set by -fkeep-inline-functions.
   Generate code for functions even if they are fully inlined  */
int flag_keep_inline_functions;

/* Set by -fkeep-static-consts.
   Emit static const variables even if they are not used  */
int flag_keep_static_consts = 1;

/* Set by -fleading-underscore.
   Give external symbols a leading underscore  */
int flag_leading_underscore = -1;

/* Set by -floop-block.
   Enable Loop Blocking transformation  */
int flag_loop_block;

/* Set by -floop-interchange.
   Enable Loop Interchange transformation  */
int flag_loop_interchange;

/* Set by -floop-strip-mine.
   Enable Loop Strip Mining transformation  */
int flag_loop_strip_mine;

/* Set by -fmath-errno.
   Set errno after built-in math functions  */
int flag_errno_math = 1;

/* Set by -fmem-report.
   Report on permanent memory allocation  */
int mem_report;

/* Set by -fmerge-all-constants.
   Attempt to merge identical constants and constant variables  */
int flag_merge_constants = 1;

/* Set by -fmerge-debug-strings.
   Attempt to merge identical debug strings across compilation units  */
int flag_merge_debug_strings = 1;

/* Set by -fmodulo-sched.
   Perform SMS based modulo scheduling before the first scheduling pass  */
int flag_modulo_sched;

/* Set by -fmodulo-sched-allow-regmoves.
   Perform SMS based modulo scheduling with register moves allowed  */
int flag_modulo_sched_allow_regmoves;

/* Set by -fmove-loop-invariants.
   Move loop invariant computations out of loops  */
int flag_move_loop_invariants = 1;

/* Set by -fmudflap.
   Add mudflap bounds-checking instrumentation for single-threaded program  */
int flag_mudflap;

/* Set by -fmudflapir.
   Ignore read operations when inserting mudflap instrumentation  */
int flag_mudflap_ignore_reads;

/* Set by -fnon-call-exceptions.
   Support synchronous non-call exceptions  */
int flag_non_call_exceptions;

/* Set by -fobjc-call-cxx-cdtors.
   Generate special Objective-C methods to initialize/destroy non-POD C++ ivars, if needed  */
int flag_objc_call_cxx_cdtors;

/* Set by -fobjc-direct-dispatch.
   Allow fast jumps to the message dispatcher  */
int flag_objc_direct_dispatch;

/* Set by -fobjc-exceptions.
   Enable Objective-C exception and synchronization syntax  */
int flag_objc_exceptions;

/* Set by -fobjc-gc.
   Enable garbage collection (GC) in Objective-C/Objective-C++ programs  */
int flag_objc_gc;

/* Set by -fobjc-sjlj-exceptions.
   Enable Objective-C setjmp exception handling runtime  */
int flag_objc_sjlj_exceptions = -1;

/* Set by -fomit-frame-pointer.
   When possible do not generate stack frames  */
int flag_omit_frame_pointer;

/* Set by -fopenmp.
   Enable OpenMP (implies -frecursive in Fortran)  */
int flag_openmp;

/* Set by -foptimize-register-move.
   Do the full register move optimization pass  */
int flag_regmove;

/* Set by -foptimize-sibling-calls.
   Optimize sibling and tail recursive calls  */
int flag_optimize_sibling_calls;

/* Set by -fpack-struct.
   Pack structure members together without holes  */
int flag_pack_struct;

#ifdef GCC_DRIVER
/* Set by -fpcc-struct-return.
   Return small aggregates in memory, not registers  */
int flag_pcc_struct_return;
#endif /* GCC_DRIVER */

/* Set by -fpeel-loops.
   Perform loop peeling  */
int flag_peel_loops;

/* Set by -fpeephole.
   Enable machine specific peephole optimizations  */
int flag_no_peephole;

/* Set by -fpeephole2.
   Enable an RTL peephole pass before sched2  */
int flag_peephole2;

/* Set by -fpost-ipa-mem-report.
   Report on memory allocation before interprocedural optimization  */
int post_ipa_mem_report;

/* Set by -fpre-ipa-mem-report.
   Report on memory allocation before interprocedural optimization  */
int pre_ipa_mem_report;

/* Set by -fpredictive-commoning.
   Run predictive commoning optimization.  */
int flag_predictive_commoning;

/* Set by -fprefetch-loop-arrays.
   Generate prefetch instructions, if available, for arrays in loops  */
int flag_prefetch_loop_arrays;

/* Set by -fprofile.
   Enable basic program profiling code  */
int profile_flag;

/* Set by -fprofile-arcs.
   Insert arc-based program profiling code  */
int profile_arc_flag;

/* Set by -fprofile-correction.
   Enable correction of flow inconsistent profile data input  */
int flag_profile_correction;

/* Set by -fprofile-use.
   Enable common options for performing profile feedback directed optimizations  */
int flag_profile_use;

/* Set by -fprofile-values.
   Insert code to profile values of expressions  */
int flag_profile_values;

/* Set by -freciprocal-math.
   Same as -fassociative-math for expressions which include division.  */
int flag_reciprocal_math;

/* Set by -frecord-gcc-switches.
   Record gcc command line switches in the object file.  */
int flag_record_gcc_switches;

/* Set by -frename-registers.
   Perform a register renaming optimization pass  */
int flag_rename_registers = 2;

/* Set by -freorder-blocks.
   Reorder basic blocks to improve code placement  */
int flag_reorder_blocks;

/* Set by -freorder-blocks-and-partition.
   Reorder basic blocks and partition into hot and cold sections  */
int flag_reorder_blocks_and_partition;

/* Set by -freorder-functions.
   Reorder functions to improve code placement  */
int flag_reorder_functions;

/* Set by -frerun-cse-after-loop.
   Add a common subexpression elimination pass after loop optimizations  */
int flag_rerun_cse_after_loop = 2;

/* Set by -freschedule-modulo-scheduled-loops.
   Enable/Disable the traditional scheduling in loops that already passed modulo scheduling  */
int flag_resched_modulo_sched;

/* Set by -frounding-math.
   Disable optimizations that assume default FP rounding behavior  */
int flag_rounding_math;

/* Set by -frtl-abstract-sequences.
   Perform sequence abstraction optimization on RTL  */
int flag_rtl_seqabstr;

/* Set by -fsched-interblock.
   Enable scheduling across basic blocks  */
int flag_schedule_interblock = 1;

/* Set by -fsched-spec.
   Allow speculative motion of non-loads  */
int flag_schedule_speculative = 1;

/* Set by -fsched-spec-load.
   Allow speculative motion of some loads  */
int flag_schedule_speculative_load;

/* Set by -fsched-spec-load-dangerous.
   Allow speculative motion of more loads  */
int flag_schedule_speculative_load_dangerous;

/* Set by -fsched-stalled-insns.
   Allow premature scheduling of queued insns  */
int flag_sched_stalled_insns;

/* Set by -fsched-stalled-insns-dep.
   Set dependence distance checking in premature scheduling of queued insns  */
int flag_sched_stalled_insns_dep = 1;

/* Set by -fsched2-use-superblocks.
   If scheduling post reload, do superblock scheduling  */
int flag_sched2_use_superblocks;

/* Set by -fsched2-use-traces.
   If scheduling post reload, do trace scheduling  */
int flag_sched2_use_traces;

/* Set by -fschedule-insns.
   Reschedule instructions before register allocation  */
int flag_schedule_insns;

/* Set by -fschedule-insns2.
   Reschedule instructions after register allocation  */
int flag_schedule_insns_after_reload;

/* Set by -fsection-anchors.
   Access data in the same section from shared anchor points  */
int flag_section_anchors;

/* Set by -fsee.
   Eliminate redundant sign extensions using LCM.  */
int flag_see = 0;

/* Set by -fsel-sched-pipelining.
   Perform software pipelining of inner loops during selective scheduling  */
int flag_sel_sched_pipelining = 0;

/* Set by -fsel-sched-pipelining-outer-loops.
   Perform software pipelining of outer loops during selective scheduling  */
int flag_sel_sched_pipelining_outer_loops = 0;

/* Set by -fsel-sched-reschedule-pipelined.
   Reschedule pipelined regions without pipelining  */
int flag_sel_sched_reschedule_pipelined = 0;

/* Set by -fselective-scheduling.
   Schedule instructions using selective scheduling algorithm  */
int flag_selective_scheduling;

/* Set by -fselective-scheduling2.
   Run selective scheduling after reload  */
int flag_selective_scheduling2;

/* Set by -fshow-column.
   Show column numbers in diagnostics, when available.  Default off  */
int flag_show_column = 0;

/* Set by -fsignaling-nans.
   Disable optimizations observable by IEEE signaling NaNs  */
int flag_signaling_nans;

/* Set by -fsigned-zeros.
   Disable floating point optimizations that ignore the IEEE signedness of zero  */
int flag_signed_zeros = 1;

/* Set by -fsingle-precision-constant.
   Convert floating point constants to single precision constants  */
int flag_single_precision_constant;

/* Set by -fsplit-ivs-in-unroller.
   Split lifetimes of induction variables when loops are unrolled  */
int flag_split_ivs_in_unroller = 1;

/* Set by -fsplit-wide-types.
   Split wide types into independent registers  */
int flag_split_wide_types;

/* Set by -fstack-protector.
   Use propolice as a stack protection method  */
int flag_stack_protect;

/* Set by -fstrict-aliasing.
   Assume strict aliasing rules apply  */
int flag_strict_aliasing;

/* Set by -fstrict-overflow.
   Treat signed overflow as undefined  */
int flag_strict_overflow;

/* Set by -fsyntax-only.
   Check for syntax errors, then stop  */
int flag_syntax_only;

/* Set by -ftest-coverage.
   Create data files needed by \"gcov\"  */
int flag_test_coverage;

/* Set by -fthread-jumps.
   Perform jump threading optimizations  */
int flag_thread_jumps;

/* Set by -ftime-report.
   Report the time taken by each compiler pass  */
int time_report;

/* Set by -ftoplevel-reorder.
   Reorder top level functions, variables, and asms  */
int flag_toplevel_reorder = 2;

/* Set by -ftracer.
   Perform superblock formation via tail duplication  */
int flag_tracer;

/* Set by -ftrapping-math.
   Assume floating-point operations can trap  */
int flag_trapping_math = 1;

/* Set by -ftrapv.
   Trap for signed overflow in addition, subtraction and multiplication  */
int flag_trapv;

/* Set by -ftree-builtin-call-dce.
   Enable conditional dead code elimination for builtin calls  */
int flag_tree_builtin_call_dce = 0;

/* Set by -ftree-ccp.
   Enable SSA-CCP optimization on trees  */
int flag_tree_ccp;

/* Set by -ftree-ch.
   Enable loop header copying on trees  */
int flag_tree_ch;

/* Set by -ftree-copy-prop.
   Enable copy propagation on trees  */
int flag_tree_copy_prop;

/* Set by -ftree-copyrename.
   Replace SSA temporaries with better names in copies  */
int flag_tree_copyrename;

/* Set by -ftree-cselim.
   Transform condition stores into unconditional ones  */
int flag_tree_cselim = 2;

/* Set by -ftree-dce.
   Enable SSA dead code elimination optimization on trees  */
int flag_tree_dce;

/* Set by -ftree-dominator-opts.
   Enable dominator optimizations  */
int flag_tree_dom;

/* Set by -ftree-dse.
   Enable dead store elimination  */
int flag_tree_dse;

/* Set by -ftree-fre.
   Enable Full Redundancy Elimination (FRE) on trees  */
int flag_tree_fre;

/* Set by -ftree-loop-distribution.
   Enable loop distribution on trees  */
int flag_tree_loop_distribution;

/* Set by -ftree-loop-im.
   Enable loop invariant motion on trees  */
int flag_tree_loop_im = 1;

/* Set by -ftree-loop-ivcanon.
   Create canonical induction variables in loops  */
int flag_tree_loop_ivcanon = 1;

/* Set by -ftree-loop-linear.
   Enable linear loop transforms on trees  */
int flag_tree_loop_linear;

/* Set by -ftree-loop-optimize.
   Enable loop optimizations on tree level  */
int flag_tree_loop_optimize = 1;

/* Set by -ftree-lrs.
   Perform live range splitting during the SSA->normal pass  */
int flag_tree_live_range_split;

/* Set by -ftree-parallelize-loops=.
   Enable automatic parallelization of loops  */
int flag_tree_parallelize_loops = 1;

/* Set by -ftree-pre.
   Enable SSA-PRE optimization on trees  */
int flag_tree_pre;

/* Set by -ftree-reassoc.
   Enable reassociation on tree level  */
int flag_tree_reassoc = 1;

/* Set by -ftree-scev-cprop.
   Enable copy propagation of scalar-evolution information.  */
int flag_tree_scev_cprop = 1;

/* Set by -ftree-sink.
   Enable SSA code sinking on trees  */
int flag_tree_sink;

/* Set by -ftree-sra.
   Perform scalar replacement of aggregates  */
int flag_tree_sra;

/* Set by -ftree-switch-conversion.
   Perform conversions of switch initializations.  */
int flag_tree_switch_conversion;

/* Set by -ftree-ter.
   Replace temporary expressions in the SSA->normal pass  */
int flag_tree_ter = 1;

/* Set by -ftree-vect-loop-version.
   Enable loop versioning when doing loop vectorization on trees  */
int flag_tree_vect_loop_version = 1;

/* Set by -ftree-vectorize.
   Enable loop vectorization on trees  */
int flag_tree_vectorize;

/* Set by -ftree-vrp.
   Perform Value Range Propagation on trees  */
int flag_tree_vrp = 0;

/* Set by -funit-at-a-time.
   Compile whole compilation unit at a time  */
int flag_unit_at_a_time = 1;

/* Set by -funroll-all-loops.
   Perform loop unrolling for all loops  */
int flag_unroll_all_loops;

/* Set by -funroll-loops.
   Perform loop unrolling when iteration count is known  */
int flag_unroll_loops;

/* Set by -funsafe-loop-optimizations.
   Allow loop optimizations to assume that the loops behave in normal way  */
int flag_unsafe_loop_optimizations;

/* Set by -funsafe-math-optimizations.
   Allow math optimizations that may violate IEEE or ISO standards  */
int flag_unsafe_math_optimizations;

/* Set by -funswitch-loops.
   Perform loop unswitching  */
int flag_unswitch_loops;

/* Set by -funwind-tables.
   Just generate unwind tables for exception handling  */
int flag_unwind_tables;

#ifdef GCC_DRIVER
/* Set by -fvar-tracking.
   Perform variable tracking  */
int flag_var_tracking;
#endif /* GCC_DRIVER */

/* Set by -fvar-tracking-uninit.
   Perform variable tracking and also tag variables that are uninitialized  */
int flag_var_tracking_uninit;

/* Set by -fvariable-expansion-in-unroller.
   Apply variable expansion when loops are unrolled  */
int flag_variable_expansion_in_unroller;

/* Set by -fvect-cost-model.
   Enable use of cost model in vectorization  */
int flag_vect_cost_model;

/* Set by -fverbose-asm.
   Add extra commentary to assembler output  */
int flag_verbose_asm;

/* Set by -fvisibility-ms-compat.
   Changes visibility to match Microsoft Visual Studio by default  */
int flag_visibility_ms_compat;

/* Set by -fvpt.
   Use expression value profiles in optimizations  */
int flag_value_profile_transformations;

/* Set by -fweb.
   Construct webs and split unrelated uses of single variable  */
int flag_web = 2;

/* Set by -fwhole-program.
   Perform whole program optimizations  */
int flag_whole_program = 0;

/* Set by -fwrapv.
   Assume signed arithmetic overflow wraps around  */
int flag_wrapv;

/* Set by -fzero-initialized-in-bss.
   Put zero initialized data in the bss section  */
int flag_zero_initialized_in_bss = 1;

/* Set by -mabi=.
   Specify an ABI  */
const char *target_abi_name;

/* Set by -mfix-cortex-m3-ldrd.
   Avoid overlapping destination and address registers on LDRD instructions that may trigger Cortex-M3 errata.  */
int fix_cm3_ldrd = 2;

/* Set by -mfloat-abi=.
   Specify if floating point hardware should be used  */
const char *target_float_abi_name;

/* Set by -mfp=.
     */
const char *target_fpe_name;

/* Set by -mfpu=.
   Specify the name of the target floating point hardware/format  */
const char *target_fpu_name;

/* Set by -mpic-register=.
   Specify the register to be used for PIC addressing  */
const char *arm_pic_register_string;

/* Set by -mstructure-size-boundary=.
   Specify the minimum bit alignment of structures  */
const char *structure_size_string;

/* Set by -mtp=.
   Specify how to access the thread pointer  */
const char *target_thread_switch;

/* Set by -mword-relocations.
   Only generate absolute relocations on word sized values.  */
int target_word_relocations = TARGET_DEFAULT_WORD_RELOCATIONS;

/* Set by -pedantic.
   Issue warnings needed for strict compliance to the standard  */
int pedantic;

/* Set by -quiet.
   Do not display functions compiled or elapsed time  */
int quiet_flag;

/* Set by -version.
   Display the compiler's version  */
int version_flag;

/* Set by -w.
   Suppress warnings  */
int inhibit_warnings;


/* Local state variables.  */
static const char *VAR_march_;
static const char *VAR_mcpu_;
static int VAR_mhard_float;
static int VAR_msoft_float;
static const char *VAR_mtune_;

const char * const lang_names[] =
{
  "C",
  "C++",
  "ObjC",
  "ObjC++",
  0
};

const unsigned int cl_options_count = N_OPTS;

const unsigned int cl_lang_count = 4;

const struct cl_option cl_options[] =
{
  { "--help",
    "Display this information",
    N_OPTS, 5, -1,
    CL_COMMON,
    0, CLVC_BOOLEAN, 0 },
  { "--help=",
    "--help=<class>	Display descriptions of a specific class of options.  <class> is one or more of optimizers, target, warnings, undocumented, params",
    N_OPTS, 6, -1,
    CL_COMMON | CL_JOINED | CL_REPORT,
    0, CLVC_STRING, 0 },
  { "--output-pch=",
    0,
    N_OPTS, 12, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, CLVC_STRING, 0 },
  { "--param",
    "--param <param>=<value>	Set parameter <param> to value.  See below for a complete list of parameters",
    N_OPTS, 6, -1,
    CL_COMMON | CL_SEPARATE,
    0, CLVC_BOOLEAN, 0 },
  { "--target-help",
    "Alias for --help=target",
    N_OPTS, 12, -1,
    CL_COMMON,
    0, CLVC_BOOLEAN, 0 },
  { "--version",
    0,
    N_OPTS, 8, -1,
    CL_COMMON,
    0, CLVC_BOOLEAN, 0 },
  { "-A",
    "-A<question>=<answer>	Assert the <answer> to <question>.  Putting '-' before <question> disables the <answer> to <question>",
    N_OPTS, 1, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, CLVC_STRING, 0 },
  { "-C",
    "Do not discard comments",
    N_OPTS, 1, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-CC",
    "Do not discard comments in macro expansions",
    N_OPTS, 2, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-D",
    "-D<macro>[=<val>]	Define a <macro> with <val> as its value.  If just <macro> is given, <val> is taken to be 1",
    N_OPTS, 1, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, CLVC_STRING, 0 },
  { "-E",
    0,
    N_OPTS, 1, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_UNDOCUMENTED,
    0, CLVC_BOOLEAN, 0 },
  { "-F",
    "-F <dir>	Add <dir> to the end of the main framework include path",
    N_OPTS, 1, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, CLVC_STRING, 0 },
  { "-G",
    "-G<number>	Put global and static data smaller than <number> bytes into a special section (on some targets)",
    N_OPTS, 1, -1,
    CL_COMMON | CL_JOINED | CL_SEPARATE | CL_UINTEGER,
    0, CLVC_BOOLEAN, 0 },
  { "-H",
    "Print the name of header files as they are used",
    N_OPTS, 1, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-I",
    "-I <dir>	Add <dir> to the end of the main include path",
    N_OPTS, 1, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, CLVC_STRING, 0 },
  { "-M",
    "Generate make dependencies",
    N_OPTS, 1, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-MD",
    "Generate make dependencies and compile",
    N_OPTS, 2, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_SEPARATE,
    0, CLVC_BOOLEAN, 0 },
  { "-MF",
    "-MF <file>	Write dependency output to the given file",
    N_OPTS, 2, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, CLVC_STRING, 0 },
  { "-MG",
    "Treat missing header files as generated files",
    N_OPTS, 2, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-MM",
    "Like -M but ignore system header files",
    N_OPTS, 2, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-MMD",
    "Like -MD but ignore system header files",
    N_OPTS, 3, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_SEPARATE,
    0, CLVC_BOOLEAN, 0 },
  { "-MP",
    "Generate phony targets for all headers",
    N_OPTS, 2, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-MQ",
    "-MQ <target>	Add a MAKE-quoted target",
    N_OPTS, 2, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, CLVC_STRING, 0 },
  { "-MT",
    "-MT <target>	Add an unquoted target",
    N_OPTS, 2, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, CLVC_STRING, 0 },
  { "-O",
    "-O<number>	Set optimization level to <number>",
    N_OPTS, 1, -1,
    CL_COMMON | CL_JOINED | CL_MISSING_OK | CL_OPTIMIZATION,
    0, CLVC_STRING, 0 },
  { "-Os",
    "Optimize for space rather than speed",
    OPT_O, 2, -1,
    CL_COMMON | CL_OPTIMIZATION,
    0, CLVC_BOOLEAN, 0 },
  { "-P",
    "Do not generate #line directives",
    N_OPTS, 1, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-U",
    "-U<macro>	Undefine <macro>",
    N_OPTS, 1, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, CLVC_STRING, 0 },
  { "-W",
    "This switch is deprecated; use -Wextra instead",
    N_OPTS, 1, -1,
    CL_COMMON | CL_REJECT_NEGATIVE,
    0, CLVC_BOOLEAN, 0 },
  { "-Wabi",
    "Warn about things that will change when compiling with an ABI-compliant compiler",
    N_OPTS, 4, 29,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_abi, CLVC_BOOLEAN, 0 },
  { "-Waddress",
    "Warn about suspicious uses of memory addresses",
    N_OPTS, 8, 30,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_address, CLVC_BOOLEAN, 0 },
  { "-Waggregate-return",
    "Warn about returning structures, unions or arrays",
    N_OPTS, 17, 31,
    CL_COMMON | CL_WARNING,
    &warn_aggregate_return, CLVC_BOOLEAN, 0 },
  { "-Wall",
    "Enable most warning messages",
    N_OPTS, 4, 32,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, CLVC_BOOLEAN, 0 },
  { "-Warray-bounds",
    "Warn if an array is accessed out of bounds",
    N_OPTS, 13, 33,
    CL_COMMON | CL_WARNING,
    &warn_array_bounds, CLVC_BOOLEAN, 0 },
  { "-Wassign-intercept",
    "Warn whenever an Objective-C assignment is being intercepted by the garbage collector",
    N_OPTS, 17, 34,
    CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_assign_intercept, CLVC_BOOLEAN, 0 },
  { "-Wattributes",
    "Warn about inappropriate attribute usage",
    N_OPTS, 11, 35,
    CL_COMMON | CL_WARNING,
    &warn_attributes, CLVC_BOOLEAN, 0 },
  { "-Wbad-function-cast",
    "Warn about casting functions to incompatible types",
    N_OPTS, 18, 36,
    CL_C | CL_ObjC | CL_WARNING,
    &warn_bad_function_cast, CLVC_BOOLEAN, 0 },
  { "-Wbuiltin-macro-redefined",
    "Warn when a built-in preprocessor macro is undefined or redefined",
    N_OPTS, 24, 37,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, CLVC_BOOLEAN, 0 },
  { "-Wc++-compat",
    "Warn about C constructs that are not in the common subset of C and C++",
    N_OPTS, 11, 38,
    CL_C | CL_ObjC | CL_WARNING,
    &warn_cxx_compat, CLVC_BOOLEAN, 0 },
  { "-Wc++0x-compat",
    "Warn about C++ constructs whose meaning differs between ISO C++ 1998 and ISO C++ 200x",
    N_OPTS, 13, 39,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    &warn_cxx0x_compat, CLVC_BOOLEAN, 0 },
  { "-Wcast-align",
    "Warn about pointer casts which increase alignment",
    N_OPTS, 11, 40,
    CL_COMMON | CL_WARNING,
    &warn_cast_align, CLVC_BOOLEAN, 0 },
  { "-Wcast-qual",
    "Warn about casts which discard qualifiers",
    N_OPTS, 10, 41,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_cast_qual, CLVC_BOOLEAN, 0 },
  { "-Wchar-subscripts",
    "Warn about subscripts whose type is \"char\"",
    N_OPTS, 16, 42,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_char_subscripts, CLVC_BOOLEAN, 0 },
  { "-Wclobbered",
    "Warn about variables that might be changed by \"longjmp\" or \"vfork\"",
    N_OPTS, 10, 43,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_clobbered, CLVC_BOOLEAN, 0 },
  { "-Wcomment",
    "Warn about possibly nested block comments, and C++ comments spanning more than one physical line",
    N_OPTS, 8, 44,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, CLVC_BOOLEAN, 0 },
  { "-Wcomments",
    "Synonym for -Wcomment",
    N_OPTS, 9, 45,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, CLVC_BOOLEAN, 0 },
  { "-Wconversion",
    "Warn for implicit type conversions that may change a value",
    N_OPTS, 11, 46,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_conversion, CLVC_BOOLEAN, 0 },
  { "-Wcoverage-mismatch",
    "Warn instead of error in case profiles in -fprofile-use do not match",
    N_OPTS, 18, -1,
    CL_COMMON | CL_REJECT_NEGATIVE | CL_WARNING,
    &warn_coverage_mismatch, CLVC_BOOLEAN, 0 },
  { "-Wctor-dtor-privacy",
    "Warn when all constructors and destructors are private",
    N_OPTS, 18, 48,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    &warn_ctor_dtor_privacy, CLVC_BOOLEAN, 0 },
  { "-Wdeclaration-after-statement",
    "Warn when a declaration is found after a statement",
    N_OPTS, 28, 49,
    CL_C | CL_ObjC | CL_WARNING,
    &warn_declaration_after_statement, CLVC_BOOLEAN, 0 },
  { "-Wdeprecated",
    "Warn if a deprecated compiler feature, class, method, or field is used",
    N_OPTS, 11, 50,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_deprecated, CLVC_BOOLEAN, 0 },
  { "-Wdeprecated-declarations",
    "Warn about uses of __attribute__((deprecated)) declarations",
    N_OPTS, 24, 51,
    CL_COMMON | CL_WARNING,
    &warn_deprecated_decl, CLVC_BOOLEAN, 0 },
  { "-Wdisabled-optimization",
    "Warn when an optimization pass is disabled",
    N_OPTS, 22, 52,
    CL_COMMON | CL_WARNING,
    &warn_disabled_optimization, CLVC_BOOLEAN, 0 },
  { "-Wdiv-by-zero",
    "Warn about compile-time integer division by zero",
    N_OPTS, 12, 53,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_div_by_zero, CLVC_BOOLEAN, 0 },
  { "-Weffc++",
    "Warn about violations of Effective C++ style rules",
    N_OPTS, 7, 54,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    &warn_ecpp, CLVC_BOOLEAN, 0 },
  { "-Wempty-body",
    "Warn about an empty body in an if or else statement",
    N_OPTS, 11, 55,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_empty_body, CLVC_BOOLEAN, 0 },
  { "-Wendif-labels",
    "Warn about stray tokens after #elif and #endif",
    N_OPTS, 13, 56,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, CLVC_BOOLEAN, 0 },
  { "-Wenum-compare",
    "Warn about comparison of different enum types",
    N_OPTS, 13, 57,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    &warn_enum_compare, CLVC_BOOLEAN, 0 },
  { "-Werror",
    "Treat all warnings as errors",
    N_OPTS, 6, 58,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_COMMON,
    &warnings_are_errors, CLVC_BOOLEAN, 0 },
  { "-Werror-implicit-function-declaration",
    "This switch is deprecated; use -Werror=implicit-function-declaration instead",
    N_OPTS, 36, -1,
    CL_C | CL_ObjC | CL_REJECT_NEGATIVE | CL_WARNING,
    0, CLVC_BOOLEAN, 0 },
  { "-Werror=",
    "Treat specified warning as error",
    N_OPTS, 7, 60,
    CL_COMMON | CL_JOINED,
    0, CLVC_STRING, 0 },
  { "-Wextra",
    "Print extra (possibly unwanted) warnings",
    N_OPTS, 6, 61,
    CL_COMMON | CL_WARNING,
    0, CLVC_BOOLEAN, 0 },
  { "-Wfatal-errors",
    "Exit on the first error occurred",
    N_OPTS, 13, 62,
    CL_COMMON,
    &flag_fatal_errors, CLVC_BOOLEAN, 0 },
  { "-Wfloat-equal",
    "Warn if testing floating point numbers for equality",
    N_OPTS, 12, 63,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_float_equal, CLVC_BOOLEAN, 0 },
  { "-Wformat",
    "Warn about printf/scanf/strftime/strfmon format string anomalies",
    N_OPTS, 7, 64,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, CLVC_BOOLEAN, 0 },
  { "-Wformat-contains-nul",
    "Warn about format strings that contain NUL bytes",
    N_OPTS, 20, 65,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_format_contains_nul, CLVC_BOOLEAN, 0 },
  { "-Wformat-extra-args",
    "Warn if passing too many arguments to a function for its format string",
    N_OPTS, 18, 66,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_format_extra_args, CLVC_BOOLEAN, 0 },
  { "-Wformat-nonliteral",
    "Warn about format strings that are not literals",
    N_OPTS, 18, 67,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_format_nonliteral, CLVC_BOOLEAN, 0 },
  { "-Wformat-security",
    "Warn about possible security problems with format functions",
    N_OPTS, 16, 68,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_format_security, CLVC_BOOLEAN, 0 },
  { "-Wformat-y2k",
    "Warn about strftime formats yielding 2-digit years",
    N_OPTS, 11, 69,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_format_y2k, CLVC_BOOLEAN, 0 },
  { "-Wformat-zero-length",
    "Warn about zero-length formats",
    N_OPTS, 19, 70,
    CL_C | CL_ObjC | CL_WARNING,
    &warn_format_zero_length, CLVC_BOOLEAN, 0 },
  { "-Wformat=",
    0,
    N_OPTS, 8, 71,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_WARNING,
    0, CLVC_STRING, 0 },
  { "-Wframe-larger-than=",
    "-Wframe-larger-than=<number> Warn if a function's stack frame requires more than <number> bytes",
    N_OPTS, 19, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE | CL_UINTEGER,
    0, CLVC_BOOLEAN, 0 },
  { "-Wignored-qualifiers",
    "Warn whenever type qualifiers are ignored.",
    N_OPTS, 19, 73,
    CL_C | CL_CXX | CL_WARNING,
    &warn_ignored_qualifiers, CLVC_BOOLEAN, 0 },
  { "-Wimplicit",
    0,
    N_OPTS, 9, 74,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, CLVC_BOOLEAN, 0 },
  { "-Wimplicit-function-declaration",
    "Warn about implicit function declarations",
    N_OPTS, 30, 75,
    CL_C | CL_ObjC | CL_WARNING,
    &warn_implicit_function_declaration, CLVC_BOOLEAN, 0 },
  { "-Wimplicit-int",
    "Warn when a declaration does not specify a type",
    N_OPTS, 13, 76,
    CL_C | CL_ObjC | CL_WARNING,
    &warn_implicit_int, CLVC_BOOLEAN, 0 },
  { "-Wimport",
    0,
    N_OPTS, 7, 77,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_UNDOCUMENTED,
    0, CLVC_BOOLEAN, 0 },
  { "-Winit-self",
    "Warn about variables which are initialized to themselves",
    N_OPTS, 10, 78,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_init_self, CLVC_BOOLEAN, 0 },
  { "-Winline",
    "Warn when an inlined function cannot be inlined",
    N_OPTS, 7, 79,
    CL_COMMON | CL_WARNING,
    &warn_inline, CLVC_BOOLEAN, 0 },
  { "-Wint-to-pointer-cast",
    "Warn when there is a cast to a pointer from an integer of a different size",
    N_OPTS, 20, 80,
    CL_C | CL_ObjC | CL_WARNING,
    &warn_int_to_pointer_cast, CLVC_BOOLEAN, 0 },
  { "-Winvalid-offsetof",
    "Warn about invalid uses of the \"offsetof\" macro",
    N_OPTS, 17, 81,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    &warn_invalid_offsetof, CLVC_BOOLEAN, 0 },
  { "-Winvalid-pch",
    "Warn about PCH files that are found but not used",
    N_OPTS, 12, 82,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, CLVC_BOOLEAN, 0 },
  { "-Wlarger-than-",
    0,
    N_OPTS, 13, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE | CL_UINTEGER | CL_WARNING,
    0, CLVC_BOOLEAN, 0 },
  { "-Wlarger-than=",
    "-Wlarger-than=<number>	Warn if an object is larger than <number> bytes",
    N_OPTS, 13, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE | CL_UINTEGER | CL_WARNING,
    0, CLVC_BOOLEAN, 0 },
  { "-Wlogical-op",
    "Warn when a logical operator is suspicously always evaluating to true or false",
    N_OPTS, 11, 85,
    CL_COMMON | CL_WARNING,
    &warn_logical_op, CLVC_BOOLEAN, 0 },
  { "-Wlong-long",
    "Do not warn about using \"long long\" when -pedantic",
    N_OPTS, 10, 86,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_long_long, CLVC_BOOLEAN, 0 },
  { "-Wmain",
    "Warn about suspicious declarations of \"main\"",
    N_OPTS, 5, 87,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_main, CLVC_BOOLEAN, 0 },
  { "-Wmissing-braces",
    "Warn about possibly missing braces around initializers",
    N_OPTS, 15, 88,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_missing_braces, CLVC_BOOLEAN, 0 },
  { "-Wmissing-declarations",
    "Warn about global functions without previous declarations",
    N_OPTS, 21, 89,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_missing_declarations, CLVC_BOOLEAN, 0 },
  { "-Wmissing-field-initializers",
    "Warn about missing fields in struct initializers",
    N_OPTS, 27, 90,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_missing_field_initializers, CLVC_BOOLEAN, 0 },
  { "-Wmissing-format-attribute",
    "Warn about functions which might be candidates for format attributes",
    N_OPTS, 25, 91,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_missing_format_attribute, CLVC_BOOLEAN, 0 },
  { "-Wmissing-include-dirs",
    "Warn about user-specified include directories that do not exist",
    N_OPTS, 21, 92,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, CLVC_BOOLEAN, 0 },
  { "-Wmissing-noreturn",
    "Warn about functions which might be candidates for __attribute__((noreturn))",
    N_OPTS, 17, 93,
    CL_COMMON | CL_WARNING,
    &warn_missing_noreturn, CLVC_BOOLEAN, 0 },
  { "-Wmissing-parameter-type",
    "Warn about function parameters declared without a type specifier in K&R-style functions",
    N_OPTS, 23, 94,
    CL_C | CL_ObjC | CL_WARNING,
    &warn_missing_parameter_type, CLVC_BOOLEAN, 0 },
  { "-Wmissing-prototypes",
    "Warn about global functions without prototypes",
    N_OPTS, 19, 95,
    CL_C | CL_ObjC | CL_WARNING,
    &warn_missing_prototypes, CLVC_BOOLEAN, 0 },
  { "-Wmudflap",
    "Warn about constructs not instrumented by -fmudflap",
    N_OPTS, 8, 96,
    CL_COMMON | CL_WARNING,
    &warn_mudflap, CLVC_BOOLEAN, 0 },
  { "-Wmultichar",
    "Warn about use of multi-character character constants",
    N_OPTS, 10, 97,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, CLVC_BOOLEAN, 0 },
  { "-Wnested-externs",
    "Warn about \"extern\" declarations not at file scope",
    N_OPTS, 15, 98,
    CL_C | CL_ObjC | CL_WARNING,
    &warn_nested_externs, CLVC_BOOLEAN, 0 },
  { "-Wnon-template-friend",
    "Warn when non-templatized friend functions are declared within a template",
    N_OPTS, 20, 99,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    &warn_nontemplate_friend, CLVC_BOOLEAN, 0 },
  { "-Wnon-virtual-dtor",
    "Warn about non-virtual destructors",
    N_OPTS, 17, 100,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    &warn_nonvdtor, CLVC_BOOLEAN, 0 },
  { "-Wnonnull",
    "Warn about NULL being passed to argument slots marked as requiring non-NULL",
    N_OPTS, 8, 101,
    CL_C | CL_ObjC | CL_WARNING,
    &warn_nonnull, CLVC_BOOLEAN, 0 },
  { "-Wnormalized=",
    "-Wnormalized=<id|nfc|nfkc>	Warn about non-normalised Unicode strings",
    N_OPTS, 12, 102,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_WARNING,
    0, CLVC_STRING, 0 },
  { "-Wold-style-cast",
    "Warn if a C-style cast is used in a program",
    N_OPTS, 15, 103,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    &warn_old_style_cast, CLVC_BOOLEAN, 0 },
  { "-Wold-style-declaration",
    "Warn for obsolescent usage in a declaration",
    N_OPTS, 22, 104,
    CL_C | CL_ObjC | CL_WARNING,
    &warn_old_style_declaration, CLVC_BOOLEAN, 0 },
  { "-Wold-style-definition",
    "Warn if an old-style parameter definition is used",
    N_OPTS, 21, 105,
    CL_C | CL_ObjC | CL_WARNING,
    &warn_old_style_definition, CLVC_BOOLEAN, 0 },
  { "-Woverflow",
    "Warn about overflow in arithmetic expressions",
    N_OPTS, 9, 106,
    CL_COMMON | CL_WARNING,
    &warn_overflow, CLVC_BOOLEAN, 0 },
  { "-Woverlength-strings",
    "Warn if a string is longer than the maximum portable length specified by the standard",
    N_OPTS, 19, 107,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_overlength_strings, CLVC_BOOLEAN, 0 },
  { "-Woverloaded-virtual",
    "Warn about overloaded virtual function names",
    N_OPTS, 19, 108,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    &warn_overloaded_virtual, CLVC_BOOLEAN, 0 },
  { "-Woverride-init",
    "Warn about overriding initializers without side effects",
    N_OPTS, 14, 109,
    CL_C | CL_ObjC | CL_WARNING,
    &warn_override_init, CLVC_BOOLEAN, 0 },
  { "-Wpacked",
    "Warn when the packed attribute has no effect on struct layout",
    N_OPTS, 7, 110,
    CL_COMMON | CL_WARNING,
    &warn_packed, CLVC_BOOLEAN, 0 },
  { "-Wpacked-bitfield-compat",
    "Warn about packed bit-fields whose offset changed in GCC 4.4",
    N_OPTS, 23, 111,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_packed_bitfield_compat, CLVC_BOOLEAN, 0 },
  { "-Wpadded",
    "Warn when padding is required to align structure members",
    N_OPTS, 7, 112,
    CL_COMMON | CL_WARNING,
    &warn_padded, CLVC_BOOLEAN, 0 },
  { "-Wparentheses",
    "Warn about possibly missing parentheses",
    N_OPTS, 12, 113,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_parentheses, CLVC_BOOLEAN, 0 },
  { "-Wpmf-conversions",
    "Warn when converting the type of pointers to member functions",
    N_OPTS, 16, 114,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    &warn_pmf2ptr, CLVC_BOOLEAN, 0 },
  { "-Wpointer-arith",
    "Warn about function pointer arithmetic",
    N_OPTS, 14, 115,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_pointer_arith, CLVC_BOOLEAN, 0 },
  { "-Wpointer-sign",
    "Warn when a pointer differs in signedness in an assignment",
    N_OPTS, 13, 116,
    CL_C | CL_ObjC | CL_WARNING,
    &warn_pointer_sign, CLVC_BOOLEAN, 0 },
  { "-Wpointer-to-int-cast",
    "Warn when a pointer is cast to an integer of a different size",
    N_OPTS, 20, 117,
    CL_C | CL_ObjC | CL_WARNING,
    &warn_pointer_to_int_cast, CLVC_BOOLEAN, 0 },
  { "-Wpragmas",
    "Warn about misuses of pragmas",
    N_OPTS, 8, 118,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_pragmas, CLVC_BOOLEAN, 0 },
  { "-Wprotocol",
    "Warn if inherited methods are unimplemented",
    N_OPTS, 9, 119,
    CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_protocol, CLVC_BOOLEAN, 0 },
  { "-Wpsabi",
    0,
    N_OPTS, 6, 120,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_UNDOCUMENTED,
    &warn_psabi, CLVC_BOOLEAN, 0 },
  { "-Wredundant-decls",
    "Warn about multiple declarations of the same object",
    N_OPTS, 16, 121,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_redundant_decls, CLVC_BOOLEAN, 0 },
  { "-Wreorder",
    "Warn when the compiler reorders code",
    N_OPTS, 8, 122,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    &warn_reorder, CLVC_BOOLEAN, 0 },
  { "-Wreturn-type",
    "Warn whenever a function's return type defaults to \"int\" (C), or about inconsistent return types (C++)",
    N_OPTS, 12, 123,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_return_type, CLVC_BOOLEAN, 0 },
  { "-Wselector",
    "Warn if a selector has multiple methods",
    N_OPTS, 9, 124,
    CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_selector, CLVC_BOOLEAN, 0 },
  { "-Wsequence-point",
    "Warn about possible violations of sequence point rules",
    N_OPTS, 15, 125,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_sequence_point, CLVC_BOOLEAN, 0 },
  { "-Wshadow",
    "Warn when one local variable shadows another",
    N_OPTS, 7, 126,
    CL_COMMON | CL_WARNING,
    &warn_shadow, CLVC_BOOLEAN, 0 },
  { "-Wsign-compare",
    "Warn about signed-unsigned comparisons",
    N_OPTS, 13, 127,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_sign_compare, CLVC_BOOLEAN, 0 },
  { "-Wsign-conversion",
    "Warn for implicit type conversions between signed and unsigned integers",
    N_OPTS, 16, 128,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    &warn_sign_conversion, CLVC_BOOLEAN, 0 },
  { "-Wsign-promo",
    "Warn when overload promotes from unsigned to signed",
    N_OPTS, 11, 129,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    &warn_sign_promo, CLVC_BOOLEAN, 0 },
  { "-Wstack-protector",
    "Warn when not issuing stack smashing protection for some reason",
    N_OPTS, 16, 130,
    CL_COMMON | CL_WARNING,
    &warn_stack_protect, CLVC_BOOLEAN, 0 },
  { "-Wstrict-aliasing",
    "Warn about code which might break strict aliasing rules",
    N_OPTS, 16, 131,
    CL_COMMON | CL_WARNING,
    0, CLVC_BOOLEAN, 0 },
  { "-Wstrict-aliasing=",
    "Warn about code which might break strict aliasing rules",
    N_OPTS, 17, 132,
    CL_COMMON | CL_JOINED | CL_UINTEGER | CL_WARNING,
    &warn_strict_aliasing, CLVC_BOOLEAN, 0 },
  { "-Wstrict-null-sentinel",
    "Warn about uncasted NULL used as sentinel",
    N_OPTS, 21, 133,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, CLVC_BOOLEAN, 0 },
  { "-Wstrict-overflow",
    "Warn about optimizations that assume that signed overflow is undefined",
    N_OPTS, 16, 134,
    CL_COMMON | CL_WARNING,
    0, CLVC_BOOLEAN, 0 },
  { "-Wstrict-overflow=",
    "Warn about optimizations that assume that signed overflow is undefined",
    N_OPTS, 17, 135,
    CL_COMMON | CL_JOINED | CL_UINTEGER | CL_WARNING,
    &warn_strict_overflow, CLVC_BOOLEAN, 0 },
  { "-Wstrict-prototypes",
    "Warn about unprototyped function declarations",
    N_OPTS, 18, 136,
    CL_C | CL_ObjC | CL_WARNING,
    &warn_strict_prototypes, CLVC_BOOLEAN, 0 },
  { "-Wstrict-selector-match",
    "Warn if type signatures of candidate methods do not match exactly",
    N_OPTS, 22, 137,
    CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_strict_selector_match, CLVC_BOOLEAN, 0 },
  { "-Wswitch",
    "Warn about enumerated switches, with no default, missing a case",
    N_OPTS, 7, 138,
    CL_COMMON | CL_WARNING,
    &warn_switch, CLVC_BOOLEAN, 0 },
  { "-Wswitch-default",
    "Warn about enumerated switches missing a \"default:\" statement",
    N_OPTS, 15, 139,
    CL_COMMON | CL_WARNING,
    &warn_switch_default, CLVC_BOOLEAN, 0 },
  { "-Wswitch-enum",
    "Warn about all enumerated switches missing a specific case",
    N_OPTS, 12, 140,
    CL_COMMON | CL_WARNING,
    &warn_switch_enum, CLVC_BOOLEAN, 0 },
  { "-Wsync-nand",
    "Warn when __sync_fetch_and_nand and __sync_nand_and_fetch built-in functions are used",
    N_OPTS, 10, 141,
    CL_C | CL_CXX | CL_WARNING,
    &warn_sync_nand, CLVC_BOOLEAN, 0 },
  { "-Wsynth",
    "Deprecated.  This switch has no effect",
    N_OPTS, 6, 142,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    &warn_synth, CLVC_BOOLEAN, 0 },
  { "-Wsystem-headers",
    "Do not suppress warnings from system headers",
    N_OPTS, 15, 143,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_WARNING,
    &warn_system_headers, CLVC_BOOLEAN, 0 },
  { "-Wtraditional",
    "Warn about features not present in traditional C",
    N_OPTS, 12, 144,
    CL_C | CL_ObjC | CL_WARNING,
    &warn_traditional, CLVC_BOOLEAN, 0 },
  { "-Wtraditional-conversion",
    "Warn of prototypes causing type conversions different from what would happen in the absence of prototype",
    N_OPTS, 23, 145,
    CL_C | CL_ObjC | CL_WARNING,
    &warn_traditional_conversion, CLVC_BOOLEAN, 0 },
  { "-Wtrigraphs",
    "Warn if trigraphs are encountered that might affect the meaning of the program",
    N_OPTS, 10, 146,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, CLVC_BOOLEAN, 0 },
  { "-Wtype-limits",
    "Warn if a comparison is always true or always false due to the limited range of the data type",
    N_OPTS, 12, 147,
    CL_COMMON | CL_WARNING,
    &warn_type_limits, CLVC_BOOLEAN, 0 },
  { "-Wundeclared-selector",
    "Warn about @selector()s without previously declared methods",
    N_OPTS, 20, 148,
    CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_undeclared_selector, CLVC_BOOLEAN, 0 },
  { "-Wundef",
    "Warn if an undefined macro is used in an #if directive",
    N_OPTS, 6, 149,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, CLVC_BOOLEAN, 0 },
  { "-Wuninitialized",
    "Warn about uninitialized automatic variables",
    N_OPTS, 14, 150,
    CL_COMMON | CL_WARNING,
    &warn_uninitialized, CLVC_BOOLEAN, 0 },
  { "-Wunknown-pragmas",
    "Warn about unrecognized pragmas",
    N_OPTS, 16, 151,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, CLVC_BOOLEAN, 0 },
  { "-Wunreachable-code",
    "Warn about code that will never be executed",
    N_OPTS, 17, 152,
    CL_COMMON | CL_WARNING,
    &warn_notreached, CLVC_BOOLEAN, 0 },
  { "-Wunsafe-loop-optimizations",
    "Warn if the loop cannot be optimized due to nontrivial assumptions.",
    N_OPTS, 26, 153,
    CL_COMMON | CL_WARNING,
    &warn_unsafe_loop_optimizations, CLVC_BOOLEAN, 0 },
  { "-Wunused",
    "Enable all -Wunused- warnings",
    N_OPTS, 7, 154,
    CL_COMMON | CL_WARNING,
    &warn_unused, CLVC_BOOLEAN, 0 },
  { "-Wunused-function",
    "Warn when a function is unused",
    N_OPTS, 16, 155,
    CL_COMMON | CL_WARNING,
    &warn_unused_function, CLVC_BOOLEAN, 0 },
  { "-Wunused-label",
    "Warn when a label is unused",
    N_OPTS, 13, 156,
    CL_COMMON | CL_WARNING,
    &warn_unused_label, CLVC_BOOLEAN, 0 },
  { "-Wunused-macros",
    "Warn about macros defined in the main file that are not used",
    N_OPTS, 14, 157,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, CLVC_BOOLEAN, 0 },
  { "-Wunused-parameter",
    "Warn when a function parameter is unused",
    N_OPTS, 17, 158,
    CL_COMMON | CL_WARNING,
    &warn_unused_parameter, CLVC_BOOLEAN, 0 },
  { "-Wunused-value",
    "Warn when an expression value is unused",
    N_OPTS, 13, 159,
    CL_COMMON | CL_WARNING,
    &warn_unused_value, CLVC_BOOLEAN, 0 },
  { "-Wunused-variable",
    "Warn when a variable is unused",
    N_OPTS, 16, 160,
    CL_COMMON | CL_WARNING,
    &warn_unused_variable, CLVC_BOOLEAN, 0 },
  { "-Wvariadic-macros",
    "Do not warn about using variadic macros when -pedantic",
    N_OPTS, 16, 161,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, CLVC_BOOLEAN, 0 },
  { "-Wvla",
    "Warn if a variable length array is used",
    N_OPTS, 4, 162,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_vla, CLVC_BOOLEAN, 0 },
  { "-Wvolatile-register-var",
    "Warn when a register variable is declared volatile",
    N_OPTS, 22, 163,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_volatile_register_var, CLVC_BOOLEAN, 0 },
  { "-Wwrite-strings",
    "In C++, nonzero means warn about deprecated conversion from string literals to `char *'.  In C, similar warning, except that the conversion is of course not deprecated by the ISO C standard.",
    N_OPTS, 14, 164,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    &warn_write_strings, CLVC_BOOLEAN, 0 },
  { "-ansi",
    "A synonym for -std=c89 (for C) or -std=c++98 (for C++)",
    N_OPTS, 4, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-aux-info",
    "-aux-info <file>	Emit declaration information into <file>",
    N_OPTS, 8, -1,
    CL_COMMON | CL_SEPARATE,
    0, CLVC_BOOLEAN, 0 },
  { "-aux-info=",
    0,
    N_OPTS, 9, -1,
    CL_COMMON | CL_JOINED,
    0, CLVC_STRING, 0 },
  { "-auxbase",
    0,
    N_OPTS, 7, -1,
    CL_COMMON | CL_SEPARATE,
    0, CLVC_BOOLEAN, 0 },
  { "-auxbase-strip",
    0,
    N_OPTS, 13, -1,
    CL_COMMON | CL_SEPARATE,
    0, CLVC_BOOLEAN, 0 },
  { "-d",
    "-d<letters>	Enable dumps from specific passes of the compiler",
    N_OPTS, 1, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_JOINED,
    0, CLVC_STRING, 0 },
  { "-dumpbase",
    "-dumpbase <file>	Set the file basename to be used for dumps",
    OPT_d, 8, -1,
    CL_COMMON | CL_SEPARATE,
    0, CLVC_BOOLEAN, 0 },
  { "-fPIC",
    "Generate position-independent code if possible (large mode)",
    N_OPTS, 4, 172,
    CL_COMMON | CL_REPORT,
    &flag_pic, CLVC_EQUAL, 2 },
  { "-fPIE",
    "Generate position-independent code for executables if possible (large mode)",
    N_OPTS, 4, 173,
    CL_COMMON | CL_REPORT,
    &flag_pie, CLVC_EQUAL, 2 },
  { "-fabi-version=",
    0,
    N_OPTS, 13, 174,
    CL_COMMON | CL_JOINED | CL_UINTEGER,
    &flag_abi_version, CLVC_BOOLEAN, 0 },
  { "-faccess-control",
    "Enforce class member access control semantics",
    N_OPTS, 15, 175,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-falign-functions",
    "Align the start of functions",
    N_OPTS, 16, 176,
    CL_COMMON | CL_UINTEGER | CL_OPTIMIZATION | CL_REPORT,
    &align_functions, CLVC_EQUAL, 0 },
  { "-falign-functions=",
    0,
    N_OPTS, 17, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE | CL_UINTEGER,
    0, CLVC_BOOLEAN, 0 },
  { "-falign-jumps",
    "Align labels which are only reached by jumping",
    N_OPTS, 12, 178,
    CL_COMMON | CL_UINTEGER | CL_OPTIMIZATION | CL_REPORT,
    &align_jumps, CLVC_EQUAL, 0 },
  { "-falign-jumps=",
    0,
    N_OPTS, 13, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE | CL_UINTEGER,
    0, CLVC_BOOLEAN, 0 },
  { "-falign-labels",
    "Align all labels",
    N_OPTS, 13, 180,
    CL_COMMON | CL_UINTEGER | CL_OPTIMIZATION | CL_REPORT,
    &align_labels, CLVC_EQUAL, 0 },
  { "-falign-labels=",
    0,
    N_OPTS, 14, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE | CL_UINTEGER,
    0, CLVC_BOOLEAN, 0 },
  { "-falign-loops",
    "Align the start of loops",
    N_OPTS, 12, 182,
    CL_COMMON | CL_UINTEGER | CL_OPTIMIZATION | CL_REPORT,
    &align_loops, CLVC_BOOLEAN, 0 },
  { "-falign-loops=",
    0,
    N_OPTS, 13, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE | CL_UINTEGER,
    0, CLVC_BOOLEAN, 0 },
  { "-fall-virtual",
    0,
    N_OPTS, 12, 184,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-falt-external-templates",
    "Change when template instances are emitted",
    N_OPTS, 23, 185,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fargument-alias",
    "Specify that arguments may alias each other and globals",
    N_OPTS, 15, 186,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_argument_noalias, CLVC_EQUAL, 0 },
  { "-fargument-noalias",
    "Assume arguments may alias globals but not each other",
    N_OPTS, 17, 187,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_argument_noalias, CLVC_EQUAL, 1 },
  { "-fargument-noalias-anything",
    "Assume arguments alias no other storage",
    N_OPTS, 26, 188,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_argument_noalias, CLVC_EQUAL, 3 },
  { "-fargument-noalias-global",
    "Assume arguments alias neither each other nor globals",
    N_OPTS, 24, 189,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_argument_noalias, CLVC_EQUAL, 2 },
  { "-fasm",
    "Recognize the \"asm\" keyword",
    N_OPTS, 4, 190,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fassociative-math",
    "Allow optimization for floating-point arithmetic which may change the result of the operation due to rounding.",
    N_OPTS, 17, 191,
    CL_COMMON | CL_REPORT,
    &flag_associative_math, CLVC_BOOLEAN, 0 },
  { "-fasynchronous-unwind-tables",
    "Generate unwind tables that are exact at each instruction boundary",
    N_OPTS, 27, 192,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_asynchronous_unwind_tables, CLVC_BOOLEAN, 0 },
  { "-fauto-inc-dec",
    "Generate auto-inc/dec instructions",
    N_OPTS, 13, 193,
    CL_COMMON | CL_REPORT,
    &flag_auto_inc_dec, CLVC_BOOLEAN, 0 },
  { "-fbounds-check",
    "Generate code to check bounds before indexing arrays",
    N_OPTS, 13, 194,
    CL_COMMON | CL_REPORT,
    &flag_bounds_check, CLVC_BOOLEAN, 0 },
  { "-fbranch-count-reg",
    "Replace add, compare, branch with branch on count register",
    N_OPTS, 17, 195,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_branch_on_count_reg, CLVC_BOOLEAN, 0 },
  { "-fbranch-probabilities",
    "Use profiling information for branch probabilities",
    N_OPTS, 21, 196,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_branch_probabilities, CLVC_BOOLEAN, 0 },
  { "-fbranch-target-load-optimize",
    "Perform branch target load optimization before prologue / epilogue threading",
    N_OPTS, 28, 197,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_branch_target_load_optimize, CLVC_BOOLEAN, 0 },
  { "-fbranch-target-load-optimize2",
    "Perform branch target load optimization after prologue / epilogue threading",
    N_OPTS, 29, 198,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_branch_target_load_optimize2, CLVC_BOOLEAN, 0 },
  { "-fbtr-bb-exclusive",
    "Restrict target load migration not to re-use registers in any basic block",
    N_OPTS, 17, 199,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_btr_bb_exclusive, CLVC_BOOLEAN, 0 },
  { "-fbuiltin",
    "Recognize built-in functions",
    N_OPTS, 8, 200,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fbuiltin-",
    0,
    N_OPTS, 9, 201,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, CLVC_STRING, 0 },
  { "-fcall-saved-",
    "-fcall-saved-<register>	Mark <register> as being preserved across functions",
    N_OPTS, 12, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE,
    0, CLVC_STRING, 0 },
  { "-fcall-used-",
    "-fcall-used-<register>	Mark <register> as being corrupted by function calls",
    N_OPTS, 11, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE,
    0, CLVC_STRING, 0 },
  { "-fcaller-saves",
    "Save registers around function calls",
    N_OPTS, 13, 204,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_caller_saves, CLVC_BOOLEAN, 0 },
  { "-fcheck-data-deps",
    "Compare the results of several data dependence analyzers.",
    N_OPTS, 16, 205,
    CL_COMMON | CL_REPORT,
    &flag_check_data_deps, CLVC_BOOLEAN, 0 },
  { "-fcheck-new",
    "Check the return value of new",
    N_OPTS, 10, 206,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fcommon",
    "Do not put uninitialized globals in the common section",
    N_OPTS, 7, 207,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_no_common, CLVC_EQUAL, 0 },
  { "-fcond-mismatch",
    "Allow the arguments of the '?' operator to have different types",
    N_OPTS, 14, 208,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fconserve-space",
    "Reduce the size of object files",
    N_OPTS, 15, 209,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fconserve-stack",
    "Do not perform optimizations increasing noticeably stack usage",
    N_OPTS, 15, 210,
    CL_COMMON | CL_OPTIMIZATION,
    &flag_conserve_stack, CLVC_BOOLEAN, 0 },
  { "-fconstant-string-class=",
    "-fconst-string-class=<name>	Use class <name> for constant strings",
    N_OPTS, 23, 211,
    CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, CLVC_STRING, 0 },
  { "-fcprop-registers",
    "Perform a register copy-propagation optimization pass",
    N_OPTS, 16, 212,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_cprop_registers, CLVC_BOOLEAN, 0 },
  { "-fcrossjumping",
    "Perform cross-jumping optimization",
    N_OPTS, 13, 213,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_crossjumping, CLVC_BOOLEAN, 0 },
  { "-fcse-follow-jumps",
    "When running CSE, follow jumps to their targets",
    N_OPTS, 17, 214,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_cse_follow_jumps, CLVC_BOOLEAN, 0 },
  { "-fcse-skip-blocks",
    "When running CSE, follow conditional jumps",
    N_OPTS, 16, 215,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_cse_skip_blocks, CLVC_BOOLEAN, 0 },
  { "-fcx-fortran-rules",
    "Complex multiplication and division follow Fortran rules",
    N_OPTS, 17, 216,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_cx_fortran_rules, CLVC_BOOLEAN, 0 },
  { "-fcx-limited-range",
    "Omit range reduction step when performing complex division",
    N_OPTS, 17, 217,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_cx_limited_range, CLVC_BOOLEAN, 0 },
  { "-fdata-sections",
    "Place data items into their own section",
    N_OPTS, 14, 218,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_data_sections, CLVC_BOOLEAN, 0 },
  { "-fdbg-cnt-list",
    "List all available debugging counters with their limits and counts.",
    N_OPTS, 13, 219,
    CL_COMMON | CL_REPORT,
    0, CLVC_BOOLEAN, 0 },
  { "-fdbg-cnt=",
    "-fdbg-cnt=<counter>:<limit>[,<counter>:<limit>,...]    Set the debug counter limit.   ",
    N_OPTS, 9, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE,
    0, CLVC_STRING, 0 },
  { "-fdce",
    "Use the RTL dead code elimination pass",
    N_OPTS, 4, 221,
    CL_COMMON | CL_OPTIMIZATION,
    &flag_dce, CLVC_BOOLEAN, 0 },
  { "-fdebug-prefix-map=",
    "Map one directory name to another in debug information",
    N_OPTS, 18, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE,
    0, CLVC_STRING, 0 },
  { "-fdefault-inline",
    "Inline member functions by default",
    N_OPTS, 15, 223,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fdefer-pop",
    "Defer popping functions args from stack until later",
    N_OPTS, 10, 224,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_defer_pop, CLVC_BOOLEAN, 0 },
  { "-fdelayed-branch",
    "Attempt to fill delay slots of branch instructions",
    N_OPTS, 15, 225,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_delayed_branch, CLVC_BOOLEAN, 0 },
  { "-fdelete-null-pointer-checks",
    "Delete useless null pointer checks",
    N_OPTS, 27, 226,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_delete_null_pointer_checks, CLVC_BOOLEAN, 0 },
  { "-fdiagnostics-show-location=",
    "-fdiagnostics-show-location=[once|every-line]	How often to emit source location at the beginning of line-wrapped diagnostics",
    N_OPTS, 27, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE,
    0, CLVC_STRING, 0 },
  { "-fdiagnostics-show-option",
    "Amend appropriate diagnostic messages with the command line option that controls them",
    N_OPTS, 24, 228,
    CL_COMMON,
    0, CLVC_BOOLEAN, 0 },
  { "-fdirectives-only",
    "Preprocess directives only.",
    N_OPTS, 16, 229,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fdollars-in-identifiers",
    "Permit '$' as an identifier character",
    N_OPTS, 23, 230,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fdse",
    "Use the RTL dead store elimination pass",
    N_OPTS, 4, 231,
    CL_COMMON | CL_OPTIMIZATION,
    &flag_dse, CLVC_BOOLEAN, 0 },
  { "-fdump-",
    "-fdump-<type>	Dump various compiler internals to a file",
    N_OPTS, 6, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE,
    0, CLVC_STRING, 0 },
  { "-fdump-noaddr",
    "Suppress output of addresses in debugging dumps",
    OPT_fdump_, 12, 233,
    CL_COMMON | CL_REPORT,
    &flag_dump_noaddr, CLVC_BOOLEAN, 0 },
  { "-fdump-unnumbered",
    "Suppress output of instruction numbers, line number notes and addresses in debugging dumps",
    OPT_fdump_, 16, 234,
    CL_COMMON | CL_REPORT,
    &flag_dump_unnumbered, CLVC_BOOLEAN, 0 },
  { "-fdwarf2-cfi-asm",
    "Enable CFI tables via GAS assembler directives.",
    N_OPTS, 15, 235,
    CL_COMMON | CL_REPORT,
    &flag_dwarf2_cfi_asm, CLVC_BOOLEAN, 0 },
  { "-fearly-inlining",
    "Perform early inlining",
    N_OPTS, 15, 236,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_early_inlining, CLVC_BOOLEAN, 0 },
  { "-felide-constructors",
    0,
    N_OPTS, 19, 237,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-feliminate-dwarf2-dups",
    "Perform DWARF2 duplicate elimination",
    N_OPTS, 22, 238,
    CL_COMMON | CL_REPORT,
    &flag_eliminate_dwarf2_dups, CLVC_BOOLEAN, 0 },
  { "-feliminate-unused-debug-symbols",
    "Perform unused type elimination in debug info",
    N_OPTS, 31, 239,
    CL_COMMON | CL_REPORT,
    &flag_debug_only_used_symbols, CLVC_BOOLEAN, 0 },
  { "-feliminate-unused-debug-types",
    "Perform unused type elimination in debug info",
    N_OPTS, 29, 240,
    CL_COMMON | CL_REPORT,
    &flag_eliminate_unused_debug_types, CLVC_BOOLEAN, 0 },
  { "-femit-class-debug-always",
    "Do not suppress C++ class debug information.",
    N_OPTS, 24, 241,
    CL_COMMON | CL_REPORT,
    &flag_emit_class_debug_always, CLVC_BOOLEAN, 0 },
  { "-femit-struct-debug-baseonly",
    "-femit-struct-debug-baseonly	Aggressive reduced debug info for structs",
    N_OPTS, 27, 242,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-femit-struct-debug-detailed=",
    "-femit-struct-debug-detailed=<spec-list>	Detailed reduced debug info for structs",
    N_OPTS, 28, 243,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, CLVC_STRING, 0 },
  { "-femit-struct-debug-reduced",
    "-femit-struct-debug-reduced	Conservative reduced debug info for structs",
    N_OPTS, 26, 244,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fenforce-eh-specs",
    "Generate code to check exception specifications",
    N_OPTS, 17, 245,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fenum-int-equiv",
    0,
    N_OPTS, 15, 246,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fexceptions",
    "Enable exception handling",
    N_OPTS, 11, 247,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_exceptions, CLVC_BOOLEAN, 0 },
  { "-fexec-charset=",
    "-fexec-charset=<cset>	Convert all strings and character constants to character set <cset>",
    N_OPTS, 14, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_REJECT_NEGATIVE,
    0, CLVC_STRING, 0 },
  { "-fexpensive-optimizations",
    "Perform a number of minor, expensive optimizations",
    N_OPTS, 24, 249,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_expensive_optimizations, CLVC_BOOLEAN, 0 },
  { "-fextended-identifiers",
    "Permit universal character names (\\u and \\U) in identifiers",
    N_OPTS, 21, 250,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fexternal-templates",
    0,
    N_OPTS, 19, 251,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-ffast-math",
    0,
    N_OPTS, 10, 252,
    CL_COMMON,
    0, CLVC_BOOLEAN, 0 },
  { "-ffinite-math-only",
    "Assume no NaNs or infinities are generated",
    N_OPTS, 17, 253,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_finite_math_only, CLVC_BOOLEAN, 0 },
  { "-ffixed-",
    "-ffixed-<register>	Mark <register> as being unavailable to the compiler",
    N_OPTS, 7, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE,
    0, CLVC_STRING, 0 },
  { "-ffloat-store",
    "Don't allocate floats and doubles in extended-precision registers",
    N_OPTS, 12, 255,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_float_store, CLVC_BOOLEAN, 0 },
  { "-ffor-scope",
    "Scope of for-init-statement variables is local to the loop",
    N_OPTS, 10, 256,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fforce-addr",
    "Does nothing.  Preserved for backward compatibility.",
    N_OPTS, 11, 257,
    CL_COMMON,
    0, CLVC_BOOLEAN, 0 },
  { "-fforward-propagate",
    "Perform a forward propagation pass on RTL",
    N_OPTS, 18, 258,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_forward_propagate, CLVC_BOOLEAN, 0 },
  { "-ffreestanding",
    "Do not assume that standard C libraries and \"main\" exist",
    N_OPTS, 13, 259,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-ffriend-injection",
    "Inject friend functions into enclosing namespace",
    N_OPTS, 17, 260,
    CL_CXX | CL_ObjCXX,
    &flag_friend_injection, CLVC_BOOLEAN, 0 },
  { "-ffunction-cse",
    "Allow function addresses to be held in registers",
    N_OPTS, 13, 261,
    CL_COMMON | CL_REPORT,
    &flag_no_function_cse, CLVC_EQUAL, 0 },
  { "-ffunction-sections",
    "Place each function into its own section",
    N_OPTS, 18, 262,
    CL_COMMON | CL_REPORT,
    &flag_function_sections, CLVC_BOOLEAN, 0 },
  { "-fgcse",
    "Perform global common subexpression elimination",
    N_OPTS, 5, 263,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_gcse, CLVC_BOOLEAN, 0 },
  { "-fgcse-after-reload",
    "Perform global common subexpression elimination after register allocation has finished",
    N_OPTS, 18, 264,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_gcse_after_reload, CLVC_BOOLEAN, 0 },
  { "-fgcse-las",
    "Perform redundant load after store elimination in global common subexpression elimination",
    N_OPTS, 9, 265,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_gcse_las, CLVC_BOOLEAN, 0 },
  { "-fgcse-lm",
    "Perform enhanced load motion during global common subexpression elimination",
    N_OPTS, 8, 266,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_gcse_lm, CLVC_BOOLEAN, 0 },
  { "-fgcse-sm",
    "Perform store motion after global common subexpression elimination",
    N_OPTS, 8, 267,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_gcse_sm, CLVC_BOOLEAN, 0 },
  { "-fgnu-keywords",
    "Recognize GNU-defined keywords",
    N_OPTS, 13, 268,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fgnu-runtime",
    "Generate code for GNU runtime environment",
    N_OPTS, 12, 269,
    CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fgnu89-inline",
    "Use traditional GNU semantics for inline functions",
    N_OPTS, 13, 270,
    CL_C | CL_ObjC,
    &flag_gnu89_inline, CLVC_BOOLEAN, 0 },
  { "-fgraphite",
    "Enable in and out of Graphite representation",
    N_OPTS, 9, 271,
    CL_COMMON | CL_REPORT,
    &flag_graphite, CLVC_BOOLEAN, 0 },
  { "-fgraphite-identity",
    "Enable Graphite Identity transformation",
    N_OPTS, 18, 272,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_graphite_identity, CLVC_BOOLEAN, 0 },
  { "-fguess-branch-probability",
    "Enable guessing of branch probabilities",
    N_OPTS, 25, 273,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_guess_branch_prob, CLVC_BOOLEAN, 0 },
  { "-fguiding-decls",
    0,
    N_OPTS, 14, 274,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fhandle-exceptions",
    0,
    N_OPTS, 18, 275,
    CL_CXX | CL_ObjCXX | CL_OPTIMIZATION,
    0, CLVC_BOOLEAN, 0 },
  { "-fhelp",
    0,
    N_OPTS, 5, 276,
    CL_COMMON,
    0, CLVC_BOOLEAN, 0 },
  { "-fhelp=",
    0,
    N_OPTS, 6, 277,
    CL_COMMON | CL_JOINED,
    0, CLVC_STRING, 0 },
  { "-fhonor-std",
    0,
    N_OPTS, 10, 278,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fhosted",
    "Assume normal C execution environment",
    N_OPTS, 7, 279,
    CL_C | CL_ObjC,
    0, CLVC_BOOLEAN, 0 },
  { "-fhuge-objects",
    "Enable support for huge objects",
    N_OPTS, 13, 280,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fident",
    "Process #ident directives",
    N_OPTS, 6, 281,
    CL_COMMON | CL_REPORT,
    &flag_no_ident, CLVC_EQUAL, 0 },
  { "-fif-conversion",
    "Perform conversion of conditional jumps to branchless equivalents",
    N_OPTS, 14, 282,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_if_conversion, CLVC_BOOLEAN, 0 },
  { "-fif-conversion2",
    "Perform conversion of conditional jumps to conditional execution",
    N_OPTS, 15, 283,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_if_conversion2, CLVC_BOOLEAN, 0 },
  { "-fimplement-inlines",
    "Export functions even if they can be inlined",
    N_OPTS, 18, 284,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fimplicit-inline-templates",
    "Emit implicit instantiations of inline templates",
    N_OPTS, 26, 285,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fimplicit-templates",
    "Emit implicit instantiations of templates",
    N_OPTS, 19, 286,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-findirect-inlining",
    "Perform indirect inlining",
    N_OPTS, 18, 287,
    CL_COMMON | CL_REPORT,
    &flag_indirect_inlining, CLVC_BOOLEAN, 0 },
  { "-finhibit-size-directive",
    "Do not generate .size directives",
    N_OPTS, 23, 288,
    CL_COMMON | CL_REPORT,
    &flag_inhibit_size_directive, CLVC_BOOLEAN, 0 },
  { "-finline",
    "Pay attention to the \"inline\" keyword",
    N_OPTS, 7, 289,
    CL_COMMON | CL_REPORT,
    &flag_no_inline, CLVC_EQUAL, 0 },
  { "-finline-functions",
    "Integrate simple functions into their callers",
    N_OPTS, 17, 290,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_inline_functions, CLVC_BOOLEAN, 0 },
  { "-finline-functions-called-once",
    "Integrate functions called once into their callers",
    N_OPTS, 29, 291,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_inline_functions_called_once, CLVC_BOOLEAN, 0 },
  { "-finline-limit-",
    0,
    N_OPTS, 14, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE | CL_UINTEGER,
    0, CLVC_BOOLEAN, 0 },
  { "-finline-limit=",
    "-finline-limit=<number>	Limit the size of inlined functions to <number>",
    N_OPTS, 14, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE | CL_UINTEGER,
    0, CLVC_BOOLEAN, 0 },
  { "-finline-small-functions",
    "Integrate simple functions into their callers when code size is known to not growth",
    N_OPTS, 23, 294,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_inline_small_functions, CLVC_BOOLEAN, 0 },
  { "-finput-charset=",
    "-finput-charset=<cset>	Specify the default character set for source files",
    N_OPTS, 15, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_REJECT_NEGATIVE,
    0, CLVC_STRING, 0 },
  { "-finstrument-functions",
    "Instrument function entry and exit with profiling calls",
    N_OPTS, 21, 296,
    CL_COMMON | CL_REPORT,
    &flag_instrument_function_entry_exit, CLVC_BOOLEAN, 0 },
  { "-finstrument-functions-exclude-file-list=",
    "-finstrument-functions-exclude-file-list=filename,...  Do not instrument functions listed in files",
    N_OPTS, 40, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE,
    0, CLVC_STRING, 0 },
  { "-finstrument-functions-exclude-function-list=",
    "-finstrument-functions-exclude-function-list=name,...  Do not instrument listed functions",
    N_OPTS, 44, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE,
    0, CLVC_STRING, 0 },
  { "-fipa-cp",
    "Perform Interprocedural constant propagation",
    N_OPTS, 7, 299,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_ipa_cp, CLVC_BOOLEAN, 0 },
  { "-fipa-cp-clone",
    "Perform cloning to make Interprocedural constant propagation stronger",
    N_OPTS, 13, 300,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_ipa_cp_clone, CLVC_BOOLEAN, 0 },
  { "-fipa-matrix-reorg",
    "Perform matrix layout flattening and transposing based on profiling information.",
    N_OPTS, 17, 301,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_ipa_matrix_reorg, CLVC_BOOLEAN, 0 },
  { "-fipa-pta",
    "Perform interprocedural points-to analysis",
    N_OPTS, 8, 302,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_ipa_pta, CLVC_BOOLEAN, 0 },
  { "-fipa-pure-const",
    "Discover pure and const functions",
    N_OPTS, 15, 303,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_ipa_pure_const, CLVC_BOOLEAN, 0 },
  { "-fipa-reference",
    "Discover readonly and non addressable static variables",
    N_OPTS, 14, 304,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_ipa_reference, CLVC_BOOLEAN, 0 },
  { "-fipa-struct-reorg",
    "Perform structure layout optimizations based on profiling information.",
    N_OPTS, 17, 305,
    CL_COMMON | CL_REPORT,
    &flag_ipa_struct_reorg, CLVC_BOOLEAN, 0 },
  { "-fipa-type-escape",
    "Type based escape and alias analysis",
    N_OPTS, 16, 306,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_ipa_type_escape, CLVC_BOOLEAN, 0 },
  { "-fira-algorithm=",
    "-fira-algorithm=[CB|priority] Set the used IRA algorithm",
    N_OPTS, 15, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE,
    0, CLVC_STRING, 0 },
  { "-fira-coalesce",
    "Do optimistic coalescing.",
    N_OPTS, 13, 308,
    CL_COMMON | CL_REPORT,
    &flag_ira_coalesce, CLVC_BOOLEAN, 0 },
  { "-fira-region=",
    "-fira-region=[one|all|mixed] Set regions for IRA",
    N_OPTS, 12, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE,
    0, CLVC_STRING, 0 },
  { "-fira-share-save-slots",
    "Share slots for saving different hard registers.",
    N_OPTS, 21, 310,
    CL_COMMON | CL_REPORT,
    &flag_ira_share_save_slots, CLVC_BOOLEAN, 0 },
  { "-fira-share-spill-slots",
    "Share stack slots for spilled pseudo-registers.",
    N_OPTS, 22, 311,
    CL_COMMON | CL_REPORT,
    &flag_ira_share_spill_slots, CLVC_BOOLEAN, 0 },
  { "-fira-verbose=",
    "-fira-verbose=<number> Control IRA's level of diagnostic messages.",
    N_OPTS, 13, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE | CL_UINTEGER,
    0, CLVC_BOOLEAN, 0 },
  { "-fivopts",
    "Optimize induction variables on trees",
    N_OPTS, 7, 313,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_ivopts, CLVC_BOOLEAN, 0 },
  { "-fjump-tables",
    "Use jump tables for sufficiently large switch statements",
    N_OPTS, 12, 314,
    CL_COMMON | CL_OPTIMIZATION,
    &flag_jump_tables, CLVC_BOOLEAN, 0 },
  { "-fkeep-inline-functions",
    "Generate code for functions even if they are fully inlined",
    N_OPTS, 22, 315,
    CL_COMMON | CL_REPORT,
    &flag_keep_inline_functions, CLVC_BOOLEAN, 0 },
  { "-fkeep-static-consts",
    "Emit static const variables even if they are not used",
    N_OPTS, 19, 316,
    CL_COMMON | CL_REPORT,
    &flag_keep_static_consts, CLVC_BOOLEAN, 0 },
  { "-flabels-ok",
    0,
    N_OPTS, 10, 317,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-flax-vector-conversions",
    "Allow implicit conversions between vectors with differing numbers of subparts and/or differing element types.",
    N_OPTS, 23, 318,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fleading-underscore",
    "Give external symbols a leading underscore",
    N_OPTS, 19, 319,
    CL_COMMON | CL_REPORT,
    &flag_leading_underscore, CLVC_BOOLEAN, 0 },
  { "-floop-block",
    "Enable Loop Blocking transformation",
    N_OPTS, 11, 320,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_loop_block, CLVC_BOOLEAN, 0 },
  { "-floop-interchange",
    "Enable Loop Interchange transformation",
    N_OPTS, 17, 321,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_loop_interchange, CLVC_BOOLEAN, 0 },
  { "-floop-optimize",
    "Does nothing.  Preserved for backward compatibility.",
    N_OPTS, 14, 322,
    CL_COMMON,
    0, CLVC_BOOLEAN, 0 },
  { "-floop-strip-mine",
    "Enable Loop Strip Mining transformation",
    N_OPTS, 16, 323,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_loop_strip_mine, CLVC_BOOLEAN, 0 },
  { "-fmath-errno",
    "Set errno after built-in math functions",
    N_OPTS, 11, 324,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_errno_math, CLVC_BOOLEAN, 0 },
  { "-fmem-report",
    "Report on permanent memory allocation",
    N_OPTS, 11, 325,
    CL_COMMON | CL_REPORT,
    &mem_report, CLVC_BOOLEAN, 0 },
  { "-fmerge-all-constants",
    "Attempt to merge identical constants and constant variables",
    N_OPTS, 20, 326,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_merge_constants, CLVC_EQUAL, 2 },
  { "-fmerge-constants",
    "Attempt to merge identical constants across compilation units",
    N_OPTS, 16, 327,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_merge_constants, CLVC_EQUAL, 1 },
  { "-fmerge-debug-strings",
    "Attempt to merge identical debug strings across compilation units",
    N_OPTS, 20, 328,
    CL_COMMON | CL_REPORT,
    &flag_merge_debug_strings, CLVC_BOOLEAN, 0 },
  { "-fmessage-length=",
    "-fmessage-length=<number>	Limit diagnostics to <number> characters per line.  0 suppresses line-wrapping",
    N_OPTS, 16, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE | CL_UINTEGER,
    0, CLVC_BOOLEAN, 0 },
  { "-fmodulo-sched",
    "Perform SMS based modulo scheduling before the first scheduling pass",
    N_OPTS, 13, 330,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_modulo_sched, CLVC_BOOLEAN, 0 },
  { "-fmodulo-sched-allow-regmoves",
    "Perform SMS based modulo scheduling with register moves allowed",
    N_OPTS, 28, 331,
    CL_COMMON | CL_REPORT,
    &flag_modulo_sched_allow_regmoves, CLVC_BOOLEAN, 0 },
  { "-fmove-loop-invariants",
    "Move loop invariant computations out of loops",
    N_OPTS, 21, 332,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_move_loop_invariants, CLVC_BOOLEAN, 0 },
  { "-fms-extensions",
    "Don't warn about uses of Microsoft extensions",
    N_OPTS, 14, 333,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fmudflap",
    "Add mudflap bounds-checking instrumentation for single-threaded program",
    N_OPTS, 8, -1,
    CL_COMMON | CL_REJECT_NEGATIVE | CL_REPORT,
    &flag_mudflap, CLVC_BOOLEAN, 0 },
  { "-fmudflapir",
    "Ignore read operations when inserting mudflap instrumentation",
    N_OPTS, 10, -1,
    CL_COMMON | CL_REJECT_NEGATIVE | CL_REPORT,
    &flag_mudflap_ignore_reads, CLVC_BOOLEAN, 0 },
  { "-fmudflapth",
    "Add mudflap bounds-checking instrumentation for multi-threaded program",
    N_OPTS, 10, -1,
    CL_COMMON | CL_REJECT_NEGATIVE | CL_REPORT,
    &flag_mudflap, CLVC_EQUAL, 2 },
  { "-fname-mangling-version-",
    0,
    N_OPTS, 23, 337,
    CL_CXX | CL_ObjCXX | CL_JOINED,
    0, CLVC_STRING, 0 },
  { "-fnew-abi",
    0,
    N_OPTS, 8, 338,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fnext-runtime",
    "Generate code for NeXT (Apple Mac OS X) runtime environment",
    N_OPTS, 13, 339,
    CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fnil-receivers",
    "Assume that receivers of Objective-C messages may be nil",
    N_OPTS, 14, 340,
    CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fnon-call-exceptions",
    "Support synchronous non-call exceptions",
    N_OPTS, 20, 341,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_non_call_exceptions, CLVC_BOOLEAN, 0 },
  { "-fnonansi-builtins",
    0,
    N_OPTS, 17, 342,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fnonnull-objects",
    0,
    N_OPTS, 16, 343,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fobjc-call-cxx-cdtors",
    "Generate special Objective-C methods to initialize/destroy non-POD C++ ivars, if needed",
    N_OPTS, 21, 344,
    CL_ObjCXX,
    &flag_objc_call_cxx_cdtors, CLVC_BOOLEAN, 0 },
  { "-fobjc-direct-dispatch",
    "Allow fast jumps to the message dispatcher",
    N_OPTS, 21, 345,
    CL_ObjC | CL_ObjCXX,
    &flag_objc_direct_dispatch, CLVC_BOOLEAN, 0 },
  { "-fobjc-exceptions",
    "Enable Objective-C exception and synchronization syntax",
    N_OPTS, 16, 346,
    CL_ObjC | CL_ObjCXX,
    &flag_objc_exceptions, CLVC_BOOLEAN, 0 },
  { "-fobjc-gc",
    "Enable garbage collection (GC) in Objective-C/Objective-C++ programs",
    N_OPTS, 8, 347,
    CL_ObjC | CL_ObjCXX,
    &flag_objc_gc, CLVC_BOOLEAN, 0 },
  { "-fobjc-sjlj-exceptions",
    "Enable Objective-C setjmp exception handling runtime",
    N_OPTS, 21, 348,
    CL_ObjC | CL_ObjCXX,
    &flag_objc_sjlj_exceptions, CLVC_BOOLEAN, 0 },
  { "-fomit-frame-pointer",
    "When possible do not generate stack frames",
    N_OPTS, 19, 349,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_omit_frame_pointer, CLVC_BOOLEAN, 0 },
  { "-fopenmp",
    "Enable OpenMP (implies -frecursive in Fortran)",
    N_OPTS, 7, 350,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    &flag_openmp, CLVC_BOOLEAN, 0 },
  { "-foperator-names",
    "Recognize C++ keywords like \"compl\" and \"xor\"",
    N_OPTS, 15, 351,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-foptimize-register-move",
    "Do the full register move optimization pass",
    N_OPTS, 23, 352,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_regmove, CLVC_BOOLEAN, 0 },
  { "-foptimize-sibling-calls",
    "Optimize sibling and tail recursive calls",
    N_OPTS, 23, 353,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_optimize_sibling_calls, CLVC_BOOLEAN, 0 },
  { "-foptional-diags",
    "Enable optional diagnostics",
    N_OPTS, 15, 354,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fpack-struct",
    "Pack structure members together without holes",
    N_OPTS, 12, 355,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_pack_struct, CLVC_BOOLEAN, 0 },
  { "-fpack-struct=",
    "-fpack-struct=<number>	Set initial maximum structure member alignment",
    N_OPTS, 13, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE | CL_UINTEGER | CL_OPTIMIZATION,
    0, CLVC_BOOLEAN, 0 },
  { "-fpcc-struct-return",
    "Return small aggregates in memory, not registers",
    N_OPTS, 18, 357,
    CL_COMMON | CL_REPORT,
    &flag_pcc_struct_return, CLVC_EQUAL, 1 },
  { "-fpch-deps",
    0,
    N_OPTS, 9, 358,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fpch-preprocess",
    "Look for and use PCH files even when preprocessing",
    N_OPTS, 15, 359,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fpeel-loops",
    "Perform loop peeling",
    N_OPTS, 11, 360,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_peel_loops, CLVC_BOOLEAN, 0 },
  { "-fpeephole",
    "Enable machine specific peephole optimizations",
    N_OPTS, 9, 361,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_no_peephole, CLVC_EQUAL, 0 },
  { "-fpeephole2",
    "Enable an RTL peephole pass before sched2",
    N_OPTS, 10, 362,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_peephole2, CLVC_BOOLEAN, 0 },
  { "-fpermissive",
    "Downgrade conformance errors to warnings",
    N_OPTS, 11, 363,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fpic",
    "Generate position-independent code if possible (small mode)",
    N_OPTS, 4, 364,
    CL_COMMON | CL_REPORT,
    &flag_pic, CLVC_EQUAL, 1 },
  { "-fpie",
    "Generate position-independent code for executables if possible (small mode)",
    N_OPTS, 4, 365,
    CL_COMMON | CL_REPORT,
    &flag_pie, CLVC_EQUAL, 1 },
  { "-fpost-ipa-mem-report",
    "Report on memory allocation before interprocedural optimization",
    N_OPTS, 20, 366,
    CL_COMMON | CL_REPORT,
    &post_ipa_mem_report, CLVC_BOOLEAN, 0 },
  { "-fpre-ipa-mem-report",
    "Report on memory allocation before interprocedural optimization",
    N_OPTS, 19, 367,
    CL_COMMON | CL_REPORT,
    &pre_ipa_mem_report, CLVC_BOOLEAN, 0 },
  { "-fpredictive-commoning",
    "Run predictive commoning optimization.",
    N_OPTS, 21, 368,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_predictive_commoning, CLVC_BOOLEAN, 0 },
  { "-fprefetch-loop-arrays",
    "Generate prefetch instructions, if available, for arrays in loops",
    N_OPTS, 21, 369,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_prefetch_loop_arrays, CLVC_BOOLEAN, 0 },
  { "-fpreprocessed",
    "Treat the input file as already preprocessed",
    N_OPTS, 13, 370,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fprofile",
    "Enable basic program profiling code",
    N_OPTS, 8, 371,
    CL_COMMON | CL_REPORT,
    &profile_flag, CLVC_BOOLEAN, 0 },
  { "-fprofile-arcs",
    "Insert arc-based program profiling code",
    N_OPTS, 13, 372,
    CL_COMMON | CL_REPORT,
    &profile_arc_flag, CLVC_BOOLEAN, 0 },
  { "-fprofile-correction",
    "Enable correction of flow inconsistent profile data input",
    N_OPTS, 19, 373,
    CL_COMMON | CL_REPORT,
    &flag_profile_correction, CLVC_BOOLEAN, 0 },
  { "-fprofile-dir=",
    "Set the top-level directory for storing the profile data. The default is 'pwd'.",
    N_OPTS, 13, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE,
    0, CLVC_STRING, 0 },
  { "-fprofile-generate",
    "Enable common options for generating profile info for profile feedback directed optimizations",
    N_OPTS, 17, 375,
    CL_COMMON,
    0, CLVC_BOOLEAN, 0 },
  { "-fprofile-generate=",
    "Enable common options for generating profile info for profile feedback directed optimizations, and set -fprofile-dir=",
    N_OPTS, 18, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE,
    0, CLVC_STRING, 0 },
  { "-fprofile-use",
    "Enable common options for performing profile feedback directed optimizations",
    N_OPTS, 12, 377,
    CL_COMMON,
    &flag_profile_use, CLVC_BOOLEAN, 0 },
  { "-fprofile-use=",
    "Enable common options for performing profile feedback directed optimizations, and set -fprofile-dir=",
    N_OPTS, 13, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE,
    0, CLVC_STRING, 0 },
  { "-fprofile-values",
    "Insert code to profile values of expressions",
    N_OPTS, 15, 379,
    CL_COMMON | CL_REPORT,
    &flag_profile_values, CLVC_BOOLEAN, 0 },
  { "-frandom-seed",
    0,
    N_OPTS, 12, 380,
    CL_COMMON,
    0, CLVC_BOOLEAN, 0 },
  { "-frandom-seed=",
    "-frandom-seed=<string>	Make compile reproducible using <string>",
    N_OPTS, 13, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE,
    0, CLVC_STRING, 0 },
  { "-freciprocal-math",
    "Same as -fassociative-math for expressions which include division.",
    N_OPTS, 16, 382,
    CL_COMMON | CL_REPORT,
    &flag_reciprocal_math, CLVC_BOOLEAN, 0 },
  { "-frecord-gcc-switches",
    "Record gcc command line switches in the object file.",
    N_OPTS, 20, 383,
    CL_COMMON | CL_REPORT,
    &flag_record_gcc_switches, CLVC_BOOLEAN, 0 },
  { "-freg-struct-return",
    "Return small aggregates in registers",
    N_OPTS, 18, 384,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_pcc_struct_return, CLVC_EQUAL, 0 },
  { "-fregmove",
    "Enables a register move optimization",
    N_OPTS, 8, 385,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_regmove, CLVC_BOOLEAN, 0 },
  { "-frename-registers",
    "Perform a register renaming optimization pass",
    N_OPTS, 17, 386,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_rename_registers, CLVC_BOOLEAN, 0 },
  { "-freorder-blocks",
    "Reorder basic blocks to improve code placement",
    N_OPTS, 15, 387,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_reorder_blocks, CLVC_BOOLEAN, 0 },
  { "-freorder-blocks-and-partition",
    "Reorder basic blocks and partition into hot and cold sections",
    N_OPTS, 29, 388,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_reorder_blocks_and_partition, CLVC_BOOLEAN, 0 },
  { "-freorder-functions",
    "Reorder functions to improve code placement",
    N_OPTS, 18, 389,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_reorder_functions, CLVC_BOOLEAN, 0 },
  { "-freplace-objc-classes",
    "Used in Fix-and-Continue mode to indicate that object files may be swapped in at runtime",
    N_OPTS, 21, 390,
    CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-frepo",
    "Enable automatic template instantiation",
    N_OPTS, 5, 391,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-frerun-cse-after-loop",
    "Add a common subexpression elimination pass after loop optimizations",
    N_OPTS, 21, 392,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_rerun_cse_after_loop, CLVC_BOOLEAN, 0 },
  { "-frerun-loop-opt",
    "Does nothing.  Preserved for backward compatibility.",
    N_OPTS, 15, 393,
    CL_COMMON,
    0, CLVC_BOOLEAN, 0 },
  { "-freschedule-modulo-scheduled-loops",
    "Enable/Disable the traditional scheduling in loops that already passed modulo scheduling",
    N_OPTS, 34, 394,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_resched_modulo_sched, CLVC_BOOLEAN, 0 },
  { "-frounding-math",
    "Disable optimizations that assume default FP rounding behavior",
    N_OPTS, 14, 395,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_rounding_math, CLVC_BOOLEAN, 0 },
  { "-frtl-abstract-sequences",
    "Perform sequence abstraction optimization on RTL",
    N_OPTS, 23, 396,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_rtl_seqabstr, CLVC_BOOLEAN, 0 },
  { "-frtti",
    "Generate run time type descriptor information",
    N_OPTS, 5, 397,
    CL_CXX | CL_ObjCXX | CL_OPTIMIZATION,
    0, CLVC_BOOLEAN, 0 },
  { "-fsched-interblock",
    "Enable scheduling across basic blocks",
    N_OPTS, 17, 398,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_schedule_interblock, CLVC_BOOLEAN, 0 },
  { "-fsched-spec",
    "Allow speculative motion of non-loads",
    N_OPTS, 11, 399,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_schedule_speculative, CLVC_BOOLEAN, 0 },
  { "-fsched-spec-load",
    "Allow speculative motion of some loads",
    N_OPTS, 16, 400,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_schedule_speculative_load, CLVC_BOOLEAN, 0 },
  { "-fsched-spec-load-dangerous",
    "Allow speculative motion of more loads",
    N_OPTS, 26, 401,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_schedule_speculative_load_dangerous, CLVC_BOOLEAN, 0 },
  { "-fsched-stalled-insns",
    "Allow premature scheduling of queued insns",
    N_OPTS, 20, 402,
    CL_COMMON | CL_UINTEGER | CL_OPTIMIZATION | CL_REPORT,
    &flag_sched_stalled_insns, CLVC_BOOLEAN, 0 },
  { "-fsched-stalled-insns-dep",
    "Set dependence distance checking in premature scheduling of queued insns",
    N_OPTS, 24, 403,
    CL_COMMON | CL_UINTEGER | CL_OPTIMIZATION | CL_REPORT,
    &flag_sched_stalled_insns_dep, CLVC_EQUAL, 1 },
  { "-fsched-stalled-insns-dep=",
    "-fsched-stalled-insns-dep=<number>	Set dependence distance checking in premature scheduling of queued insns",
    N_OPTS, 25, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE | CL_UINTEGER,
    0, CLVC_BOOLEAN, 0 },
  { "-fsched-stalled-insns=",
    "-fsched-stalled-insns=<number>	Set number of queued insns that can be prematurely scheduled",
    N_OPTS, 21, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE | CL_UINTEGER,
    0, CLVC_BOOLEAN, 0 },
  { "-fsched-verbose=",
    "-fsched-verbose=<number>	Set the verbosity level of the scheduler",
    N_OPTS, 15, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE,
    0, CLVC_STRING, 0 },
  { "-fsched2-use-superblocks",
    "If scheduling post reload, do superblock scheduling",
    N_OPTS, 23, 407,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_sched2_use_superblocks, CLVC_BOOLEAN, 0 },
  { "-fsched2-use-traces",
    "If scheduling post reload, do trace scheduling",
    N_OPTS, 18, 408,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_sched2_use_traces, CLVC_BOOLEAN, 0 },
  { "-fschedule-insns",
    "Reschedule instructions before register allocation",
    N_OPTS, 15, 409,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_schedule_insns, CLVC_BOOLEAN, 0 },
  { "-fschedule-insns2",
    "Reschedule instructions after register allocation",
    N_OPTS, 16, 410,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_schedule_insns_after_reload, CLVC_BOOLEAN, 0 },
  { "-fsection-anchors",
    "Access data in the same section from shared anchor points",
    N_OPTS, 16, 411,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_section_anchors, CLVC_BOOLEAN, 0 },
  { "-fsee",
    "Eliminate redundant sign extensions using LCM.",
    N_OPTS, 4, 412,
    CL_COMMON | CL_REPORT,
    &flag_see, CLVC_BOOLEAN, 0 },
  { "-fsel-sched-pipelining",
    "Perform software pipelining of inner loops during selective scheduling",
    N_OPTS, 21, 413,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_sel_sched_pipelining, CLVC_BOOLEAN, 0 },
  { "-fsel-sched-pipelining-outer-loops",
    "Perform software pipelining of outer loops during selective scheduling",
    N_OPTS, 33, 414,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_sel_sched_pipelining_outer_loops, CLVC_BOOLEAN, 0 },
  { "-fsel-sched-reschedule-pipelined",
    "Reschedule pipelined regions without pipelining",
    N_OPTS, 31, 415,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_sel_sched_reschedule_pipelined, CLVC_BOOLEAN, 0 },
  { "-fselective-scheduling",
    "Schedule instructions using selective scheduling algorithm",
    N_OPTS, 21, 416,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_selective_scheduling, CLVC_BOOLEAN, 0 },
  { "-fselective-scheduling2",
    "Run selective scheduling after reload",
    N_OPTS, 22, 417,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_selective_scheduling2, CLVC_BOOLEAN, 0 },
  { "-fshort-double",
    "Use the same size for double as for float",
    N_OPTS, 13, 418,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_OPTIMIZATION,
    0, CLVC_BOOLEAN, 0 },
  { "-fshort-enums",
    "Use the narrowest integer type possible for enumeration types",
    N_OPTS, 12, 419,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_OPTIMIZATION,
    0, CLVC_BOOLEAN, 0 },
  { "-fshort-wchar",
    "Force the underlying type for \"wchar_t\" to be \"unsigned short\"",
    N_OPTS, 12, 420,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_OPTIMIZATION,
    0, CLVC_BOOLEAN, 0 },
  { "-fshow-column",
    "Show column numbers in diagnostics, when available.  Default off",
    N_OPTS, 12, 421,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_REPORT,
    &flag_show_column, CLVC_BOOLEAN, 0 },
  { "-fsignaling-nans",
    "Disable optimizations observable by IEEE signaling NaNs",
    N_OPTS, 15, 422,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_signaling_nans, CLVC_BOOLEAN, 0 },
  { "-fsigned-bitfields",
    "When \"signed\" or \"unsigned\" is not given make the bitfield signed",
    N_OPTS, 17, 423,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fsigned-char",
    "Make \"char\" signed by default",
    N_OPTS, 12, 424,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fsigned-zeros",
    "Disable floating point optimizations that ignore the IEEE signedness of zero",
    N_OPTS, 13, 425,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_signed_zeros, CLVC_BOOLEAN, 0 },
  { "-fsingle-precision-constant",
    "Convert floating point constants to single precision constants",
    N_OPTS, 26, 426,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_single_precision_constant, CLVC_BOOLEAN, 0 },
  { "-fsplit-ivs-in-unroller",
    "Split lifetimes of induction variables when loops are unrolled",
    N_OPTS, 22, 427,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_split_ivs_in_unroller, CLVC_BOOLEAN, 0 },
  { "-fsplit-wide-types",
    "Split wide types into independent registers",
    N_OPTS, 17, 428,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_split_wide_types, CLVC_BOOLEAN, 0 },
  { "-fsquangle",
    0,
    N_OPTS, 9, 429,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fstack-check",
    "Insert stack checking code into the program.  Same as -fstack-check=specific",
    N_OPTS, 12, 430,
    CL_COMMON | CL_REPORT,
    0, CLVC_BOOLEAN, 0 },
  { "-fstack-check=",
    "-fstack-check=[no|generic|specific]	Insert stack checking code into the program",
    N_OPTS, 13, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE | CL_REPORT,
    0, CLVC_STRING, 0 },
  { "-fstack-limit",
    0,
    N_OPTS, 12, 432,
    CL_COMMON,
    0, CLVC_BOOLEAN, 0 },
  { "-fstack-limit-register=",
    "-fstack-limit-register=<register>	Trap if the stack goes past <register>",
    N_OPTS, 22, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE,
    0, CLVC_STRING, 0 },
  { "-fstack-limit-symbol=",
    "-fstack-limit-symbol=<name>	Trap if the stack goes past symbol <name>",
    N_OPTS, 20, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE,
    0, CLVC_STRING, 0 },
  { "-fstack-protector",
    "Use propolice as a stack protection method",
    N_OPTS, 16, 435,
    CL_COMMON | CL_REPORT,
    &flag_stack_protect, CLVC_EQUAL, 1 },
  { "-fstack-protector-all",
    "Use a stack protection method for every function",
    N_OPTS, 20, -1,
    CL_COMMON | CL_REJECT_NEGATIVE | CL_REPORT,
    &flag_stack_protect, CLVC_EQUAL, 2 },
  { "-fstats",
    "Display statistics accumulated during compilation",
    N_OPTS, 6, 437,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fstrength-reduce",
    "Does nothing.  Preserved for backward compatibility.",
    N_OPTS, 16, 438,
    CL_COMMON,
    0, CLVC_BOOLEAN, 0 },
  { "-fstrict-aliasing",
    "Assume strict aliasing rules apply",
    N_OPTS, 16, 439,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_strict_aliasing, CLVC_BOOLEAN, 0 },
  { "-fstrict-overflow",
    "Treat signed overflow as undefined",
    N_OPTS, 16, 440,
    CL_COMMON | CL_REPORT,
    &flag_strict_overflow, CLVC_BOOLEAN, 0 },
  { "-fstrict-prototype",
    0,
    N_OPTS, 17, 441,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fsyntax-only",
    "Check for syntax errors, then stop",
    N_OPTS, 12, 442,
    CL_COMMON | CL_REPORT,
    &flag_syntax_only, CLVC_BOOLEAN, 0 },
  { "-ftabstop=",
    "-ftabstop=<number>	Distance between tab stops for column reporting",
    N_OPTS, 9, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_REJECT_NEGATIVE | CL_UINTEGER,
    0, CLVC_BOOLEAN, 0 },
  { "-ftarget-help",
    0,
    N_OPTS, 12, 444,
    CL_COMMON,
    0, CLVC_BOOLEAN, 0 },
  { "-ftemplate-depth-",
    "-ftemplate-depth-<number>	Specify maximum template instantiation depth",
    N_OPTS, 16, -1,
    CL_CXX | CL_ObjCXX | CL_JOINED | CL_REJECT_NEGATIVE | CL_UINTEGER,
    0, CLVC_BOOLEAN, 0 },
  { "-ftest-coverage",
    "Create data files needed by \"gcov\"",
    N_OPTS, 14, 446,
    CL_COMMON | CL_REPORT,
    &flag_test_coverage, CLVC_BOOLEAN, 0 },
  { "-fthis-is-variable",
    0,
    N_OPTS, 17, 447,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fthread-jumps",
    "Perform jump threading optimizations",
    N_OPTS, 13, 448,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_thread_jumps, CLVC_BOOLEAN, 0 },
  { "-fthreadsafe-statics",
    "-fno-threadsafe-statics	Do not generate thread-safe code for initializing local statics",
    N_OPTS, 19, 449,
    CL_CXX | CL_ObjCXX | CL_OPTIMIZATION,
    0, CLVC_BOOLEAN, 0 },
  { "-ftime-report",
    "Report the time taken by each compiler pass",
    N_OPTS, 12, 450,
    CL_COMMON | CL_REPORT,
    &time_report, CLVC_BOOLEAN, 0 },
  { "-ftls-model=",
    "-ftls-model=[global-dynamic|local-dynamic|initial-exec|local-exec]	Set the default thread-local storage code generation model",
    N_OPTS, 11, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE,
    0, CLVC_STRING, 0 },
  { "-ftoplevel-reorder",
    "Reorder top level functions, variables, and asms",
    N_OPTS, 17, 452,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_toplevel_reorder, CLVC_BOOLEAN, 0 },
  { "-ftracer",
    "Perform superblock formation via tail duplication",
    N_OPTS, 7, 453,
    CL_COMMON | CL_REPORT,
    &flag_tracer, CLVC_BOOLEAN, 0 },
  { "-ftrapping-math",
    "Assume floating-point operations can trap",
    N_OPTS, 14, 454,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_trapping_math, CLVC_BOOLEAN, 0 },
  { "-ftrapv",
    "Trap for signed overflow in addition, subtraction and multiplication",
    N_OPTS, 6, 455,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_trapv, CLVC_BOOLEAN, 0 },
  { "-ftree-builtin-call-dce",
    "Enable conditional dead code elimination for builtin calls",
    N_OPTS, 22, 456,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_tree_builtin_call_dce, CLVC_BOOLEAN, 0 },
  { "-ftree-ccp",
    "Enable SSA-CCP optimization on trees",
    N_OPTS, 9, 457,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_tree_ccp, CLVC_BOOLEAN, 0 },
  { "-ftree-ch",
    "Enable loop header copying on trees",
    N_OPTS, 8, 458,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_tree_ch, CLVC_BOOLEAN, 0 },
  { "-ftree-copy-prop",
    "Enable copy propagation on trees",
    N_OPTS, 15, 459,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_tree_copy_prop, CLVC_BOOLEAN, 0 },
  { "-ftree-copyrename",
    "Replace SSA temporaries with better names in copies",
    N_OPTS, 16, 460,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_tree_copyrename, CLVC_BOOLEAN, 0 },
  { "-ftree-cselim",
    "Transform condition stores into unconditional ones",
    N_OPTS, 12, 461,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_tree_cselim, CLVC_BOOLEAN, 0 },
  { "-ftree-dce",
    "Enable SSA dead code elimination optimization on trees",
    N_OPTS, 9, 462,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_tree_dce, CLVC_BOOLEAN, 0 },
  { "-ftree-dominator-opts",
    "Enable dominator optimizations",
    N_OPTS, 20, 463,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_tree_dom, CLVC_BOOLEAN, 0 },
  { "-ftree-dse",
    "Enable dead store elimination",
    N_OPTS, 9, 464,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_tree_dse, CLVC_BOOLEAN, 0 },
  { "-ftree-fre",
    "Enable Full Redundancy Elimination (FRE) on trees",
    N_OPTS, 9, 465,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_tree_fre, CLVC_BOOLEAN, 0 },
  { "-ftree-loop-distribution",
    "Enable loop distribution on trees",
    N_OPTS, 23, 466,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_tree_loop_distribution, CLVC_BOOLEAN, 0 },
  { "-ftree-loop-im",
    "Enable loop invariant motion on trees",
    N_OPTS, 13, 467,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_tree_loop_im, CLVC_BOOLEAN, 0 },
  { "-ftree-loop-ivcanon",
    "Create canonical induction variables in loops",
    N_OPTS, 18, 468,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_tree_loop_ivcanon, CLVC_BOOLEAN, 0 },
  { "-ftree-loop-linear",
    "Enable linear loop transforms on trees",
    N_OPTS, 17, 469,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_tree_loop_linear, CLVC_BOOLEAN, 0 },
  { "-ftree-loop-optimize",
    "Enable loop optimizations on tree level",
    N_OPTS, 19, 470,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_tree_loop_optimize, CLVC_BOOLEAN, 0 },
  { "-ftree-lrs",
    "Perform live range splitting during the SSA->normal pass",
    N_OPTS, 9, 471,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_tree_live_range_split, CLVC_BOOLEAN, 0 },
  { "-ftree-parallelize-loops=",
    "Enable automatic parallelization of loops",
    N_OPTS, 24, 472,
    CL_COMMON | CL_JOINED | CL_UINTEGER | CL_REPORT,
    &flag_tree_parallelize_loops, CLVC_BOOLEAN, 0 },
  { "-ftree-pre",
    "Enable SSA-PRE optimization on trees",
    N_OPTS, 9, 473,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_tree_pre, CLVC_BOOLEAN, 0 },
  { "-ftree-reassoc",
    "Enable reassociation on tree level",
    N_OPTS, 13, 474,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_tree_reassoc, CLVC_BOOLEAN, 0 },
  { "-ftree-salias",
    "Does nothing.  Preserved for backward compatibility.",
    N_OPTS, 12, 475,
    CL_COMMON,
    0, CLVC_BOOLEAN, 0 },
  { "-ftree-scev-cprop",
    "Enable copy propagation of scalar-evolution information.",
    N_OPTS, 16, 476,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_tree_scev_cprop, CLVC_BOOLEAN, 0 },
  { "-ftree-sink",
    "Enable SSA code sinking on trees",
    N_OPTS, 10, 477,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_tree_sink, CLVC_BOOLEAN, 0 },
  { "-ftree-sra",
    "Perform scalar replacement of aggregates",
    N_OPTS, 9, 478,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_tree_sra, CLVC_BOOLEAN, 0 },
  { "-ftree-store-ccp",
    "Does nothing.  Preserved for backward compatibility.",
    N_OPTS, 15, 479,
    CL_COMMON,
    0, CLVC_BOOLEAN, 0 },
  { "-ftree-store-copy-prop",
    "Does nothing.  Preserved for backward compatibility.",
    N_OPTS, 21, 480,
    CL_COMMON,
    0, CLVC_BOOLEAN, 0 },
  { "-ftree-switch-conversion",
    "Perform conversions of switch initializations.",
    N_OPTS, 23, 481,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_tree_switch_conversion, CLVC_BOOLEAN, 0 },
  { "-ftree-ter",
    "Replace temporary expressions in the SSA->normal pass",
    N_OPTS, 9, 482,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_tree_ter, CLVC_BOOLEAN, 0 },
  { "-ftree-vect-loop-version",
    "Enable loop versioning when doing loop vectorization on trees",
    N_OPTS, 23, 483,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_tree_vect_loop_version, CLVC_BOOLEAN, 0 },
  { "-ftree-vectorize",
    "Enable loop vectorization on trees",
    N_OPTS, 15, 484,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_tree_vectorize, CLVC_BOOLEAN, 0 },
  { "-ftree-vectorizer-verbose=",
    "-ftree-vectorizer-verbose=<number>	Set the verbosity level of the vectorizer",
    N_OPTS, 25, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE,
    0, CLVC_STRING, 0 },
  { "-ftree-vrp",
    "Perform Value Range Propagation on trees",
    N_OPTS, 9, 486,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_tree_vrp, CLVC_BOOLEAN, 0 },
  { "-funit-at-a-time",
    "Compile whole compilation unit at a time",
    N_OPTS, 15, 487,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_unit_at_a_time, CLVC_BOOLEAN, 0 },
  { "-funroll-all-loops",
    "Perform loop unrolling for all loops",
    N_OPTS, 17, 488,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_unroll_all_loops, CLVC_BOOLEAN, 0 },
  { "-funroll-loops",
    "Perform loop unrolling when iteration count is known",
    N_OPTS, 13, 489,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_unroll_loops, CLVC_BOOLEAN, 0 },
  { "-funsafe-loop-optimizations",
    "Allow loop optimizations to assume that the loops behave in normal way",
    N_OPTS, 26, 490,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_unsafe_loop_optimizations, CLVC_BOOLEAN, 0 },
  { "-funsafe-math-optimizations",
    "Allow math optimizations that may violate IEEE or ISO standards",
    N_OPTS, 26, 491,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_unsafe_math_optimizations, CLVC_BOOLEAN, 0 },
  { "-funsigned-bitfields",
    "When \"signed\" or \"unsigned\" is not given make the bitfield unsigned",
    N_OPTS, 19, 492,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-funsigned-char",
    "Make \"char\" unsigned by default",
    N_OPTS, 14, 493,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-funswitch-loops",
    "Perform loop unswitching",
    N_OPTS, 15, 494,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_unswitch_loops, CLVC_BOOLEAN, 0 },
  { "-funwind-tables",
    "Just generate unwind tables for exception handling",
    N_OPTS, 14, 495,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_unwind_tables, CLVC_BOOLEAN, 0 },
  { "-fuse-cxa-atexit",
    "Use __cxa_atexit to register destructors",
    N_OPTS, 15, 496,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fuse-cxa-get-exception-ptr",
    "Use __cxa_get_exception_ptr in exception handling",
    N_OPTS, 26, 497,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fvar-tracking",
    "Perform variable tracking",
    N_OPTS, 13, 498,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_var_tracking, CLVC_BOOLEAN, 0 },
  { "-fvar-tracking-uninit",
    "Perform variable tracking and also tag variables that are uninitialized",
    N_OPTS, 20, 499,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_var_tracking_uninit, CLVC_BOOLEAN, 0 },
  { "-fvariable-expansion-in-unroller",
    "Apply variable expansion when loops are unrolled",
    N_OPTS, 31, 500,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_variable_expansion_in_unroller, CLVC_BOOLEAN, 0 },
  { "-fvect-cost-model",
    "Enable use of cost model in vectorization",
    N_OPTS, 16, 501,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_vect_cost_model, CLVC_BOOLEAN, 0 },
  { "-fverbose-asm",
    "Add extra commentary to assembler output",
    N_OPTS, 12, 502,
    CL_COMMON | CL_REPORT,
    &flag_verbose_asm, CLVC_BOOLEAN, 0 },
  { "-fvisibility-inlines-hidden",
    "Marks all inlined methods as having hidden visibility",
    N_OPTS, 26, 503,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fvisibility-ms-compat",
    "Changes visibility to match Microsoft Visual Studio by default",
    N_OPTS, 21, 504,
    CL_CXX | CL_ObjCXX,
    &flag_visibility_ms_compat, CLVC_BOOLEAN, 0 },
  { "-fvisibility=",
    "-fvisibility=[default|internal|hidden|protected]	Set the default symbol visibility",
    N_OPTS, 12, -1,
    CL_COMMON | CL_JOINED | CL_REJECT_NEGATIVE,
    0, CLVC_STRING, 0 },
  { "-fvpt",
    "Use expression value profiles in optimizations",
    N_OPTS, 4, 506,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_value_profile_transformations, CLVC_BOOLEAN, 0 },
  { "-fvtable-gc",
    "Discard unused virtual functions",
    N_OPTS, 10, 507,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fvtable-thunks",
    "Implement vtables using thunks",
    N_OPTS, 14, 508,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fweak",
    "Emit common-like symbols as weak symbols",
    N_OPTS, 5, 509,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fweb",
    "Construct webs and split unrelated uses of single variable",
    N_OPTS, 4, 510,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_web, CLVC_BOOLEAN, 0 },
  { "-fwhole-program",
    "Perform whole program optimizations",
    N_OPTS, 14, 511,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_whole_program, CLVC_BOOLEAN, 0 },
  { "-fwide-exec-charset=",
    "-fwide-exec-charset=<cset>	Convert all wide strings and character constants to character set <cset>",
    N_OPTS, 19, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_REJECT_NEGATIVE,
    0, CLVC_STRING, 0 },
  { "-fworking-directory",
    "Generate a #line directive pointing at the current working directory",
    N_OPTS, 18, 513,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fwrapv",
    "Assume signed arithmetic overflow wraps around",
    N_OPTS, 6, 514,
    CL_COMMON | CL_OPTIMIZATION | CL_REPORT,
    &flag_wrapv, CLVC_BOOLEAN, 0 },
  { "-fxref",
    "Emit cross referencing information",
    N_OPTS, 5, 515,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-fzero-initialized-in-bss",
    "Put zero initialized data in the bss section",
    N_OPTS, 24, 516,
    CL_COMMON | CL_REPORT,
    &flag_zero_initialized_in_bss, CLVC_BOOLEAN, 0 },
  { "-fzero-link",
    "Generate lazy class lookup (via objc_getClass()) for use in Zero-Link mode",
    N_OPTS, 10, 517,
    CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-g",
    "Generate debug information in default format",
    N_OPTS, 1, -1,
    CL_COMMON | CL_JOINED | CL_MISSING_OK,
    0, CLVC_STRING, 0 },
  { "-gcoff",
    "Generate debug information in COFF format",
    OPT_g, 5, 520,
    CL_COMMON | CL_JOINED | CL_MISSING_OK,
    0, CLVC_STRING, 0 },
  { "-gdwarf-2",
    "Generate debug information in DWARF v2 format",
    OPT_g, 8, 523,
    CL_COMMON | CL_JOINED | CL_MISSING_OK,
    0, CLVC_STRING, 0 },
  { "-gen-decls",
    "Dump declarations to a .decl file",
    OPT_g, 9, -1,
    CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-ggdb",
    "Generate debug information in default extended format",
    OPT_g, 4, -1,
    CL_COMMON | CL_JOINED | CL_MISSING_OK,
    0, CLVC_STRING, 0 },
  { "-gstabs",
    "Generate debug information in STABS format",
    OPT_g, 6, 524,
    CL_COMMON | CL_JOINED | CL_MISSING_OK,
    0, CLVC_STRING, 0 },
  { "-gstabs+",
    "Generate debug information in extended STABS format",
    OPT_gstabs, 7, 525,
    CL_COMMON | CL_JOINED | CL_MISSING_OK,
    0, CLVC_STRING, 0 },
  { "-gvms",
    "Generate debug information in VMS format",
    OPT_g, 4, 526,
    CL_COMMON | CL_JOINED | CL_MISSING_OK,
    0, CLVC_STRING, 0 },
  { "-gxcoff",
    "Generate debug information in XCOFF format",
    OPT_g, 6, 527,
    CL_COMMON | CL_JOINED | CL_MISSING_OK,
    0, CLVC_STRING, 0 },
  { "-gxcoff+",
    "Generate debug information in extended XCOFF format",
    OPT_gxcoff, 7, 519,
    CL_COMMON | CL_JOINED | CL_MISSING_OK,
    0, CLVC_STRING, 0 },
  { "-idirafter",
    "-idirafter <dir>	Add <dir> to the end of the system include path",
    N_OPTS, 9, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, CLVC_STRING, 0 },
  { "-imacros",
    "-imacros <file>	Accept definition of macros in <file>",
    N_OPTS, 7, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, CLVC_STRING, 0 },
  { "-imultilib",
    "-imultilib <dir> Set <dir> to be the multilib include subdirectory",
    N_OPTS, 9, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, CLVC_STRING, 0 },
  { "-include",
    "-include <file>	Include the contents of <file> before other files",
    N_OPTS, 7, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, CLVC_STRING, 0 },
  { "-iprefix",
    "-iprefix <path>	Specify <path> as a prefix for next two options",
    N_OPTS, 7, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, CLVC_STRING, 0 },
  { "-iquote",
    "-iquote <dir>	Add <dir> to the end of the quote include path",
    N_OPTS, 6, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, CLVC_STRING, 0 },
  { "-isysroot",
    "-isysroot <dir>	Set <dir> to be the system root directory",
    N_OPTS, 8, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, CLVC_STRING, 0 },
  { "-isystem",
    "-isystem <dir>	Add <dir> to the start of the system include path",
    N_OPTS, 7, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, CLVC_STRING, 0 },
  { "-iwithprefix",
    "-iwithprefix <dir>	Add <dir> to the end of the system include path",
    N_OPTS, 11, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, CLVC_STRING, 0 },
  { "-iwithprefixbefore",
    "-iwithprefixbefore <dir>	Add <dir> to the end of the main include path",
    OPT_iwithprefix, 17, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, CLVC_STRING, 0 },
  { "-lang-asm",
    0,
    N_OPTS, 8, -1,
    CL_C | CL_UNDOCUMENTED,
    0, CLVC_BOOLEAN, 0 },
  { "-lang-objc",
    0,
    N_OPTS, 9, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_UNDOCUMENTED,
    0, CLVC_BOOLEAN, 0 },
  { "-mabi=",
    "Specify an ABI",
    N_OPTS, 5, -1,
    CL_TARGET | CL_JOINED | CL_REJECT_NEGATIVE,
    &target_abi_name, CLVC_STRING, 0 },
  { "-mabort-on-noreturn",
    "Generate a call to abort if a noreturn function returns",
    N_OPTS, 18, 541,
    CL_TARGET | CL_REPORT,
    &target_flags, CLVC_BIT_SET, MASK_ABORT_NORETURN },
  { "-mapcs",
    0,
    N_OPTS, 5, -1,
    CL_TARGET | CL_REJECT_NEGATIVE | CL_UNDOCUMENTED,
    &target_flags, CLVC_BIT_SET, MASK_APCS_FRAME },
  { "-mapcs-float",
    "Pass FP arguments in FP registers",
    N_OPTS, 11, 543,
    CL_TARGET | CL_REPORT,
    &target_flags, CLVC_BIT_SET, MASK_APCS_FLOAT },
  { "-mapcs-frame",
    "Generate APCS conformant stack frames",
    N_OPTS, 11, 544,
    CL_TARGET | CL_REPORT,
    &target_flags, CLVC_BIT_SET, MASK_APCS_FRAME },
  { "-mapcs-reentrant",
    "Generate re-entrant, PIC code",
    N_OPTS, 15, 545,
    CL_TARGET | CL_REPORT,
    &target_flags, CLVC_BIT_SET, MASK_APCS_REENT },
  { "-mapcs-stack-check",
    0,
    N_OPTS, 17, 546,
    CL_TARGET | CL_UNDOCUMENTED | CL_REPORT,
    &target_flags, CLVC_BIT_SET, MASK_APCS_STACK },
  { "-march=",
    "Specify the name of the target architecture",
    N_OPTS, 6, -1,
    CL_TARGET | CL_JOINED | CL_REJECT_NEGATIVE,
    &VAR_march_, CLVC_STRING, 0 },
  { "-marm",
    0,
    N_OPTS, 4, -1,
    CL_TARGET | CL_REJECT_NEGATIVE | CL_UNDOCUMENTED,
    &target_flags, CLVC_BIT_CLEAR, MASK_THUMB },
  { "-mbig-endian",
    "Assume target CPU is configured as big endian",
    N_OPTS, 11, -1,
    CL_TARGET | CL_REJECT_NEGATIVE | CL_REPORT,
    &target_flags, CLVC_BIT_SET, MASK_BIG_END },
  { "-mcallee-super-interworking",
    "Thumb: Assume non-static functions may be called from ARM code",
    N_OPTS, 26, 550,
    CL_TARGET | CL_REPORT,
    &target_flags, CLVC_BIT_SET, MASK_CALLEE_INTERWORKING },
  { "-mcaller-super-interworking",
    "Thumb: Assume function pointers may go to non-Thumb aware code",
    N_OPTS, 26, 551,
    CL_TARGET | CL_REPORT,
    &target_flags, CLVC_BIT_SET, MASK_CALLER_INTERWORKING },
  { "-mcirrus-fix-invalid-insns",
    "Cirrus: Place NOPs to avoid invalid instruction combinations",
    N_OPTS, 25, 552,
    CL_TARGET | CL_REPORT,
    &target_flags, CLVC_BIT_SET, MASK_CIRRUS_FIX_INVALID_INSNS },
  { "-mcpu=",
    "Specify the name of the target CPU",
    N_OPTS, 5, -1,
    CL_TARGET | CL_JOINED | CL_REJECT_NEGATIVE,
    &VAR_mcpu_, CLVC_STRING, 0 },
  { "-mfix-cortex-m3-ldrd",
    "Avoid overlapping destination and address registers on LDRD instructions that may trigger Cortex-M3 errata.",
    N_OPTS, 19, 554,
    CL_TARGET | CL_REPORT,
    &fix_cm3_ldrd, CLVC_BOOLEAN, 0 },
  { "-mfloat-abi=",
    "Specify if floating point hardware should be used",
    N_OPTS, 11, -1,
    CL_TARGET | CL_JOINED | CL_REJECT_NEGATIVE,
    &target_float_abi_name, CLVC_STRING, 0 },
  { "-mfp=",
    0,
    N_OPTS, 4, -1,
    CL_TARGET | CL_JOINED | CL_REJECT_NEGATIVE | CL_UNDOCUMENTED,
    &target_fpe_name, CLVC_STRING, 0 },
  { "-mfpe",
    0,
    N_OPTS, 4, -1,
    CL_TARGET | CL_REJECT_NEGATIVE | CL_UNDOCUMENTED,
    &target_flags, CLVC_BIT_SET, MASK_FPE },
  { "-mfpe=",
    0,
    N_OPTS, 5, -1,
    CL_TARGET | CL_JOINED | CL_REJECT_NEGATIVE | CL_UNDOCUMENTED,
    &target_fpe_name, CLVC_STRING, 0 },
  { "-mfpu=",
    "Specify the name of the target floating point hardware/format",
    N_OPTS, 5, -1,
    CL_TARGET | CL_JOINED | CL_REJECT_NEGATIVE,
    &target_fpu_name, CLVC_STRING, 0 },
  { "-mhard-float",
    "Alias for -mfloat-abi=hard",
    N_OPTS, 11, -1,
    CL_TARGET | CL_REJECT_NEGATIVE,
    &VAR_mhard_float, CLVC_BOOLEAN, 0 },
  { "-mlittle-endian",
    "Assume target CPU is configured as little endian",
    N_OPTS, 14, -1,
    CL_TARGET | CL_REJECT_NEGATIVE | CL_REPORT,
    &target_flags, CLVC_BIT_CLEAR, MASK_BIG_END },
  { "-mlong-calls",
    "Generate call insns as indirect calls, if necessary",
    N_OPTS, 11, 562,
    CL_TARGET | CL_REPORT,
    &target_flags, CLVC_BIT_SET, MASK_LONG_CALLS },
  { "-mpic-register=",
    "Specify the register to be used for PIC addressing",
    N_OPTS, 14, -1,
    CL_TARGET | CL_JOINED | CL_REJECT_NEGATIVE,
    &arm_pic_register_string, CLVC_STRING, 0 },
  { "-mpoke-function-name",
    "Store function names in object code",
    N_OPTS, 19, 564,
    CL_TARGET | CL_REPORT,
    &target_flags, CLVC_BIT_SET, MASK_POKE_FUNCTION_NAME },
  { "-msched-prolog",
    "Permit scheduling of a function's prologue sequence",
    N_OPTS, 13, 565,
    CL_TARGET | CL_REPORT,
    &target_flags, CLVC_BIT_SET, MASK_SCHED_PROLOG },
  { "-msingle-pic-base",
    "Do not load the PIC register in function prologues",
    N_OPTS, 16, 566,
    CL_TARGET | CL_REPORT,
    &target_flags, CLVC_BIT_SET, MASK_SINGLE_PIC_BASE },
  { "-msoft-float",
    "Alias for -mfloat-abi=soft",
    N_OPTS, 11, -1,
    CL_TARGET | CL_REJECT_NEGATIVE,
    &VAR_msoft_float, CLVC_BOOLEAN, 0 },
  { "-mstructure-size-boundary=",
    "Specify the minimum bit alignment of structures",
    N_OPTS, 25, -1,
    CL_TARGET | CL_JOINED | CL_REJECT_NEGATIVE,
    &structure_size_string, CLVC_STRING, 0 },
  { "-mthumb",
    "Compile for the Thumb not the ARM",
    N_OPTS, 6, 569,
    CL_TARGET | CL_REPORT,
    &target_flags, CLVC_BIT_SET, MASK_THUMB },
  { "-mthumb-interwork",
    "Support calls between Thumb and ARM instruction sets",
    N_OPTS, 16, 570,
    CL_TARGET | CL_REPORT,
    &target_flags, CLVC_BIT_SET, MASK_INTERWORK },
  { "-mtp=",
    "Specify how to access the thread pointer",
    N_OPTS, 4, -1,
    CL_TARGET | CL_JOINED | CL_REJECT_NEGATIVE,
    &target_thread_switch, CLVC_STRING, 0 },
  { "-mtpcs-frame",
    "Thumb: Generate (non-leaf) stack frames even if not needed",
    N_OPTS, 11, 572,
    CL_TARGET | CL_REPORT,
    &target_flags, CLVC_BIT_SET, MASK_TPCS_FRAME },
  { "-mtpcs-leaf-frame",
    "Thumb: Generate (leaf) stack frames even if not needed",
    N_OPTS, 16, 573,
    CL_TARGET | CL_REPORT,
    &target_flags, CLVC_BIT_SET, MASK_TPCS_LEAF_FRAME },
  { "-mtune=",
    "Tune code for the given processor",
    N_OPTS, 6, -1,
    CL_TARGET | CL_JOINED | CL_REJECT_NEGATIVE,
    &VAR_mtune_, CLVC_STRING, 0 },
  { "-mvectorize-with-neon-quad",
    "Use Neon quad-word (rather than double-word) registers for vectorization",
    N_OPTS, 25, 575,
    CL_TARGET | CL_REPORT,
    &target_flags, CLVC_BIT_SET, MASK_NEON_VECTORIZE_QUAD },
  { "-mword-relocations",
    "Only generate absolute relocations on word sized values.",
    N_OPTS, 17, 576,
    CL_TARGET | CL_REPORT,
    &target_word_relocations, CLVC_BOOLEAN, 0 },
  { "-mwords-little-endian",
    "Assume big endian bytes, little endian words",
    N_OPTS, 20, -1,
    CL_TARGET | CL_REJECT_NEGATIVE | CL_REPORT,
    &target_flags, CLVC_BIT_SET, MASK_LITTLE_WORDS },
  { "-nostdinc",
    "Do not search standard system include directories (those specified with -isystem will still be used)",
    N_OPTS, 8, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-nostdinc++",
    "Do not search standard system include directories for C++",
    N_OPTS, 10, -1,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-o",
    "-o <file>	Place output into <file>",
    N_OPTS, 1, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_JOINED | CL_SEPARATE,
    0, CLVC_STRING, 0 },
  { "-p",
    "Enable function profiling",
    N_OPTS, 1, -1,
    CL_COMMON,
    &profile_flag, CLVC_BOOLEAN, 0 },
  { "-pedantic",
    "Issue warnings needed for strict compliance to the standard",
    N_OPTS, 8, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_COMMON,
    &pedantic, CLVC_BOOLEAN, 0 },
  { "-pedantic-errors",
    "Like -pedantic but issue them as errors",
    N_OPTS, 15, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_COMMON,
    0, CLVC_BOOLEAN, 0 },
  { "-pie",
    "Create a position independent executable",
    N_OPTS, 3, 589,
    CL_COMMON | CL_REJECT_NEGATIVE,
    0, CLVC_BOOLEAN, 0 },
  { "-print-objc-runtime-info",
    "Generate C header of platform-specific features",
    N_OPTS, 23, -1,
    CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-print-pch-checksum",
    "Print a checksum of the executable for PCH validity checking, and stop",
    N_OPTS, 18, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-quiet",
    "Do not display functions compiled or elapsed time",
    N_OPTS, 5, -1,
    CL_COMMON,
    &quiet_flag, CLVC_BOOLEAN, 0 },
  { "-remap",
    "Remap file names when including files",
    N_OPTS, 5, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-shared",
    "Create a shared library",
    N_OPTS, 6, 584,
    CL_COMMON | CL_REJECT_NEGATIVE,
    0, CLVC_BOOLEAN, 0 },
  { "-std=c++0x",
    "Conform to the ISO 1998 C++ standard, with extensions that are likely to become a part of the upcoming ISO C++ standard, dubbed C++0x. Note that the extensions enabled by this mode are experimental and may be removed in future releases of GCC.",
    N_OPTS, 9, -1,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-std=c++98",
    "Conform to the ISO 1998 C++ standard",
    N_OPTS, 9, -1,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-std=c89",
    "Conform to the ISO 1990 C standard",
    N_OPTS, 7, -1,
    CL_C | CL_ObjC,
    0, CLVC_BOOLEAN, 0 },
  { "-std=c99",
    "Conform to the ISO 1999 C standard",
    N_OPTS, 7, -1,
    CL_C | CL_ObjC,
    0, CLVC_BOOLEAN, 0 },
  { "-std=c9x",
    "Deprecated in favor of -std=c99",
    N_OPTS, 7, -1,
    CL_C | CL_ObjC,
    0, CLVC_BOOLEAN, 0 },
  { "-std=gnu++0x",
    "Conform to the ISO 1998 C++ standard, with GNU extensions and extensions that are likely to become a part of the upcoming ISO C++ standard, dubbed C++0x. Note that the extensions enabled by this mode are experimental and may be removed in future releases of GCC.",
    N_OPTS, 11, -1,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-std=gnu++98",
    "Conform to the ISO 1998 C++ standard with GNU extensions",
    N_OPTS, 11, -1,
    CL_CXX | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-std=gnu89",
    "Conform to the ISO 1990 C standard with GNU extensions",
    N_OPTS, 9, -1,
    CL_C | CL_ObjC,
    0, CLVC_BOOLEAN, 0 },
  { "-std=gnu99",
    "Conform to the ISO 1999 C standard with GNU extensions",
    N_OPTS, 9, -1,
    CL_C | CL_ObjC,
    0, CLVC_BOOLEAN, 0 },
  { "-std=gnu9x",
    "Deprecated in favor of -std=gnu99",
    N_OPTS, 9, -1,
    CL_C | CL_ObjC,
    0, CLVC_BOOLEAN, 0 },
  { "-std=iso9899:1990",
    "Conform to the ISO 1990 C standard",
    N_OPTS, 16, -1,
    CL_C | CL_ObjC,
    0, CLVC_BOOLEAN, 0 },
  { "-std=iso9899:199409",
    "Conform to the ISO 1990 C standard as amended in 1994",
    N_OPTS, 18, -1,
    CL_C | CL_ObjC,
    0, CLVC_BOOLEAN, 0 },
  { "-std=iso9899:1999",
    "Conform to the ISO 1999 C standard",
    N_OPTS, 16, -1,
    CL_C | CL_ObjC,
    0, CLVC_BOOLEAN, 0 },
  { "-std=iso9899:199x",
    "Deprecated in favor of -std=iso9899:1999",
    N_OPTS, 16, -1,
    CL_C | CL_ObjC,
    0, CLVC_BOOLEAN, 0 },
  { "-traditional-cpp",
    "Enable traditional preprocessing",
    N_OPTS, 15, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-trigraphs",
    "-trigraphs	Support ISO C trigraphs",
    N_OPTS, 9, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-undef",
    "Do not predefine system-specific and GCC-specific macros",
    N_OPTS, 5, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, CLVC_BOOLEAN, 0 },
  { "-v",
    "Enable verbose output",
    N_OPTS, 1, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_COMMON,
    0, CLVC_BOOLEAN, 0 },
  { "-version",
    "Display the compiler's version",
    N_OPTS, 7, -1,
    CL_COMMON,
    &version_flag, CLVC_BOOLEAN, 0 },
  { "-w",
    "Suppress warnings",
    N_OPTS, 1, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_COMMON,
    &inhibit_warnings, CLVC_BOOLEAN, 0 }
};

#if !defined(GCC_DRIVER) && !defined(IN_LIBGCC2) && !defined(IN_TARGET_LIBS)

/* Save optimization variables into a structure.  */
void
cl_optimization_save (struct cl_optimization *ptr)
{
  gcc_assert (IN_RANGE (optimize, 0, 255));
  gcc_assert (IN_RANGE (optimize_size, 0, 255));
  gcc_assert (IN_RANGE (flag_argument_noalias, 0, 255));
  gcc_assert (IN_RANGE (flag_asynchronous_unwind_tables, 0, 255));
  gcc_assert (IN_RANGE (flag_branch_on_count_reg, 0, 255));
  gcc_assert (IN_RANGE (flag_branch_probabilities, 0, 255));
  gcc_assert (IN_RANGE (flag_branch_target_load_optimize, 0, 255));
  gcc_assert (IN_RANGE (flag_branch_target_load_optimize2, 0, 255));
  gcc_assert (IN_RANGE (flag_btr_bb_exclusive, 0, 255));
  gcc_assert (IN_RANGE (flag_caller_saves, 0, 255));
  gcc_assert (IN_RANGE (flag_no_common, 0, 255));
  gcc_assert (IN_RANGE (flag_conserve_stack, 0, 255));
  gcc_assert (IN_RANGE (flag_cprop_registers, 0, 255));
  gcc_assert (IN_RANGE (flag_crossjumping, 0, 255));
  gcc_assert (IN_RANGE (flag_cse_follow_jumps, 0, 255));
  gcc_assert (IN_RANGE (flag_cse_skip_blocks, 0, 255));
  gcc_assert (IN_RANGE (flag_cx_fortran_rules, 0, 255));
  gcc_assert (IN_RANGE (flag_cx_limited_range, 0, 255));
  gcc_assert (IN_RANGE (flag_data_sections, 0, 255));
  gcc_assert (IN_RANGE (flag_dce, 0, 255));
  gcc_assert (IN_RANGE (flag_defer_pop, 0, 255));
  gcc_assert (IN_RANGE (flag_delayed_branch, 0, 255));
  gcc_assert (IN_RANGE (flag_delete_null_pointer_checks, 0, 255));
  gcc_assert (IN_RANGE (flag_dse, 0, 255));
  gcc_assert (IN_RANGE (flag_early_inlining, 0, 255));
  gcc_assert (IN_RANGE (flag_exceptions, 0, 255));
  gcc_assert (IN_RANGE (flag_expensive_optimizations, 0, 255));
  gcc_assert (IN_RANGE (flag_finite_math_only, 0, 255));
  gcc_assert (IN_RANGE (flag_float_store, 0, 255));
  gcc_assert (IN_RANGE (flag_forward_propagate, 0, 255));
  gcc_assert (IN_RANGE (flag_gcse, 0, 255));
  gcc_assert (IN_RANGE (flag_gcse_after_reload, 0, 255));
  gcc_assert (IN_RANGE (flag_gcse_las, 0, 255));
  gcc_assert (IN_RANGE (flag_gcse_lm, 0, 255));
  gcc_assert (IN_RANGE (flag_gcse_sm, 0, 255));
  gcc_assert (IN_RANGE (flag_graphite_identity, 0, 255));
  gcc_assert (IN_RANGE (flag_guess_branch_prob, 0, 255));
  gcc_assert (IN_RANGE (flag_if_conversion, 0, 255));
  gcc_assert (IN_RANGE (flag_if_conversion2, 0, 255));
  gcc_assert (IN_RANGE (flag_inline_functions, 0, 255));
  gcc_assert (IN_RANGE (flag_inline_functions_called_once, 0, 255));
  gcc_assert (IN_RANGE (flag_inline_small_functions, 0, 255));
  gcc_assert (IN_RANGE (flag_ipa_cp, 0, 255));
  gcc_assert (IN_RANGE (flag_ipa_cp_clone, 0, 255));
  gcc_assert (IN_RANGE (flag_ipa_matrix_reorg, 0, 255));
  gcc_assert (IN_RANGE (flag_ipa_pta, 0, 255));
  gcc_assert (IN_RANGE (flag_ipa_pure_const, 0, 255));
  gcc_assert (IN_RANGE (flag_ipa_reference, 0, 255));
  gcc_assert (IN_RANGE (flag_ipa_type_escape, 0, 255));
  gcc_assert (IN_RANGE (flag_ivopts, 0, 255));
  gcc_assert (IN_RANGE (flag_jump_tables, 0, 255));
  gcc_assert (IN_RANGE (flag_loop_block, 0, 255));
  gcc_assert (IN_RANGE (flag_loop_interchange, 0, 255));
  gcc_assert (IN_RANGE (flag_loop_strip_mine, 0, 255));
  gcc_assert (IN_RANGE (flag_errno_math, 0, 255));
  gcc_assert (IN_RANGE (flag_merge_constants, 0, 255));
  gcc_assert (IN_RANGE (flag_modulo_sched, 0, 255));
  gcc_assert (IN_RANGE (flag_move_loop_invariants, 0, 255));
  gcc_assert (IN_RANGE (flag_non_call_exceptions, 0, 255));
  gcc_assert (IN_RANGE (flag_omit_frame_pointer, 0, 255));
  gcc_assert (IN_RANGE (flag_regmove, 0, 255));
  gcc_assert (IN_RANGE (flag_optimize_sibling_calls, 0, 255));
  gcc_assert (IN_RANGE (flag_pack_struct, 0, 255));
  gcc_assert (IN_RANGE (flag_peel_loops, 0, 255));
  gcc_assert (IN_RANGE (flag_no_peephole, 0, 255));
  gcc_assert (IN_RANGE (flag_peephole2, 0, 255));
  gcc_assert (IN_RANGE (flag_predictive_commoning, 0, 255));
  gcc_assert (IN_RANGE (flag_prefetch_loop_arrays, 0, 255));
  gcc_assert (IN_RANGE (flag_pcc_struct_return, 0, 255));
  gcc_assert (IN_RANGE (flag_rename_registers, 0, 255));
  gcc_assert (IN_RANGE (flag_reorder_blocks, 0, 255));
  gcc_assert (IN_RANGE (flag_reorder_blocks_and_partition, 0, 255));
  gcc_assert (IN_RANGE (flag_reorder_functions, 0, 255));
  gcc_assert (IN_RANGE (flag_rerun_cse_after_loop, 0, 255));
  gcc_assert (IN_RANGE (flag_resched_modulo_sched, 0, 255));
  gcc_assert (IN_RANGE (flag_rounding_math, 0, 255));
  gcc_assert (IN_RANGE (flag_rtl_seqabstr, 0, 255));
  gcc_assert (IN_RANGE (flag_schedule_interblock, 0, 255));
  gcc_assert (IN_RANGE (flag_schedule_speculative, 0, 255));
  gcc_assert (IN_RANGE (flag_schedule_speculative_load, 0, 255));
  gcc_assert (IN_RANGE (flag_schedule_speculative_load_dangerous, 0, 255));
  gcc_assert (IN_RANGE (flag_sched2_use_superblocks, 0, 255));
  gcc_assert (IN_RANGE (flag_sched2_use_traces, 0, 255));
  gcc_assert (IN_RANGE (flag_schedule_insns, 0, 255));
  gcc_assert (IN_RANGE (flag_schedule_insns_after_reload, 0, 255));
  gcc_assert (IN_RANGE (flag_section_anchors, 0, 255));
  gcc_assert (IN_RANGE (flag_sel_sched_pipelining, 0, 255));
  gcc_assert (IN_RANGE (flag_sel_sched_pipelining_outer_loops, 0, 255));
  gcc_assert (IN_RANGE (flag_sel_sched_reschedule_pipelined, 0, 255));
  gcc_assert (IN_RANGE (flag_selective_scheduling, 0, 255));
  gcc_assert (IN_RANGE (flag_selective_scheduling2, 0, 255));
  gcc_assert (IN_RANGE (flag_signaling_nans, 0, 255));
  gcc_assert (IN_RANGE (flag_signed_zeros, 0, 255));
  gcc_assert (IN_RANGE (flag_single_precision_constant, 0, 255));
  gcc_assert (IN_RANGE (flag_split_ivs_in_unroller, 0, 255));
  gcc_assert (IN_RANGE (flag_split_wide_types, 0, 255));
  gcc_assert (IN_RANGE (flag_strict_aliasing, 0, 255));
  gcc_assert (IN_RANGE (flag_thread_jumps, 0, 255));
  gcc_assert (IN_RANGE (flag_toplevel_reorder, 0, 255));
  gcc_assert (IN_RANGE (flag_trapping_math, 0, 255));
  gcc_assert (IN_RANGE (flag_trapv, 0, 255));
  gcc_assert (IN_RANGE (flag_tree_builtin_call_dce, 0, 255));
  gcc_assert (IN_RANGE (flag_tree_ccp, 0, 255));
  gcc_assert (IN_RANGE (flag_tree_ch, 0, 255));
  gcc_assert (IN_RANGE (flag_tree_copy_prop, 0, 255));
  gcc_assert (IN_RANGE (flag_tree_copyrename, 0, 255));
  gcc_assert (IN_RANGE (flag_tree_cselim, 0, 255));
  gcc_assert (IN_RANGE (flag_tree_dce, 0, 255));
  gcc_assert (IN_RANGE (flag_tree_dom, 0, 255));
  gcc_assert (IN_RANGE (flag_tree_dse, 0, 255));
  gcc_assert (IN_RANGE (flag_tree_fre, 0, 255));
  gcc_assert (IN_RANGE (flag_tree_loop_distribution, 0, 255));
  gcc_assert (IN_RANGE (flag_tree_loop_im, 0, 255));
  gcc_assert (IN_RANGE (flag_tree_loop_ivcanon, 0, 255));
  gcc_assert (IN_RANGE (flag_tree_loop_linear, 0, 255));
  gcc_assert (IN_RANGE (flag_tree_loop_optimize, 0, 255));
  gcc_assert (IN_RANGE (flag_tree_live_range_split, 0, 255));
  gcc_assert (IN_RANGE (flag_tree_pre, 0, 255));
  gcc_assert (IN_RANGE (flag_tree_reassoc, 0, 255));
  gcc_assert (IN_RANGE (flag_tree_scev_cprop, 0, 255));
  gcc_assert (IN_RANGE (flag_tree_sink, 0, 255));
  gcc_assert (IN_RANGE (flag_tree_sra, 0, 255));
  gcc_assert (IN_RANGE (flag_tree_switch_conversion, 0, 255));
  gcc_assert (IN_RANGE (flag_tree_ter, 0, 255));
  gcc_assert (IN_RANGE (flag_tree_vect_loop_version, 0, 255));
  gcc_assert (IN_RANGE (flag_tree_vectorize, 0, 255));
  gcc_assert (IN_RANGE (flag_tree_vrp, 0, 255));
  gcc_assert (IN_RANGE (flag_unit_at_a_time, 0, 255));
  gcc_assert (IN_RANGE (flag_unroll_all_loops, 0, 255));
  gcc_assert (IN_RANGE (flag_unroll_loops, 0, 255));
  gcc_assert (IN_RANGE (flag_unsafe_loop_optimizations, 0, 255));
  gcc_assert (IN_RANGE (flag_unsafe_math_optimizations, 0, 255));
  gcc_assert (IN_RANGE (flag_unswitch_loops, 0, 255));
  gcc_assert (IN_RANGE (flag_unwind_tables, 0, 255));
  gcc_assert (IN_RANGE (flag_var_tracking, 0, 255));
  gcc_assert (IN_RANGE (flag_var_tracking_uninit, 0, 255));
  gcc_assert (IN_RANGE (flag_variable_expansion_in_unroller, 0, 255));
  gcc_assert (IN_RANGE (flag_vect_cost_model, 0, 255));
  gcc_assert (IN_RANGE (flag_value_profile_transformations, 0, 255));
  gcc_assert (IN_RANGE (flag_web, 0, 255));
  gcc_assert (IN_RANGE (flag_whole_program, 0, 255));
  gcc_assert (IN_RANGE (flag_wrapv, 0, 255));

  ptr->align_functions = align_functions;
  ptr->align_jumps = align_jumps;
  ptr->align_labels = align_labels;
  ptr->align_loops = align_loops;
  ptr->flag_sched_stalled_insns = flag_sched_stalled_insns;
  ptr->flag_sched_stalled_insns_dep = flag_sched_stalled_insns_dep;
  ptr->optimize = optimize;
  ptr->optimize_size = optimize_size;
  ptr->flag_argument_noalias = flag_argument_noalias;
  ptr->flag_asynchronous_unwind_tables = flag_asynchronous_unwind_tables;
  ptr->flag_branch_on_count_reg = flag_branch_on_count_reg;
  ptr->flag_branch_probabilities = flag_branch_probabilities;
  ptr->flag_branch_target_load_optimize = flag_branch_target_load_optimize;
  ptr->flag_branch_target_load_optimize2 = flag_branch_target_load_optimize2;
  ptr->flag_btr_bb_exclusive = flag_btr_bb_exclusive;
  ptr->flag_caller_saves = flag_caller_saves;
  ptr->flag_no_common = flag_no_common;
  ptr->flag_conserve_stack = flag_conserve_stack;
  ptr->flag_cprop_registers = flag_cprop_registers;
  ptr->flag_crossjumping = flag_crossjumping;
  ptr->flag_cse_follow_jumps = flag_cse_follow_jumps;
  ptr->flag_cse_skip_blocks = flag_cse_skip_blocks;
  ptr->flag_cx_fortran_rules = flag_cx_fortran_rules;
  ptr->flag_cx_limited_range = flag_cx_limited_range;
  ptr->flag_data_sections = flag_data_sections;
  ptr->flag_dce = flag_dce;
  ptr->flag_defer_pop = flag_defer_pop;
  ptr->flag_delayed_branch = flag_delayed_branch;
  ptr->flag_delete_null_pointer_checks = flag_delete_null_pointer_checks;
  ptr->flag_dse = flag_dse;
  ptr->flag_early_inlining = flag_early_inlining;
  ptr->flag_exceptions = flag_exceptions;
  ptr->flag_expensive_optimizations = flag_expensive_optimizations;
  ptr->flag_finite_math_only = flag_finite_math_only;
  ptr->flag_float_store = flag_float_store;
  ptr->flag_forward_propagate = flag_forward_propagate;
  ptr->flag_gcse = flag_gcse;
  ptr->flag_gcse_after_reload = flag_gcse_after_reload;
  ptr->flag_gcse_las = flag_gcse_las;
  ptr->flag_gcse_lm = flag_gcse_lm;
  ptr->flag_gcse_sm = flag_gcse_sm;
  ptr->flag_graphite_identity = flag_graphite_identity;
  ptr->flag_guess_branch_prob = flag_guess_branch_prob;
  ptr->flag_if_conversion = flag_if_conversion;
  ptr->flag_if_conversion2 = flag_if_conversion2;
  ptr->flag_inline_functions = flag_inline_functions;
  ptr->flag_inline_functions_called_once = flag_inline_functions_called_once;
  ptr->flag_inline_small_functions = flag_inline_small_functions;
  ptr->flag_ipa_cp = flag_ipa_cp;
  ptr->flag_ipa_cp_clone = flag_ipa_cp_clone;
  ptr->flag_ipa_matrix_reorg = flag_ipa_matrix_reorg;
  ptr->flag_ipa_pta = flag_ipa_pta;
  ptr->flag_ipa_pure_const = flag_ipa_pure_const;
  ptr->flag_ipa_reference = flag_ipa_reference;
  ptr->flag_ipa_type_escape = flag_ipa_type_escape;
  ptr->flag_ivopts = flag_ivopts;
  ptr->flag_jump_tables = flag_jump_tables;
  ptr->flag_loop_block = flag_loop_block;
  ptr->flag_loop_interchange = flag_loop_interchange;
  ptr->flag_loop_strip_mine = flag_loop_strip_mine;
  ptr->flag_errno_math = flag_errno_math;
  ptr->flag_merge_constants = flag_merge_constants;
  ptr->flag_modulo_sched = flag_modulo_sched;
  ptr->flag_move_loop_invariants = flag_move_loop_invariants;
  ptr->flag_non_call_exceptions = flag_non_call_exceptions;
  ptr->flag_omit_frame_pointer = flag_omit_frame_pointer;
  ptr->flag_regmove = flag_regmove;
  ptr->flag_optimize_sibling_calls = flag_optimize_sibling_calls;
  ptr->flag_pack_struct = flag_pack_struct;
  ptr->flag_peel_loops = flag_peel_loops;
  ptr->flag_no_peephole = flag_no_peephole;
  ptr->flag_peephole2 = flag_peephole2;
  ptr->flag_predictive_commoning = flag_predictive_commoning;
  ptr->flag_prefetch_loop_arrays = flag_prefetch_loop_arrays;
  ptr->flag_pcc_struct_return = flag_pcc_struct_return;
  ptr->flag_rename_registers = flag_rename_registers;
  ptr->flag_reorder_blocks = flag_reorder_blocks;
  ptr->flag_reorder_blocks_and_partition = flag_reorder_blocks_and_partition;
  ptr->flag_reorder_functions = flag_reorder_functions;
  ptr->flag_rerun_cse_after_loop = flag_rerun_cse_after_loop;
  ptr->flag_resched_modulo_sched = flag_resched_modulo_sched;
  ptr->flag_rounding_math = flag_rounding_math;
  ptr->flag_rtl_seqabstr = flag_rtl_seqabstr;
  ptr->flag_schedule_interblock = flag_schedule_interblock;
  ptr->flag_schedule_speculative = flag_schedule_speculative;
  ptr->flag_schedule_speculative_load = flag_schedule_speculative_load;
  ptr->flag_schedule_speculative_load_dangerous = flag_schedule_speculative_load_dangerous;
  ptr->flag_sched2_use_superblocks = flag_sched2_use_superblocks;
  ptr->flag_sched2_use_traces = flag_sched2_use_traces;
  ptr->flag_schedule_insns = flag_schedule_insns;
  ptr->flag_schedule_insns_after_reload = flag_schedule_insns_after_reload;
  ptr->flag_section_anchors = flag_section_anchors;
  ptr->flag_sel_sched_pipelining = flag_sel_sched_pipelining;
  ptr->flag_sel_sched_pipelining_outer_loops = flag_sel_sched_pipelining_outer_loops;
  ptr->flag_sel_sched_reschedule_pipelined = flag_sel_sched_reschedule_pipelined;
  ptr->flag_selective_scheduling = flag_selective_scheduling;
  ptr->flag_selective_scheduling2 = flag_selective_scheduling2;
  ptr->flag_signaling_nans = flag_signaling_nans;
  ptr->flag_signed_zeros = flag_signed_zeros;
  ptr->flag_single_precision_constant = flag_single_precision_constant;
  ptr->flag_split_ivs_in_unroller = flag_split_ivs_in_unroller;
  ptr->flag_split_wide_types = flag_split_wide_types;
  ptr->flag_strict_aliasing = flag_strict_aliasing;
  ptr->flag_thread_jumps = flag_thread_jumps;
  ptr->flag_toplevel_reorder = flag_toplevel_reorder;
  ptr->flag_trapping_math = flag_trapping_math;
  ptr->flag_trapv = flag_trapv;
  ptr->flag_tree_builtin_call_dce = flag_tree_builtin_call_dce;
  ptr->flag_tree_ccp = flag_tree_ccp;
  ptr->flag_tree_ch = flag_tree_ch;
  ptr->flag_tree_copy_prop = flag_tree_copy_prop;
  ptr->flag_tree_copyrename = flag_tree_copyrename;
  ptr->flag_tree_cselim = flag_tree_cselim;
  ptr->flag_tree_dce = flag_tree_dce;
  ptr->flag_tree_dom = flag_tree_dom;
  ptr->flag_tree_dse = flag_tree_dse;
  ptr->flag_tree_fre = flag_tree_fre;
  ptr->flag_tree_loop_distribution = flag_tree_loop_distribution;
  ptr->flag_tree_loop_im = flag_tree_loop_im;
  ptr->flag_tree_loop_ivcanon = flag_tree_loop_ivcanon;
  ptr->flag_tree_loop_linear = flag_tree_loop_linear;
  ptr->flag_tree_loop_optimize = flag_tree_loop_optimize;
  ptr->flag_tree_live_range_split = flag_tree_live_range_split;
  ptr->flag_tree_pre = flag_tree_pre;
  ptr->flag_tree_reassoc = flag_tree_reassoc;
  ptr->flag_tree_scev_cprop = flag_tree_scev_cprop;
  ptr->flag_tree_sink = flag_tree_sink;
  ptr->flag_tree_sra = flag_tree_sra;
  ptr->flag_tree_switch_conversion = flag_tree_switch_conversion;
  ptr->flag_tree_ter = flag_tree_ter;
  ptr->flag_tree_vect_loop_version = flag_tree_vect_loop_version;
  ptr->flag_tree_vectorize = flag_tree_vectorize;
  ptr->flag_tree_vrp = flag_tree_vrp;
  ptr->flag_unit_at_a_time = flag_unit_at_a_time;
  ptr->flag_unroll_all_loops = flag_unroll_all_loops;
  ptr->flag_unroll_loops = flag_unroll_loops;
  ptr->flag_unsafe_loop_optimizations = flag_unsafe_loop_optimizations;
  ptr->flag_unsafe_math_optimizations = flag_unsafe_math_optimizations;
  ptr->flag_unswitch_loops = flag_unswitch_loops;
  ptr->flag_unwind_tables = flag_unwind_tables;
  ptr->flag_var_tracking = flag_var_tracking;
  ptr->flag_var_tracking_uninit = flag_var_tracking_uninit;
  ptr->flag_variable_expansion_in_unroller = flag_variable_expansion_in_unroller;
  ptr->flag_vect_cost_model = flag_vect_cost_model;
  ptr->flag_value_profile_transformations = flag_value_profile_transformations;
  ptr->flag_web = flag_web;
  ptr->flag_whole_program = flag_whole_program;
  ptr->flag_wrapv = flag_wrapv;
}

/* Restore optimization options from a structure.  */
void
cl_optimization_restore (struct cl_optimization *ptr)
{
  align_functions = ptr->align_functions;
  align_jumps = ptr->align_jumps;
  align_labels = ptr->align_labels;
  align_loops = ptr->align_loops;
  flag_sched_stalled_insns = ptr->flag_sched_stalled_insns;
  flag_sched_stalled_insns_dep = ptr->flag_sched_stalled_insns_dep;
  optimize = ptr->optimize;
  optimize_size = ptr->optimize_size;
  flag_argument_noalias = ptr->flag_argument_noalias;
  flag_asynchronous_unwind_tables = ptr->flag_asynchronous_unwind_tables;
  flag_branch_on_count_reg = ptr->flag_branch_on_count_reg;
  flag_branch_probabilities = ptr->flag_branch_probabilities;
  flag_branch_target_load_optimize = ptr->flag_branch_target_load_optimize;
  flag_branch_target_load_optimize2 = ptr->flag_branch_target_load_optimize2;
  flag_btr_bb_exclusive = ptr->flag_btr_bb_exclusive;
  flag_caller_saves = ptr->flag_caller_saves;
  flag_no_common = ptr->flag_no_common;
  flag_conserve_stack = ptr->flag_conserve_stack;
  flag_cprop_registers = ptr->flag_cprop_registers;
  flag_crossjumping = ptr->flag_crossjumping;
  flag_cse_follow_jumps = ptr->flag_cse_follow_jumps;
  flag_cse_skip_blocks = ptr->flag_cse_skip_blocks;
  flag_cx_fortran_rules = ptr->flag_cx_fortran_rules;
  flag_cx_limited_range = ptr->flag_cx_limited_range;
  flag_data_sections = ptr->flag_data_sections;
  flag_dce = ptr->flag_dce;
  flag_defer_pop = ptr->flag_defer_pop;
  flag_delayed_branch = ptr->flag_delayed_branch;
  flag_delete_null_pointer_checks = ptr->flag_delete_null_pointer_checks;
  flag_dse = ptr->flag_dse;
  flag_early_inlining = ptr->flag_early_inlining;
  flag_exceptions = ptr->flag_exceptions;
  flag_expensive_optimizations = ptr->flag_expensive_optimizations;
  flag_finite_math_only = ptr->flag_finite_math_only;
  flag_float_store = ptr->flag_float_store;
  flag_forward_propagate = ptr->flag_forward_propagate;
  flag_gcse = ptr->flag_gcse;
  flag_gcse_after_reload = ptr->flag_gcse_after_reload;
  flag_gcse_las = ptr->flag_gcse_las;
  flag_gcse_lm = ptr->flag_gcse_lm;
  flag_gcse_sm = ptr->flag_gcse_sm;
  flag_graphite_identity = ptr->flag_graphite_identity;
  flag_guess_branch_prob = ptr->flag_guess_branch_prob;
  flag_if_conversion = ptr->flag_if_conversion;
  flag_if_conversion2 = ptr->flag_if_conversion2;
  flag_inline_functions = ptr->flag_inline_functions;
  flag_inline_functions_called_once = ptr->flag_inline_functions_called_once;
  flag_inline_small_functions = ptr->flag_inline_small_functions;
  flag_ipa_cp = ptr->flag_ipa_cp;
  flag_ipa_cp_clone = ptr->flag_ipa_cp_clone;
  flag_ipa_matrix_reorg = ptr->flag_ipa_matrix_reorg;
  flag_ipa_pta = ptr->flag_ipa_pta;
  flag_ipa_pure_const = ptr->flag_ipa_pure_const;
  flag_ipa_reference = ptr->flag_ipa_reference;
  flag_ipa_type_escape = ptr->flag_ipa_type_escape;
  flag_ivopts = ptr->flag_ivopts;
  flag_jump_tables = ptr->flag_jump_tables;
  flag_loop_block = ptr->flag_loop_block;
  flag_loop_interchange = ptr->flag_loop_interchange;
  flag_loop_strip_mine = ptr->flag_loop_strip_mine;
  flag_errno_math = ptr->flag_errno_math;
  flag_merge_constants = ptr->flag_merge_constants;
  flag_modulo_sched = ptr->flag_modulo_sched;
  flag_move_loop_invariants = ptr->flag_move_loop_invariants;
  flag_non_call_exceptions = ptr->flag_non_call_exceptions;
  flag_omit_frame_pointer = ptr->flag_omit_frame_pointer;
  flag_regmove = ptr->flag_regmove;
  flag_optimize_sibling_calls = ptr->flag_optimize_sibling_calls;
  flag_pack_struct = ptr->flag_pack_struct;
  flag_peel_loops = ptr->flag_peel_loops;
  flag_no_peephole = ptr->flag_no_peephole;
  flag_peephole2 = ptr->flag_peephole2;
  flag_predictive_commoning = ptr->flag_predictive_commoning;
  flag_prefetch_loop_arrays = ptr->flag_prefetch_loop_arrays;
  flag_pcc_struct_return = ptr->flag_pcc_struct_return;
  flag_rename_registers = ptr->flag_rename_registers;
  flag_reorder_blocks = ptr->flag_reorder_blocks;
  flag_reorder_blocks_and_partition = ptr->flag_reorder_blocks_and_partition;
  flag_reorder_functions = ptr->flag_reorder_functions;
  flag_rerun_cse_after_loop = ptr->flag_rerun_cse_after_loop;
  flag_resched_modulo_sched = ptr->flag_resched_modulo_sched;
  flag_rounding_math = ptr->flag_rounding_math;
  flag_rtl_seqabstr = ptr->flag_rtl_seqabstr;
  flag_schedule_interblock = ptr->flag_schedule_interblock;
  flag_schedule_speculative = ptr->flag_schedule_speculative;
  flag_schedule_speculative_load = ptr->flag_schedule_speculative_load;
  flag_schedule_speculative_load_dangerous = ptr->flag_schedule_speculative_load_dangerous;
  flag_sched2_use_superblocks = ptr->flag_sched2_use_superblocks;
  flag_sched2_use_traces = ptr->flag_sched2_use_traces;
  flag_schedule_insns = ptr->flag_schedule_insns;
  flag_schedule_insns_after_reload = ptr->flag_schedule_insns_after_reload;
  flag_section_anchors = ptr->flag_section_anchors;
  flag_sel_sched_pipelining = ptr->flag_sel_sched_pipelining;
  flag_sel_sched_pipelining_outer_loops = ptr->flag_sel_sched_pipelining_outer_loops;
  flag_sel_sched_reschedule_pipelined = ptr->flag_sel_sched_reschedule_pipelined;
  flag_selective_scheduling = ptr->flag_selective_scheduling;
  flag_selective_scheduling2 = ptr->flag_selective_scheduling2;
  flag_signaling_nans = ptr->flag_signaling_nans;
  flag_signed_zeros = ptr->flag_signed_zeros;
  flag_single_precision_constant = ptr->flag_single_precision_constant;
  flag_split_ivs_in_unroller = ptr->flag_split_ivs_in_unroller;
  flag_split_wide_types = ptr->flag_split_wide_types;
  flag_strict_aliasing = ptr->flag_strict_aliasing;
  flag_thread_jumps = ptr->flag_thread_jumps;
  flag_toplevel_reorder = ptr->flag_toplevel_reorder;
  flag_trapping_math = ptr->flag_trapping_math;
  flag_trapv = ptr->flag_trapv;
  flag_tree_builtin_call_dce = ptr->flag_tree_builtin_call_dce;
  flag_tree_ccp = ptr->flag_tree_ccp;
  flag_tree_ch = ptr->flag_tree_ch;
  flag_tree_copy_prop = ptr->flag_tree_copy_prop;
  flag_tree_copyrename = ptr->flag_tree_copyrename;
  flag_tree_cselim = ptr->flag_tree_cselim;
  flag_tree_dce = ptr->flag_tree_dce;
  flag_tree_dom = ptr->flag_tree_dom;
  flag_tree_dse = ptr->flag_tree_dse;
  flag_tree_fre = ptr->flag_tree_fre;
  flag_tree_loop_distribution = ptr->flag_tree_loop_distribution;
  flag_tree_loop_im = ptr->flag_tree_loop_im;
  flag_tree_loop_ivcanon = ptr->flag_tree_loop_ivcanon;
  flag_tree_loop_linear = ptr->flag_tree_loop_linear;
  flag_tree_loop_optimize = ptr->flag_tree_loop_optimize;
  flag_tree_live_range_split = ptr->flag_tree_live_range_split;
  flag_tree_pre = ptr->flag_tree_pre;
  flag_tree_reassoc = ptr->flag_tree_reassoc;
  flag_tree_scev_cprop = ptr->flag_tree_scev_cprop;
  flag_tree_sink = ptr->flag_tree_sink;
  flag_tree_sra = ptr->flag_tree_sra;
  flag_tree_switch_conversion = ptr->flag_tree_switch_conversion;
  flag_tree_ter = ptr->flag_tree_ter;
  flag_tree_vect_loop_version = ptr->flag_tree_vect_loop_version;
  flag_tree_vectorize = ptr->flag_tree_vectorize;
  flag_tree_vrp = ptr->flag_tree_vrp;
  flag_unit_at_a_time = ptr->flag_unit_at_a_time;
  flag_unroll_all_loops = ptr->flag_unroll_all_loops;
  flag_unroll_loops = ptr->flag_unroll_loops;
  flag_unsafe_loop_optimizations = ptr->flag_unsafe_loop_optimizations;
  flag_unsafe_math_optimizations = ptr->flag_unsafe_math_optimizations;
  flag_unswitch_loops = ptr->flag_unswitch_loops;
  flag_unwind_tables = ptr->flag_unwind_tables;
  flag_var_tracking = ptr->flag_var_tracking;
  flag_var_tracking_uninit = ptr->flag_var_tracking_uninit;
  flag_variable_expansion_in_unroller = ptr->flag_variable_expansion_in_unroller;
  flag_vect_cost_model = ptr->flag_vect_cost_model;
  flag_value_profile_transformations = ptr->flag_value_profile_transformations;
  flag_web = ptr->flag_web;
  flag_whole_program = ptr->flag_whole_program;
  flag_wrapv = ptr->flag_wrapv;
}

/* Print optimization options from a structure.  */
void
cl_optimization_print (FILE *file,
                       int indent_to,
                       struct cl_optimization *ptr)
{
  fputs ("\n", file);
  if (ptr->align_functions)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "align_functions",
             ptr->align_functions);

  if (ptr->align_jumps)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "align_jumps",
             ptr->align_jumps);

  if (ptr->align_labels)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "align_labels",
             ptr->align_labels);

  if (ptr->align_loops)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "align_loops",
             ptr->align_loops);

  if (ptr->flag_sched_stalled_insns)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_sched_stalled_insns",
             ptr->flag_sched_stalled_insns);

  if (ptr->flag_sched_stalled_insns_dep)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_sched_stalled_insns_dep",
             ptr->flag_sched_stalled_insns_dep);

  if (ptr->optimize)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "optimize",
             ptr->optimize);

  if (ptr->optimize_size)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "optimize_size",
             ptr->optimize_size);

  if (ptr->flag_argument_noalias)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_argument_noalias",
             ptr->flag_argument_noalias);

  if (ptr->flag_asynchronous_unwind_tables)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_asynchronous_unwind_tables",
             ptr->flag_asynchronous_unwind_tables);

  if (ptr->flag_branch_on_count_reg)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_branch_on_count_reg",
             ptr->flag_branch_on_count_reg);

  if (ptr->flag_branch_probabilities)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_branch_probabilities",
             ptr->flag_branch_probabilities);

  if (ptr->flag_branch_target_load_optimize)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_branch_target_load_optimize",
             ptr->flag_branch_target_load_optimize);

  if (ptr->flag_branch_target_load_optimize2)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_branch_target_load_optimize2",
             ptr->flag_branch_target_load_optimize2);

  if (ptr->flag_btr_bb_exclusive)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_btr_bb_exclusive",
             ptr->flag_btr_bb_exclusive);

  if (ptr->flag_caller_saves)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_caller_saves",
             ptr->flag_caller_saves);

  if (ptr->flag_no_common)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_no_common",
             ptr->flag_no_common);

  if (ptr->flag_conserve_stack)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_conserve_stack",
             ptr->flag_conserve_stack);

  if (ptr->flag_cprop_registers)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_cprop_registers",
             ptr->flag_cprop_registers);

  if (ptr->flag_crossjumping)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_crossjumping",
             ptr->flag_crossjumping);

  if (ptr->flag_cse_follow_jumps)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_cse_follow_jumps",
             ptr->flag_cse_follow_jumps);

  if (ptr->flag_cse_skip_blocks)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_cse_skip_blocks",
             ptr->flag_cse_skip_blocks);

  if (ptr->flag_cx_fortran_rules)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_cx_fortran_rules",
             ptr->flag_cx_fortran_rules);

  if (ptr->flag_cx_limited_range)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_cx_limited_range",
             ptr->flag_cx_limited_range);

  if (ptr->flag_data_sections)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_data_sections",
             ptr->flag_data_sections);

  if (ptr->flag_dce)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_dce",
             ptr->flag_dce);

  if (ptr->flag_defer_pop)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_defer_pop",
             ptr->flag_defer_pop);

  if (ptr->flag_delayed_branch)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_delayed_branch",
             ptr->flag_delayed_branch);

  if (ptr->flag_delete_null_pointer_checks)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_delete_null_pointer_checks",
             ptr->flag_delete_null_pointer_checks);

  if (ptr->flag_dse)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_dse",
             ptr->flag_dse);

  if (ptr->flag_early_inlining)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_early_inlining",
             ptr->flag_early_inlining);

  if (ptr->flag_exceptions)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_exceptions",
             ptr->flag_exceptions);

  if (ptr->flag_expensive_optimizations)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_expensive_optimizations",
             ptr->flag_expensive_optimizations);

  if (ptr->flag_finite_math_only)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_finite_math_only",
             ptr->flag_finite_math_only);

  if (ptr->flag_float_store)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_float_store",
             ptr->flag_float_store);

  if (ptr->flag_forward_propagate)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_forward_propagate",
             ptr->flag_forward_propagate);

  if (ptr->flag_gcse)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_gcse",
             ptr->flag_gcse);

  if (ptr->flag_gcse_after_reload)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_gcse_after_reload",
             ptr->flag_gcse_after_reload);

  if (ptr->flag_gcse_las)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_gcse_las",
             ptr->flag_gcse_las);

  if (ptr->flag_gcse_lm)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_gcse_lm",
             ptr->flag_gcse_lm);

  if (ptr->flag_gcse_sm)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_gcse_sm",
             ptr->flag_gcse_sm);

  if (ptr->flag_graphite_identity)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_graphite_identity",
             ptr->flag_graphite_identity);

  if (ptr->flag_guess_branch_prob)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_guess_branch_prob",
             ptr->flag_guess_branch_prob);

  if (ptr->flag_if_conversion)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_if_conversion",
             ptr->flag_if_conversion);

  if (ptr->flag_if_conversion2)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_if_conversion2",
             ptr->flag_if_conversion2);

  if (ptr->flag_inline_functions)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_inline_functions",
             ptr->flag_inline_functions);

  if (ptr->flag_inline_functions_called_once)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_inline_functions_called_once",
             ptr->flag_inline_functions_called_once);

  if (ptr->flag_inline_small_functions)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_inline_small_functions",
             ptr->flag_inline_small_functions);

  if (ptr->flag_ipa_cp)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_ipa_cp",
             ptr->flag_ipa_cp);

  if (ptr->flag_ipa_cp_clone)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_ipa_cp_clone",
             ptr->flag_ipa_cp_clone);

  if (ptr->flag_ipa_matrix_reorg)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_ipa_matrix_reorg",
             ptr->flag_ipa_matrix_reorg);

  if (ptr->flag_ipa_pta)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_ipa_pta",
             ptr->flag_ipa_pta);

  if (ptr->flag_ipa_pure_const)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_ipa_pure_const",
             ptr->flag_ipa_pure_const);

  if (ptr->flag_ipa_reference)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_ipa_reference",
             ptr->flag_ipa_reference);

  if (ptr->flag_ipa_type_escape)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_ipa_type_escape",
             ptr->flag_ipa_type_escape);

  if (ptr->flag_ivopts)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_ivopts",
             ptr->flag_ivopts);

  if (ptr->flag_jump_tables)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_jump_tables",
             ptr->flag_jump_tables);

  if (ptr->flag_loop_block)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_loop_block",
             ptr->flag_loop_block);

  if (ptr->flag_loop_interchange)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_loop_interchange",
             ptr->flag_loop_interchange);

  if (ptr->flag_loop_strip_mine)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_loop_strip_mine",
             ptr->flag_loop_strip_mine);

  if (ptr->flag_errno_math)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_errno_math",
             ptr->flag_errno_math);

  if (ptr->flag_merge_constants)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_merge_constants",
             ptr->flag_merge_constants);

  if (ptr->flag_modulo_sched)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_modulo_sched",
             ptr->flag_modulo_sched);

  if (ptr->flag_move_loop_invariants)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_move_loop_invariants",
             ptr->flag_move_loop_invariants);

  if (ptr->flag_non_call_exceptions)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_non_call_exceptions",
             ptr->flag_non_call_exceptions);

  if (ptr->flag_omit_frame_pointer)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_omit_frame_pointer",
             ptr->flag_omit_frame_pointer);

  if (ptr->flag_regmove)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_regmove",
             ptr->flag_regmove);

  if (ptr->flag_optimize_sibling_calls)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_optimize_sibling_calls",
             ptr->flag_optimize_sibling_calls);

  if (ptr->flag_pack_struct)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_pack_struct",
             ptr->flag_pack_struct);

  if (ptr->flag_peel_loops)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_peel_loops",
             ptr->flag_peel_loops);

  if (ptr->flag_no_peephole)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_no_peephole",
             ptr->flag_no_peephole);

  if (ptr->flag_peephole2)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_peephole2",
             ptr->flag_peephole2);

  if (ptr->flag_predictive_commoning)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_predictive_commoning",
             ptr->flag_predictive_commoning);

  if (ptr->flag_prefetch_loop_arrays)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_prefetch_loop_arrays",
             ptr->flag_prefetch_loop_arrays);

  if (ptr->flag_pcc_struct_return)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_pcc_struct_return",
             ptr->flag_pcc_struct_return);

  if (ptr->flag_rename_registers)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_rename_registers",
             ptr->flag_rename_registers);

  if (ptr->flag_reorder_blocks)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_reorder_blocks",
             ptr->flag_reorder_blocks);

  if (ptr->flag_reorder_blocks_and_partition)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_reorder_blocks_and_partition",
             ptr->flag_reorder_blocks_and_partition);

  if (ptr->flag_reorder_functions)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_reorder_functions",
             ptr->flag_reorder_functions);

  if (ptr->flag_rerun_cse_after_loop)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_rerun_cse_after_loop",
             ptr->flag_rerun_cse_after_loop);

  if (ptr->flag_resched_modulo_sched)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_resched_modulo_sched",
             ptr->flag_resched_modulo_sched);

  if (ptr->flag_rounding_math)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_rounding_math",
             ptr->flag_rounding_math);

  if (ptr->flag_rtl_seqabstr)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_rtl_seqabstr",
             ptr->flag_rtl_seqabstr);

  if (ptr->flag_schedule_interblock)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_schedule_interblock",
             ptr->flag_schedule_interblock);

  if (ptr->flag_schedule_speculative)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_schedule_speculative",
             ptr->flag_schedule_speculative);

  if (ptr->flag_schedule_speculative_load)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_schedule_speculative_load",
             ptr->flag_schedule_speculative_load);

  if (ptr->flag_schedule_speculative_load_dangerous)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_schedule_speculative_load_dangerous",
             ptr->flag_schedule_speculative_load_dangerous);

  if (ptr->flag_sched2_use_superblocks)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_sched2_use_superblocks",
             ptr->flag_sched2_use_superblocks);

  if (ptr->flag_sched2_use_traces)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_sched2_use_traces",
             ptr->flag_sched2_use_traces);

  if (ptr->flag_schedule_insns)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_schedule_insns",
             ptr->flag_schedule_insns);

  if (ptr->flag_schedule_insns_after_reload)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_schedule_insns_after_reload",
             ptr->flag_schedule_insns_after_reload);

  if (ptr->flag_section_anchors)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_section_anchors",
             ptr->flag_section_anchors);

  if (ptr->flag_sel_sched_pipelining)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_sel_sched_pipelining",
             ptr->flag_sel_sched_pipelining);

  if (ptr->flag_sel_sched_pipelining_outer_loops)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_sel_sched_pipelining_outer_loops",
             ptr->flag_sel_sched_pipelining_outer_loops);

  if (ptr->flag_sel_sched_reschedule_pipelined)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_sel_sched_reschedule_pipelined",
             ptr->flag_sel_sched_reschedule_pipelined);

  if (ptr->flag_selective_scheduling)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_selective_scheduling",
             ptr->flag_selective_scheduling);

  if (ptr->flag_selective_scheduling2)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_selective_scheduling2",
             ptr->flag_selective_scheduling2);

  if (ptr->flag_signaling_nans)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_signaling_nans",
             ptr->flag_signaling_nans);

  if (ptr->flag_signed_zeros)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_signed_zeros",
             ptr->flag_signed_zeros);

  if (ptr->flag_single_precision_constant)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_single_precision_constant",
             ptr->flag_single_precision_constant);

  if (ptr->flag_split_ivs_in_unroller)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_split_ivs_in_unroller",
             ptr->flag_split_ivs_in_unroller);

  if (ptr->flag_split_wide_types)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_split_wide_types",
             ptr->flag_split_wide_types);

  if (ptr->flag_strict_aliasing)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_strict_aliasing",
             ptr->flag_strict_aliasing);

  if (ptr->flag_thread_jumps)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_thread_jumps",
             ptr->flag_thread_jumps);

  if (ptr->flag_toplevel_reorder)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_toplevel_reorder",
             ptr->flag_toplevel_reorder);

  if (ptr->flag_trapping_math)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_trapping_math",
             ptr->flag_trapping_math);

  if (ptr->flag_trapv)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_trapv",
             ptr->flag_trapv);

  if (ptr->flag_tree_builtin_call_dce)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_tree_builtin_call_dce",
             ptr->flag_tree_builtin_call_dce);

  if (ptr->flag_tree_ccp)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_tree_ccp",
             ptr->flag_tree_ccp);

  if (ptr->flag_tree_ch)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_tree_ch",
             ptr->flag_tree_ch);

  if (ptr->flag_tree_copy_prop)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_tree_copy_prop",
             ptr->flag_tree_copy_prop);

  if (ptr->flag_tree_copyrename)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_tree_copyrename",
             ptr->flag_tree_copyrename);

  if (ptr->flag_tree_cselim)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_tree_cselim",
             ptr->flag_tree_cselim);

  if (ptr->flag_tree_dce)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_tree_dce",
             ptr->flag_tree_dce);

  if (ptr->flag_tree_dom)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_tree_dom",
             ptr->flag_tree_dom);

  if (ptr->flag_tree_dse)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_tree_dse",
             ptr->flag_tree_dse);

  if (ptr->flag_tree_fre)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_tree_fre",
             ptr->flag_tree_fre);

  if (ptr->flag_tree_loop_distribution)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_tree_loop_distribution",
             ptr->flag_tree_loop_distribution);

  if (ptr->flag_tree_loop_im)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_tree_loop_im",
             ptr->flag_tree_loop_im);

  if (ptr->flag_tree_loop_ivcanon)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_tree_loop_ivcanon",
             ptr->flag_tree_loop_ivcanon);

  if (ptr->flag_tree_loop_linear)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_tree_loop_linear",
             ptr->flag_tree_loop_linear);

  if (ptr->flag_tree_loop_optimize)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_tree_loop_optimize",
             ptr->flag_tree_loop_optimize);

  if (ptr->flag_tree_live_range_split)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_tree_live_range_split",
             ptr->flag_tree_live_range_split);

  if (ptr->flag_tree_pre)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_tree_pre",
             ptr->flag_tree_pre);

  if (ptr->flag_tree_reassoc)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_tree_reassoc",
             ptr->flag_tree_reassoc);

  if (ptr->flag_tree_scev_cprop)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_tree_scev_cprop",
             ptr->flag_tree_scev_cprop);

  if (ptr->flag_tree_sink)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_tree_sink",
             ptr->flag_tree_sink);

  if (ptr->flag_tree_sra)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_tree_sra",
             ptr->flag_tree_sra);

  if (ptr->flag_tree_switch_conversion)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_tree_switch_conversion",
             ptr->flag_tree_switch_conversion);

  if (ptr->flag_tree_ter)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_tree_ter",
             ptr->flag_tree_ter);

  if (ptr->flag_tree_vect_loop_version)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_tree_vect_loop_version",
             ptr->flag_tree_vect_loop_version);

  if (ptr->flag_tree_vectorize)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_tree_vectorize",
             ptr->flag_tree_vectorize);

  if (ptr->flag_tree_vrp)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_tree_vrp",
             ptr->flag_tree_vrp);

  if (ptr->flag_unit_at_a_time)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_unit_at_a_time",
             ptr->flag_unit_at_a_time);

  if (ptr->flag_unroll_all_loops)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_unroll_all_loops",
             ptr->flag_unroll_all_loops);

  if (ptr->flag_unroll_loops)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_unroll_loops",
             ptr->flag_unroll_loops);

  if (ptr->flag_unsafe_loop_optimizations)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_unsafe_loop_optimizations",
             ptr->flag_unsafe_loop_optimizations);

  if (ptr->flag_unsafe_math_optimizations)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_unsafe_math_optimizations",
             ptr->flag_unsafe_math_optimizations);

  if (ptr->flag_unswitch_loops)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_unswitch_loops",
             ptr->flag_unswitch_loops);

  if (ptr->flag_unwind_tables)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_unwind_tables",
             ptr->flag_unwind_tables);

  if (ptr->flag_var_tracking)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_var_tracking",
             ptr->flag_var_tracking);

  if (ptr->flag_var_tracking_uninit)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_var_tracking_uninit",
             ptr->flag_var_tracking_uninit);

  if (ptr->flag_variable_expansion_in_unroller)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_variable_expansion_in_unroller",
             ptr->flag_variable_expansion_in_unroller);

  if (ptr->flag_vect_cost_model)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_vect_cost_model",
             ptr->flag_vect_cost_model);

  if (ptr->flag_value_profile_transformations)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_value_profile_transformations",
             ptr->flag_value_profile_transformations);

  if (ptr->flag_web)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_web",
             ptr->flag_web);

  if (ptr->flag_whole_program)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_whole_program",
             ptr->flag_whole_program);

  if (ptr->flag_wrapv)
    fprintf (file, "%*s%s (0x%x)\n",
             indent_to, "",
             "flag_wrapv",
             ptr->flag_wrapv);

}

/* Save selected option variables into a structure.  */
void
cl_target_option_save (struct cl_target_option *ptr)
{
  if (targetm.target_option.save)
    targetm.target_option.save (ptr);

  ptr->target_flags = target_flags;
}

/* Restore selected current options from a structure.  */
void
cl_target_option_restore (struct cl_target_option *ptr)
{
  target_flags = ptr->target_flags;

  if (targetm.target_option.restore)
    targetm.target_option.restore (ptr);
}

/* Print optimization options from a structure.  */
void
cl_target_option_print (FILE *file,
                        int indent,
                        struct cl_target_option *ptr)
{
  fputs ("\n", file);
  if (ptr->target_flags)
    fprintf (file, "%*s%s (0x%x)\n",
             indent, "",
             "target_flags",
             ptr->target_flags);


  if (targetm.target_option.print)
    targetm.target_option.print (file, indent, ptr);
}
#endif
