/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.tools;

import java.io.File;
import lejos.nxt.remote.NXTCommRequest;
import lejos.nxt.remote.NXTCommand;
import lejos.pc.comm.NXTCommLogListener;
import lejos.pc.comm.NXTCommLoggable;
import lejos.pc.comm.NXTConnector;
import lejos.pc.tools.NXJUploadException;
import lejos.pc.tools.ToolsLogListener;

public class Upload
extends NXTCommLoggable {
    private NXTCommand fNXTCommand;
    private NXTConnector fConnector = new NXTConnector();

    public Upload() {
        this.fNXTCommand = new NXTCommand();
    }

    public void upload(String name, String address, int protocols, String fileName, boolean run) throws NXJUploadException {
        boolean connected;
        File f = new File(fileName);
        if (!f.exists()) {
            throw new NXJUploadException(fileName + ": No such file");
        }
        String nxtFileName = f.getName();
        int lastDot = nxtFileName.lastIndexOf(46);
        if (lastDot >= 0 && (lastDot = nxtFileName.substring(0, lastDot).lastIndexOf(46)) >= 0) {
            nxtFileName = nxtFileName.substring(lastDot + 1);
        }
        if (nxtFileName.length() > 20) {
            throw new NXJUploadException(fileName + ": Filename is more than 20 characters");
        }
        if (protocols == 0) {
            protocols = 3;
        }
        if (!(connected = this.fConnector.connectTo(name, address, protocols))) {
            throw new NXJUploadException("No NXT found - is it switched on and plugged in (for USB)?");
        }
        this.fNXTCommand.setNXTComm((NXTCommRequest)this.fConnector.getNXTComm());
        try {
            this.log(this.fNXTCommand.uploadFile(f, nxtFileName));
            if (run) {
                this.fNXTCommand.setVerify(false);
                this.fNXTCommand.startProgram(nxtFileName);
            }
            this.fNXTCommand.close();
        }
        catch (Throwable t) {
            throw new NXJUploadException("Exception during upload", t);
        }
    }

    public void addLogListener(ToolsLogListener listener) {
        this.fLogListeners.add(listener);
        this.fConnector.addLogListener((NXTCommLogListener)listener);
    }

    public void removeLogListener(ToolsLogListener listener) {
        this.fLogListeners.remove(listener);
        this.fConnector.removeLogListener((NXTCommLogListener)listener);
    }
}

