/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.tools;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import js.tinyvm.TinyVMException;
import lejos.pc.comm.NXTCommLogListener;
import lejos.pc.comm.NXTConnector;
import lejos.pc.tools.ToolsLogger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class SocketProxy {
    private String host;
    private int port;
    private DataInputStream inFromNXT;
    private DataOutputStream outToNXT;
    private ServerSocket serverSocket;
    private Socket sock;

    public void run(String[] args) throws TinyVMException {
        try {
            boolean connected;
            int protocols = 0;
            ProxyCommandLineParser fParser = new ProxyCommandLineParser();
            CommandLine commandLine = fParser.parse(args);
            boolean blueTooth = commandLine.hasOption("b");
            boolean usb = commandLine.hasOption("u");
            String name = commandLine.getOptionValue("n");
            String address = commandLine.getOptionValue("d");
            NXTConnector conn = new NXTConnector();
            conn.addLogListener((NXTCommLogListener)new ToolsLogger());
            if (blueTooth) {
                protocols |= 2;
            }
            if (usb) {
                protocols |= 1;
            }
            if (protocols == 0) {
                protocols = 3;
            }
            if (!(connected = conn.connectTo(name, address, protocols))) {
                System.err.println("Failed to connect to NXT");
                System.exit(1);
            }
            this.inFromNXT = conn.getDataIn();
            this.outToNXT = conn.getDataOut();
            boolean isServer = this.inFromNXT.readBoolean();
            if (isServer) {
                this.newSocketServer();
            } else {
                this.newSocketConnection();
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void newSocketServer() throws IOException {
        int port = this.inFromNXT.readInt();
        System.out.println("Waiting on " + port);
        this.serverSocket = new ServerSocket(port);
        while (true) {
            byte command;
            if ((command = this.inFromNXT.readByte()) != 1) {
                continue;
            }
            this.waitForConnection();
        }
    }

    private void waitForConnection() throws IOException {
        this.sock = this.serverSocket.accept();
        this.outToNXT.writeBoolean(true);
        this.outToNXT.flush();
        DataInputStream inFromSocket = new DataInputStream(this.sock.getInputStream());
        DataOutputStream outToSocket = new DataOutputStream(this.sock.getOutputStream());
        new Forward(this.sock, inFromSocket, this.outToNXT);
        new ForwardNXT(this.sock, this.inFromNXT, outToSocket);
        while (!this.sock.isClosed()) {
            Thread.yield();
        }
    }

    private void newSocketConnection() throws UnknownHostException, IOException {
        int len = this.inFromNXT.readByte();
        char[] hostChars = new char[len];
        for (int i = 0; i < len; ++i) {
            hostChars[i] = this.inFromNXT.readChar();
        }
        this.port = this.inFromNXT.readInt();
        this.host = new String(hostChars);
        System.out.println("Host: " + this.host + " port: " + this.port);
        this.sock = new Socket(this.host, this.port);
        this.outToNXT.writeBoolean(true);
        this.outToNXT.flush();
        DataInputStream inFromSocket = new DataInputStream(this.sock.getInputStream());
        DataOutputStream outToSocket = new DataOutputStream(this.sock.getOutputStream());
        new Forward(this.sock, inFromSocket, this.outToNXT);
        new ForwardNXT(this.sock, this.inFromNXT, outToSocket);
    }

    public static void main(String[] args) {
        try {
            new SocketProxy().run(args);
        }
        catch (Throwable t) {
            System.err.println("An error has occurred: " + t.getMessage());
        }
    }

    class ProxyCommandLineParser {
        ProxyCommandLineParser() {
        }

        public CommandLine parse(String[] args) throws TinyVMException {
            CommandLine result;
            assert (args != null) : "Precondition: args != null";
            Options options = new Options();
            options.addOption("h", "help", false, "help");
            options.addOption("b", "bluetooth", false, "use bluetooth");
            options.addOption("u", "usb", false, "use usb");
            Option nameOption = new Option("n", "name", true, "look for named NXT");
            nameOption.setArgName("name");
            options.addOption(nameOption);
            Option addressOption = new Option("d", "address", true, "look for NXT with given address");
            addressOption.setArgName("address");
            options.addOption(addressOption);
            try {
                try {
                    result = new GnuParser().parse(options, args);
                }
                catch (ParseException e) {
                    throw new TinyVMException(e.getMessage(), (Throwable)e);
                }
                if (result.hasOption("h")) {
                    throw new TinyVMException("Help:");
                }
            }
            catch (TinyVMException e) {
                StringWriter writer = new StringWriter();
                PrintWriter printWriter = new PrintWriter(writer);
                printWriter.println(e.getMessage());
                String commandName = System.getProperty("COMMAND_NAME", "lejos.pc.tools.SocketProxy");
                String usage = commandName + " [options]";
                new HelpFormatter().printHelp(printWriter, 80, usage.toString(), null, options, 0, 2, null);
                throw new TinyVMException(writer.toString());
            }
            assert (result != null) : "Postconditon: result != null";
            return result;
        }
    }

    private class ForwardNXT
    extends Thread {
        private static final byte ESCAPE = -1;
        private static final byte ESCAPE_CLOSE = 1;
        private DataOutputStream dout;
        private DataInputStream din;
        private Socket sock;

        public ForwardNXT(Socket sock, DataInputStream dis, DataOutputStream dos) {
            this.din = dis;
            this.dout = dos;
            this.sock = sock;
            this.start();
        }

        public void run() {
            try {
                while (true) {
                    int in;
                    if ((in = this.din.read()) < 0) {
                        this.sock.close();
                        return;
                    }
                    if ((byte)in == -1) {
                        in = this.din.read();
                        if ((byte)in == 1) {
                            this.sock.close();
                            return;
                        }
                        in = -1;
                    }
                    this.dout.writeByte(in);
                    this.dout.flush();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return;
            }
        }
    }

    private class Forward
    extends Thread {
        private DataOutputStream dout;
        private DataInputStream din;
        private Socket sock;

        public Forward(Socket sock, DataInputStream dis, DataOutputStream dos) {
            this.din = dis;
            this.dout = dos;
            this.sock = sock;
            this.start();
        }

        public void run() {
            try {
                while (true) {
                    int in;
                    if ((in = this.din.read()) < 0) {
                        this.sock.close();
                        return;
                    }
                    this.dout.writeByte(in);
                    this.dout.flush();
                }
            }
            catch (IOException iOException) {
                return;
            }
        }
    }
}

