/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.tools;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import lejos.pc.tools.LabeledGauge;

public class SensorPanel
extends JPanel {
    private static final long serialVersionUID = 3592127880184905255L;
    private static final int DEFAULT_MAX_RAW_VALUE = 1024;
    private static final int DEFAULT_MAX_SCALED_VALUE = 100;
    private static final Dimension PANEL_SIZE = new Dimension(120, 350);
    private LabeledGauge rawGauge;
    private LabeledGauge scaledGauge;
    private JLabel nameLabel;
    private JLabel typeLabel = new JLabel("No Sensor");

    public SensorPanel(String name) {
        this.nameLabel = new JLabel(name);
        this.rawGauge = new LabeledGauge("Raw", 1024);
        this.scaledGauge = new LabeledGauge("Scaled", 100);
        this.add(this.nameLabel);
        this.add(this.rawGauge);
        this.add(this.scaledGauge);
        this.add(this.typeLabel);
        Dimension size = PANEL_SIZE;
        this.setSize(size);
        this.setMaximumSize(size);
        this.setPreferredSize(size);
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    public void setRawVal(int val) {
        this.rawGauge.setVal(val);
    }

    public void setRawMaxVal(int val) {
        this.rawGauge.setMaxVal(val);
    }

    public void setScaledVal(int val) {
        this.scaledGauge.setVal(val);
    }

    public void setScaledMaxVal(int val) {
        this.scaledGauge.setMaxVal(val);
    }

    public void setType(String type) {
        this.typeLabel.setText(type);
    }
}

