/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.tools;

import javax.swing.table.AbstractTableModel;
import lejos.pc.comm.NXTConnectionState;
import lejos.pc.comm.NXTInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NXTConnectionModel
extends AbstractTableModel {
    private static final long serialVersionUID = 3540880662561527501L;
    private static final String[] columnNames = new String[]{"Name", "Protocol", "Address", "Status"};
    private static final int NUM_COLUMNS = 4;
    private Object[][] nxtData;
    private int numNXTs;

    public NXTConnectionModel(NXTInfo[] nxts, int numNXTs) {
        this.setData(nxts, numNXTs);
    }

    public void setData(NXTInfo[] nxts, int numNXTs) {
        this.numNXTs = numNXTs;
        this.nxtData = new Object[numNXTs][4];
        for (int i = 0; i < numNXTs; ++i) {
            this.nxtData[i][0] = nxts[i].name;
            this.nxtData[i][1] = nxts[i].protocol == 1 ? "USB" : "Bluetooth";
            this.nxtData[i][2] = nxts[i].deviceAddress == null ? "" : nxts[i].deviceAddress;
            this.nxtData[i][3] = NXTConnectionState.DISCONNECTED;
        }
    }

    public void setConnected(int row, NXTConnectionState state) {
        this.nxtData[row][3] = state;
    }

    @Override
    public int getRowCount() {
        return this.numNXTs;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.nxtData[row][column];
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return this.nxtData[0][column].getClass();
    }
}

