/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.tools;

import java.io.IOException;
import lejos.pc.comm.NXTCommException;
import lejos.pc.comm.NXTConnector;
import lejos.pc.comm.NXTInfo;
import lejos.pc.comm.NXTSamba;
import lejos.pc.tools.CommandLineParser;
import lejos.pc.tools.NXJFlashUI;
import lejos.pc.tools.NXJFlashUpdate;
import org.apache.commons.cli.CommandLine;

public class NXJFlash
implements NXJFlashUI {
    NXJFlashUpdate updater = new NXJFlashUpdate(this);

    public void message(String str) {
        System.out.println(str);
    }

    public void progress(String str, int percent) {
        System.out.printf("%s %3d%%\r", str, percent);
        System.out.flush();
    }

    int getChoice() throws IOException {
        while (System.in.available() > 0) {
            System.in.read();
        }
        char choice = (char)System.in.read();
        while (System.in.available() > 0) {
            System.in.read();
        }
        if (choice >= '0' && choice <= '9') {
            return choice - 48;
        }
        return -1;
    }

    NXTSamba openDevice() throws NXTCommException, IOException {
        NXTSamba samba = this.updater.openSambaDevice(0);
        if (samba == null) {
            System.out.println("No devices in firmware update mode were found.\nSearching for other NXT devices.");
            NXTConnector conn = new NXTConnector();
            NXTInfo[] nxts = conn.search(null, null, 1);
            if (nxts.length <= 0) {
                System.out.println("No NXT found. Please check that the device is turned on and connected.");
                return null;
            }
            int devNo = 0;
            do {
                System.out.println("The following NXT devices have been found:");
                for (int i = 0; i < nxts.length; ++i) {
                    System.out.println("  " + (i + 1) + ":  " + nxts[i].name + "  " + nxts[i].deviceAddress);
                }
                System.out.println("Select the device to update, or enter 0 to exit.");
                System.out.print("Device number to update: ");
            } while ((devNo = this.getChoice()) < 0 || devNo > nxts.length);
            if (devNo == 0) {
                return null;
            }
            this.updater.resetDevice(nxts[devNo - 1]);
            samba = this.updater.openSambaDevice(30000);
        }
        if (samba == null) {
            System.out.println("No NXT found. Please check that the device is turned on and connected.");
        }
        return samba;
    }

    public void run(String[] args) throws Exception {
        NXTSamba nxt;
        String home;
        CommandLineParser parser = new CommandLineParser();
        CommandLine commandLine = parser.parse(args);
        String vmFile = null;
        String menuFile = null;
        if (commandLine.getArgs().length > 0) {
            vmFile = commandLine.getArgs()[0];
        }
        if (commandLine.getArgs().length > 1) {
            menuFile = commandLine.getArgs()[1];
        }
        if ((home = System.getProperty("nxj.home")) == null) {
            home = System.getenv("NXJ_HOME");
        }
        byte[] memoryImage = this.updater.createFirmwareImage(vmFile, menuFile, home);
        byte[] fs = null;
        if (commandLine.hasOption("f")) {
            fs = this.updater.createFilesystemImage();
        }
        if ((nxt = this.openDevice()) != null) {
            this.updater.updateDevice(nxt, memoryImage, fs, true, true, true);
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            NXJFlash instance = new NXJFlash();
            instance.run(args);
        }
        catch (Throwable t) {
            System.err.println("an error occurred: " + t.getMessage());
        }
    }
}

