/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.tools;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import lejos.nxt.remote.DeviceInfo;
import lejos.nxt.remote.FileInfo;
import lejos.nxt.remote.FirmwareInfo;
import lejos.nxt.remote.InputValues;
import lejos.nxt.remote.NXTCommRequest;
import lejos.nxt.remote.NXTCommand;
import lejos.nxt.remote.NXTProtocol;
import lejos.pc.comm.NXTComm;
import lejos.pc.comm.NXTCommException;
import lejos.pc.comm.NXTCommFactory;
import lejos.pc.comm.NXTCommLogListener;
import lejos.pc.comm.NXTConnectionState;
import lejos.pc.comm.NXTConnector;
import lejos.pc.comm.NXTInfo;
import lejos.pc.tools.ConsoleViewComms;
import lejos.pc.tools.ConsoleViewerUI;
import lejos.pc.tools.DataViewComms;
import lejos.pc.tools.DataViewerUI;
import lejos.pc.tools.ExtendedFileModel;
import lejos.pc.tools.LabeledGauge;
import lejos.pc.tools.NXTConnectionModel;
import lejos.pc.tools.SensorPanel;
import lejos.pc.tools.ToolsLogger;

public class NXJControl
implements ListSelectionListener,
NXTProtocol,
DataViewerUI,
ConsoleViewerUI {
    public static final int MAX_FILES = 30;
    private static final int LCP = 0;
    private static final int RCONSOLE = 1;
    private static final int DATALOG = 2;
    private static final Dimension frameSize = new Dimension(800, 620);
    private static final Dimension filesAreaSize = new Dimension(780, 300);
    private static final Dimension filesPanelSize = new Dimension(500, 400);
    private static final Dimension nxtButtonsPanelSize = new Dimension(220, 130);
    private static final Dimension filesButtonsPanelSize = new Dimension(700, 100);
    private static final Dimension nxtTableSize = new Dimension(500, 100);
    private static final Dimension labelSize = new Dimension(60, 20);
    private static final Dimension sliderSize = new Dimension(150, 50);
    private static final Dimension tachoSize = new Dimension(100, 20);
    private static final Dimension infoPanelSize = new Dimension(300, 110);
    private static final Dimension namePanelSize = new Dimension(300, 110);
    private static final Dimension innerInfoPanelSize = new Dimension(280, 70);
    private static final Dimension tonePanelSize = new Dimension(300, 110);
    private static final Dimension i2cPanelSize = new Dimension(480, 170);
    private static final int fileNameColumnWidth = 200;
    private static final String title = "NXJ Control Center";
    private static final String[] sensorTypes = new String[]{"No Sensor", "Touch Sensor", "Temperature", "RCX Light", "RCX Rotation", "Light Active", "Light Inactive", "Sound DB", "Sound DBA", "Custom", "I2C", "I2C 9V"};
    private static final int[] sensorTypeValues = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private static final String[] sensors = new String[]{"S1", "S2", "S3", "S4"};
    private static final String[] sensorModes = new String[]{"Raw", "Boolean", "Percentage"};
    private static final int[] sensorModeValues = new int[]{0, 32, -128};
    private final String[] motorNames = new String[]{"A", "B", "C"};
    private Cursor hourglassCursor = new Cursor(3);
    private Cursor normalCursor = new Cursor(0);
    private JFrame frame = new JFrame("NXJ Control Center");
    private JTable nxtTable = new JTable();
    private JScrollPane nxtTablePane;
    private JTextField nameText = new JTextField(8);
    private JTable table;
    private JScrollPane tablePane;
    private JPanel filesPanel = new JPanel();
    private JPanel consolePanel = new JPanel();
    private JPanel monitorPanel = new JPanel();
    private JPanel controlPanel = new JPanel();
    private JPanel dataPanel = new JPanel();
    private JPanel otherPanel = new JPanel();
    private JTextArea theConsoleLog = new JTextArea(22, 68);
    private JTextArea theDataLog = new JTextArea(20, 68);
    private LabeledGauge batteryGauge = new LabeledGauge("Battery", 10000);
    private JSlider[] sliders = new JSlider[3];
    private JLabel[] tachos = new JLabel[3];
    private JCheckBox[] selectors = new JCheckBox[3];
    private JCheckBox[] reversors = new JCheckBox[3];
    private JTextField[] limits = new JTextField[3];
    private JButton[] resetButtons = new JButton[3];
    private JButton connectButton = new JButton("Connect");
    private JButton dataDownloadButton = new JButton("Download");
    private TextField dataColumns = new TextField("8", 2);
    private JButton searchButton = new JButton("Search");
    private JButton monitorUpdateButton = new JButton("Update");
    private JButton forwardButton = new JButton("Forward");
    private JButton backwardButton = new JButton("Backward");
    private JButton leftButton = new JButton("Turn Left");
    private JButton rightButton = new JButton("Turn Right");
    private JButton deleteButton = new JButton("Delete Files");
    private JButton uploadButton = new JButton("Upload file");
    private JButton downloadButton = new JButton("Download file");
    private JButton runButton = new JButton("Run program");
    private JButton nameButton = new JButton("Set Name");
    private JButton formatButton = new JButton("Format");
    private JRadioButton usbButton = new JRadioButton("USB");
    private JRadioButton bluetoothButton = new JRadioButton("Bluetooth");
    private JRadioButton bothButton = new JRadioButton("Both", true);
    private JRadioButton lcpButton = new JRadioButton("LCP", true);
    private JRadioButton rconsoleButton = new JRadioButton("RConsole");
    private JRadioButton datalogButton = new JRadioButton("Data Log");
    private JFormattedTextField freq = new JFormattedTextField(new Integer(500));
    private JFormattedTextField duration = new JFormattedTextField(new Integer(1000));
    private JComboBox sensorList = new JComboBox<String>(sensors);
    private JComboBox sensorList2 = new JComboBox<String>(sensors);
    private JComboBox sensorModeList = new JComboBox<String>(sensorModes);
    private JComboBox sensorTypeList = new JComboBox<String>(sensorTypes);
    private SensorPanel[] sensorPanels = new SensorPanel[]{new SensorPanel("Sensor Port 1"), new SensorPanel("Sensor Port 2"), new SensorPanel("Sensor Port 3"), new SensorPanel("Sensor Port 4")};
    private JFormattedTextField txData = new JFormattedTextField();
    private JFormattedTextField rxDataLength = new JFormattedTextField(new Integer(1));
    private JLabel rxData = new JLabel();
    private Border etchedBorder = BorderFactory.createEtchedBorder();
    private JButton soundButton = new JButton("Play Sound File");
    private JTextField newName = new JTextField(16);
    private JTabbedPane tabbedPane = new JTabbedPane();
    private NXTConnectionModel nm;
    private ExtendedFileModel fm;
    private NXJControl control;
    private NXTCommand nxtCommand;
    private NXTCommand[] nxtCommands;
    private NXTComm[] nxtComms;
    private NXTConnector conn = new NXTConnector();
    private NXTInfo[] nxts;
    private InputValues[] sensorValues = new InputValues[4];
    private int mv;
    private int appProtocol = 0;
    private int rowLength = 8;
    private int recordCount;
    private DataViewComms dvc;
    private DataViewComms[] dvcs;
    private ConsoleViewComms cvc;
    private ConsoleViewComms[] cvcs;
    private static final NumberFormat FORMAT_FLOAT = NumberFormat.getNumberInstance();

    public static void main(String[] args) {
        try {
            NXJControl instance = new NXJControl();
            instance.run();
        }
        catch (Throwable t) {
            System.err.println("Error: " + t.getMessage());
        }
    }

    private void run() {
        WindowAdapter listener = new WindowAdapter(){

            public void windowClosing(WindowEvent w) {
                NXJControl.this.closeAll();
                System.exit(0);
            }
        };
        this.frame.addWindowListener(listener);
        this.conn.addLogListener((NXTCommLogListener)new ToolsLogger());
        this.control = this;
        this.searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                NXJControl.this.search();
            }
        });
        this.connectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                NXJControl.this.connect();
            }
        });
        this.dataDownloadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                NXJControl.this.recordCount = 0;
                try {
                    NXJControl.this.rowLength = Integer.parseInt(NXJControl.this.dataColumns.getText());
                }
                catch (NumberFormatException ex) {
                    System.out.println(NXJControl.this.dataColumns.getText() + " is not a number, default reset to 8");
                }
                NXJControl.this.dvc.startDownload();
            }
        });
        this.monitorUpdateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                NXJControl.this.getSensorValues();
                NXJControl.this.updateSensors();
            }
        });
        this.lcpButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (NXJControl.this.appProtocol == NXJControl.this.getAppProtocol()) {
                    return;
                }
                if (NXJControl.this.lcpButton.isSelected()) {
                    NXJControl.this.createLCPTabs();
                    NXJControl.this.appProtocol = 0;
                }
            }
        });
        this.rconsoleButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (NXJControl.this.appProtocol == NXJControl.this.getAppProtocol()) {
                    return;
                }
                if (NXJControl.this.rconsoleButton.isSelected()) {
                    NXJControl.this.createConsoleTabs();
                    NXJControl.this.appProtocol = 1;
                }
            }
        });
        this.datalogButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (NXJControl.this.appProtocol == NXJControl.this.getAppProtocol()) {
                    return;
                }
                if (NXJControl.this.datalogButton.isSelected()) {
                    NXJControl.this.createDataLogTabs();
                    NXJControl.this.appProtocol = 2;
                }
            }
        });
        this.createNXTSelectionPanel();
        this.createConsolePanel();
        this.createDataPanel();
        this.createMonitorPanel();
        this.createControlPanel();
        this.createMiscellaneousPanel();
        this.filesPanel.setPreferredSize(filesPanelSize);
        this.frame.setPreferredSize(frameSize);
        this.createLCPTabs();
        this.frame.add(this.tabbedPane);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private void showFiles() {
        this.createFilesTable();
        this.filesPanel.removeAll();
        this.createFilesPanel();
        this.otherPanel.removeAll();
        this.createMiscellaneousPanel();
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                NXJControl.this.deleteFiles();
            }
        });
        this.uploadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                NXJControl.this.upload();
            }
        });
        this.downloadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                NXJControl.this.download();
            }
        });
        this.runButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                NXJControl.this.runFile();
            }
        });
        this.nameButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                NXJControl.this.rename(NXJControl.this.newName.getText());
            }
        });
        this.soundButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NXJControl.this.playSoundFile();
            }
        });
        this.formatButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NXJControl.this.format();
            }
        });
    }

    private void createNXTSelectionPanel() {
        JPanel nxtPanel = new JPanel();
        this.nxtTablePane = new JScrollPane(this.nxtTable);
        this.nxtTablePane.setPreferredSize(nxtTableSize);
        nxtPanel.add((Component)new JScrollPane(this.nxtTablePane), "West");
        this.frame.getContentPane().add((Component)nxtPanel, "North");
        this.nxtTable.setPreferredScrollableViewportSize(nxtButtonsPanelSize);
        JLabel nameLabel = new JLabel("Name: ");
        JPanel namePanel = new JPanel();
        namePanel.add(nameLabel);
        namePanel.add(this.nameText);
        JPanel nxtButtonPanel = new JPanel();
        nxtButtonPanel.add(namePanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.searchButton);
        buttonPanel.add(this.connectButton);
        nxtButtonPanel.add(buttonPanel);
        nxtButtonPanel.add(this.usbButton);
        nxtButtonPanel.add(this.bluetoothButton);
        nxtButtonPanel.add(this.bothButton);
        ButtonGroup protocolButtonGroup = new ButtonGroup();
        protocolButtonGroup.add(this.usbButton);
        protocolButtonGroup.add(this.bluetoothButton);
        protocolButtonGroup.add(this.bothButton);
        nxtButtonPanel.add(this.lcpButton);
        nxtButtonPanel.add(this.rconsoleButton);
        nxtButtonPanel.add(this.datalogButton);
        ButtonGroup appProtocolButtonGroup = new ButtonGroup();
        appProtocolButtonGroup.add(this.lcpButton);
        appProtocolButtonGroup.add(this.rconsoleButton);
        appProtocolButtonGroup.add(this.datalogButton);
        nxtButtonPanel.setPreferredSize(nxtButtonsPanelSize);
        nxtPanel.add((Component)nxtButtonPanel, "East");
    }

    private void createConsolePanel() {
        JLabel consoleTitleLabel = new JLabel("Output from RConsole");
        this.consolePanel.add(consoleTitleLabel);
        this.consolePanel.add(new JScrollPane(this.theConsoleLog));
    }

    private void createDataPanel() {
        JLabel dataTitleLabel = new JLabel("Data Log");
        this.dataPanel.add((Component)dataTitleLabel, "North");
        this.dataPanel.add((Component)new JScrollPane(this.theDataLog), "Center");
        JPanel commandPanel = new JPanel();
        commandPanel.add(new JLabel("Columns:"));
        commandPanel.add(this.dataColumns);
        commandPanel.add(this.dataDownloadButton);
        this.dataPanel.add((Component)commandPanel, "South");
    }

    private void createMonitorPanel() {
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        JPanel batteryPanel = new JPanel();
        batteryPanel.setBorder(this.etchedBorder);
        batteryPanel.add(this.batteryGauge);
        leftPanel.add(batteryPanel);
        JPanel setSensorPanel = new JPanel();
        setSensorPanel.setBorder(this.etchedBorder);
        setSensorPanel.setLayout(new BoxLayout(setSensorPanel, 1));
        JLabel setSensorLabel = new JLabel("Set Sensor type & mode");
        JPanel labelPanel = new JPanel();
        labelPanel.add(setSensorLabel);
        setSensorPanel.add(labelPanel);
        JPanel portPanel = new JPanel();
        JLabel portLabel = new JLabel("Port:");
        portPanel.add(portLabel);
        portPanel.add(this.sensorList2);
        setSensorPanel.add(portPanel);
        JPanel typePanel = new JPanel();
        JLabel typeLabel = new JLabel("Type:");
        typePanel.add(typeLabel);
        typePanel.add(this.sensorTypeList);
        setSensorPanel.add(typePanel);
        JPanel modePanel = new JPanel();
        JLabel modeLabel = new JLabel("Mode:");
        modePanel.add(modeLabel);
        modePanel.add(this.sensorModeList);
        setSensorPanel.add(modePanel);
        JButton setSensorButton = new JButton("Set Sensor");
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(setSensorButton);
        setSensorPanel.add(buttonPanel);
        leftPanel.add(setSensorPanel);
        setSensorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NXJControl.this.setSensor();
            }
        });
        this.monitorPanel.add(leftPanel);
        for (int i = 0; i < 4; ++i) {
            this.monitorPanel.add(this.sensorPanels[i]);
        }
        this.monitorPanel.add(this.monitorUpdateButton);
    }

    private void createLCPTabs() {
        this.tabbedPane.removeAll();
        this.tabbedPane.addTab("Files", this.filesPanel);
        this.tabbedPane.addTab("Monitor", this.monitorPanel);
        this.tabbedPane.addTab("Control", this.controlPanel);
        this.tabbedPane.addTab("Miscellaneous", this.otherPanel);
    }

    private void createConsoleTabs() {
        this.tabbedPane.removeAll();
        this.tabbedPane.addTab("Console", this.consolePanel);
    }

    private void createDataLogTabs() {
        this.tabbedPane.removeAll();
        this.tabbedPane.addTab("Data Log", this.dataPanel);
    }

    private void createFilesPanel() {
        this.filesPanel.add((Component)this.tablePane, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.deleteButton);
        buttonPanel.add(this.uploadButton);
        buttonPanel.add(this.downloadButton);
        buttonPanel.add(this.runButton);
        buttonPanel.add(this.soundButton);
        buttonPanel.add(this.formatButton);
        buttonPanel.setPreferredSize(filesButtonsPanelSize);
        this.filesPanel.add((Component)buttonPanel, "South");
    }

    private void createMiscellaneousPanel() {
        this.createInfoPanel();
        this.createTonePanel();
        this.createI2cPanel();
        this.createNamePanel();
    }

    private void createNamePanel() {
        JPanel namePanel = new JPanel();
        namePanel.setPreferredSize(namePanelSize);
        namePanel.setLayout(new BoxLayout(namePanel, 1));
        namePanel.setBorder(this.etchedBorder);
        JPanel titlePanel = new JPanel();
        JLabel title = new JLabel("Change Friendly Name");
        JPanel newNamePanel = new JPanel();
        JLabel nameLabel = new JLabel("New name:");
        titlePanel.add(title);
        namePanel.add(titlePanel);
        newNamePanel.add(nameLabel);
        newNamePanel.add(this.newName);
        namePanel.add(newNamePanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.nameButton);
        namePanel.add(buttonPanel);
        this.otherPanel.add(namePanel);
    }

    private void createInfoPanel() {
        JPanel infoPanel = new JPanel();
        DeviceInfo di = null;
        FirmwareInfo fi = null;
        infoPanel.setLayout(new GridLayout(4, 2));
        JLabel freeFlashLabel = new JLabel("Free flash:  ");
        String protocolVersionString = "Unknown";
        String firmwareVersionString = "Unknown";
        String freeFlashString = "Unknown";
        if (this.nxtCommand != null) {
            try {
                di = this.nxtCommand.getDeviceInfo();
                fi = this.nxtCommand.getFirmwareVersion();
                protocolVersionString = fi.protocolVersion;
                firmwareVersionString = fi.firmwareVersion;
                freeFlashString = "" + di.freeFlash;
            }
            catch (IOException ioe) {
                this.showMessage("IO Exception getting device information");
            }
        }
        JLabel freeFlash = new JLabel(freeFlashString);
        infoPanel.add(freeFlashLabel);
        infoPanel.add(freeFlash);
        JLabel firmwareVersionLabel = new JLabel("Firmware version:");
        JLabel firmwareVersion = new JLabel(firmwareVersionString);
        infoPanel.add(firmwareVersionLabel);
        infoPanel.add(firmwareVersion);
        JLabel protocolVersionLabel = new JLabel("Protocol version:");
        JLabel protocolVersion = new JLabel(protocolVersionString);
        infoPanel.add(protocolVersionLabel);
        infoPanel.add(protocolVersion);
        infoPanel.setPreferredSize(innerInfoPanelSize);
        JPanel outerInfoPanel = new JPanel();
        outerInfoPanel.setPreferredSize(infoPanelSize);
        outerInfoPanel.setBorder(this.etchedBorder);
        JPanel headingPanel = new JPanel();
        JLabel headingLabel = new JLabel("Brick Information");
        headingPanel.add(headingLabel);
        outerInfoPanel.add(headingPanel);
        outerInfoPanel.add(infoPanel);
        this.otherPanel.add(outerInfoPanel);
    }

    private void createTonePanel() {
        JPanel tonePanel = new JPanel();
        tonePanel.setLayout(new BoxLayout(tonePanel, 1));
        JPanel toneHeading = new JPanel();
        JLabel toneLabel = new JLabel("Play tone");
        toneHeading.add(toneLabel);
        tonePanel.add(toneHeading);
        JPanel freqPanel = new JPanel();
        JLabel freqLabel = new JLabel("Frequency:");
        this.freq.setColumns(5);
        freqLabel.setLabelFor(this.freq);
        JLabel durationLabel = new JLabel("Duration:");
        this.duration.setColumns(5);
        durationLabel.setLabelFor(this.duration);
        JButton play = new JButton("Play tone");
        freqPanel.add(freqLabel);
        freqPanel.add(this.freq);
        freqPanel.add(durationLabel);
        freqPanel.add(this.duration);
        tonePanel.add(freqPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(play);
        tonePanel.add(buttonPanel);
        tonePanel.setPreferredSize(tonePanelSize);
        tonePanel.setBorder(this.etchedBorder);
        this.otherPanel.add(tonePanel);
        play.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NXJControl.this.playTone();
            }
        });
    }

    private void createI2cPanel() {
        JPanel i2cPanel = new JPanel();
        i2cPanel.setLayout(new BoxLayout(i2cPanel, 1));
        JPanel labelPanel = new JPanel();
        JLabel i2cTester = new JLabel("I2C Device Tester");
        labelPanel.add(i2cTester);
        i2cPanel.add(labelPanel);
        JPanel topPanel = new JPanel();
        JPanel sensorSelectPanel = new JPanel();
        JLabel sensorLabel = new JLabel("Port:");
        sensorSelectPanel.add(sensorLabel);
        sensorSelectPanel.add(this.sensorList);
        JLabel addressLabel = new JLabel("Address:");
        JFormattedTextField address = new JFormattedTextField(new Integer(2));
        address.setColumns(2);
        sensorSelectPanel.add(addressLabel);
        sensorSelectPanel.add(address);
        topPanel.add(sensorSelectPanel);
        JPanel rxlPanel = new JPanel();
        JLabel rxlLabel = new JLabel("RxData length:");
        rxlLabel.setLabelFor(this.rxDataLength);
        rxlPanel.add(rxlLabel);
        rxlPanel.add(this.rxDataLength);
        topPanel.add(rxlPanel);
        i2cPanel.add(topPanel);
        this.txData.setColumns(32);
        JPanel txPanel = new JPanel();
        JLabel txLabel = new JLabel("Send (hex):");
        txLabel.setLabelFor(this.txData);
        txPanel.add(txLabel);
        txPanel.add(this.txData);
        i2cPanel.add(txPanel);
        this.rxDataLength.setColumns(2);
        JPanel rxPanel = new JPanel();
        JLabel rxLabel = new JLabel("Received (hex):");
        rxLabel.setLabelFor(this.rxData);
        rxPanel.add(rxLabel);
        rxPanel.add(this.rxData);
        i2cPanel.add(rxPanel);
        JButton txDataSend = new JButton("Send");
        JButton i2cStatus = new JButton("Status");
        JButton rxDataReceive = new JButton("Receive");
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(txDataSend);
        buttonsPanel.add(i2cStatus);
        buttonsPanel.add(rxDataReceive);
        i2cPanel.add(buttonsPanel);
        i2cPanel.setBorder(BorderFactory.createEtchedBorder());
        i2cPanel.setPreferredSize(i2cPanelSize);
        this.otherPanel.add(i2cPanel);
        txDataSend.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NXJControl.this.i2cSend();
            }
        });
        rxDataReceive.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NXJControl.this.i2cReceive();
            }
        });
        i2cStatus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NXJControl.this.i2cStatus();
            }
        });
    }

    private void createFilesTable() {
        this.fm = new ExtendedFileModel(this.nxtCommand);
        this.table = new JTable(this.fm);
        this.table.setAutoResizeMode(0);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.tablePane = new JScrollPane(this.table);
        this.tablePane.setPreferredSize(filesAreaSize);
    }

    private JPanel createMotorPanel(int index) {
        JButton resetButton;
        JCheckBox selected;
        JSlider slider;
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.sliders[index] = slider = new JSlider(0, 100);
        slider.setMajorTickSpacing(50);
        slider.setMinorTickSpacing(10);
        slider.setPaintLabels(true);
        slider.setPaintTicks(true);
        JLabel label = new JLabel("   " + this.motorNames[index]);
        label.setPreferredSize(labelSize);
        panel.add(label);
        final JLabel value = new JLabel("    " + slider.getValue());
        value.setPreferredSize(labelSize);
        panel.add(value);
        slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent c) {
                value.setText(String.format("%6d", slider.getValue()));
            }
        });
        slider.setPreferredSize(sliderSize);
        panel.add(slider);
        JLabel tacho = new JLabel("");
        tacho.setPreferredSize(tachoSize);
        this.tachos[index] = tacho;
        panel.add(tacho);
        this.selectors[index] = selected = new JCheckBox();
        selected.setPreferredSize(labelSize);
        panel.add(selected);
        JCheckBox reverse = new JCheckBox();
        reverse.setPreferredSize(labelSize);
        this.reversors[index] = reverse;
        panel.add(reverse);
        JTextField limit = new JTextField(6);
        limit.setMaximumSize(new Dimension(60, 20));
        this.limits[index] = limit;
        panel.add(limit);
        this.resetButtons[index] = resetButton = new JButton("Reset");
        panel.add(resetButton);
        resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NXJControl.this.resetTacho((JButton)e.getSource());
            }
        });
        panel.setBorder(BorderFactory.createEtchedBorder());
        return panel;
    }

    private JPanel createMotorsHeader() {
        JPanel labelPanel = new JPanel();
        JLabel motorLabel = new JLabel("Motor");
        motorLabel.setPreferredSize(labelSize);
        JLabel speedLabel = new JLabel("Speed");
        speedLabel.setPreferredSize(labelSize);
        JLabel sliderLabel = new JLabel("          Set speed");
        sliderLabel.setPreferredSize(sliderSize);
        JLabel tachoLabel = new JLabel("Tachometer");
        tachoLabel.setPreferredSize(tachoSize);
        JLabel selectedLabel = new JLabel("Selected");
        selectedLabel.setPreferredSize(labelSize);
        JLabel reverseLabel = new JLabel("Reverse");
        reverseLabel.setPreferredSize(labelSize);
        JLabel limitLabel = new JLabel("Limit");
        limitLabel.setPreferredSize(labelSize);
        JLabel resetLabel = new JLabel("Reset");
        resetLabel.setPreferredSize(labelSize);
        labelPanel.add(motorLabel);
        labelPanel.add(speedLabel);
        labelPanel.add(sliderLabel);
        labelPanel.add(tachoLabel);
        labelPanel.add(selectedLabel);
        labelPanel.add(reverseLabel);
        labelPanel.add(limitLabel);
        labelPanel.add(resetLabel);
        return labelPanel;
    }

    private void createControlPanel() {
        JPanel motorsPanel = new JPanel();
        motorsPanel.setLayout(new BoxLayout(motorsPanel, 1));
        motorsPanel.add(this.createMotorsHeader());
        for (int i = 0; i < 3; ++i) {
            motorsPanel.add(this.createMotorPanel(i));
        }
        JPanel buttonsPanel = new JPanel();
        this.controlPanel.add(motorsPanel);
        buttonsPanel.add(this.forwardButton);
        buttonsPanel.add(this.backwardButton);
        buttonsPanel.add(this.leftButton);
        buttonsPanel.add(this.rightButton);
        this.controlPanel.add(buttonsPanel);
        this.forwardButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (!NXJControl.this.aMotorSelected()) {
                    return;
                }
                int[] speed = NXJControl.this.getSpeeds();
                NXJControl.this.move(speed[0], speed[1], speed[2]);
            }

            public void mouseReleased(MouseEvent e) {
                NXJControl.this.stopMotors();
            }
        });
        this.backwardButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (!NXJControl.this.aMotorSelected()) {
                    return;
                }
                int[] speed = NXJControl.this.getSpeeds();
                NXJControl.this.move(-speed[0], -speed[1], -speed[2]);
            }

            public void mouseReleased(MouseEvent e) {
                NXJControl.this.stopMotors();
            }
        });
        this.leftButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (!NXJControl.this.twoMotorsSelected()) {
                    return;
                }
                int[] speed = NXJControl.this.getSpeeds();
                int[] multipliers = NXJControl.this.leftMultipliers();
                NXJControl.this.move(speed[0] * multipliers[0], speed[1] * multipliers[1], speed[2] * multipliers[2]);
            }

            public void mouseReleased(MouseEvent e) {
                NXJControl.this.stopMotors();
            }
        });
        this.rightButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (!NXJControl.this.twoMotorsSelected()) {
                    return;
                }
                int[] speed = NXJControl.this.getSpeeds();
                int[] multipliers = NXJControl.this.rightMultipliers();
                NXJControl.this.move(speed[0] * multipliers[0], speed[1] * multipliers[1], speed[2] * multipliers[2]);
            }

            public void mouseReleased(MouseEvent e) {
                NXJControl.this.stopMotors();
            }
        });
    }

    private int numMotorsSelected() {
        int numSelected = 0;
        for (int i = 0; i < 3; ++i) {
            if (!this.selectors[i].isSelected()) continue;
            ++numSelected;
        }
        return numSelected;
    }

    private boolean twoMotorsSelected() {
        if (this.numMotorsSelected() != 2) {
            this.showMessage("Exactly two motors must be selected");
            return false;
        }
        return true;
    }

    private boolean aMotorSelected() {
        if (this.numMotorsSelected() < 1) {
            this.showMessage("At least one motor must be selected");
            return false;
        }
        return true;
    }

    private int[] leftMultipliers() {
        int[] multipliers = new int[3];
        boolean firstFound = false;
        boolean secondFound = false;
        for (int i = 0; i < 3; ++i) {
            if (this.selectors[i].isSelected() && !firstFound) {
                firstFound = true;
                multipliers[i] = -1;
                continue;
            }
            if (this.selectors[i].isSelected() && !secondFound) {
                secondFound = true;
                multipliers[i] = 1;
                continue;
            }
            multipliers[i] = 0;
        }
        return multipliers;
    }

    private int[] rightMultipliers() {
        int[] multipliers = new int[3];
        boolean firstFound = false;
        boolean secondFound = false;
        for (int i = 0; i < 3; ++i) {
            if (this.selectors[i].isSelected() && !firstFound) {
                firstFound = true;
                multipliers[i] = 1;
                continue;
            }
            if (this.selectors[i].isSelected() && !secondFound) {
                secondFound = true;
                multipliers[i] = -1;
                continue;
            }
            multipliers[i] = 0;
        }
        return multipliers;
    }

    private void getFile(File file, String fileName, int size) {
        FileOutputStream out = null;
        int received = 0;
        try {
            out = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        try {
            byte[] data;
            FileInfo fi = this.nxtCommand.openRead(fileName);
            do {
                data = this.nxtCommand.readFile((byte)0, size - received < 51 ? size - received : 51);
                out.write(data);
            } while ((received += data.length) < size);
            this.nxtCommand.closeFile(fi.fileHandle);
            out.close();
        }
        catch (IOException ioe) {
            this.showMessage("IOException downloading file");
        }
    }

    public void showMessage(String msg) {
        JOptionPane.showMessageDialog(this.frame, msg);
    }

    private void updateSensors() {
        if (this.nxtCommand == null) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            int max = 1024;
            this.sensorPanels[i].setRawVal(this.sensorValues[i].rawADValue);
            if (this.sensorValues[i].sensorMode == -128) {
                max = 100;
            } else if (this.sensorValues[i].sensorMode == 32) {
                max = 1;
            }
            this.sensorPanels[i].setScaledMaxVal(max);
            this.sensorPanels[i].setScaledVal(this.sensorValues[i].scaledValue);
            this.sensorPanels[i].setType(sensorTypes[this.sensorValues[i].sensorType]);
            this.sensorPanels[i].repaint();
        }
        this.batteryGauge.setVal(this.mv);
    }

    private void clearFiles() {
        this.filesPanel.removeAll();
        this.filesPanel.repaint();
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            int row = this.nxtTable.getSelectedRow();
            if (row < 0) {
                return;
            }
            if (this.nxts[row].connectionState != NXTConnectionState.DISCONNECTED && this.nxts[row].connectionState != NXTConnectionState.UNKNOWN) {
                this.updateConnectButton(true);
                if (this.nxts[row].connectionState == NXTConnectionState.LCP_CONNECTED) {
                    this.nxtCommand = this.nxtCommands[row];
                    this.showFiles();
                }
                if (this.nxts[row].connectionState == NXTConnectionState.DATALOG_CONNECTED) {
                    this.dvc = this.dvcs[row];
                }
                if (this.nxts[row].connectionState == NXTConnectionState.RCONSOLE_CONNECTED) {
                    this.cvc = this.cvcs[row];
                }
            } else {
                this.updateConnectButton(false);
                this.clearFiles();
            }
        }
    }

    private void search() {
        this.closeAll();
        this.clearFiles();
        this.updateConnectButton(false);
        this.nxtTable.setModel(new NXTConnectionModel(null, 0));
        this.nxts = this.conn.search(this.nameText.getText(), null, this.getProtocols());
        if (this.nxts.length == 0) {
            this.showMessage("No NXTS found");
            return;
        }
        this.nm = new NXTConnectionModel(this.nxts, this.nxts.length);
        this.nxtTable.setModel(this.nm);
        TableColumn col = this.nxtTable.getColumnModel().getColumn(3);
        col.setPreferredWidth(150);
        this.nxtTable.setRowSelectionInterval(0, 0);
        this.nxtTable.getSelectionModel().addListSelectionListener(this.control);
        this.nxtCommands = new NXTCommand[this.nxts.length];
        this.nxtComms = new NXTComm[this.nxts.length];
        this.dvcs = new DataViewComms[this.nxts.length];
        this.cvcs = new ConsoleViewComms[this.nxts.length];
    }

    private void closeAll() {
        if (this.nxtCommands == null) {
            return;
        }
        for (int i = 0; i < this.nxtCommands.length; ++i) {
            NXTCommand nc = this.nxtCommands[i];
            if (nc == null) continue;
            try {
                nc.close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.nxtCommand = null;
    }

    private void updateConnectionStatus(int row, NXTConnectionState state) {
        this.nm.setConnected(row, state);
        this.nxtTable.repaint();
        this.updateConnectButton(state != NXTConnectionState.DISCONNECTED);
        if (state != NXTConnectionState.LCP_CONNECTED) {
            this.nxtCommands[row] = null;
        }
    }

    private void updateConnectButton(boolean connected) {
        this.connectButton.setText(connected ? "Disconnect" : "Connect");
    }

    private int getProtocols() {
        int protocols = 0;
        if (this.usbButton.isSelected()) {
            protocols = 1;
        }
        if (this.bluetoothButton.isSelected()) {
            protocols = 2;
        }
        if (this.bothButton.isSelected()) {
            protocols = 3;
        }
        return protocols;
    }

    private int getAppProtocol() {
        int appProtocol = 0;
        if (this.lcpButton.isSelected()) {
            appProtocol = 0;
        }
        if (this.rconsoleButton.isSelected()) {
            appProtocol = 1;
        }
        if (this.datalogButton.isSelected()) {
            appProtocol = 2;
        }
        return appProtocol;
    }

    private void stopMotors() {
        try {
            if (this.nxtCommand == null) {
                return;
            }
            this.nxtCommand.setOutputState(0, (byte)0, 0, 0, 0, 0, 0);
            this.nxtCommand.setOutputState(1, (byte)0, 0, 0, 0, 0, 0);
            this.nxtCommand.setOutputState(2, (byte)0, 0, 0, 0, 0, 0);
            this.tachos[0].setText("      " + this.nxtCommand.getTachoCount(0));
            this.tachos[1].setText("      " + this.nxtCommand.getTachoCount(1));
            this.tachos[2].setText("      " + this.nxtCommand.getTachoCount(2));
        }
        catch (IOException ioe) {
            this.showMessage("IOException while stopping motors");
        }
    }

    private int[] getLimits() {
        int[] lim = new int[3];
        for (int i = 0; i < 3; ++i) {
            try {
                lim[i] = Integer.parseInt(this.limits[i].getText());
                continue;
            }
            catch (NumberFormatException nfe) {
                lim[i] = 0;
            }
        }
        return lim;
    }

    private int[] getSpeeds() {
        int[] speed = new int[3];
        for (int i = 0; i < 3; ++i) {
            speed[i] = this.sliders[i].getValue();
            if (!this.reversors[i].isSelected()) continue;
            speed[i] = -speed[i];
        }
        return speed;
    }

    private void getSensorValues() {
        try {
            for (int i = 0; i < 4; ++i) {
                if (this.nxtCommand == null) {
                    return;
                }
                this.sensorValues[i] = this.nxtCommand.getInputValues(i);
            }
            this.mv = this.nxtCommand.getBatteryLevel();
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
    }

    private String toHex(byte[] b) {
        StringBuffer output = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            output.append(Integer.toHexString(b[i]));
        }
        return output.toString();
    }

    private byte[] fromHex(String s) {
        byte[] reply = new byte[s.length() / 2];
        for (int i = 0; i < reply.length; ++i) {
            char c1 = s.charAt(i * 2);
            char c2 = s.charAt(i * 2 + 1);
            reply[i] = (byte)(this.getHexDigit(c1) << 4 | this.getHexDigit(c2));
        }
        return reply;
    }

    private int getHexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return 0;
    }

    private byte[] appendBytes(byte[] array1, byte[] array2) {
        byte[] array = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, array, 0, array1.length);
        System.arraycopy(array2, 0, array, array1.length, array2.length);
        return array;
    }

    private void connect() {
        int row = this.nxtTable.getSelectedRow();
        int currentAppProtocol = this.getAppProtocol();
        if (row >= 0) {
            if (this.nxts[row].connectionState == NXTConnectionState.LCP_CONNECTED) {
                try {
                    this.nxtCommand = this.nxtCommands[row];
                    this.nxtCommand.close();
                    this.nxts[row].connectionState = NXTConnectionState.DISCONNECTED;
                }
                catch (IOException ioe) {
                    this.showMessage("IOException while disconnecting");
                }
                this.updateConnectionStatus(row, this.nxts[row].connectionState);
                this.clearFiles();
                this.nxtCommand = null;
                return;
            }
            if (this.nxts[row].connectionState == NXTConnectionState.RCONSOLE_CONNECTED) {
                this.cvc.close();
                this.nxts[row].connectionState = NXTConnectionState.DISCONNECTED;
                this.updateConnectionStatus(row, this.nxts[row].connectionState);
                this.cvc = null;
                return;
            }
            if (this.nxts[row].connectionState == NXTConnectionState.DATALOG_CONNECTED) {
                this.dvc.close();
                this.nxts[row].connectionState = NXTConnectionState.DISCONNECTED;
                this.updateConnectionStatus(row, this.nxts[row].connectionState);
                this.dvc.setConnected(false);
                this.dvc = null;
                return;
            }
            if (currentAppProtocol == 1) {
                this.consoleConnect();
                return;
            }
            if (currentAppProtocol == 2) {
                this.dataConnect();
                return;
            }
            boolean open = false;
            try {
                NXTComm nxtComm;
                this.clearFiles();
                this.nxtCommands[row] = this.nxtCommand = new NXTCommand();
                this.nxtComms[row] = nxtComm = NXTCommFactory.createNXTComm((int)this.nxts[row].protocol);
                open = nxtComm.open(this.nxts[row], 1);
                this.nxtCommand.setNXTComm((NXTCommRequest)nxtComm);
            }
            catch (NXTCommException e) {
                open = false;
            }
            if (!open) {
                this.showMessage("Failed to connect");
            } else {
                this.updateConnectionStatus(row, this.nxts[row].connectionState);
                this.showFiles();
            }
        } else {
            this.showMessage("You must do a search and select the NXT to connect to");
        }
    }

    private void consoleConnect() {
        int row = this.nxtTable.getSelectedRow();
        if (row >= 0) {
            boolean open = false;
            this.theConsoleLog.setText("");
            this.cvcs[row] = new ConsoleViewComms(this, true, false);
            this.cvc = this.cvcs[row];
            open = this.cvc.connectTo(this.nxts[row].name, this.nxts[row].deviceAddress, this.nxts[row].protocol);
            if (!open) {
                this.showMessage("Failed to connect to RConsole");
                return;
            }
            this.nxts[row].connectionState = NXTConnectionState.RCONSOLE_CONNECTED;
            this.updateConnectionStatus(row, this.nxts[row].connectionState);
        }
    }

    private void dataConnect() {
        int row = this.nxtTable.getSelectedRow();
        if (row >= 0) {
            boolean open = false;
            this.theDataLog.setText("");
            this.dvcs[row] = new DataViewComms(this);
            this.dvc = this.dvcs[row];
            open = this.dvc.connectTo(this.nxts[row].name, this.nxts[row].deviceAddress, this.nxts[row].protocol);
            if (!open) {
                this.showMessage("Failed to connect to data logger");
                return;
            }
            this.nxts[row].connectionState = NXTConnectionState.DATALOG_CONNECTED;
            this.updateConnectionStatus(row, this.nxts[row].connectionState);
        }
    }

    public void append(float x) {
        if (0 == this.recordCount % this.rowLength) {
            this.theDataLog.append("\n");
        }
        this.theDataLog.append(FORMAT_FLOAT.format(x) + "\t ");
        ++this.recordCount;
    }

    private void deleteFiles() {
        this.frame.setCursor(this.hourglassCursor);
        try {
            for (int i = 0; i < this.fm.getRowCount(); ++i) {
                Boolean b = (Boolean)this.fm.getValueAt(i, 4);
                boolean deleteIt = b;
                String fileName = (String)this.fm.getValueAt(i, 0);
                if (!deleteIt) continue;
                this.fm.delete(fileName, i);
                --i;
                this.table.invalidate();
                this.tablePane.revalidate();
            }
        }
        catch (IOException ioe) {
            this.showMessage("IOException deleting files");
        }
        this.frame.setCursor(this.normalCursor);
    }

    private void upload() {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showOpenDialog(this.frame);
        if (returnVal == 0) {
            this.frame.setCursor(this.hourglassCursor);
            try {
                File file = fc.getSelectedFile();
                if (file.getName().length() > 20) {
                    this.showMessage("File name is more than 20 characters");
                } else {
                    this.nxtCommand.uploadFile(file, file.getName());
                    String msg = this.fm.fetchFiles();
                    if (msg != null) {
                        this.showMessage(msg);
                    }
                    this.table.invalidate();
                    this.tablePane.revalidate();
                }
            }
            catch (IOException ioe) {
                this.showMessage("IOException uploading file");
            }
            this.frame.setCursor(this.normalCursor);
        }
    }

    private void download() {
        int i = this.table.getSelectedRow();
        if (i < 0) {
            return;
        }
        String fileName = this.fm.getFile((int)i).fileName;
        int size = this.fm.getFile((int)i).fileSize;
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        fc.setSelectedFile(new File(fileName));
        int returnVal = fc.showSaveDialog(this.frame);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            this.frame.setCursor(this.hourglassCursor);
            this.getFile(file, fileName, size);
            this.frame.setCursor(this.normalCursor);
        }
    }

    private void runFile() {
        int row = this.table.getSelectedRow();
        if (row < 0) {
            return;
        }
        String fileName = this.fm.getFile((int)row).fileName;
        try {
            this.nxtCommand.startProgram(fileName);
            this.nxtCommand.close();
            this.nxtCommand = null;
            this.updateConnectionStatus(this.nxtTable.getSelectedRow(), this.nxts[row].connectionState);
            this.clearFiles();
        }
        catch (IOException ioe) {
            this.showMessage("IOException running program");
        }
    }

    private void rename(String name) {
        if (this.nxtCommand == null) {
            return;
        }
        if (name != null && name.length() <= 16 && name.length() > 0) {
            this.frame.setCursor(this.hourglassCursor);
            try {
                this.nxtCommand.setFriendlyName(name);
                this.frame.setTitle("NXJ Control Center : " + name);
                this.newName.setText("");
            }
            catch (IOException ioe) {
                this.showMessage("IOException setting friendly name");
            }
            this.frame.setCursor(this.normalCursor);
        } else {
            this.showMessage("Please supply a name from 1 to 16 chareacters");
        }
    }

    private void move(int speed0, int speed1, int speed2) {
        int[] lim = this.getLimits();
        try {
            if (this.nxtCommand == null) {
                return;
            }
            if (this.selectors[0].isSelected()) {
                this.nxtCommand.setOutputState(0, (byte)speed0, 0, 0, 0, 0, lim[0]);
            }
            if (this.selectors[1].isSelected()) {
                this.nxtCommand.setOutputState(1, (byte)speed1, 0, 0, 0, 0, lim[1]);
            }
            if (this.selectors[2].isSelected()) {
                this.nxtCommand.setOutputState(2, (byte)speed2, 0, 0, 0, 0, lim[2]);
            }
        }
        catch (IOException ioe) {
            this.showMessage("IOException updating control");
        }
    }

    private void setSensor() {
        try {
            if (this.nxtCommand == null) {
                return;
            }
            this.nxtCommand.setInputMode(this.sensorList.getSelectedIndex(), sensorTypeValues[this.sensorTypeList.getSelectedIndex()], sensorModeValues[this.sensorModeList.getSelectedIndex()]);
        }
        catch (IOException ioe) {
            this.showMessage("IOException setting sensor type");
        }
    }

    private void playTone() {
        try {
            if (this.nxtCommand == null) {
                return;
            }
            this.nxtCommand.playTone(((Integer)this.freq.getValue()).intValue(), ((Integer)this.duration.getValue()).intValue());
        }
        catch (IOException ioe) {
            this.showMessage("IO Exception playing tone");
        }
        catch (NumberFormatException nfe) {
            this.showMessage("Frequency and Duration must be integers");
        }
    }

    private void resetTacho(JButton b) {
        int motor = -1;
        for (int i = 0; i < 3; ++i) {
            if (b != this.resetButtons[i]) continue;
            motor = i;
        }
        if (this.nxtCommand == null) {
            return;
        }
        try {
            this.nxtCommand.resetMotorPosition(motor, false);
            this.tachos[motor].setText("      " + this.nxtCommand.getTachoCount(motor));
        }
        catch (IOException ioe) {
            this.showMessage("IO Exception resetting motor");
        }
    }

    private void playSoundFile() {
        int row = this.table.getSelectedRow();
        if (row < 0) {
            return;
        }
        String fileName = this.fm.getFile((int)row).fileName;
        try {
            this.nxtCommand.playSoundFile(fileName, false);
        }
        catch (IOException ioe) {
            this.showMessage("IO Exception playing sound file");
        }
    }

    private void i2cSend() {
        byte[] address = new byte[]{2};
        if (this.nxtCommand == null) {
            return;
        }
        try {
            this.nxtCommand.LSWrite((byte)this.sensorList.getSelectedIndex(), this.appendBytes(address, this.fromHex(this.txData.getText())), ((Integer)this.rxDataLength.getValue()).byteValue());
        }
        catch (IOException ioe) {
            this.showMessage("IO Exception sending txData");
        }
    }

    private void i2cStatus() {
        if (this.nxtCommand == null) {
            return;
        }
        try {
            byte[] reply = this.nxtCommand.LSGetStatus((byte)this.sensorList.getSelectedIndex());
            if (reply != null) {
                System.out.println("LSStatus reply length = " + reply.length);
                String hex = this.toHex(reply);
                this.rxData.setText(hex);
            } else {
                this.rxData.setText("null");
            }
        }
        catch (IOException ioe) {
            this.showMessage("IO Exception getting status");
        }
    }

    private void i2cReceive() {
        if (this.nxtCommand == null) {
            return;
        }
        try {
            byte[] reply = this.nxtCommand.LSRead((byte)this.sensorList.getSelectedIndex());
            if (reply != null) {
                String hex = this.toHex(reply);
                this.rxData.setText(hex);
            } else {
                this.rxData.setText("null");
            }
        }
        catch (IOException ioe) {
            this.showMessage("IO Exception reading rxData");
        }
    }

    private void format() {
        if (this.nxtCommand == null) {
            return;
        }
        try {
            this.nxtCommand.deleteUserFlash();
            this.fm.fetchFiles();
            this.table.invalidate();
            this.tablePane.revalidate();
        }
        catch (IOException ioe) {
            this.showMessage("IO Exception formatting file system");
        }
    }

    public void logMessage(String msg) {
        System.out.println(msg);
    }

    public void connectedTo(String name, String address) {
    }

    public void setStatus(String msg) {
    }

    public void append(String value) {
        this.theConsoleLog.append(value);
    }

    public void updateLCD(byte[] buffer) {
    }
}

