/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.tools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lejos.pc.tools.DataViewComms;
import lejos.pc.tools.DataViewerUI;

public class DataViewer
extends JFrame
implements ActionListener,
ChangeListener,
DataViewerUI {
    private static final long serialVersionUID = 4275975098699509511L;
    private JButton startButton = new JButton("Download");
    private JButton connectButton = new JButton("Connect");
    private JRadioButton btButton = new JRadioButton("Bluetooth");
    private JRadioButton usbButton = new JRadioButton("USB");
    private JLabel statusField = new JLabel();
    private JTextField lengthField = new JTextField(2);
    private JTextField nameField = new JTextField(10);
    private JTextField addrField = new JTextField(12);
    private int _recordCount;
    private int _rowLength;
    private DataViewComms comm;
    private boolean usbSelected = true;
    private String usingUSB = "Using USB";
    private String usingBluetooth = "Using Bluetooth";
    private JTextArea theLog;
    private static final NumberFormat FORMAT_FLOAT = NumberFormat.getNumberInstance();

    public DataViewer() {
        this.setDefaultCloseOperation(3);
        this.setTitle("View output from NXJ Datalogger");
        this.setSize(600, 600);
        this.statusField.setPreferredSize(new Dimension(200, 20));
        this.buildGUI();
        this.comm = new DataViewComms(this);
    }

    private void buildGUI() {
        JPanel connectPanel = new JPanel();
        ButtonGroup choiceGroup = new ButtonGroup();
        choiceGroup.add(this.usbButton);
        this.usbButton.setSelected(true);
        this.usbButton.addChangeListener(this);
        this.btButton.addChangeListener(this);
        choiceGroup.add(this.btButton);
        connectPanel.add(this.usbButton);
        connectPanel.add(this.btButton);
        connectPanel.add(this.connectButton);
        this.connectButton.addActionListener(this);
        connectPanel.add(new JLabel(" Name "));
        connectPanel.add(this.nameField);
        connectPanel.add(new JLabel(" Addr "));
        connectPanel.add(this.addrField);
        JPanel downLoadPanel = new JPanel();
        downLoadPanel.add(this.startButton);
        downLoadPanel.add(new JLabel("Row Length:"));
        downLoadPanel.add(this.lengthField);
        this.lengthField.setText("2");
        this.startButton.addActionListener(this);
        downLoadPanel.add(new JLabel("  Status:"));
        downLoadPanel.add(this.statusField);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new GridLayout(2, 1));
        topPanel.add(connectPanel);
        topPanel.add(downLoadPanel);
        this.add((Component)topPanel, "North");
        this.theLog = new JTextArea(30, 40);
        this.getContentPane().add((Component)new JScrollPane(this.theLog), "Center");
        this.setStatus("Waiting to Connect");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.connectButton) {
            boolean useUSB;
            String address;
            String name = this.nameField.getText();
            if (!this.comm.connecTo(name, address = this.addrField.getText(), useUSB = this.usbButton.isSelected())) {
                this.setStatus("Connect Failed");
                if (useUSB) {
                    JOptionPane.showMessageDialog(this, "Sorry... but USB did not connect.\nYou might want to check:\n  Is the NXT turned on and connected? \n  Does it display  'wait for USB'? ", "We have a connection problem.", -1);
                } else {
                    JOptionPane.showMessageDialog(this, "Sorry... Bluetooth did not connect. \nYou might want to check:\n Is the dongle plugged in?\n Is the NXT turned on?\n Does it display  'wait for BT'? ", "We have a connection problem.", -1);
                }
            }
        } else if (e.getSource() == this.startButton) {
            this.theLog.setText("");
            this._rowLength = Integer.parseInt(this.lengthField.getText());
            this._recordCount = 0;
            this.comm.startDownload();
        }
    }

    public void connectedTo(String name, String address) {
        this.nameField.setText(name);
        this.addrField.setText(address);
        this.setStatus("Connected ");
    }

    public void append(float value) {
        if (0 == this._recordCount % this._rowLength) {
            this.theLog.append("\n");
        }
        this.theLog.append(FORMAT_FLOAT.format(value) + "\t ");
        ++this._recordCount;
    }

    public static void main(String[] args) {
        DataViewer frame = new DataViewer();
        frame.setVisible(true);
    }

    public void setStatus(String s) {
        this.statusField.setText(s);
    }

    public void showMessage(String msg) {
        JOptionPane.showMessageDialog(this, msg, "Message", -1);
    }

    public void logMessage(String msg) {
        System.out.println(msg);
    }

    public void stateChanged(ChangeEvent e) {
        if (this.usbSelected && this.usbButton.isSelected()) {
            return;
        }
        if (this.usbButton.isSelected()) {
            this.setStatus(this.usingUSB);
            this.usbSelected = true;
        } else {
            this.setStatus(this.usingBluetooth);
            this.usbSelected = false;
        }
    }
}

