/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.tools;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import lejos.pc.comm.NXTConnector;
import lejos.pc.tools.DataViewerUI;

public class DataViewComms {
    private NXTConnector con;
    private boolean connected = false;
    private DataViewerUI viewer;
    private OutputStream os;
    private DataInputStream dataIn;

    public DataViewComms(DataViewerUI viewer) {
        this.viewer = viewer;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public boolean connecTo(String name, String address, boolean useUSB) {
        int protocols = useUSB ? 1 : 2;
        return this.connectTo(name, address, protocols);
    }

    public boolean connectTo(String name, String address, int protocol) {
        this.viewer.logMessage("Connecting to " + name + " " + address);
        this.con = new NXTConnector();
        boolean res = this.con.connectTo(name, address, protocol);
        this.viewer.logMessage("Connect result " + res);
        if (!res) {
            this.viewer.logMessage("Connection failed ");
            return false;
        }
        this.os = this.con.getOutputStream();
        this.dataIn = this.con.getDataIn();
        if (this.dataIn == null) {
            this.viewer.logMessage("NULL input stream ");
            return false;
        }
        if (this.os == null) {
            this.viewer.logMessage("NULL output stream");
            return false;
        }
        this.connected = true;
        name = this.con.getNXTInfo().name;
        address = this.con.getNXTInfo().deviceAddress;
        this.viewer.connectedTo(name, address);
        return true;
    }

    public void startDownload() {
        if (!this.connected) {
            this.viewer.showMessage("Not yet connected");
            return;
        }
        int b = 15;
        try {
            this.os.write(b);
            this.os.flush();
        }
        catch (IOException e) {
            this.viewer.showMessage(e + " handshake failed ");
        }
        try {
            int length = this.dataIn.readInt();
            this.viewer.setStatus(" reading length " + length);
            for (int i = 0; i < length; ++i) {
                this.viewer.append(this.dataIn.readFloat());
            }
        }
        catch (IOException e) {
            this.viewer.showMessage("read error " + e);
        }
        this.viewer.setStatus("Read all data");
    }

    public void close() {
        try {
            if (this.con != null) {
                this.con.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

