/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lejos.pc.tools.ConsoleViewComms;
import lejos.pc.tools.ConsoleViewerUI;

public class ConsoleViewer
extends JFrame
implements ConsoleViewerUI,
ActionListener,
ChangeListener {
    private static final int LCD_WIDTH = 100;
    private static final int LCD_HEIGHT = 64;
    private static final long serialVersionUID = -4789857573625988062L;
    private JButton connectButton = new JButton("Connect");
    private JRadioButton usbButton = new JRadioButton("USB");
    private JRadioButton btButton = new JRadioButton("BlueTooth");
    private JLabel statusField = new JLabel();
    private TextField nameField = new TextField(10);
    private TextField addrField = new TextField(12);
    private ConsoleViewComms comm;
    private boolean usbSelected = true;
    private String usingUSB = "Using USB";
    private String usingBluetooth = "Using Bluetooth";
    private TextArea theLog;
    private LCDDisplay lcd;

    public ConsoleViewer() {
        this.setDefaultCloseOperation(3);
        this.setTitle("View RConsole output from NXT");
        this.setSize(650, 600);
        this.statusField.setPreferredSize(new Dimension(200, 20));
        this.buildGui();
        this.comm = new ConsoleViewComms(this, true, true);
    }

    public void buildGui() {
        JPanel connectPanel = new JPanel();
        ButtonGroup choiceGroup = new ButtonGroup();
        choiceGroup.add(this.usbButton);
        this.usbButton.setSelected(true);
        this.usbButton.addChangeListener(this);
        this.btButton.addChangeListener(this);
        choiceGroup.add(this.btButton);
        connectPanel.add(this.usbButton);
        connectPanel.add(this.btButton);
        connectPanel.add(new JLabel(" Name"));
        connectPanel.add(this.nameField);
        this.connectButton.addActionListener(this);
        connectPanel.add(new JLabel("Addr"));
        connectPanel.add(this.addrField);
        JPanel statusPanel = new JPanel(new BorderLayout());
        statusPanel.add((Component)new JLabel("Status: "), "Before");
        statusPanel.add((Component)this.statusField, "Center");
        JPanel topLeftPanel = new JPanel();
        topLeftPanel.setLayout(new GridLayout(2, 1));
        topLeftPanel.add(connectPanel);
        topLeftPanel.add(this.connectButton);
        this.lcd = new LCDDisplay();
        this.lcd.setMinimumSize(new Dimension(200, 128));
        this.lcd.setEnabled(true);
        this.lcd.setPreferredSize(this.lcd.getMinimumSize());
        JPanel topPanel = new JPanel();
        topPanel.add(topLeftPanel);
        topPanel.add(this.lcd);
        this.add((Component)topPanel, "North");
        this.theLog = new TextArea(40, 40);
        this.add((Component)this.theLog, "Center");
        this.add((Component)statusPanel, "South");
        this.statusField.setText(this.usingUSB);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.connectButton) {
            this.setStatus("Connecting");
            this.theLog.setText("");
            String name = this.nameField.getText();
            String address = this.addrField.getText();
            boolean _useUSB = this.usbButton.isSelected();
            if (!this.comm.connectTo(name, address, _useUSB)) {
                this.setStatus("Connection Failed");
                if (_useUSB) {
                    JOptionPane.showMessageDialog(this, "Sorry... USB did not connect.\nYou might want to check:\n  Is the NXT turned on and connected? \n  Does it display  'USB Console...'? ", "We have a connection problem.", -1);
                } else {
                    JOptionPane.showMessageDialog(this, "Sorry... Bluetooth did not connect. \nYou might want to check:\n Is the dongle plugged in?\n Is the NXT turned on?\n Does it display  'BT Console....'? ", "We have a connection problem.", -1);
                }
            }
        }
    }

    public void append(String data) {
        this.theLog.setText(this.theLog.getText() + data);
        this.theLog.setCaretPosition(Integer.MAX_VALUE);
    }

    public void updateLCD(byte[] buffer) {
        this.lcd.update(buffer);
    }

    public void connectedTo(String name, String address) {
        this.nameField.setText(name);
        this.addrField.setText(address);
        this.setStatus("Connected to " + name);
    }

    public static void main(String[] args) {
        ConsoleViewer frame = new ConsoleViewer();
        frame.setVisible(true);
    }

    public void setStatus(String s) {
        this.statusField.setText(s);
    }

    public void stateChanged(ChangeEvent e) {
        if (this.usbSelected && this.usbButton.isSelected()) {
            return;
        }
        if (this.usbButton.isSelected()) {
            this.setStatus(this.usingUSB);
            this.usbSelected = true;
        } else {
            this.setStatus(this.usingBluetooth);
            this.usbSelected = false;
        }
    }

    public void logMessage(String msg) {
        System.out.println(msg);
    }

    class LCDDisplay
    extends JPanel {
        private BufferedImage lcd = new BufferedImage(100, 64, 2);
        private Graphics2D lcdGC = this.lcd.createGraphics();

        LCDDisplay() {
        }

        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            super.paint(g);
            int width = this.getWidth();
            int height = this.getHeight();
            int imgWidth = this.lcd.getWidth();
            int imgHeight = this.lcd.getHeight();
            if (width < height * imgWidth / imgHeight) {
                imgHeight = width * imgHeight / imgWidth;
                imgWidth = width;
            } else {
                imgWidth = height * imgWidth / imgHeight;
                imgHeight = height;
            }
            g2d.drawImage(this.lcd, (width - imgWidth) / 2, (height - imgHeight) / 2, imgWidth, imgHeight, null);
        }

        public void update(byte[] buffer) {
            int offset = 0;
            int row = 0;
            this.lcdGC.setColor(new Color(255, 255, 255, 255));
            this.lcdGC.fillRect(0, 0, this.lcd.getWidth(), this.lcd.getHeight());
            this.lcdGC.setColor(new Color(0, 128, 0, 100));
            this.lcdGC.fillRect(0, 0, this.lcd.getWidth(), this.lcd.getHeight());
            this.lcdGC.setColor(new Color(0, 0, 0, 255));
            for (row = 0; row < 64; row += 8) {
                for (int x = 0; x < 100; ++x) {
                    byte vals = buffer[offset++];
                    for (int y = 0; y < 8; ++y) {
                        if ((vals & 1) != 0) {
                            this.lcdGC.fillRect(x, y + row, 1, 1);
                        }
                        vals = (byte)(vals >> 1);
                    }
                }
            }
            this.repaint();
        }
    }
}

